(function() {var type_impls = {
"alloc":[["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Result%3CT,+E%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/result.rs.html#518\">source</a><a href=\"#impl-Result%3CT,+E%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, E&gt; <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;T, E&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.is_ok\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"const since 1.48.0\">const: 1.48.0</span> · <a class=\"src\" href=\"src/core/result.rs.html#538\">source</a></span><h4 class=\"code-header\">pub const fn <a href=\"core/result/enum.Result.html#tymethod.is_ok\" class=\"fn\">is_ok</a>(&amp;self) -&gt; <a class=\"primitive\" href=\"core/primitive.bool.html\">bool</a></h4></section></summary><div class=\"docblock\"><p>Returns <code>true</code> if the result is <a href=\"core/result/enum.Result.html#variant.Ok\" title=\"variant core::result::Result::Ok\"><code>Ok</code></a>.</p>\n<h5 id=\"examples\"><a href=\"#examples\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;i32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Ok</span>(-<span class=\"number\">3</span>);\n<span class=\"macro\">assert_eq!</span>(x.is_ok(), <span class=\"bool-val\">true</span>);\n\n<span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;i32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"string\">&quot;Some error message&quot;</span>);\n<span class=\"macro\">assert_eq!</span>(x.is_ok(), <span class=\"bool-val\">false</span>);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+x:+Result%3Ci32,+%26str%3E+=+Ok(-3);%0Aassert_eq!(x.is_ok(),+true);%0A%0Alet+x:+Result%3Ci32,+%26str%3E+=+Err(%22Some+error+message%22);%0Aassert_eq!(x.is_ok(),+false);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.is_ok_and\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.70.0\">1.70.0</span> · <a class=\"src\" href=\"src/core/result.rs.html#559\">source</a></span><h4 class=\"code-header\">pub fn <a href=\"core/result/enum.Result.html#tymethod.is_ok_and\" class=\"fn\">is_ok_and</a>(self, f: impl <a class=\"trait\" href=\"core/ops/function/trait.FnOnce.html\" title=\"trait core::ops::function::FnOnce\">FnOnce</a>(T) -&gt; <a class=\"primitive\" href=\"core/primitive.bool.html\">bool</a>) -&gt; <a class=\"primitive\" href=\"core/primitive.bool.html\">bool</a></h4></section></summary><div class=\"docblock\"><p>Returns <code>true</code> if the result is <a href=\"core/result/enum.Result.html#variant.Ok\" title=\"variant core::result::Result::Ok\"><code>Ok</code></a> and the value inside of it matches a predicate.</p>\n<h5 id=\"examples-1\"><a href=\"#examples-1\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"number\">2</span>);\n<span class=\"macro\">assert_eq!</span>(x.is_ok_and(|x| x &gt; <span class=\"number\">1</span>), <span class=\"bool-val\">true</span>);\n\n<span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"number\">0</span>);\n<span class=\"macro\">assert_eq!</span>(x.is_ok_and(|x| x &gt; <span class=\"number\">1</span>), <span class=\"bool-val\">false</span>);\n\n<span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"string\">&quot;hey&quot;</span>);\n<span class=\"macro\">assert_eq!</span>(x.is_ok_and(|x| x &gt; <span class=\"number\">1</span>), <span class=\"bool-val\">false</span>);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+x:+Result%3Cu32,+%26str%3E+=+Ok(2);%0Aassert_eq!(x.is_ok_and(%7Cx%7C+x+%3E+1),+true);%0A%0Alet+x:+Result%3Cu32,+%26str%3E+=+Ok(0);%0Aassert_eq!(x.is_ok_and(%7Cx%7C+x+%3E+1),+false);%0A%0Alet+x:+Result%3Cu32,+%26str%3E+=+Err(%22hey%22);%0Aassert_eq!(x.is_ok_and(%7Cx%7C+x+%3E+1),+false);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.is_err\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"const since 1.48.0\">const: 1.48.0</span> · <a class=\"src\" href=\"src/core/result.rs.html#581\">source</a></span><h4 class=\"code-header\">pub const fn <a href=\"core/result/enum.Result.html#tymethod.is_err\" class=\"fn\">is_err</a>(&amp;self) -&gt; <a class=\"primitive\" href=\"core/primitive.bool.html\">bool</a></h4></section></summary><div class=\"docblock\"><p>Returns <code>true</code> if the result is <a href=\"core/result/enum.Result.html#variant.Err\" title=\"variant core::result::Result::Err\"><code>Err</code></a>.</p>\n<h5 id=\"examples-2\"><a href=\"#examples-2\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;i32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Ok</span>(-<span class=\"number\">3</span>);\n<span class=\"macro\">assert_eq!</span>(x.is_err(), <span class=\"bool-val\">false</span>);\n\n<span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;i32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"string\">&quot;Some error message&quot;</span>);\n<span class=\"macro\">assert_eq!</span>(x.is_err(), <span class=\"bool-val\">true</span>);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+x:+Result%3Ci32,+%26str%3E+=+Ok(-3);%0Aassert_eq!(x.is_err(),+false);%0A%0Alet+x:+Result%3Ci32,+%26str%3E+=+Err(%22Some+error+message%22);%0Aassert_eq!(x.is_err(),+true);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.is_err_and\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.70.0\">1.70.0</span> · <a class=\"src\" href=\"src/core/result.rs.html#604\">source</a></span><h4 class=\"code-header\">pub fn <a href=\"core/result/enum.Result.html#tymethod.is_err_and\" class=\"fn\">is_err_and</a>(self, f: impl <a class=\"trait\" href=\"core/ops/function/trait.FnOnce.html\" title=\"trait core::ops::function::FnOnce\">FnOnce</a>(E) -&gt; <a class=\"primitive\" href=\"core/primitive.bool.html\">bool</a>) -&gt; <a class=\"primitive\" href=\"core/primitive.bool.html\">bool</a></h4></section></summary><div class=\"docblock\"><p>Returns <code>true</code> if the result is <a href=\"core/result/enum.Result.html#variant.Err\" title=\"variant core::result::Result::Err\"><code>Err</code></a> and the value inside of it matches a predicate.</p>\n<h5 id=\"examples-3\"><a href=\"#examples-3\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">use </span>std::io::{Error, ErrorKind};\n\n<span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, Error&gt; = <span class=\"prelude-val\">Err</span>(Error::new(ErrorKind::NotFound, <span class=\"string\">&quot;!&quot;</span>));\n<span class=\"macro\">assert_eq!</span>(x.is_err_and(|x| x.kind() == ErrorKind::NotFound), <span class=\"bool-val\">true</span>);\n\n<span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, Error&gt; = <span class=\"prelude-val\">Err</span>(Error::new(ErrorKind::PermissionDenied, <span class=\"string\">&quot;!&quot;</span>));\n<span class=\"macro\">assert_eq!</span>(x.is_err_and(|x| x.kind() == ErrorKind::NotFound), <span class=\"bool-val\">false</span>);\n\n<span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, Error&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"number\">123</span>);\n<span class=\"macro\">assert_eq!</span>(x.is_err_and(|x| x.kind() == ErrorKind::NotFound), <span class=\"bool-val\">false</span>);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Ause+std::io::%7BError,+ErrorKind%7D;%0A%0Alet+x:+Result%3Cu32,+Error%3E+=+Err(Error::new(ErrorKind::NotFound,+%22!%22));%0Aassert_eq!(x.is_err_and(%7Cx%7C+x.kind()+==+ErrorKind::NotFound),+true);%0A%0Alet+x:+Result%3Cu32,+Error%3E+=+Err(Error::new(ErrorKind::PermissionDenied,+%22!%22));%0Aassert_eq!(x.is_err_and(%7Cx%7C+x.kind()+==+ErrorKind::NotFound),+false);%0A%0Alet+x:+Result%3Cu32,+Error%3E+=+Ok(123);%0Aassert_eq!(x.is_err_and(%7Cx%7C+x.kind()+==+ErrorKind::NotFound),+false);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.ok\" class=\"method\"><a class=\"src rightside\" href=\"src/core/result.rs.html#631\">source</a><h4 class=\"code-header\">pub fn <a href=\"core/result/enum.Result.html#tymethod.ok\" class=\"fn\">ok</a>(self) -&gt; <a class=\"enum\" href=\"core/option/enum.Option.html\" title=\"enum core::option::Option\">Option</a>&lt;T&gt;</h4></section></summary><div class=\"docblock\"><p>Converts from <code>Result&lt;T, E&gt;</code> to <a href=\"core/option/enum.Option.html\" title=\"enum core::option::Option\"><code>Option&lt;T&gt;</code></a>.</p>\n<p>Converts <code>self</code> into an <a href=\"core/option/enum.Option.html\" title=\"enum core::option::Option\"><code>Option&lt;T&gt;</code></a>, consuming <code>self</code>,\nand discarding the error, if any.</p>\n<h5 id=\"examples-4\"><a href=\"#examples-4\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"number\">2</span>);\n<span class=\"macro\">assert_eq!</span>(x.ok(), <span class=\"prelude-val\">Some</span>(<span class=\"number\">2</span>));\n\n<span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"string\">&quot;Nothing here&quot;</span>);\n<span class=\"macro\">assert_eq!</span>(x.ok(), <span class=\"prelude-val\">None</span>);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+x:+Result%3Cu32,+%26str%3E+=+Ok(2);%0Aassert_eq!(x.ok(),+Some(2));%0A%0Alet+x:+Result%3Cu32,+%26str%3E+=+Err(%22Nothing+here%22);%0Aassert_eq!(x.ok(),+None);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.err\" class=\"method\"><a class=\"src rightside\" href=\"src/core/result.rs.html#654\">source</a><h4 class=\"code-header\">pub fn <a href=\"core/result/enum.Result.html#tymethod.err\" class=\"fn\">err</a>(self) -&gt; <a class=\"enum\" href=\"core/option/enum.Option.html\" title=\"enum core::option::Option\">Option</a>&lt;E&gt;</h4></section></summary><div class=\"docblock\"><p>Converts from <code>Result&lt;T, E&gt;</code> to <a href=\"core/option/enum.Option.html\" title=\"enum core::option::Option\"><code>Option&lt;E&gt;</code></a>.</p>\n<p>Converts <code>self</code> into an <a href=\"core/option/enum.Option.html\" title=\"enum core::option::Option\"><code>Option&lt;E&gt;</code></a>, consuming <code>self</code>,\nand discarding the success value, if any.</p>\n<h5 id=\"examples-5\"><a href=\"#examples-5\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"number\">2</span>);\n<span class=\"macro\">assert_eq!</span>(x.err(), <span class=\"prelude-val\">None</span>);\n\n<span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"string\">&quot;Nothing here&quot;</span>);\n<span class=\"macro\">assert_eq!</span>(x.err(), <span class=\"prelude-val\">Some</span>(<span class=\"string\">&quot;Nothing here&quot;</span>));</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+x:+Result%3Cu32,+%26str%3E+=+Ok(2);%0Aassert_eq!(x.err(),+None);%0A%0Alet+x:+Result%3Cu32,+%26str%3E+=+Err(%22Nothing+here%22);%0Aassert_eq!(x.err(),+Some(%22Nothing+here%22));%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.as_ref\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"const since 1.48.0\">const: 1.48.0</span> · <a class=\"src\" href=\"src/core/result.rs.html#682\">source</a></span><h4 class=\"code-header\">pub const fn <a href=\"core/result/enum.Result.html#tymethod.as_ref\" class=\"fn\">as_ref</a>(&amp;self) -&gt; <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;<a class=\"primitive\" href=\"core/primitive.reference.html\">&amp;T</a>, <a class=\"primitive\" href=\"core/primitive.reference.html\">&amp;E</a>&gt;</h4></section></summary><div class=\"docblock\"><p>Converts from <code>&amp;Result&lt;T, E&gt;</code> to <code>Result&lt;&amp;T, &amp;E&gt;</code>.</p>\n<p>Produces a new <code>Result</code>, containing a reference\ninto the original, leaving the original in place.</p>\n<h5 id=\"examples-6\"><a href=\"#examples-6\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"number\">2</span>);\n<span class=\"macro\">assert_eq!</span>(x.as_ref(), <span class=\"prelude-val\">Ok</span>(<span class=\"kw-2\">&amp;</span><span class=\"number\">2</span>));\n\n<span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"string\">&quot;Error&quot;</span>);\n<span class=\"macro\">assert_eq!</span>(x.as_ref(), <span class=\"prelude-val\">Err</span>(<span class=\"kw-2\">&amp;</span><span class=\"string\">&quot;Error&quot;</span>));</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+x:+Result%3Cu32,+%26str%3E+=+Ok(2);%0Aassert_eq!(x.as_ref(),+Ok(%262));%0A%0Alet+x:+Result%3Cu32,+%26str%3E+=+Err(%22Error%22);%0Aassert_eq!(x.as_ref(),+Err(%26%22Error%22));%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.as_mut\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"const unstable\">const: <a href=\"https://github.com/rust-lang/rust/issues/82814\" title=\"Tracking issue for const_result\">unstable</a></span> · <a class=\"src\" href=\"src/core/result.rs.html#712\">source</a></span><h4 class=\"code-header\">pub fn <a href=\"core/result/enum.Result.html#tymethod.as_mut\" class=\"fn\">as_mut</a>(&amp;mut self) -&gt; <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;<a class=\"primitive\" href=\"core/primitive.reference.html\">&amp;mut T</a>, <a class=\"primitive\" href=\"core/primitive.reference.html\">&amp;mut E</a>&gt;</h4></section></summary><div class=\"docblock\"><p>Converts from <code>&amp;mut Result&lt;T, E&gt;</code> to <code>Result&lt;&amp;mut T, &amp;mut E&gt;</code>.</p>\n<h5 id=\"examples-7\"><a href=\"#examples-7\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">fn </span>mutate(r: <span class=\"kw-2\">&amp;mut </span><span class=\"prelude-ty\">Result</span>&lt;i32, i32&gt;) {\n    <span class=\"kw\">match </span>r.as_mut() {\n        <span class=\"prelude-val\">Ok</span>(v) =&gt; <span class=\"kw-2\">*</span>v = <span class=\"number\">42</span>,\n        <span class=\"prelude-val\">Err</span>(e) =&gt; <span class=\"kw-2\">*</span>e = <span class=\"number\">0</span>,\n    }\n}\n\n<span class=\"kw\">let </span><span class=\"kw-2\">mut </span>x: <span class=\"prelude-ty\">Result</span>&lt;i32, i32&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"number\">2</span>);\nmutate(<span class=\"kw-2\">&amp;mut </span>x);\n<span class=\"macro\">assert_eq!</span>(x.unwrap(), <span class=\"number\">42</span>);\n\n<span class=\"kw\">let </span><span class=\"kw-2\">mut </span>x: <span class=\"prelude-ty\">Result</span>&lt;i32, i32&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"number\">13</span>);\nmutate(<span class=\"kw-2\">&amp;mut </span>x);\n<span class=\"macro\">assert_eq!</span>(x.unwrap_err(), <span class=\"number\">0</span>);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Afn+mutate(r:+%26mut+Result%3Ci32,+i32%3E)+%7B%0A++++match+r.as_mut()+%7B%0A++++++++Ok(v)+=%3E+*v+=+42,%0A++++++++Err(e)+=%3E+*e+=+0,%0A++++%7D%0A%7D%0A%0Alet+mut+x:+Result%3Ci32,+i32%3E+=+Ok(2);%0Amutate(%26mut+x);%0Aassert_eq!(x.unwrap(),+42);%0A%0Alet+mut+x:+Result%3Ci32,+i32%3E+=+Err(13);%0Amutate(%26mut+x);%0Aassert_eq!(x.unwrap_err(),+0);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.map\" class=\"method\"><a class=\"src rightside\" href=\"src/core/result.rs.html#744\">source</a><h4 class=\"code-header\">pub fn <a href=\"core/result/enum.Result.html#tymethod.map\" class=\"fn\">map</a>&lt;U, F&gt;(self, op: F) -&gt; <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;U, E&gt;<span class=\"where fmt-newline\">where\n    F: <a class=\"trait\" href=\"core/ops/function/trait.FnOnce.html\" title=\"trait core::ops::function::FnOnce\">FnOnce</a>(T) -&gt; U,</span></h4></section></summary><div class=\"docblock\"><p>Maps a <code>Result&lt;T, E&gt;</code> to <code>Result&lt;U, E&gt;</code> by applying a function to a\ncontained <a href=\"core/result/enum.Result.html#variant.Ok\" title=\"variant core::result::Result::Ok\"><code>Ok</code></a> value, leaving an <a href=\"core/result/enum.Result.html#variant.Err\" title=\"variant core::result::Result::Err\"><code>Err</code></a> value untouched.</p>\n<p>This function can be used to compose the results of two functions.</p>\n<h5 id=\"examples-8\"><a href=\"#examples-8\">Examples</a></h5>\n<p>Print the numbers on each line of a string multiplied by two.</p>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>line = <span class=\"string\">&quot;1\\n2\\n3\\n4\\n&quot;</span>;\n\n<span class=\"kw\">for </span>num <span class=\"kw\">in </span>line.lines() {\n    <span class=\"kw\">match </span>num.parse::&lt;i32&gt;().map(|i| i * <span class=\"number\">2</span>) {\n        <span class=\"prelude-val\">Ok</span>(n) =&gt; <span class=\"macro\">println!</span>(<span class=\"string\">&quot;{n}&quot;</span>),\n        <span class=\"prelude-val\">Err</span>(..) =&gt; {}\n    }\n}</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+line+=+%221%5Cn2%5Cn3%5Cn4%5Cn%22;%0A%0Afor+num+in+line.lines()+%7B%0A++++match+num.parse::%3Ci32%3E().map(%7Ci%7C+i+*+2)+%7B%0A++++++++Ok(n)+=%3E+println!(%22%7Bn%7D%22),%0A++++++++Err(..)+=%3E+%7B%7D%0A++++%7D%0A%7D%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.map_or\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.41.0\">1.41.0</span> · <a class=\"src\" href=\"src/core/result.rs.html#772\">source</a></span><h4 class=\"code-header\">pub fn <a href=\"core/result/enum.Result.html#tymethod.map_or\" class=\"fn\">map_or</a>&lt;U, F&gt;(self, default: U, f: F) -&gt; U<span class=\"where fmt-newline\">where\n    F: <a class=\"trait\" href=\"core/ops/function/trait.FnOnce.html\" title=\"trait core::ops::function::FnOnce\">FnOnce</a>(T) -&gt; U,</span></h4></section></summary><div class=\"docblock\"><p>Returns the provided default (if <a href=\"core/result/enum.Result.html#variant.Err\" title=\"variant core::result::Result::Err\"><code>Err</code></a>), or\napplies a function to the contained value (if <a href=\"core/result/enum.Result.html#variant.Ok\" title=\"variant core::result::Result::Ok\"><code>Ok</code></a>).</p>\n<p>Arguments passed to <code>map_or</code> are eagerly evaluated; if you are passing\nthe result of a function call, it is recommended to use <a href=\"core/result/enum.Result.html#method.map_or_else\" title=\"method core::result::Result::map_or_else\"><code>map_or_else</code></a>,\nwhich is lazily evaluated.</p>\n<h5 id=\"examples-9\"><a href=\"#examples-9\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;<span class=\"kw\">_</span>, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"string\">&quot;foo&quot;</span>);\n<span class=\"macro\">assert_eq!</span>(x.map_or(<span class=\"number\">42</span>, |v| v.len()), <span class=\"number\">3</span>);\n\n<span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;<span class=\"kw-2\">&amp;</span>str, <span class=\"kw\">_</span>&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"string\">&quot;bar&quot;</span>);\n<span class=\"macro\">assert_eq!</span>(x.map_or(<span class=\"number\">42</span>, |v| v.len()), <span class=\"number\">42</span>);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+x:+Result%3C_,+%26str%3E+=+Ok(%22foo%22);%0Aassert_eq!(x.map_or(42,+%7Cv%7C+v.len()),+3);%0A%0Alet+x:+Result%3C%26str,+_%3E+=+Err(%22bar%22);%0Aassert_eq!(x.map_or(42,+%7Cv%7C+v.len()),+42);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.map_or_else\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.41.0\">1.41.0</span> · <a class=\"src\" href=\"src/core/result.rs.html#799\">source</a></span><h4 class=\"code-header\">pub fn <a href=\"core/result/enum.Result.html#tymethod.map_or_else\" class=\"fn\">map_or_else</a>&lt;U, D, F&gt;(self, default: D, f: F) -&gt; U<span class=\"where fmt-newline\">where\n    D: <a class=\"trait\" href=\"core/ops/function/trait.FnOnce.html\" title=\"trait core::ops::function::FnOnce\">FnOnce</a>(E) -&gt; U,\n    F: <a class=\"trait\" href=\"core/ops/function/trait.FnOnce.html\" title=\"trait core::ops::function::FnOnce\">FnOnce</a>(T) -&gt; U,</span></h4></section></summary><div class=\"docblock\"><p>Maps a <code>Result&lt;T, E&gt;</code> to <code>U</code> by applying fallback function <code>default</code> to\na contained <a href=\"core/result/enum.Result.html#variant.Err\" title=\"variant core::result::Result::Err\"><code>Err</code></a> value, or function <code>f</code> to a contained <a href=\"core/result/enum.Result.html#variant.Ok\" title=\"variant core::result::Result::Ok\"><code>Ok</code></a> value.</p>\n<p>This function can be used to unpack a successful result\nwhile handling an error.</p>\n<h5 id=\"examples-10\"><a href=\"#examples-10\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>k = <span class=\"number\">21</span>;\n\n<span class=\"kw\">let </span>x : <span class=\"prelude-ty\">Result</span>&lt;<span class=\"kw\">_</span>, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"string\">&quot;foo&quot;</span>);\n<span class=\"macro\">assert_eq!</span>(x.map_or_else(|e| k * <span class=\"number\">2</span>, |v| v.len()), <span class=\"number\">3</span>);\n\n<span class=\"kw\">let </span>x : <span class=\"prelude-ty\">Result</span>&lt;<span class=\"kw-2\">&amp;</span>str, <span class=\"kw\">_</span>&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"string\">&quot;bar&quot;</span>);\n<span class=\"macro\">assert_eq!</span>(x.map_or_else(|e| k * <span class=\"number\">2</span>, |v| v.len()), <span class=\"number\">42</span>);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+k+=+21;%0A%0Alet+x+:+Result%3C_,+%26str%3E+=+Ok(%22foo%22);%0Aassert_eq!(x.map_or_else(%7Ce%7C+k+*+2,+%7Cv%7C+v.len()),+3);%0A%0Alet+x+:+Result%3C%26str,+_%3E+=+Err(%22bar%22);%0Aassert_eq!(x.map_or_else(%7Ce%7C+k+*+2,+%7Cv%7C+v.len()),+42);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.map_err\" class=\"method\"><a class=\"src rightside\" href=\"src/core/result.rs.html#826\">source</a><h4 class=\"code-header\">pub fn <a href=\"core/result/enum.Result.html#tymethod.map_err\" class=\"fn\">map_err</a>&lt;F, O&gt;(self, op: O) -&gt; <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;T, F&gt;<span class=\"where fmt-newline\">where\n    O: <a class=\"trait\" href=\"core/ops/function/trait.FnOnce.html\" title=\"trait core::ops::function::FnOnce\">FnOnce</a>(E) -&gt; F,</span></h4></section></summary><div class=\"docblock\"><p>Maps a <code>Result&lt;T, E&gt;</code> to <code>Result&lt;T, F&gt;</code> by applying a function to a\ncontained <a href=\"core/result/enum.Result.html#variant.Err\" title=\"variant core::result::Result::Err\"><code>Err</code></a> value, leaving an <a href=\"core/result/enum.Result.html#variant.Ok\" title=\"variant core::result::Result::Ok\"><code>Ok</code></a> value untouched.</p>\n<p>This function can be used to pass through a successful result while handling\nan error.</p>\n<h5 id=\"examples-11\"><a href=\"#examples-11\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">fn </span>stringify(x: u32) -&gt; String { <span class=\"macro\">format!</span>(<span class=\"string\">&quot;error code: {x}&quot;</span>) }\n\n<span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, u32&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"number\">2</span>);\n<span class=\"macro\">assert_eq!</span>(x.map_err(stringify), <span class=\"prelude-val\">Ok</span>(<span class=\"number\">2</span>));\n\n<span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, u32&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"number\">13</span>);\n<span class=\"macro\">assert_eq!</span>(x.map_err(stringify), <span class=\"prelude-val\">Err</span>(<span class=\"string\">&quot;error code: 13&quot;</span>.to_string()));</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Afn+stringify(x:+u32)+-%3E+String+%7B+format!(%22error+code:+%7Bx%7D%22)+%7D%0A%0Alet+x:+Result%3Cu32,+u32%3E+=+Ok(2);%0Aassert_eq!(x.map_err(stringify),+Ok(2));%0A%0Alet+x:+Result%3Cu32,+u32%3E+=+Err(13);%0Aassert_eq!(x.map_err(stringify),+Err(%22error+code:+13%22.to_string()));%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.inspect\" class=\"method\"><a class=\"src rightside\" href=\"src/core/result.rs.html#848\">source</a><h4 class=\"code-header\">pub fn <a href=\"core/result/enum.Result.html#tymethod.inspect\" class=\"fn\">inspect</a>&lt;F&gt;(self, f: F) -&gt; <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;T, E&gt;<span class=\"where fmt-newline\">where\n    F: <a class=\"trait\" href=\"core/ops/function/trait.FnOnce.html\" title=\"trait core::ops::function::FnOnce\">FnOnce</a>(<a class=\"primitive\" href=\"core/primitive.reference.html\">&amp;T</a>),</span></h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>result_option_inspect</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/91345\">#91345</a>)</span></div></span></summary><div class=\"docblock\"><p>Calls the provided closure with a reference to the contained value (if <a href=\"core/result/enum.Result.html#variant.Ok\" title=\"variant core::result::Result::Ok\"><code>Ok</code></a>).</p>\n<h5 id=\"examples-12\"><a href=\"#examples-12\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"attr\">#![feature(result_option_inspect)]\n\n</span><span class=\"kw\">let </span>x: u8 = <span class=\"string\">&quot;4&quot;\n    </span>.parse::&lt;u8&gt;()\n    .inspect(|x| <span class=\"macro\">println!</span>(<span class=\"string\">&quot;original: {x}&quot;</span>))\n    .map(|x| x.pow(<span class=\"number\">3</span>))\n    .expect(<span class=\"string\">&quot;failed to parse number&quot;</span>);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A%23!%5Bfeature(result_option_inspect)%5D%0A%0Afn+main()+%7B%0Alet+x:+u8+=+%224%22%0A++++.parse::%3Cu8%3E()%0A++++.inspect(%7Cx%7C+println!(%22original:+%7Bx%7D%22))%0A++++.map(%7Cx%7C+x.pow(3))%0A++++.expect(%22failed+to+parse+number%22);%0A%7D&amp;version=nightly&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.inspect_err\" class=\"method\"><a class=\"src rightside\" href=\"src/core/result.rs.html#872\">source</a><h4 class=\"code-header\">pub fn <a href=\"core/result/enum.Result.html#tymethod.inspect_err\" class=\"fn\">inspect_err</a>&lt;F&gt;(self, f: F) -&gt; <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;T, E&gt;<span class=\"where fmt-newline\">where\n    F: <a class=\"trait\" href=\"core/ops/function/trait.FnOnce.html\" title=\"trait core::ops::function::FnOnce\">FnOnce</a>(<a class=\"primitive\" href=\"core/primitive.reference.html\">&amp;E</a>),</span></h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>result_option_inspect</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/91345\">#91345</a>)</span></div></span></summary><div class=\"docblock\"><p>Calls the provided closure with a reference to the contained error (if <a href=\"core/result/enum.Result.html#variant.Err\" title=\"variant core::result::Result::Err\"><code>Err</code></a>).</p>\n<h5 id=\"examples-13\"><a href=\"#examples-13\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"attr\">#![feature(result_option_inspect)]\n\n</span><span class=\"kw\">use </span>std::{fs, io};\n\n<span class=\"kw\">fn </span>read() -&gt; io::Result&lt;String&gt; {\n    fs::read_to_string(<span class=\"string\">&quot;address.txt&quot;</span>)\n        .inspect_err(|e| <span class=\"macro\">eprintln!</span>(<span class=\"string\">&quot;failed to read file: {e}&quot;</span>))\n}</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A%23!%5Bfeature(result_option_inspect)%5D%0A%0Afn+main()+%7B%0Ause+std::%7Bfs,+io%7D;%0A%0Afn+read()+-%3E+io::Result%3CString%3E+%7B%0A++++fs::read_to_string(%22address.txt%22)%0A++++++++.inspect_err(%7Ce%7C+eprintln!(%22failed+to+read+file:+%7Be%7D%22))%0A%7D%0A%7D&amp;version=nightly&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.as_deref\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.47.0\">1.47.0</span> · <a class=\"src\" href=\"src/core/result.rs.html#898-900\">source</a></span><h4 class=\"code-header\">pub fn <a href=\"core/result/enum.Result.html#tymethod.as_deref\" class=\"fn\">as_deref</a>(&amp;self) -&gt; <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;&amp;&lt;T as <a class=\"trait\" href=\"core/ops/deref/trait.Deref.html\" title=\"trait core::ops::deref::Deref\">Deref</a>&gt;::<a class=\"associatedtype\" href=\"core/ops/deref/trait.Deref.html#associatedtype.Target\" title=\"type core::ops::deref::Deref::Target\">Target</a>, <a class=\"primitive\" href=\"core/primitive.reference.html\">&amp;E</a>&gt;<span class=\"where fmt-newline\">where\n    T: <a class=\"trait\" href=\"core/ops/deref/trait.Deref.html\" title=\"trait core::ops::deref::Deref\">Deref</a>,</span></h4></section></summary><div class=\"docblock\"><p>Converts from <code>Result&lt;T, E&gt;</code> (or <code>&amp;Result&lt;T, E&gt;</code>) to <code>Result&lt;&amp;&lt;T as Deref&gt;::Target, &amp;E&gt;</code>.</p>\n<p>Coerces the <a href=\"core/result/enum.Result.html#variant.Ok\" title=\"variant core::result::Result::Ok\"><code>Ok</code></a> variant of the original <a href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\"><code>Result</code></a> via <a href=\"core/ops/deref/trait.Deref.html\" title=\"trait core::ops::deref::Deref\"><code>Deref</code></a>\nand returns the new <a href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\"><code>Result</code></a>.</p>\n<h5 id=\"examples-14\"><a href=\"#examples-14\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;String, u32&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"string\">&quot;hello&quot;</span>.to_string());\n<span class=\"kw\">let </span>y: <span class=\"prelude-ty\">Result</span>&lt;<span class=\"kw-2\">&amp;</span>str, <span class=\"kw-2\">&amp;</span>u32&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"string\">&quot;hello&quot;</span>);\n<span class=\"macro\">assert_eq!</span>(x.as_deref(), y);\n\n<span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;String, u32&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"number\">42</span>);\n<span class=\"kw\">let </span>y: <span class=\"prelude-ty\">Result</span>&lt;<span class=\"kw-2\">&amp;</span>str, <span class=\"kw-2\">&amp;</span>u32&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"kw-2\">&amp;</span><span class=\"number\">42</span>);\n<span class=\"macro\">assert_eq!</span>(x.as_deref(), y);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+x:+Result%3CString,+u32%3E+=+Ok(%22hello%22.to_string());%0Alet+y:+Result%3C%26str,+%26u32%3E+=+Ok(%22hello%22);%0Aassert_eq!(x.as_deref(),+y);%0A%0Alet+x:+Result%3CString,+u32%3E+=+Err(42);%0Alet+y:+Result%3C%26str,+%26u32%3E+=+Err(%2642);%0Aassert_eq!(x.as_deref(),+y);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.as_deref_mut\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.47.0\">1.47.0</span> · <a class=\"src\" href=\"src/core/result.rs.html#925-927\">source</a></span><h4 class=\"code-header\">pub fn <a href=\"core/result/enum.Result.html#tymethod.as_deref_mut\" class=\"fn\">as_deref_mut</a>(&amp;mut self) -&gt; <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;&amp;mut &lt;T as <a class=\"trait\" href=\"core/ops/deref/trait.Deref.html\" title=\"trait core::ops::deref::Deref\">Deref</a>&gt;::<a class=\"associatedtype\" href=\"core/ops/deref/trait.Deref.html#associatedtype.Target\" title=\"type core::ops::deref::Deref::Target\">Target</a>, <a class=\"primitive\" href=\"core/primitive.reference.html\">&amp;mut E</a>&gt;<span class=\"where fmt-newline\">where\n    T: <a class=\"trait\" href=\"core/ops/deref/trait.DerefMut.html\" title=\"trait core::ops::deref::DerefMut\">DerefMut</a>,</span></h4></section></summary><div class=\"docblock\"><p>Converts from <code>Result&lt;T, E&gt;</code> (or <code>&amp;mut Result&lt;T, E&gt;</code>) to <code>Result&lt;&amp;mut &lt;T as DerefMut&gt;::Target, &amp;mut E&gt;</code>.</p>\n<p>Coerces the <a href=\"core/result/enum.Result.html#variant.Ok\" title=\"variant core::result::Result::Ok\"><code>Ok</code></a> variant of the original <a href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\"><code>Result</code></a> via <a href=\"core/ops/deref/trait.DerefMut.html\" title=\"trait core::ops::deref::DerefMut\"><code>DerefMut</code></a>\nand returns the new <a href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\"><code>Result</code></a>.</p>\n<h5 id=\"examples-15\"><a href=\"#examples-15\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>s = <span class=\"string\">&quot;HELLO&quot;</span>.to_string();\n<span class=\"kw\">let </span><span class=\"kw-2\">mut </span>x: <span class=\"prelude-ty\">Result</span>&lt;String, u32&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"string\">&quot;hello&quot;</span>.to_string());\n<span class=\"kw\">let </span>y: <span class=\"prelude-ty\">Result</span>&lt;<span class=\"kw-2\">&amp;mut </span>str, <span class=\"kw-2\">&amp;mut </span>u32&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"kw-2\">&amp;mut </span>s);\n<span class=\"macro\">assert_eq!</span>(x.as_deref_mut().map(|x| { x.make_ascii_uppercase(); x }), y);\n\n<span class=\"kw\">let </span><span class=\"kw-2\">mut </span>i = <span class=\"number\">42</span>;\n<span class=\"kw\">let </span><span class=\"kw-2\">mut </span>x: <span class=\"prelude-ty\">Result</span>&lt;String, u32&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"number\">42</span>);\n<span class=\"kw\">let </span>y: <span class=\"prelude-ty\">Result</span>&lt;<span class=\"kw-2\">&amp;mut </span>str, <span class=\"kw-2\">&amp;mut </span>u32&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"kw-2\">&amp;mut </span>i);\n<span class=\"macro\">assert_eq!</span>(x.as_deref_mut().map(|x| { x.make_ascii_uppercase(); x }), y);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+mut+s+=+%22HELLO%22.to_string();%0Alet+mut+x:+Result%3CString,+u32%3E+=+Ok(%22hello%22.to_string());%0Alet+y:+Result%3C%26mut+str,+%26mut+u32%3E+=+Ok(%26mut+s);%0Aassert_eq!(x.as_deref_mut().map(%7Cx%7C+%7B+x.make_ascii_uppercase();+x+%7D),+y);%0A%0Alet+mut+i+=+42;%0Alet+mut+x:+Result%3CString,+u32%3E+=+Err(42);%0Alet+y:+Result%3C%26mut+str,+%26mut+u32%3E+=+Err(%26mut+i);%0Aassert_eq!(x.as_deref_mut().map(%7Cx%7C+%7B+x.make_ascii_uppercase();+x+%7D),+y);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.iter\" class=\"method\"><a class=\"src rightside\" href=\"src/core/result.rs.html#951\">source</a><h4 class=\"code-header\">pub fn <a href=\"core/result/enum.Result.html#tymethod.iter\" class=\"fn\">iter</a>(&amp;self) -&gt; <a class=\"struct\" href=\"core/result/struct.Iter.html\" title=\"struct core::result::Iter\">Iter</a>&lt;'_, T&gt;</h4></section></summary><div class=\"docblock\"><p>Returns an iterator over the possibly contained value.</p>\n<p>The iterator yields one value if the result is <a href=\"core/result/enum.Result.html#variant.Ok\" title=\"variant core::result::Result::Ok\"><code>Result::Ok</code></a>, otherwise none.</p>\n<h5 id=\"examples-16\"><a href=\"#examples-16\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"number\">7</span>);\n<span class=\"macro\">assert_eq!</span>(x.iter().next(), <span class=\"prelude-val\">Some</span>(<span class=\"kw-2\">&amp;</span><span class=\"number\">7</span>));\n\n<span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"string\">&quot;nothing!&quot;</span>);\n<span class=\"macro\">assert_eq!</span>(x.iter().next(), <span class=\"prelude-val\">None</span>);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+x:+Result%3Cu32,+%26str%3E+=+Ok(7);%0Aassert_eq!(x.iter().next(),+Some(%267));%0A%0Alet+x:+Result%3Cu32,+%26str%3E+=+Err(%22nothing!%22);%0Aassert_eq!(x.iter().next(),+None);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.iter_mut\" class=\"method\"><a class=\"src rightside\" href=\"src/core/result.rs.html#974\">source</a><h4 class=\"code-header\">pub fn <a href=\"core/result/enum.Result.html#tymethod.iter_mut\" class=\"fn\">iter_mut</a>(&amp;mut self) -&gt; <a class=\"struct\" href=\"core/result/struct.IterMut.html\" title=\"struct core::result::IterMut\">IterMut</a>&lt;'_, T&gt;</h4></section></summary><div class=\"docblock\"><p>Returns a mutable iterator over the possibly contained value.</p>\n<p>The iterator yields one value if the result is <a href=\"core/result/enum.Result.html#variant.Ok\" title=\"variant core::result::Result::Ok\"><code>Result::Ok</code></a>, otherwise none.</p>\n<h5 id=\"examples-17\"><a href=\"#examples-17\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"number\">7</span>);\n<span class=\"kw\">match </span>x.iter_mut().next() {\n    <span class=\"prelude-val\">Some</span>(v) =&gt; <span class=\"kw-2\">*</span>v = <span class=\"number\">40</span>,\n    <span class=\"prelude-val\">None </span>=&gt; {},\n}\n<span class=\"macro\">assert_eq!</span>(x, <span class=\"prelude-val\">Ok</span>(<span class=\"number\">40</span>));\n\n<span class=\"kw\">let </span><span class=\"kw-2\">mut </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"string\">&quot;nothing!&quot;</span>);\n<span class=\"macro\">assert_eq!</span>(x.iter_mut().next(), <span class=\"prelude-val\">None</span>);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+mut+x:+Result%3Cu32,+%26str%3E+=+Ok(7);%0Amatch+x.iter_mut().next()+%7B%0A++++Some(v)+=%3E+*v+=+40,%0A++++None+=%3E+%7B%7D,%0A%7D%0Aassert_eq!(x,+Ok(40));%0A%0Alet+mut+x:+Result%3Cu32,+%26str%3E+=+Err(%22nothing!%22);%0Aassert_eq!(x.iter_mut().next(),+None);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.expect\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.4.0\">1.4.0</span> · <a class=\"src\" href=\"src/core/result.rs.html#1028-1030\">source</a></span><h4 class=\"code-header\">pub fn <a href=\"core/result/enum.Result.html#tymethod.expect\" class=\"fn\">expect</a>(self, msg: &amp;<a class=\"primitive\" href=\"core/primitive.str.html\">str</a>) -&gt; T<span class=\"where fmt-newline\">where\n    E: <a class=\"trait\" href=\"alloc/fmt/trait.Debug.html\" title=\"trait alloc::fmt::Debug\">Debug</a>,</span></h4></section></summary><div class=\"docblock\"><p>Returns the contained <a href=\"core/result/enum.Result.html#variant.Ok\" title=\"variant core::result::Result::Ok\"><code>Ok</code></a> value, consuming the <code>self</code> value.</p>\n<p>Because this function may panic, its use is generally discouraged.\nInstead, prefer to use pattern matching and handle the <a href=\"core/result/enum.Result.html#variant.Err\" title=\"variant core::result::Result::Err\"><code>Err</code></a>\ncase explicitly, or call <a href=\"core/result/enum.Result.html#method.unwrap_or\" title=\"method core::result::Result::unwrap_or\"><code>unwrap_or</code></a>, <a href=\"core/result/enum.Result.html#method.unwrap_or_else\" title=\"method core::result::Result::unwrap_or_else\"><code>unwrap_or_else</code></a>, or\n<a href=\"core/result/enum.Result.html#method.unwrap_or_default\" title=\"method core::result::Result::unwrap_or_default\"><code>unwrap_or_default</code></a>.</p>\n<h5 id=\"panics\"><a href=\"#panics\">Panics</a></h5>\n<p>Panics if the value is an <a href=\"core/result/enum.Result.html#variant.Err\" title=\"variant core::result::Result::Err\"><code>Err</code></a>, with a panic message including the\npassed message, and the content of the <a href=\"core/result/enum.Result.html#variant.Err\" title=\"variant core::result::Result::Err\"><code>Err</code></a>.</p>\n<h5 id=\"examples-18\"><a href=\"#examples-18\">Examples</a></h5>\n<div class=\"example-wrap should_panic\"><a href=\"#\" class=\"tooltip\" title=\"This example panics\">ⓘ</a><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"string\">&quot;emergency failure&quot;</span>);\nx.expect(<span class=\"string\">&quot;Testing expect&quot;</span>); <span class=\"comment\">// panics with `Testing expect: emergency failure`</span></code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+x:+Result%3Cu32,+%26str%3E+=+Err(%22emergency+failure%22);%0Ax.expect(%22Testing+expect%22);+//+panics+with+%60Testing+expect:+emergency+failure%60%0A%7D&amp;edition=2021\">Run</a></div>\n<h5 id=\"recommended-message-style\"><a href=\"#recommended-message-style\">Recommended Message Style</a></h5>\n<p>We recommend that <code>expect</code> messages are used to describe the reason you\n<em>expect</em> the <code>Result</code> should be <code>Ok</code>.</p>\n\n<div class=\"example-wrap should_panic\"><a href=\"#\" class=\"tooltip\" title=\"This example panics\">ⓘ</a><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>path = std::env::var(<span class=\"string\">&quot;IMPORTANT_PATH&quot;</span>)\n    .expect(<span class=\"string\">&quot;env variable `IMPORTANT_PATH` should be set by `wrapper_script.sh`&quot;</span>);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+path+=+std::env::var(%22IMPORTANT_PATH%22)%0A++++.expect(%22env+variable+%60IMPORTANT_PATH%60+should+be+set+by+%60wrapper_script.sh%60%22);%0A%7D&amp;edition=2021\">Run</a></div>\n<p><strong>Hint</strong>: If you’re having trouble remembering how to phrase expect\nerror messages remember to focus on the word “should” as in “env\nvariable should be set by blah” or “the given binary should be available\nand executable by the current user”.</p>\n<p>For more detail on expect message styles and the reasoning behind our recommendation please\nrefer to the section on <a href=\"../../std/error/index.html#common-message-styles\">“Common Message\nStyles”</a> in the\n<a href=\"../../std/error/index.html\"><code>std::error</code></a> module docs.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.unwrap\" class=\"method\"><a class=\"src rightside\" href=\"src/core/result.rs.html#1071-1073\">source</a><h4 class=\"code-header\">pub fn <a href=\"core/result/enum.Result.html#tymethod.unwrap\" class=\"fn\">unwrap</a>(self) -&gt; T<span class=\"where fmt-newline\">where\n    E: <a class=\"trait\" href=\"alloc/fmt/trait.Debug.html\" title=\"trait alloc::fmt::Debug\">Debug</a>,</span></h4></section></summary><div class=\"docblock\"><p>Returns the contained <a href=\"core/result/enum.Result.html#variant.Ok\" title=\"variant core::result::Result::Ok\"><code>Ok</code></a> value, consuming the <code>self</code> value.</p>\n<p>Because this function may panic, its use is generally discouraged.\nInstead, prefer to use pattern matching and handle the <a href=\"core/result/enum.Result.html#variant.Err\" title=\"variant core::result::Result::Err\"><code>Err</code></a>\ncase explicitly, or call <a href=\"core/result/enum.Result.html#method.unwrap_or\" title=\"method core::result::Result::unwrap_or\"><code>unwrap_or</code></a>, <a href=\"core/result/enum.Result.html#method.unwrap_or_else\" title=\"method core::result::Result::unwrap_or_else\"><code>unwrap_or_else</code></a>, or\n<a href=\"core/result/enum.Result.html#method.unwrap_or_default\" title=\"method core::result::Result::unwrap_or_default\"><code>unwrap_or_default</code></a>.</p>\n<h5 id=\"panics-1\"><a href=\"#panics-1\">Panics</a></h5>\n<p>Panics if the value is an <a href=\"core/result/enum.Result.html#variant.Err\" title=\"variant core::result::Result::Err\"><code>Err</code></a>, with a panic message provided by the\n<a href=\"core/result/enum.Result.html#variant.Err\" title=\"variant core::result::Result::Err\"><code>Err</code></a>’s value.</p>\n<h5 id=\"examples-19\"><a href=\"#examples-19\">Examples</a></h5>\n<p>Basic usage:</p>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"number\">2</span>);\n<span class=\"macro\">assert_eq!</span>(x.unwrap(), <span class=\"number\">2</span>);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+x:+Result%3Cu32,+%26str%3E+=+Ok(2);%0Aassert_eq!(x.unwrap(),+2);%0A%7D&amp;edition=2021\">Run</a></div>\n\n<div class=\"example-wrap should_panic\"><a href=\"#\" class=\"tooltip\" title=\"This example panics\">ⓘ</a><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"string\">&quot;emergency failure&quot;</span>);\nx.unwrap(); <span class=\"comment\">// panics with `emergency failure`</span></code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+x:+Result%3Cu32,+%26str%3E+=+Err(%22emergency+failure%22);%0Ax.unwrap();+//+panics+with+%60emergency+failure%60%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.unwrap_or_default\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.16.0\">1.16.0</span> · <a class=\"src\" href=\"src/core/result.rs.html#1108-1110\">source</a></span><h4 class=\"code-header\">pub fn <a href=\"core/result/enum.Result.html#tymethod.unwrap_or_default\" class=\"fn\">unwrap_or_default</a>(self) -&gt; T<span class=\"where fmt-newline\">where\n    T: <a class=\"trait\" href=\"core/default/trait.Default.html\" title=\"trait core::default::Default\">Default</a>,</span></h4></section></summary><div class=\"docblock\"><p>Returns the contained <a href=\"core/result/enum.Result.html#variant.Ok\" title=\"variant core::result::Result::Ok\"><code>Ok</code></a> value or a default</p>\n<p>Consumes the <code>self</code> argument then, if <a href=\"core/result/enum.Result.html#variant.Ok\" title=\"variant core::result::Result::Ok\"><code>Ok</code></a>, returns the contained\nvalue, otherwise if <a href=\"core/result/enum.Result.html#variant.Err\" title=\"variant core::result::Result::Err\"><code>Err</code></a>, returns the default value for that\ntype.</p>\n<h5 id=\"examples-20\"><a href=\"#examples-20\">Examples</a></h5>\n<p>Converts a string to an integer, turning poorly-formed strings\ninto 0 (the default value for integers). <a href=\"core/primitive.str.html#method.parse\" title=\"method str::parse\"><code>parse</code></a> converts\na string to any other type that implements <a href=\"alloc/str/trait.FromStr.html\" title=\"trait alloc::str::FromStr\"><code>FromStr</code></a>, returning an\n<a href=\"core/result/enum.Result.html#variant.Err\" title=\"variant core::result::Result::Err\"><code>Err</code></a> on error.</p>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>good_year_from_input = <span class=\"string\">&quot;1909&quot;</span>;\n<span class=\"kw\">let </span>bad_year_from_input = <span class=\"string\">&quot;190blarg&quot;</span>;\n<span class=\"kw\">let </span>good_year = good_year_from_input.parse().unwrap_or_default();\n<span class=\"kw\">let </span>bad_year = bad_year_from_input.parse().unwrap_or_default();\n\n<span class=\"macro\">assert_eq!</span>(<span class=\"number\">1909</span>, good_year);\n<span class=\"macro\">assert_eq!</span>(<span class=\"number\">0</span>, bad_year);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+good_year_from_input+=+%221909%22;%0Alet+bad_year_from_input+=+%22190blarg%22;%0Alet+good_year+=+good_year_from_input.parse().unwrap_or_default();%0Alet+bad_year+=+bad_year_from_input.parse().unwrap_or_default();%0A%0Aassert_eq!(1909,+good_year);%0Aassert_eq!(0,+bad_year);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.expect_err\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.17.0\">1.17.0</span> · <a class=\"src\" href=\"src/core/result.rs.html#1135-1137\">source</a></span><h4 class=\"code-header\">pub fn <a href=\"core/result/enum.Result.html#tymethod.expect_err\" class=\"fn\">expect_err</a>(self, msg: &amp;<a class=\"primitive\" href=\"core/primitive.str.html\">str</a>) -&gt; E<span class=\"where fmt-newline\">where\n    T: <a class=\"trait\" href=\"alloc/fmt/trait.Debug.html\" title=\"trait alloc::fmt::Debug\">Debug</a>,</span></h4></section></summary><div class=\"docblock\"><p>Returns the contained <a href=\"core/result/enum.Result.html#variant.Err\" title=\"variant core::result::Result::Err\"><code>Err</code></a> value, consuming the <code>self</code> value.</p>\n<h5 id=\"panics-2\"><a href=\"#panics-2\">Panics</a></h5>\n<p>Panics if the value is an <a href=\"core/result/enum.Result.html#variant.Ok\" title=\"variant core::result::Result::Ok\"><code>Ok</code></a>, with a panic message including the\npassed message, and the content of the <a href=\"core/result/enum.Result.html#variant.Ok\" title=\"variant core::result::Result::Ok\"><code>Ok</code></a>.</p>\n<h5 id=\"examples-21\"><a href=\"#examples-21\">Examples</a></h5>\n<div class=\"example-wrap should_panic\"><a href=\"#\" class=\"tooltip\" title=\"This example panics\">ⓘ</a><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"number\">10</span>);\nx.expect_err(<span class=\"string\">&quot;Testing expect_err&quot;</span>); <span class=\"comment\">// panics with `Testing expect_err: 10`</span></code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+x:+Result%3Cu32,+%26str%3E+=+Ok(10);%0Ax.expect_err(%22Testing+expect_err%22);+//+panics+with+%60Testing+expect_err:+10%60%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.unwrap_err\" class=\"method\"><a class=\"src rightside\" href=\"src/core/result.rs.html#1166-1168\">source</a><h4 class=\"code-header\">pub fn <a href=\"core/result/enum.Result.html#tymethod.unwrap_err\" class=\"fn\">unwrap_err</a>(self) -&gt; E<span class=\"where fmt-newline\">where\n    T: <a class=\"trait\" href=\"alloc/fmt/trait.Debug.html\" title=\"trait alloc::fmt::Debug\">Debug</a>,</span></h4></section></summary><div class=\"docblock\"><p>Returns the contained <a href=\"core/result/enum.Result.html#variant.Err\" title=\"variant core::result::Result::Err\"><code>Err</code></a> value, consuming the <code>self</code> value.</p>\n<h5 id=\"panics-3\"><a href=\"#panics-3\">Panics</a></h5>\n<p>Panics if the value is an <a href=\"core/result/enum.Result.html#variant.Ok\" title=\"variant core::result::Result::Ok\"><code>Ok</code></a>, with a custom panic message provided\nby the <a href=\"core/result/enum.Result.html#variant.Ok\" title=\"variant core::result::Result::Ok\"><code>Ok</code></a>’s value.</p>\n<h5 id=\"examples-22\"><a href=\"#examples-22\">Examples</a></h5>\n<div class=\"example-wrap should_panic\"><a href=\"#\" class=\"tooltip\" title=\"This example panics\">ⓘ</a><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"number\">2</span>);\nx.unwrap_err(); <span class=\"comment\">// panics with `2`</span></code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+x:+Result%3Cu32,+%26str%3E+=+Ok(2);%0Ax.unwrap_err();+//+panics+with+%602%60%0A%7D&amp;edition=2021\">Run</a></div>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"string\">&quot;emergency failure&quot;</span>);\n<span class=\"macro\">assert_eq!</span>(x.unwrap_err(), <span class=\"string\">&quot;emergency failure&quot;</span>);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+x:+Result%3Cu32,+%26str%3E+=+Err(%22emergency+failure%22);%0Aassert_eq!(x.unwrap_err(),+%22emergency+failure%22);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.into_ok\" class=\"method\"><a class=\"src rightside\" href=\"src/core/result.rs.html#1201-1203\">source</a><h4 class=\"code-header\">pub fn <a href=\"core/result/enum.Result.html#tymethod.into_ok\" class=\"fn\">into_ok</a>(self) -&gt; T<span class=\"where fmt-newline\">where\n    E: <a class=\"trait\" href=\"core/convert/trait.Into.html\" title=\"trait core::convert::Into\">Into</a>&lt;<a class=\"primitive\" href=\"core/primitive.never.html\">!</a>&gt;,</span></h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>unwrap_infallible</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/61695\">#61695</a>)</span></div></span></summary><div class=\"docblock\"><p>Returns the contained <a href=\"core/result/enum.Result.html#variant.Ok\" title=\"variant core::result::Result::Ok\"><code>Ok</code></a> value, but never panics.</p>\n<p>Unlike <a href=\"core/result/enum.Result.html#method.unwrap\" title=\"method core::result::Result::unwrap\"><code>unwrap</code></a>, this method is known to never panic on the\nresult types it is implemented for. Therefore, it can be used\ninstead of <code>unwrap</code> as a maintainability safeguard that will fail\nto compile if the error type of the <code>Result</code> is later changed\nto an error that can actually occur.</p>\n<h5 id=\"examples-23\"><a href=\"#examples-23\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code>\n<span class=\"kw\">fn </span>only_good_news() -&gt; <span class=\"prelude-ty\">Result</span>&lt;String, !&gt; {\n    <span class=\"prelude-val\">Ok</span>(<span class=\"string\">&quot;this is fine&quot;</span>.into())\n}\n\n<span class=\"kw\">let </span>s: String = only_good_news().into_ok();\n<span class=\"macro\">println!</span>(<span class=\"string\">&quot;{s}&quot;</span>);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A%23!%5Bfeature(never_type)%5D%0A%23!%5Bfeature(unwrap_infallible)%5D%0A%0Afn+main()+%7B%0Afn+only_good_news()+-%3E+Result%3CString,+!%3E+%7B%0A++++Ok(%22this+is+fine%22.into())%0A%7D%0A%0Alet+s:+String+=+only_good_news().into_ok();%0Aprintln!(%22%7Bs%7D%22);%0A%7D&amp;version=nightly&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.into_err\" class=\"method\"><a class=\"src rightside\" href=\"src/core/result.rs.html#1236-1238\">source</a><h4 class=\"code-header\">pub fn <a href=\"core/result/enum.Result.html#tymethod.into_err\" class=\"fn\">into_err</a>(self) -&gt; E<span class=\"where fmt-newline\">where\n    T: <a class=\"trait\" href=\"core/convert/trait.Into.html\" title=\"trait core::convert::Into\">Into</a>&lt;<a class=\"primitive\" href=\"core/primitive.never.html\">!</a>&gt;,</span></h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>unwrap_infallible</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/61695\">#61695</a>)</span></div></span></summary><div class=\"docblock\"><p>Returns the contained <a href=\"core/result/enum.Result.html#variant.Err\" title=\"variant core::result::Result::Err\"><code>Err</code></a> value, but never panics.</p>\n<p>Unlike <a href=\"core/result/enum.Result.html#method.unwrap_err\" title=\"method core::result::Result::unwrap_err\"><code>unwrap_err</code></a>, this method is known to never panic on the\nresult types it is implemented for. Therefore, it can be used\ninstead of <code>unwrap_err</code> as a maintainability safeguard that will fail\nto compile if the ok type of the <code>Result</code> is later changed\nto a type that can actually occur.</p>\n<h5 id=\"examples-24\"><a href=\"#examples-24\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code>\n<span class=\"kw\">fn </span>only_bad_news() -&gt; <span class=\"prelude-ty\">Result</span>&lt;!, String&gt; {\n    <span class=\"prelude-val\">Err</span>(<span class=\"string\">&quot;Oops, it failed&quot;</span>.into())\n}\n\n<span class=\"kw\">let </span>error: String = only_bad_news().into_err();\n<span class=\"macro\">println!</span>(<span class=\"string\">&quot;{error}&quot;</span>);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A%23!%5Bfeature(never_type)%5D%0A%23!%5Bfeature(unwrap_infallible)%5D%0A%0Afn+main()+%7B%0Afn+only_bad_news()+-%3E+Result%3C!,+String%3E+%7B%0A++++Err(%22Oops,+it+failed%22.into())%0A%7D%0A%0Alet+error:+String+=+only_bad_news().into_err();%0Aprintln!(%22%7Berror%7D%22);%0A%7D&amp;version=nightly&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.and\" class=\"method\"><a class=\"src rightside\" href=\"src/core/result.rs.html#1279\">source</a><h4 class=\"code-header\">pub fn <a href=\"core/result/enum.Result.html#tymethod.and\" class=\"fn\">and</a>&lt;U&gt;(self, res: <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;U, E&gt;) -&gt; <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;U, E&gt;</h4></section></summary><div class=\"docblock\"><p>Returns <code>res</code> if the result is <a href=\"core/result/enum.Result.html#variant.Ok\" title=\"variant core::result::Result::Ok\"><code>Ok</code></a>, otherwise returns the <a href=\"core/result/enum.Result.html#variant.Err\" title=\"variant core::result::Result::Err\"><code>Err</code></a> value of <code>self</code>.</p>\n<p>Arguments passed to <code>and</code> are eagerly evaluated; if you are passing the\nresult of a function call, it is recommended to use <a href=\"core/result/enum.Result.html#method.and_then\" title=\"method core::result::Result::and_then\"><code>and_then</code></a>, which is\nlazily evaluated.</p>\n<h5 id=\"examples-25\"><a href=\"#examples-25\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"number\">2</span>);\n<span class=\"kw\">let </span>y: <span class=\"prelude-ty\">Result</span>&lt;<span class=\"kw-2\">&amp;</span>str, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"string\">&quot;late error&quot;</span>);\n<span class=\"macro\">assert_eq!</span>(x.and(y), <span class=\"prelude-val\">Err</span>(<span class=\"string\">&quot;late error&quot;</span>));\n\n<span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"string\">&quot;early error&quot;</span>);\n<span class=\"kw\">let </span>y: <span class=\"prelude-ty\">Result</span>&lt;<span class=\"kw-2\">&amp;</span>str, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"string\">&quot;foo&quot;</span>);\n<span class=\"macro\">assert_eq!</span>(x.and(y), <span class=\"prelude-val\">Err</span>(<span class=\"string\">&quot;early error&quot;</span>));\n\n<span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"string\">&quot;not a 2&quot;</span>);\n<span class=\"kw\">let </span>y: <span class=\"prelude-ty\">Result</span>&lt;<span class=\"kw-2\">&amp;</span>str, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"string\">&quot;late error&quot;</span>);\n<span class=\"macro\">assert_eq!</span>(x.and(y), <span class=\"prelude-val\">Err</span>(<span class=\"string\">&quot;not a 2&quot;</span>));\n\n<span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"number\">2</span>);\n<span class=\"kw\">let </span>y: <span class=\"prelude-ty\">Result</span>&lt;<span class=\"kw-2\">&amp;</span>str, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"string\">&quot;different result type&quot;</span>);\n<span class=\"macro\">assert_eq!</span>(x.and(y), <span class=\"prelude-val\">Ok</span>(<span class=\"string\">&quot;different result type&quot;</span>));</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+x:+Result%3Cu32,+%26str%3E+=+Ok(2);%0Alet+y:+Result%3C%26str,+%26str%3E+=+Err(%22late+error%22);%0Aassert_eq!(x.and(y),+Err(%22late+error%22));%0A%0Alet+x:+Result%3Cu32,+%26str%3E+=+Err(%22early+error%22);%0Alet+y:+Result%3C%26str,+%26str%3E+=+Ok(%22foo%22);%0Aassert_eq!(x.and(y),+Err(%22early+error%22));%0A%0Alet+x:+Result%3Cu32,+%26str%3E+=+Err(%22not+a+2%22);%0Alet+y:+Result%3C%26str,+%26str%3E+=+Err(%22late+error%22);%0Aassert_eq!(x.and(y),+Err(%22not+a+2%22));%0A%0Alet+x:+Result%3Cu32,+%26str%3E+=+Ok(2);%0Alet+y:+Result%3C%26str,+%26str%3E+=+Ok(%22different+result+type%22);%0Aassert_eq!(x.and(y),+Ok(%22different+result+type%22));%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.and_then\" class=\"method\"><a class=\"src rightside\" href=\"src/core/result.rs.html#1318\">source</a><h4 class=\"code-header\">pub fn <a href=\"core/result/enum.Result.html#tymethod.and_then\" class=\"fn\">and_then</a>&lt;U, F&gt;(self, op: F) -&gt; <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;U, E&gt;<span class=\"where fmt-newline\">where\n    F: <a class=\"trait\" href=\"core/ops/function/trait.FnOnce.html\" title=\"trait core::ops::function::FnOnce\">FnOnce</a>(T) -&gt; <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;U, E&gt;,</span></h4></section></summary><div class=\"docblock\"><p>Calls <code>op</code> if the result is <a href=\"core/result/enum.Result.html#variant.Ok\" title=\"variant core::result::Result::Ok\"><code>Ok</code></a>, otherwise returns the <a href=\"core/result/enum.Result.html#variant.Err\" title=\"variant core::result::Result::Err\"><code>Err</code></a> value of <code>self</code>.</p>\n<p>This function can be used for control flow based on <code>Result</code> values.</p>\n<h5 id=\"examples-26\"><a href=\"#examples-26\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">fn </span>sq_then_to_string(x: u32) -&gt; <span class=\"prelude-ty\">Result</span>&lt;String, <span class=\"kw-2\">&amp;</span><span class=\"lifetime\">&#39;static </span>str&gt; {\n    x.checked_mul(x).map(|sq| sq.to_string()).ok_or(<span class=\"string\">&quot;overflowed&quot;</span>)\n}\n\n<span class=\"macro\">assert_eq!</span>(<span class=\"prelude-val\">Ok</span>(<span class=\"number\">2</span>).and_then(sq_then_to_string), <span class=\"prelude-val\">Ok</span>(<span class=\"number\">4</span>.to_string()));\n<span class=\"macro\">assert_eq!</span>(<span class=\"prelude-val\">Ok</span>(<span class=\"number\">1_000_000</span>).and_then(sq_then_to_string), <span class=\"prelude-val\">Err</span>(<span class=\"string\">&quot;overflowed&quot;</span>));\n<span class=\"macro\">assert_eq!</span>(<span class=\"prelude-val\">Err</span>(<span class=\"string\">&quot;not a number&quot;</span>).and_then(sq_then_to_string), <span class=\"prelude-val\">Err</span>(<span class=\"string\">&quot;not a number&quot;</span>));</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Afn+sq_then_to_string(x:+u32)+-%3E+Result%3CString,+%26'static+str%3E+%7B%0A++++x.checked_mul(x).map(%7Csq%7C+sq.to_string()).ok_or(%22overflowed%22)%0A%7D%0A%0Aassert_eq!(Ok(2).and_then(sq_then_to_string),+Ok(4.to_string()));%0Aassert_eq!(Ok(1_000_000).and_then(sq_then_to_string),+Err(%22overflowed%22));%0Aassert_eq!(Err(%22not+a+number%22).and_then(sq_then_to_string),+Err(%22not+a+number%22));%0A%7D&amp;edition=2021\">Run</a></div>\n<p>Often used to chain fallible operations that may return <a href=\"core/result/enum.Result.html#variant.Err\" title=\"variant core::result::Result::Err\"><code>Err</code></a>.</p>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">use </span>std::{io::ErrorKind, path::Path};\n\n<span class=\"comment\">// Note: on Windows &quot;/&quot; maps to &quot;C:\\&quot;\n</span><span class=\"kw\">let </span>root_modified_time = Path::new(<span class=\"string\">&quot;/&quot;</span>).metadata().and_then(|md| md.modified());\n<span class=\"macro\">assert!</span>(root_modified_time.is_ok());\n\n<span class=\"kw\">let </span>should_fail = Path::new(<span class=\"string\">&quot;/bad/path&quot;</span>).metadata().and_then(|md| md.modified());\n<span class=\"macro\">assert!</span>(should_fail.is_err());\n<span class=\"macro\">assert_eq!</span>(should_fail.unwrap_err().kind(), ErrorKind::NotFound);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Ause+std::%7Bio::ErrorKind,+path::Path%7D;%0A%0A//+Note:+on+Windows+%22/%22+maps+to+%22C:%5C%22%0Alet+root_modified_time+=+Path::new(%22/%22).metadata().and_then(%7Cmd%7C+md.modified());%0Aassert!(root_modified_time.is_ok());%0A%0Alet+should_fail+=+Path::new(%22/bad/path%22).metadata().and_then(%7Cmd%7C+md.modified());%0Aassert!(should_fail.is_err());%0Aassert_eq!(should_fail.unwrap_err().kind(),+ErrorKind::NotFound);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.or\" class=\"method\"><a class=\"src rightside\" href=\"src/core/result.rs.html#1354\">source</a><h4 class=\"code-header\">pub fn <a href=\"core/result/enum.Result.html#tymethod.or\" class=\"fn\">or</a>&lt;F&gt;(self, res: <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;T, F&gt;) -&gt; <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;T, F&gt;</h4></section></summary><div class=\"docblock\"><p>Returns <code>res</code> if the result is <a href=\"core/result/enum.Result.html#variant.Err\" title=\"variant core::result::Result::Err\"><code>Err</code></a>, otherwise returns the <a href=\"core/result/enum.Result.html#variant.Ok\" title=\"variant core::result::Result::Ok\"><code>Ok</code></a> value of <code>self</code>.</p>\n<p>Arguments passed to <code>or</code> are eagerly evaluated; if you are passing the\nresult of a function call, it is recommended to use <a href=\"core/result/enum.Result.html#method.or_else\" title=\"method core::result::Result::or_else\"><code>or_else</code></a>, which is\nlazily evaluated.</p>\n<h5 id=\"examples-27\"><a href=\"#examples-27\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"number\">2</span>);\n<span class=\"kw\">let </span>y: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"string\">&quot;late error&quot;</span>);\n<span class=\"macro\">assert_eq!</span>(x.or(y), <span class=\"prelude-val\">Ok</span>(<span class=\"number\">2</span>));\n\n<span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"string\">&quot;early error&quot;</span>);\n<span class=\"kw\">let </span>y: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"number\">2</span>);\n<span class=\"macro\">assert_eq!</span>(x.or(y), <span class=\"prelude-val\">Ok</span>(<span class=\"number\">2</span>));\n\n<span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"string\">&quot;not a 2&quot;</span>);\n<span class=\"kw\">let </span>y: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"string\">&quot;late error&quot;</span>);\n<span class=\"macro\">assert_eq!</span>(x.or(y), <span class=\"prelude-val\">Err</span>(<span class=\"string\">&quot;late error&quot;</span>));\n\n<span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"number\">2</span>);\n<span class=\"kw\">let </span>y: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"number\">100</span>);\n<span class=\"macro\">assert_eq!</span>(x.or(y), <span class=\"prelude-val\">Ok</span>(<span class=\"number\">2</span>));</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+x:+Result%3Cu32,+%26str%3E+=+Ok(2);%0Alet+y:+Result%3Cu32,+%26str%3E+=+Err(%22late+error%22);%0Aassert_eq!(x.or(y),+Ok(2));%0A%0Alet+x:+Result%3Cu32,+%26str%3E+=+Err(%22early+error%22);%0Alet+y:+Result%3Cu32,+%26str%3E+=+Ok(2);%0Aassert_eq!(x.or(y),+Ok(2));%0A%0Alet+x:+Result%3Cu32,+%26str%3E+=+Err(%22not+a+2%22);%0Alet+y:+Result%3Cu32,+%26str%3E+=+Err(%22late+error%22);%0Aassert_eq!(x.or(y),+Err(%22late+error%22));%0A%0Alet+x:+Result%3Cu32,+%26str%3E+=+Ok(2);%0Alet+y:+Result%3Cu32,+%26str%3E+=+Ok(100);%0Aassert_eq!(x.or(y),+Ok(2));%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.or_else\" class=\"method\"><a class=\"src rightside\" href=\"src/core/result.rs.html#1379\">source</a><h4 class=\"code-header\">pub fn <a href=\"core/result/enum.Result.html#tymethod.or_else\" class=\"fn\">or_else</a>&lt;F, O&gt;(self, op: O) -&gt; <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;T, F&gt;<span class=\"where fmt-newline\">where\n    O: <a class=\"trait\" href=\"core/ops/function/trait.FnOnce.html\" title=\"trait core::ops::function::FnOnce\">FnOnce</a>(E) -&gt; <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;T, F&gt;,</span></h4></section></summary><div class=\"docblock\"><p>Calls <code>op</code> if the result is <a href=\"core/result/enum.Result.html#variant.Err\" title=\"variant core::result::Result::Err\"><code>Err</code></a>, otherwise returns the <a href=\"core/result/enum.Result.html#variant.Ok\" title=\"variant core::result::Result::Ok\"><code>Ok</code></a> value of <code>self</code>.</p>\n<p>This function can be used for control flow based on result values.</p>\n<h5 id=\"examples-28\"><a href=\"#examples-28\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">fn </span>sq(x: u32) -&gt; <span class=\"prelude-ty\">Result</span>&lt;u32, u32&gt; { <span class=\"prelude-val\">Ok</span>(x * x) }\n<span class=\"kw\">fn </span>err(x: u32) -&gt; <span class=\"prelude-ty\">Result</span>&lt;u32, u32&gt; { <span class=\"prelude-val\">Err</span>(x) }\n\n<span class=\"macro\">assert_eq!</span>(<span class=\"prelude-val\">Ok</span>(<span class=\"number\">2</span>).or_else(sq).or_else(sq), <span class=\"prelude-val\">Ok</span>(<span class=\"number\">2</span>));\n<span class=\"macro\">assert_eq!</span>(<span class=\"prelude-val\">Ok</span>(<span class=\"number\">2</span>).or_else(err).or_else(sq), <span class=\"prelude-val\">Ok</span>(<span class=\"number\">2</span>));\n<span class=\"macro\">assert_eq!</span>(<span class=\"prelude-val\">Err</span>(<span class=\"number\">3</span>).or_else(sq).or_else(err), <span class=\"prelude-val\">Ok</span>(<span class=\"number\">9</span>));\n<span class=\"macro\">assert_eq!</span>(<span class=\"prelude-val\">Err</span>(<span class=\"number\">3</span>).or_else(err).or_else(err), <span class=\"prelude-val\">Err</span>(<span class=\"number\">3</span>));</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Afn+sq(x:+u32)+-%3E+Result%3Cu32,+u32%3E+%7B+Ok(x+*+x)+%7D%0Afn+err(x:+u32)+-%3E+Result%3Cu32,+u32%3E+%7B+Err(x)+%7D%0A%0Aassert_eq!(Ok(2).or_else(sq).or_else(sq),+Ok(2));%0Aassert_eq!(Ok(2).or_else(err).or_else(sq),+Ok(2));%0Aassert_eq!(Err(3).or_else(sq).or_else(err),+Ok(9));%0Aassert_eq!(Err(3).or_else(err).or_else(err),+Err(3));%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.unwrap_or\" class=\"method\"><a class=\"src rightside\" href=\"src/core/result.rs.html#1406\">source</a><h4 class=\"code-header\">pub fn <a href=\"core/result/enum.Result.html#tymethod.unwrap_or\" class=\"fn\">unwrap_or</a>(self, default: T) -&gt; T</h4></section></summary><div class=\"docblock\"><p>Returns the contained <a href=\"core/result/enum.Result.html#variant.Ok\" title=\"variant core::result::Result::Ok\"><code>Ok</code></a> value or a provided default.</p>\n<p>Arguments passed to <code>unwrap_or</code> are eagerly evaluated; if you are passing\nthe result of a function call, it is recommended to use <a href=\"core/result/enum.Result.html#method.unwrap_or_else\" title=\"method core::result::Result::unwrap_or_else\"><code>unwrap_or_else</code></a>,\nwhich is lazily evaluated.</p>\n<h5 id=\"examples-29\"><a href=\"#examples-29\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>default = <span class=\"number\">2</span>;\n<span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"number\">9</span>);\n<span class=\"macro\">assert_eq!</span>(x.unwrap_or(default), <span class=\"number\">9</span>);\n\n<span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"string\">&quot;error&quot;</span>);\n<span class=\"macro\">assert_eq!</span>(x.unwrap_or(default), default);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+default+=+2;%0Alet+x:+Result%3Cu32,+%26str%3E+=+Ok(9);%0Aassert_eq!(x.unwrap_or(default),+9);%0A%0Alet+x:+Result%3Cu32,+%26str%3E+=+Err(%22error%22);%0Aassert_eq!(x.unwrap_or(default),+default);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.unwrap_or_else\" class=\"method\"><a class=\"src rightside\" href=\"src/core/result.rs.html#1427\">source</a><h4 class=\"code-header\">pub fn <a href=\"core/result/enum.Result.html#tymethod.unwrap_or_else\" class=\"fn\">unwrap_or_else</a>&lt;F&gt;(self, op: F) -&gt; T<span class=\"where fmt-newline\">where\n    F: <a class=\"trait\" href=\"core/ops/function/trait.FnOnce.html\" title=\"trait core::ops::function::FnOnce\">FnOnce</a>(E) -&gt; T,</span></h4></section></summary><div class=\"docblock\"><p>Returns the contained <a href=\"core/result/enum.Result.html#variant.Ok\" title=\"variant core::result::Result::Ok\"><code>Ok</code></a> value or computes it from a closure.</p>\n<h5 id=\"examples-30\"><a href=\"#examples-30\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">fn </span>count(x: <span class=\"kw-2\">&amp;</span>str) -&gt; usize { x.len() }\n\n<span class=\"macro\">assert_eq!</span>(<span class=\"prelude-val\">Ok</span>(<span class=\"number\">2</span>).unwrap_or_else(count), <span class=\"number\">2</span>);\n<span class=\"macro\">assert_eq!</span>(<span class=\"prelude-val\">Err</span>(<span class=\"string\">&quot;foo&quot;</span>).unwrap_or_else(count), <span class=\"number\">3</span>);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Afn+count(x:+%26str)+-%3E+usize+%7B+x.len()+%7D%0A%0Aassert_eq!(Ok(2).unwrap_or_else(count),+2);%0Aassert_eq!(Err(%22foo%22).unwrap_or_else(count),+3);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.unwrap_unchecked\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.58.0\">1.58.0</span> · <a class=\"src\" href=\"src/core/result.rs.html#1457\">source</a></span><h4 class=\"code-header\">pub unsafe fn <a href=\"core/result/enum.Result.html#tymethod.unwrap_unchecked\" class=\"fn\">unwrap_unchecked</a>(self) -&gt; T</h4></section></summary><div class=\"docblock\"><p>Returns the contained <a href=\"core/result/enum.Result.html#variant.Ok\" title=\"variant core::result::Result::Ok\"><code>Ok</code></a> value, consuming the <code>self</code> value,\nwithout checking that the value is not an <a href=\"core/result/enum.Result.html#variant.Err\" title=\"variant core::result::Result::Err\"><code>Err</code></a>.</p>\n<h5 id=\"safety\"><a href=\"#safety\">Safety</a></h5>\n<p>Calling this method on an <a href=\"core/result/enum.Result.html#variant.Err\" title=\"variant core::result::Result::Err\"><code>Err</code></a> is <em><a href=\"https://doc.rust-lang.org/reference/behavior-considered-undefined.html\">undefined behavior</a></em>.</p>\n<h5 id=\"examples-31\"><a href=\"#examples-31\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"number\">2</span>);\n<span class=\"macro\">assert_eq!</span>(<span class=\"kw\">unsafe </span>{ x.unwrap_unchecked() }, <span class=\"number\">2</span>);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+x:+Result%3Cu32,+%26str%3E+=+Ok(2);%0Aassert_eq!(unsafe+%7B+x.unwrap_unchecked()+%7D,+2);%0A%7D&amp;edition=2021\">Run</a></div>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"string\">&quot;emergency failure&quot;</span>);\n<span class=\"kw\">unsafe </span>{ x.unwrap_unchecked(); } <span class=\"comment\">// Undefined behavior!</span></code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+x:+Result%3Cu32,+%26str%3E+=+Err(%22emergency+failure%22);%0Aunsafe+%7B+x.unwrap_unchecked();+%7D+//+Undefined+behavior!%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.unwrap_err_unchecked\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.58.0\">1.58.0</span> · <a class=\"src\" href=\"src/core/result.rs.html#1489\">source</a></span><h4 class=\"code-header\">pub unsafe fn <a href=\"core/result/enum.Result.html#tymethod.unwrap_err_unchecked\" class=\"fn\">unwrap_err_unchecked</a>(self) -&gt; E</h4></section></summary><div class=\"docblock\"><p>Returns the contained <a href=\"core/result/enum.Result.html#variant.Err\" title=\"variant core::result::Result::Err\"><code>Err</code></a> value, consuming the <code>self</code> value,\nwithout checking that the value is not an <a href=\"core/result/enum.Result.html#variant.Ok\" title=\"variant core::result::Result::Ok\"><code>Ok</code></a>.</p>\n<h5 id=\"safety-1\"><a href=\"#safety-1\">Safety</a></h5>\n<p>Calling this method on an <a href=\"core/result/enum.Result.html#variant.Ok\" title=\"variant core::result::Result::Ok\"><code>Ok</code></a> is <em><a href=\"https://doc.rust-lang.org/reference/behavior-considered-undefined.html\">undefined behavior</a></em>.</p>\n<h5 id=\"examples-32\"><a href=\"#examples-32\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"number\">2</span>);\n<span class=\"kw\">unsafe </span>{ x.unwrap_err_unchecked() }; <span class=\"comment\">// Undefined behavior!</span></code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+x:+Result%3Cu32,+%26str%3E+=+Ok(2);%0Aunsafe+%7B+x.unwrap_err_unchecked()+%7D;+//+Undefined+behavior!%0A%7D&amp;edition=2021\">Run</a></div>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"string\">&quot;emergency failure&quot;</span>);\n<span class=\"macro\">assert_eq!</span>(<span class=\"kw\">unsafe </span>{ x.unwrap_err_unchecked() }, <span class=\"string\">&quot;emergency failure&quot;</span>);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+x:+Result%3Cu32,+%26str%3E+=+Err(%22emergency+failure%22);%0Aassert_eq!(unsafe+%7B+x.unwrap_err_unchecked()+%7D,+%22emergency+failure%22);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details></div></details>",0,"alloc::fmt::Result"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-FromResidual%3CResult%3CInfallible,+E%3E%3E-for-Result%3CT,+F%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/result.rs.html#1958\">source</a><a href=\"#impl-FromResidual%3CResult%3CInfallible,+E%3E%3E-for-Result%3CT,+F%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, E, F&gt; <a class=\"trait\" href=\"core/ops/try_trait/trait.FromResidual.html\" title=\"trait core::ops::try_trait::FromResidual\">FromResidual</a>&lt;<a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;<a class=\"enum\" href=\"core/convert/enum.Infallible.html\" title=\"enum core::convert::Infallible\">Infallible</a>, E&gt;&gt; for <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;T, F&gt;<span class=\"where fmt-newline\">where\n    F: <a class=\"trait\" href=\"core/convert/trait.From.html\" title=\"trait core::convert::From\">From</a>&lt;E&gt;,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_residual\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/result.rs.html#1961\">source</a><a href=\"#method.from_residual\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/ops/try_trait/trait.FromResidual.html#tymethod.from_residual\" class=\"fn\">from_residual</a>(residual: <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;<a class=\"enum\" href=\"core/convert/enum.Infallible.html\" title=\"enum core::convert::Infallible\">Infallible</a>, E&gt;) -&gt; <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;T, F&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>try_trait_v2</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/84277\">#84277</a>)</span></div></span><div class='docblock'>Constructs the type from a compatible <code>Residual</code> type. <a href=\"core/ops/try_trait/trait.FromResidual.html#tymethod.from_residual\">Read more</a></div></details></div></details>","FromResidual<Result<Infallible, E>>","alloc::fmt::Result"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-FromResidual%3CYeet%3CE%3E%3E-for-Result%3CT,+F%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/result.rs.html#1969\">source</a><a href=\"#impl-FromResidual%3CYeet%3CE%3E%3E-for-Result%3CT,+F%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, E, F&gt; <a class=\"trait\" href=\"core/ops/try_trait/trait.FromResidual.html\" title=\"trait core::ops::try_trait::FromResidual\">FromResidual</a>&lt;<a class=\"struct\" href=\"core/ops/try_trait/struct.Yeet.html\" title=\"struct core::ops::try_trait::Yeet\">Yeet</a>&lt;E&gt;&gt; for <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;T, F&gt;<span class=\"where fmt-newline\">where\n    F: <a class=\"trait\" href=\"core/convert/trait.From.html\" title=\"trait core::convert::From\">From</a>&lt;E&gt;,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_residual\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/result.rs.html#1971\">source</a><a href=\"#method.from_residual\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/ops/try_trait/trait.FromResidual.html#tymethod.from_residual\" class=\"fn\">from_residual</a>(_: <a class=\"struct\" href=\"core/ops/try_trait/struct.Yeet.html\" title=\"struct core::ops::try_trait::Yeet\">Yeet</a>&lt;E&gt;) -&gt; <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;T, F&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>try_trait_v2</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/84277\">#84277</a>)</span></div></span><div class='docblock'>Constructs the type from a compatible <code>Residual</code> type. <a href=\"core/ops/try_trait/trait.FromResidual.html#tymethod.from_residual\">Read more</a></div></details></div></details>","FromResidual<Yeet<E>>","alloc::fmt::Result"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Try-for-Result%3CT,+E%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/result.rs.html#1939\">source</a><a href=\"#impl-Try-for-Result%3CT,+E%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, E&gt; <a class=\"trait\" href=\"core/ops/try_trait/trait.Try.html\" title=\"trait core::ops::try_trait::Try\">Try</a> for <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;T, E&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"core/ops/try_trait/trait.Try.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = T</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>try_trait_v2</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/84277\">#84277</a>)</span></div></span><div class='docblock'>The type of the value produced by <code>?</code> when <em>not</em> short-circuiting.</div></details><details class=\"toggle\" open><summary><section id=\"associatedtype.Residual\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Residual\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"core/ops/try_trait/trait.Try.html#associatedtype.Residual\" class=\"associatedtype\">Residual</a> = <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;<a class=\"enum\" href=\"core/convert/enum.Infallible.html\" title=\"enum core::convert::Infallible\">Infallible</a>, E&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>try_trait_v2</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/84277\">#84277</a>)</span></div></span><div class='docblock'>The type of the value passed to <a href=\"core/ops/try_trait/trait.FromResidual.html#tymethod.from_residual\" title=\"associated function core::ops::try_trait::FromResidual::from_residual\"><code>FromResidual::from_residual</code></a>\nas part of <code>?</code> when short-circuiting. <a href=\"core/ops/try_trait/trait.Try.html#associatedtype.Residual\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_output\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/result.rs.html#1944\">source</a><a href=\"#method.from_output\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/ops/try_trait/trait.Try.html#tymethod.from_output\" class=\"fn\">from_output</a>(output: &lt;<a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;T, E&gt; as <a class=\"trait\" href=\"core/ops/try_trait/trait.Try.html\" title=\"trait core::ops::try_trait::Try\">Try</a>&gt;::<a class=\"associatedtype\" href=\"core/ops/try_trait/trait.Try.html#associatedtype.Output\" title=\"type core::ops::try_trait::Try::Output\">Output</a>) -&gt; <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;T, E&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>try_trait_v2</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/84277\">#84277</a>)</span></div></span><div class='docblock'>Constructs the type from its <code>Output</code> type. <a href=\"core/ops/try_trait/trait.Try.html#tymethod.from_output\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.branch\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/result.rs.html#1949\">source</a><a href=\"#method.branch\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/ops/try_trait/trait.Try.html#tymethod.branch\" class=\"fn\">branch</a>(\n    self\n) -&gt; <a class=\"enum\" href=\"core/ops/control_flow/enum.ControlFlow.html\" title=\"enum core::ops::control_flow::ControlFlow\">ControlFlow</a>&lt;&lt;<a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;T, E&gt; as <a class=\"trait\" href=\"core/ops/try_trait/trait.Try.html\" title=\"trait core::ops::try_trait::Try\">Try</a>&gt;::<a class=\"associatedtype\" href=\"core/ops/try_trait/trait.Try.html#associatedtype.Residual\" title=\"type core::ops::try_trait::Try::Residual\">Residual</a>, &lt;<a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;T, E&gt; as <a class=\"trait\" href=\"core/ops/try_trait/trait.Try.html\" title=\"trait core::ops::try_trait::Try\">Try</a>&gt;::<a class=\"associatedtype\" href=\"core/ops/try_trait/trait.Try.html#associatedtype.Output\" title=\"type core::ops::try_trait::Try::Output\">Output</a>&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>try_trait_v2</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/84277\">#84277</a>)</span></div></span><div class='docblock'>Used in <code>?</code> to decide whether the operator should produce a value\n(because this returned <a href=\"core/ops/control_flow/enum.ControlFlow.html#variant.Continue\" title=\"variant core::ops::control_flow::ControlFlow::Continue\"><code>ControlFlow::Continue</code></a>)\nor propagate a value back to the caller\n(because this returned <a href=\"core/ops/control_flow/enum.ControlFlow.html#variant.Break\" title=\"variant core::ops::control_flow::ControlFlow::Break\"><code>ControlFlow::Break</code></a>). <a href=\"core/ops/try_trait/trait.Try.html#tymethod.branch\">Read more</a></div></details></div></details>","Try","alloc::fmt::Result"],["<section id=\"impl-StructuralEq-for-Result%3CT,+E%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/result.rs.html#498\">source</a><a href=\"#impl-StructuralEq-for-Result%3CT,+E%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, E&gt; <a class=\"trait\" href=\"core/marker/trait.StructuralEq.html\" title=\"trait core::marker::StructuralEq\">StructuralEq</a> for <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;T, E&gt;</h3></section>","StructuralEq","alloc::fmt::Result"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-FromIterator%3CResult%3CA,+E%3E%3E-for-Result%3CV,+E%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/result.rs.html#1889\">source</a><a href=\"#impl-FromIterator%3CResult%3CA,+E%3E%3E-for-Result%3CV,+E%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;A, E, V&gt; <a class=\"trait\" href=\"core/iter/traits/collect/trait.FromIterator.html\" title=\"trait core::iter::traits::collect::FromIterator\">FromIterator</a>&lt;<a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;A, E&gt;&gt; for <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;V, E&gt;<span class=\"where fmt-newline\">where\n    V: <a class=\"trait\" href=\"core/iter/traits/collect/trait.FromIterator.html\" title=\"trait core::iter::traits::collect::FromIterator\">FromIterator</a>&lt;A&gt;,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_iter\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/result.rs.html#1933\">source</a><a href=\"#method.from_iter\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/iter/traits/collect/trait.FromIterator.html#tymethod.from_iter\" class=\"fn\">from_iter</a>&lt;I&gt;(iter: I) -&gt; <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;V, E&gt;<span class=\"where fmt-newline\">where\n    I: <a class=\"trait\" href=\"core/iter/traits/collect/trait.IntoIterator.html\" title=\"trait core::iter::traits::collect::IntoIterator\">IntoIterator</a>&lt;Item = <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;A, E&gt;&gt;,</span></h4></section></summary><div class=\"docblock\"><p>Takes each element in the <code>Iterator</code>: if it is an <code>Err</code>, no further\nelements are taken, and the <code>Err</code> is returned. Should no <code>Err</code> occur, a\ncontainer with the values of each <code>Result</code> is returned.</p>\n<p>Here is an example which increments every integer in a vector,\nchecking for overflow:</p>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>v = <span class=\"macro\">vec!</span>[<span class=\"number\">1</span>, <span class=\"number\">2</span>];\n<span class=\"kw\">let </span>res: <span class=\"prelude-ty\">Result</span>&lt;Vec&lt;u32&gt;, <span class=\"kw-2\">&amp;</span><span class=\"lifetime\">&#39;static </span>str&gt; = v.iter().map(|x: <span class=\"kw-2\">&amp;</span>u32|\n    x.checked_add(<span class=\"number\">1</span>).ok_or(<span class=\"string\">&quot;Overflow!&quot;</span>)\n).collect();\n<span class=\"macro\">assert_eq!</span>(res, <span class=\"prelude-val\">Ok</span>(<span class=\"macro\">vec!</span>[<span class=\"number\">2</span>, <span class=\"number\">3</span>]));</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+v+=+vec!%5B1,+2%5D;%0Alet+res:+Result%3CVec%3Cu32%3E,+%26'static+str%3E+=+v.iter().map(%7Cx:+%26u32%7C%0A++++x.checked_add(1).ok_or(%22Overflow!%22)%0A).collect();%0Aassert_eq!(res,+Ok(vec!%5B2,+3%5D));%0A%7D&amp;edition=2021\">Run</a></div>\n<p>Here is another example that tries to subtract one from another list\nof integers, this time checking for underflow:</p>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>v = <span class=\"macro\">vec!</span>[<span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">0</span>];\n<span class=\"kw\">let </span>res: <span class=\"prelude-ty\">Result</span>&lt;Vec&lt;u32&gt;, <span class=\"kw-2\">&amp;</span><span class=\"lifetime\">&#39;static </span>str&gt; = v.iter().map(|x: <span class=\"kw-2\">&amp;</span>u32|\n    x.checked_sub(<span class=\"number\">1</span>).ok_or(<span class=\"string\">&quot;Underflow!&quot;</span>)\n).collect();\n<span class=\"macro\">assert_eq!</span>(res, <span class=\"prelude-val\">Err</span>(<span class=\"string\">&quot;Underflow!&quot;</span>));</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+v+=+vec!%5B1,+2,+0%5D;%0Alet+res:+Result%3CVec%3Cu32%3E,+%26'static+str%3E+=+v.iter().map(%7Cx:+%26u32%7C%0A++++x.checked_sub(1).ok_or(%22Underflow!%22)%0A).collect();%0Aassert_eq!(res,+Err(%22Underflow!%22));%0A%7D&amp;edition=2021\">Run</a></div>\n<p>Here is a variation on the previous example, showing that no\nfurther elements are taken from <code>iter</code> after the first <code>Err</code>.</p>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>v = <span class=\"macro\">vec!</span>[<span class=\"number\">3</span>, <span class=\"number\">2</span>, <span class=\"number\">1</span>, <span class=\"number\">10</span>];\n<span class=\"kw\">let </span><span class=\"kw-2\">mut </span>shared = <span class=\"number\">0</span>;\n<span class=\"kw\">let </span>res: <span class=\"prelude-ty\">Result</span>&lt;Vec&lt;u32&gt;, <span class=\"kw-2\">&amp;</span><span class=\"lifetime\">&#39;static </span>str&gt; = v.iter().map(|x: <span class=\"kw-2\">&amp;</span>u32| {\n    shared += x;\n    x.checked_sub(<span class=\"number\">2</span>).ok_or(<span class=\"string\">&quot;Underflow!&quot;</span>)\n}).collect();\n<span class=\"macro\">assert_eq!</span>(res, <span class=\"prelude-val\">Err</span>(<span class=\"string\">&quot;Underflow!&quot;</span>));\n<span class=\"macro\">assert_eq!</span>(shared, <span class=\"number\">6</span>);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+v+=+vec!%5B3,+2,+1,+10%5D;%0Alet+mut+shared+=+0;%0Alet+res:+Result%3CVec%3Cu32%3E,+%26'static+str%3E+=+v.iter().map(%7Cx:+%26u32%7C+%7B%0A++++shared+%2B=+x;%0A++++x.checked_sub(2).ok_or(%22Underflow!%22)%0A%7D).collect();%0Aassert_eq!(res,+Err(%22Underflow!%22));%0Aassert_eq!(shared,+6);%0A%7D&amp;edition=2021\">Run</a></div>\n<p>Since the third element caused an underflow, no further elements were taken,\nso the final value of <code>shared</code> is 6 (= <code>3 + 2 + 1</code>), not 16.</p>\n</div></details></div></details>","FromIterator<Result<A, E>>","alloc::fmt::Result"],["<section id=\"impl-Eq-for-Result%3CT,+E%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/result.rs.html#498\">source</a><a href=\"#impl-Eq-for-Result%3CT,+E%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, E&gt; <a class=\"trait\" href=\"core/cmp/trait.Eq.html\" title=\"trait core::cmp::Eq\">Eq</a> for <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;T, E&gt;<span class=\"where fmt-newline\">where\n    T: <a class=\"trait\" href=\"core/cmp/trait.Eq.html\" title=\"trait core::cmp::Eq\">Eq</a>,\n    E: <a class=\"trait\" href=\"core/cmp/trait.Eq.html\" title=\"trait core::cmp::Eq\">Eq</a>,</span></h3></section>","Eq","alloc::fmt::Result"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Ord-for-Result%3CT,+E%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/result.rs.html#498\">source</a><a href=\"#impl-Ord-for-Result%3CT,+E%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, E&gt; <a class=\"trait\" href=\"core/cmp/trait.Ord.html\" title=\"trait core::cmp::Ord\">Ord</a> for <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;T, E&gt;<span class=\"where fmt-newline\">where\n    T: <a class=\"trait\" href=\"core/cmp/trait.Ord.html\" title=\"trait core::cmp::Ord\">Ord</a>,\n    E: <a class=\"trait\" href=\"core/cmp/trait.Ord.html\" title=\"trait core::cmp::Ord\">Ord</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.cmp\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/result.rs.html#498\">source</a><a href=\"#method.cmp\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/cmp/trait.Ord.html#tymethod.cmp\" class=\"fn\">cmp</a>(&amp;self, other: &amp;<a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;T, E&gt;) -&gt; <a class=\"enum\" href=\"core/cmp/enum.Ordering.html\" title=\"enum core::cmp::Ordering\">Ordering</a></h4></section></summary><div class='docblock'>This method returns an <a href=\"core/cmp/enum.Ordering.html\" title=\"enum core::cmp::Ordering\"><code>Ordering</code></a> between <code>self</code> and <code>other</code>. <a href=\"core/cmp/trait.Ord.html#tymethod.cmp\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.max\" class=\"method trait-impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.21.0\">1.21.0</span> · <a class=\"src\" href=\"src/core/cmp.rs.html#826-828\">source</a></span><a href=\"#method.max\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/cmp/trait.Ord.html#method.max\" class=\"fn\">max</a>(self, other: Self) -&gt; Self<span class=\"where fmt-newline\">where\n    Self: <a class=\"trait\" href=\"core/marker/trait.Sized.html\" title=\"trait core::marker::Sized\">Sized</a>,</span></h4></section></summary><div class='docblock'>Compares and returns the maximum of two values. <a href=\"core/cmp/trait.Ord.html#method.max\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.min\" class=\"method trait-impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.21.0\">1.21.0</span> · <a class=\"src\" href=\"src/core/cmp.rs.html#846-848\">source</a></span><a href=\"#method.min\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/cmp/trait.Ord.html#method.min\" class=\"fn\">min</a>(self, other: Self) -&gt; Self<span class=\"where fmt-newline\">where\n    Self: <a class=\"trait\" href=\"core/marker/trait.Sized.html\" title=\"trait core::marker::Sized\">Sized</a>,</span></h4></section></summary><div class='docblock'>Compares and returns the minimum of two values. <a href=\"core/cmp/trait.Ord.html#method.min\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.clamp\" class=\"method trait-impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.50.0\">1.50.0</span> · <a class=\"src\" href=\"src/core/cmp.rs.html#871-874\">source</a></span><a href=\"#method.clamp\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/cmp/trait.Ord.html#method.clamp\" class=\"fn\">clamp</a>(self, min: Self, max: Self) -&gt; Self<span class=\"where fmt-newline\">where\n    Self: <a class=\"trait\" href=\"core/marker/trait.Sized.html\" title=\"trait core::marker::Sized\">Sized</a> + <a class=\"trait\" href=\"core/cmp/trait.PartialOrd.html\" title=\"trait core::cmp::PartialOrd\">PartialOrd</a>,</span></h4></section></summary><div class='docblock'>Restrict a value to a certain interval. <a href=\"core/cmp/trait.Ord.html#method.clamp\">Read more</a></div></details></div></details>","Ord","alloc::fmt::Result"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-PartialEq-for-Result%3CT,+E%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/result.rs.html#498\">source</a><a href=\"#impl-PartialEq-for-Result%3CT,+E%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, E&gt; <a class=\"trait\" href=\"core/cmp/trait.PartialEq.html\" title=\"trait core::cmp::PartialEq\">PartialEq</a> for <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;T, E&gt;<span class=\"where fmt-newline\">where\n    T: <a class=\"trait\" href=\"core/cmp/trait.PartialEq.html\" title=\"trait core::cmp::PartialEq\">PartialEq</a>,\n    E: <a class=\"trait\" href=\"core/cmp/trait.PartialEq.html\" title=\"trait core::cmp::PartialEq\">PartialEq</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.eq\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/result.rs.html#498\">source</a><a href=\"#method.eq\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/cmp/trait.PartialEq.html#tymethod.eq\" class=\"fn\">eq</a>(&amp;self, other: &amp;<a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;T, E&gt;) -&gt; <a class=\"primitive\" href=\"core/primitive.bool.html\">bool</a></h4></section></summary><div class='docblock'>This method tests for <code>self</code> and <code>other</code> values to be equal, and is used\nby <code>==</code>.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.ne\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/cmp.rs.html#239\">source</a><a href=\"#method.ne\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/cmp/trait.PartialEq.html#method.ne\" class=\"fn\">ne</a>(&amp;self, other: <a class=\"primitive\" href=\"core/primitive.reference.html\">&amp;Rhs</a>) -&gt; <a class=\"primitive\" href=\"core/primitive.bool.html\">bool</a></h4></section></summary><div class='docblock'>This method tests for <code>!=</code>. The default implementation is almost always\nsufficient, and should not be overridden without very good reason.</div></details></div></details>","PartialEq","alloc::fmt::Result"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Clone-for-Result%3CT,+E%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/result.rs.html#1673-1676\">source</a><a href=\"#impl-Clone-for-Result%3CT,+E%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, E&gt; <a class=\"trait\" href=\"core/clone/trait.Clone.html\" title=\"trait core::clone::Clone\">Clone</a> for <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;T, E&gt;<span class=\"where fmt-newline\">where\n    T: <a class=\"trait\" href=\"core/clone/trait.Clone.html\" title=\"trait core::clone::Clone\">Clone</a>,\n    E: <a class=\"trait\" href=\"core/clone/trait.Clone.html\" title=\"trait core::clone::Clone\">Clone</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.clone\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/result.rs.html#1679\">source</a><a href=\"#method.clone\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/clone/trait.Clone.html#tymethod.clone\" class=\"fn\">clone</a>(&amp;self) -&gt; <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;T, E&gt;</h4></section></summary><div class='docblock'>Returns a copy of the value. <a href=\"core/clone/trait.Clone.html#tymethod.clone\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.clone_from\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/result.rs.html#1687\">source</a><a href=\"#method.clone_from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/clone/trait.Clone.html#method.clone_from\" class=\"fn\">clone_from</a>(&amp;mut self, source: &amp;<a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;T, E&gt;)</h4></section></summary><div class='docblock'>Performs copy-assignment from <code>source</code>. <a href=\"core/clone/trait.Clone.html#method.clone_from\">Read more</a></div></details></div></details>","Clone","alloc::fmt::Result"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-IntoIterator-for-Result%3CT,+E%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/result.rs.html#1697\">source</a><a href=\"#impl-IntoIterator-for-Result%3CT,+E%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, E&gt; <a class=\"trait\" href=\"core/iter/traits/collect/trait.IntoIterator.html\" title=\"trait core::iter::traits::collect::IntoIterator\">IntoIterator</a> for <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;T, E&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.into_iter\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/result.rs.html#1717\">source</a><a href=\"#method.into_iter\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/iter/traits/collect/trait.IntoIterator.html#tymethod.into_iter\" class=\"fn\">into_iter</a>(self) -&gt; <a class=\"struct\" href=\"core/result/struct.IntoIter.html\" title=\"struct core::result::IntoIter\">IntoIter</a>&lt;T&gt;</h4></section></summary><div class=\"docblock\"><p>Returns a consuming iterator over the possibly contained value.</p>\n<p>The iterator yields one value if the result is <a href=\"core/result/enum.Result.html#variant.Ok\" title=\"variant core::result::Result::Ok\"><code>Result::Ok</code></a>, otherwise none.</p>\n<h5 id=\"examples\"><a href=\"#examples\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"number\">5</span>);\n<span class=\"kw\">let </span>v: Vec&lt;u32&gt; = x.into_iter().collect();\n<span class=\"macro\">assert_eq!</span>(v, [<span class=\"number\">5</span>]);\n\n<span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"string\">&quot;nothing!&quot;</span>);\n<span class=\"kw\">let </span>v: Vec&lt;u32&gt; = x.into_iter().collect();\n<span class=\"macro\">assert_eq!</span>(v, []);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+x:+Result%3Cu32,+%26str%3E+=+Ok(5);%0Alet+v:+Vec%3Cu32%3E+=+x.into_iter().collect();%0Aassert_eq!(v,+%5B5%5D);%0A%0Alet+x:+Result%3Cu32,+%26str%3E+=+Err(%22nothing!%22);%0Alet+v:+Vec%3Cu32%3E+=+x.into_iter().collect();%0Aassert_eq!(v,+%5B%5D);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle\" open><summary><section id=\"associatedtype.Item\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Item\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"core/iter/traits/collect/trait.IntoIterator.html#associatedtype.Item\" class=\"associatedtype\">Item</a> = T</h4></section></summary><div class='docblock'>The type of the elements being iterated over.</div></details><details class=\"toggle\" open><summary><section id=\"associatedtype.IntoIter\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.IntoIter\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"core/iter/traits/collect/trait.IntoIterator.html#associatedtype.IntoIter\" class=\"associatedtype\">IntoIter</a> = <a class=\"struct\" href=\"core/result/struct.IntoIter.html\" title=\"struct core::result::IntoIter\">IntoIter</a>&lt;T&gt;</h4></section></summary><div class='docblock'>Which kind of iterator are we turning this into?</div></details></div></details>","IntoIterator","alloc::fmt::Result"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Hash-for-Result%3CT,+E%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/result.rs.html#498\">source</a><a href=\"#impl-Hash-for-Result%3CT,+E%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, E&gt; <a class=\"trait\" href=\"core/hash/trait.Hash.html\" title=\"trait core::hash::Hash\">Hash</a> for <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;T, E&gt;<span class=\"where fmt-newline\">where\n    T: <a class=\"trait\" href=\"core/hash/trait.Hash.html\" title=\"trait core::hash::Hash\">Hash</a>,\n    E: <a class=\"trait\" href=\"core/hash/trait.Hash.html\" title=\"trait core::hash::Hash\">Hash</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.hash\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/result.rs.html#498\">source</a><a href=\"#method.hash\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/hash/trait.Hash.html#tymethod.hash\" class=\"fn\">hash</a>&lt;__H&gt;(&amp;self, state: <a class=\"primitive\" href=\"core/primitive.reference.html\">&amp;mut __H</a>)<span class=\"where fmt-newline\">where\n    __H: <a class=\"trait\" href=\"core/hash/trait.Hasher.html\" title=\"trait core::hash::Hasher\">Hasher</a>,</span></h4></section></summary><div class='docblock'>Feeds this value into the given <a href=\"core/hash/trait.Hasher.html\" title=\"trait core::hash::Hasher\"><code>Hasher</code></a>. <a href=\"core/hash/trait.Hash.html#tymethod.hash\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.hash_slice\" class=\"method trait-impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.3.0\">1.3.0</span> · <a class=\"src\" href=\"src/core/hash/mod.rs.html#242-244\">source</a></span><a href=\"#method.hash_slice\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/hash/trait.Hash.html#method.hash_slice\" class=\"fn\">hash_slice</a>&lt;H&gt;(data: &amp;<a class=\"primitive\" href=\"core/primitive.slice.html\">[Self]</a>, state: <a class=\"primitive\" href=\"core/primitive.reference.html\">&amp;mut H</a>)<span class=\"where fmt-newline\">where\n    H: <a class=\"trait\" href=\"core/hash/trait.Hasher.html\" title=\"trait core::hash::Hasher\">Hasher</a>,\n    Self: <a class=\"trait\" href=\"core/marker/trait.Sized.html\" title=\"trait core::marker::Sized\">Sized</a>,</span></h4></section></summary><div class='docblock'>Feeds a slice of this type into the given <a href=\"core/hash/trait.Hasher.html\" title=\"trait core::hash::Hasher\"><code>Hasher</code></a>. <a href=\"core/hash/trait.Hash.html#method.hash_slice\">Read more</a></div></details></div></details>","Hash","alloc::fmt::Result"],["<section id=\"impl-StructuralPartialEq-for-Result%3CT,+E%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/result.rs.html#498\">source</a><a href=\"#impl-StructuralPartialEq-for-Result%3CT,+E%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, E&gt; <a class=\"trait\" href=\"core/marker/trait.StructuralPartialEq.html\" title=\"trait core::marker::StructuralPartialEq\">StructuralPartialEq</a> for <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;T, E&gt;</h3></section>","StructuralPartialEq","alloc::fmt::Result"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Sum%3CResult%3CU,+E%3E%3E-for-Result%3CT,+E%3E\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.16.0\">1.16.0</span> · <a class=\"src\" href=\"src/core/iter/traits/accum.rs.html#153-155\">source</a></span><a href=\"#impl-Sum%3CResult%3CU,+E%3E%3E-for-Result%3CT,+E%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, U, E&gt; <a class=\"trait\" href=\"core/iter/traits/accum/trait.Sum.html\" title=\"trait core::iter::traits::accum::Sum\">Sum</a>&lt;<a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;U, E&gt;&gt; for <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;T, E&gt;<span class=\"where fmt-newline\">where\n    T: <a class=\"trait\" href=\"core/iter/traits/accum/trait.Sum.html\" title=\"trait core::iter::traits::accum::Sum\">Sum</a>&lt;U&gt;,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.sum\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/iter/traits/accum.rs.html#175-177\">source</a><a href=\"#method.sum\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/iter/traits/accum/trait.Sum.html#tymethod.sum\" class=\"fn\">sum</a>&lt;I&gt;(iter: I) -&gt; <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;T, E&gt;<span class=\"where fmt-newline\">where\n    I: <a class=\"trait\" href=\"core/iter/traits/iterator/trait.Iterator.html\" title=\"trait core::iter::traits::iterator::Iterator\">Iterator</a>&lt;Item = <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;U, E&gt;&gt;,</span></h4></section></summary><div class=\"docblock\"><p>Takes each element in the <a href=\"core/iter/traits/iterator/trait.Iterator.html\" title=\"trait core::iter::traits::iterator::Iterator\"><code>Iterator</code></a>: if it is an <a href=\"core/result/enum.Result.html#variant.Err\" title=\"variant core::result::Result::Err\"><code>Err</code></a>, no further\nelements are taken, and the <a href=\"core/result/enum.Result.html#variant.Err\" title=\"variant core::result::Result::Err\"><code>Err</code></a> is returned. Should no <a href=\"core/result/enum.Result.html#variant.Err\" title=\"variant core::result::Result::Err\"><code>Err</code></a>\noccur, the sum of all elements is returned.</p>\n<h5 id=\"examples\"><a href=\"#examples\">Examples</a></h5>\n<p>This sums up every integer in a vector, rejecting the sum if a negative\nelement is encountered:</p>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>f = |<span class=\"kw-2\">&amp;</span>x: <span class=\"kw-2\">&amp;</span>i32| <span class=\"kw\">if </span>x &lt; <span class=\"number\">0 </span>{ <span class=\"prelude-val\">Err</span>(<span class=\"string\">&quot;Negative element found&quot;</span>) } <span class=\"kw\">else </span>{ <span class=\"prelude-val\">Ok</span>(x) };\n<span class=\"kw\">let </span>v = <span class=\"macro\">vec!</span>[<span class=\"number\">1</span>, <span class=\"number\">2</span>];\n<span class=\"kw\">let </span>res: <span class=\"prelude-ty\">Result</span>&lt;i32, <span class=\"kw\">_</span>&gt; = v.iter().map(f).sum();\n<span class=\"macro\">assert_eq!</span>(res, <span class=\"prelude-val\">Ok</span>(<span class=\"number\">3</span>));\n<span class=\"kw\">let </span>v = <span class=\"macro\">vec!</span>[<span class=\"number\">1</span>, -<span class=\"number\">2</span>];\n<span class=\"kw\">let </span>res: <span class=\"prelude-ty\">Result</span>&lt;i32, <span class=\"kw\">_</span>&gt; = v.iter().map(f).sum();\n<span class=\"macro\">assert_eq!</span>(res, <span class=\"prelude-val\">Err</span>(<span class=\"string\">&quot;Negative element found&quot;</span>));</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+f+=+%7C%26x:+%26i32%7C+if+x+%3C+0+%7B+Err(%22Negative+element+found%22)+%7D+else+%7B+Ok(x)+%7D;%0Alet+v+=+vec!%5B1,+2%5D;%0Alet+res:+Result%3Ci32,+_%3E+=+v.iter().map(f).sum();%0Aassert_eq!(res,+Ok(3));%0Alet+v+=+vec!%5B1,+-2%5D;%0Alet+res:+Result%3Ci32,+_%3E+=+v.iter().map(f).sum();%0Aassert_eq!(res,+Err(%22Negative+element+found%22));%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details></div></details>","Sum<Result<U, E>>","alloc::fmt::Result"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-PartialOrd-for-Result%3CT,+E%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/result.rs.html#498\">source</a><a href=\"#impl-PartialOrd-for-Result%3CT,+E%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, E&gt; <a class=\"trait\" href=\"core/cmp/trait.PartialOrd.html\" title=\"trait core::cmp::PartialOrd\">PartialOrd</a> for <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;T, E&gt;<span class=\"where fmt-newline\">where\n    T: <a class=\"trait\" href=\"core/cmp/trait.PartialOrd.html\" title=\"trait core::cmp::PartialOrd\">PartialOrd</a>,\n    E: <a class=\"trait\" href=\"core/cmp/trait.PartialOrd.html\" title=\"trait core::cmp::PartialOrd\">PartialOrd</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.partial_cmp\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/result.rs.html#498\">source</a><a href=\"#method.partial_cmp\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/cmp/trait.PartialOrd.html#tymethod.partial_cmp\" class=\"fn\">partial_cmp</a>(&amp;self, other: &amp;<a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;T, E&gt;) -&gt; <a class=\"enum\" href=\"core/option/enum.Option.html\" title=\"enum core::option::Option\">Option</a>&lt;<a class=\"enum\" href=\"core/cmp/enum.Ordering.html\" title=\"enum core::cmp::Ordering\">Ordering</a>&gt;</h4></section></summary><div class='docblock'>This method returns an ordering between <code>self</code> and <code>other</code> values if one exists. <a href=\"core/cmp/trait.PartialOrd.html#tymethod.partial_cmp\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.lt\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/cmp.rs.html#1122\">source</a><a href=\"#method.lt\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/cmp/trait.PartialOrd.html#method.lt\" class=\"fn\">lt</a>(&amp;self, other: <a class=\"primitive\" href=\"core/primitive.reference.html\">&amp;Rhs</a>) -&gt; <a class=\"primitive\" href=\"core/primitive.bool.html\">bool</a></h4></section></summary><div class='docblock'>This method tests less than (for <code>self</code> and <code>other</code>) and is used by the <code>&lt;</code> operator. <a href=\"core/cmp/trait.PartialOrd.html#method.lt\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.le\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/cmp.rs.html#1139\">source</a><a href=\"#method.le\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/cmp/trait.PartialOrd.html#method.le\" class=\"fn\">le</a>(&amp;self, other: <a class=\"primitive\" href=\"core/primitive.reference.html\">&amp;Rhs</a>) -&gt; <a class=\"primitive\" href=\"core/primitive.bool.html\">bool</a></h4></section></summary><div class='docblock'>This method tests less than or equal to (for <code>self</code> and <code>other</code>) and is used by the <code>&lt;=</code>\noperator. <a href=\"core/cmp/trait.PartialOrd.html#method.le\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.gt\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/cmp.rs.html#1155\">source</a><a href=\"#method.gt\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/cmp/trait.PartialOrd.html#method.gt\" class=\"fn\">gt</a>(&amp;self, other: <a class=\"primitive\" href=\"core/primitive.reference.html\">&amp;Rhs</a>) -&gt; <a class=\"primitive\" href=\"core/primitive.bool.html\">bool</a></h4></section></summary><div class='docblock'>This method tests greater than (for <code>self</code> and <code>other</code>) and is used by the <code>&gt;</code> operator. <a href=\"core/cmp/trait.PartialOrd.html#method.gt\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.ge\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/cmp.rs.html#1172\">source</a><a href=\"#method.ge\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/cmp/trait.PartialOrd.html#method.ge\" class=\"fn\">ge</a>(&amp;self, other: <a class=\"primitive\" href=\"core/primitive.reference.html\">&amp;Rhs</a>) -&gt; <a class=\"primitive\" href=\"core/primitive.bool.html\">bool</a></h4></section></summary><div class='docblock'>This method tests greater than or equal to (for <code>self</code> and <code>other</code>) and is used by the <code>&gt;=</code>\noperator. <a href=\"core/cmp/trait.PartialOrd.html#method.ge\">Read more</a></div></details></div></details>","PartialOrd","alloc::fmt::Result"],["<section id=\"impl-Copy-for-Result%3CT,+E%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/result.rs.html#498\">source</a><a href=\"#impl-Copy-for-Result%3CT,+E%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, E&gt; <a class=\"trait\" href=\"core/marker/trait.Copy.html\" title=\"trait core::marker::Copy\">Copy</a> for <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;T, E&gt;<span class=\"where fmt-newline\">where\n    T: <a class=\"trait\" href=\"core/marker/trait.Copy.html\" title=\"trait core::marker::Copy\">Copy</a>,\n    E: <a class=\"trait\" href=\"core/marker/trait.Copy.html\" title=\"trait core::marker::Copy\">Copy</a>,</span></h3></section>","Copy","alloc::fmt::Result"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Debug-for-Result%3CT,+E%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/result.rs.html#498\">source</a><a href=\"#impl-Debug-for-Result%3CT,+E%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, E&gt; <a class=\"trait\" href=\"alloc/fmt/trait.Debug.html\" title=\"trait alloc::fmt::Debug\">Debug</a> for <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;T, E&gt;<span class=\"where fmt-newline\">where\n    T: <a class=\"trait\" href=\"alloc/fmt/trait.Debug.html\" title=\"trait alloc::fmt::Debug\">Debug</a>,\n    E: <a class=\"trait\" href=\"alloc/fmt/trait.Debug.html\" title=\"trait alloc::fmt::Debug\">Debug</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.fmt\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/result.rs.html#498\">source</a><a href=\"#method.fmt\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"alloc/fmt/trait.Debug.html#tymethod.fmt\" class=\"fn\">fmt</a>(&amp;self, f: &amp;mut <a class=\"struct\" href=\"alloc/fmt/struct.Formatter.html\" title=\"struct alloc::fmt::Formatter\">Formatter</a>&lt;'_&gt;) -&gt; <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;<a class=\"primitive\" href=\"core/primitive.unit.html\">()</a>, <a class=\"struct\" href=\"alloc/fmt/struct.Error.html\" title=\"struct alloc::fmt::Error\">Error</a>&gt;</h4></section></summary><div class='docblock'>Formats the value using the given formatter. <a href=\"alloc/fmt/trait.Debug.html#tymethod.fmt\">Read more</a></div></details></div></details>","Debug","alloc::fmt::Result"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Product%3CResult%3CU,+E%3E%3E-for-Result%3CT,+E%3E\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.16.0\">1.16.0</span> · <a class=\"src\" href=\"src/core/iter/traits/accum.rs.html#184-186\">source</a></span><a href=\"#impl-Product%3CResult%3CU,+E%3E%3E-for-Result%3CT,+E%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, U, E&gt; <a class=\"trait\" href=\"core/iter/traits/accum/trait.Product.html\" title=\"trait core::iter::traits::accum::Product\">Product</a>&lt;<a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;U, E&gt;&gt; for <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;T, E&gt;<span class=\"where fmt-newline\">where\n    T: <a class=\"trait\" href=\"core/iter/traits/accum/trait.Product.html\" title=\"trait core::iter::traits::accum::Product\">Product</a>&lt;U&gt;,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.product\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/iter/traits/accum.rs.html#205-207\">source</a><a href=\"#method.product\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/iter/traits/accum/trait.Product.html#tymethod.product\" class=\"fn\">product</a>&lt;I&gt;(iter: I) -&gt; <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;T, E&gt;<span class=\"where fmt-newline\">where\n    I: <a class=\"trait\" href=\"core/iter/traits/iterator/trait.Iterator.html\" title=\"trait core::iter::traits::iterator::Iterator\">Iterator</a>&lt;Item = <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;U, E&gt;&gt;,</span></h4></section></summary><div class=\"docblock\"><p>Takes each element in the <a href=\"core/iter/traits/iterator/trait.Iterator.html\" title=\"trait core::iter::traits::iterator::Iterator\"><code>Iterator</code></a>: if it is an <a href=\"core/result/enum.Result.html#variant.Err\" title=\"variant core::result::Result::Err\"><code>Err</code></a>, no further\nelements are taken, and the <a href=\"core/result/enum.Result.html#variant.Err\" title=\"variant core::result::Result::Err\"><code>Err</code></a> is returned. Should no <a href=\"core/result/enum.Result.html#variant.Err\" title=\"variant core::result::Result::Err\"><code>Err</code></a>\noccur, the product of all elements is returned.</p>\n<h5 id=\"examples\"><a href=\"#examples\">Examples</a></h5>\n<p>This multiplies each number in a vector of strings,\nif a string could not be parsed the operation returns <code>Err</code>:</p>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>nums = <span class=\"macro\">vec!</span>[<span class=\"string\">&quot;5&quot;</span>, <span class=\"string\">&quot;10&quot;</span>, <span class=\"string\">&quot;1&quot;</span>, <span class=\"string\">&quot;2&quot;</span>];\n<span class=\"kw\">let </span>total: <span class=\"prelude-ty\">Result</span>&lt;usize, <span class=\"kw\">_</span>&gt; = nums.iter().map(|w| w.parse::&lt;usize&gt;()).product();\n<span class=\"macro\">assert_eq!</span>(total, <span class=\"prelude-val\">Ok</span>(<span class=\"number\">100</span>));\n<span class=\"kw\">let </span>nums = <span class=\"macro\">vec!</span>[<span class=\"string\">&quot;5&quot;</span>, <span class=\"string\">&quot;10&quot;</span>, <span class=\"string\">&quot;one&quot;</span>, <span class=\"string\">&quot;2&quot;</span>];\n<span class=\"kw\">let </span>total: <span class=\"prelude-ty\">Result</span>&lt;usize, <span class=\"kw\">_</span>&gt; = nums.iter().map(|w| w.parse::&lt;usize&gt;()).product();\n<span class=\"macro\">assert!</span>(total.is_err());</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+nums+=+vec!%5B%225%22,+%2210%22,+%221%22,+%222%22%5D;%0Alet+total:+Result%3Cusize,+_%3E+=+nums.iter().map(%7Cw%7C+w.parse::%3Cusize%3E()).product();%0Aassert_eq!(total,+Ok(100));%0Alet+nums+=+vec!%5B%225%22,+%2210%22,+%22one%22,+%222%22%5D;%0Alet+total:+Result%3Cusize,+_%3E+=+nums.iter().map(%7Cw%7C+w.parse::%3Cusize%3E()).product();%0Aassert!(total.is_err());%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details></div></details>","Product<Result<U, E>>","alloc::fmt::Result"]],
"core":[["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Result%3CT,+E%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/result.rs.html#518-1497\">source</a><a href=\"#impl-Result%3CT,+E%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, E&gt; <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;T, E&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.is_ok\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"const since 1.48.0\">const: 1.48.0</span> · <a class=\"src\" href=\"src/core/result.rs.html#538-540\">source</a></span><h4 class=\"code-header\">pub const fn <a href=\"core/result/enum.Result.html#tymethod.is_ok\" class=\"fn\">is_ok</a>(&amp;self) -&gt; <a class=\"primitive\" href=\"primitive.bool.html\">bool</a></h4></section></summary><div class=\"docblock\"><p>Returns <code>true</code> if the result is <a href=\"core/result/enum.Result.html#variant.Ok\" title=\"variant core::result::Result::Ok\"><code>Ok</code></a>.</p>\n<h5 id=\"examples\"><a href=\"#examples\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;i32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Ok</span>(-<span class=\"number\">3</span>);\n<span class=\"macro\">assert_eq!</span>(x.is_ok(), <span class=\"bool-val\">true</span>);\n\n<span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;i32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"string\">&quot;Some error message&quot;</span>);\n<span class=\"macro\">assert_eq!</span>(x.is_ok(), <span class=\"bool-val\">false</span>);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+x:+Result%3Ci32,+%26str%3E+=+Ok(-3);%0Aassert_eq!(x.is_ok(),+true);%0A%0Alet+x:+Result%3Ci32,+%26str%3E+=+Err(%22Some+error+message%22);%0Aassert_eq!(x.is_ok(),+false);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.is_ok_and\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.70.0\">1.70.0</span> · <a class=\"src\" href=\"src/core/result.rs.html#559-564\">source</a></span><h4 class=\"code-header\">pub fn <a href=\"core/result/enum.Result.html#tymethod.is_ok_and\" class=\"fn\">is_ok_and</a>(self, f: impl <a class=\"trait\" href=\"core/ops/trait.FnOnce.html\" title=\"trait core::ops::FnOnce\">FnOnce</a>(T) -&gt; <a class=\"primitive\" href=\"primitive.bool.html\">bool</a>) -&gt; <a class=\"primitive\" href=\"primitive.bool.html\">bool</a></h4></section></summary><div class=\"docblock\"><p>Returns <code>true</code> if the result is <a href=\"core/result/enum.Result.html#variant.Ok\" title=\"variant core::result::Result::Ok\"><code>Ok</code></a> and the value inside of it matches a predicate.</p>\n<h5 id=\"examples-1\"><a href=\"#examples-1\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"number\">2</span>);\n<span class=\"macro\">assert_eq!</span>(x.is_ok_and(|x| x &gt; <span class=\"number\">1</span>), <span class=\"bool-val\">true</span>);\n\n<span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"number\">0</span>);\n<span class=\"macro\">assert_eq!</span>(x.is_ok_and(|x| x &gt; <span class=\"number\">1</span>), <span class=\"bool-val\">false</span>);\n\n<span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"string\">&quot;hey&quot;</span>);\n<span class=\"macro\">assert_eq!</span>(x.is_ok_and(|x| x &gt; <span class=\"number\">1</span>), <span class=\"bool-val\">false</span>);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+x:+Result%3Cu32,+%26str%3E+=+Ok(2);%0Aassert_eq!(x.is_ok_and(%7Cx%7C+x+%3E+1),+true);%0A%0Alet+x:+Result%3Cu32,+%26str%3E+=+Ok(0);%0Aassert_eq!(x.is_ok_and(%7Cx%7C+x+%3E+1),+false);%0A%0Alet+x:+Result%3Cu32,+%26str%3E+=+Err(%22hey%22);%0Aassert_eq!(x.is_ok_and(%7Cx%7C+x+%3E+1),+false);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.is_err\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"const since 1.48.0\">const: 1.48.0</span> · <a class=\"src\" href=\"src/core/result.rs.html#581-583\">source</a></span><h4 class=\"code-header\">pub const fn <a href=\"core/result/enum.Result.html#tymethod.is_err\" class=\"fn\">is_err</a>(&amp;self) -&gt; <a class=\"primitive\" href=\"primitive.bool.html\">bool</a></h4></section></summary><div class=\"docblock\"><p>Returns <code>true</code> if the result is <a href=\"core/result/enum.Result.html#variant.Err\" title=\"variant core::result::Result::Err\"><code>Err</code></a>.</p>\n<h5 id=\"examples-2\"><a href=\"#examples-2\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;i32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Ok</span>(-<span class=\"number\">3</span>);\n<span class=\"macro\">assert_eq!</span>(x.is_err(), <span class=\"bool-val\">false</span>);\n\n<span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;i32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"string\">&quot;Some error message&quot;</span>);\n<span class=\"macro\">assert_eq!</span>(x.is_err(), <span class=\"bool-val\">true</span>);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+x:+Result%3Ci32,+%26str%3E+=+Ok(-3);%0Aassert_eq!(x.is_err(),+false);%0A%0Alet+x:+Result%3Ci32,+%26str%3E+=+Err(%22Some+error+message%22);%0Aassert_eq!(x.is_err(),+true);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.is_err_and\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.70.0\">1.70.0</span> · <a class=\"src\" href=\"src/core/result.rs.html#604-609\">source</a></span><h4 class=\"code-header\">pub fn <a href=\"core/result/enum.Result.html#tymethod.is_err_and\" class=\"fn\">is_err_and</a>(self, f: impl <a class=\"trait\" href=\"core/ops/trait.FnOnce.html\" title=\"trait core::ops::FnOnce\">FnOnce</a>(E) -&gt; <a class=\"primitive\" href=\"primitive.bool.html\">bool</a>) -&gt; <a class=\"primitive\" href=\"primitive.bool.html\">bool</a></h4></section></summary><div class=\"docblock\"><p>Returns <code>true</code> if the result is <a href=\"core/result/enum.Result.html#variant.Err\" title=\"variant core::result::Result::Err\"><code>Err</code></a> and the value inside of it matches a predicate.</p>\n<h5 id=\"examples-3\"><a href=\"#examples-3\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">use </span>std::io::{Error, ErrorKind};\n\n<span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, Error&gt; = <span class=\"prelude-val\">Err</span>(Error::new(ErrorKind::NotFound, <span class=\"string\">&quot;!&quot;</span>));\n<span class=\"macro\">assert_eq!</span>(x.is_err_and(|x| x.kind() == ErrorKind::NotFound), <span class=\"bool-val\">true</span>);\n\n<span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, Error&gt; = <span class=\"prelude-val\">Err</span>(Error::new(ErrorKind::PermissionDenied, <span class=\"string\">&quot;!&quot;</span>));\n<span class=\"macro\">assert_eq!</span>(x.is_err_and(|x| x.kind() == ErrorKind::NotFound), <span class=\"bool-val\">false</span>);\n\n<span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, Error&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"number\">123</span>);\n<span class=\"macro\">assert_eq!</span>(x.is_err_and(|x| x.kind() == ErrorKind::NotFound), <span class=\"bool-val\">false</span>);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Ause+std::io::%7BError,+ErrorKind%7D;%0A%0Alet+x:+Result%3Cu32,+Error%3E+=+Err(Error::new(ErrorKind::NotFound,+%22!%22));%0Aassert_eq!(x.is_err_and(%7Cx%7C+x.kind()+==+ErrorKind::NotFound),+true);%0A%0Alet+x:+Result%3Cu32,+Error%3E+=+Err(Error::new(ErrorKind::PermissionDenied,+%22!%22));%0Aassert_eq!(x.is_err_and(%7Cx%7C+x.kind()+==+ErrorKind::NotFound),+false);%0A%0Alet+x:+Result%3Cu32,+Error%3E+=+Ok(123);%0Aassert_eq!(x.is_err_and(%7Cx%7C+x.kind()+==+ErrorKind::NotFound),+false);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.ok\" class=\"method\"><a class=\"src rightside\" href=\"src/core/result.rs.html#631-636\">source</a><h4 class=\"code-header\">pub fn <a href=\"core/result/enum.Result.html#tymethod.ok\" class=\"fn\">ok</a>(self) -&gt; <a class=\"enum\" href=\"core/option/enum.Option.html\" title=\"enum core::option::Option\">Option</a>&lt;T&gt;</h4></section></summary><div class=\"docblock\"><p>Converts from <code>Result&lt;T, E&gt;</code> to <a href=\"core/option/enum.Option.html\" title=\"enum core::option::Option\"><code>Option&lt;T&gt;</code></a>.</p>\n<p>Converts <code>self</code> into an <a href=\"core/option/enum.Option.html\" title=\"enum core::option::Option\"><code>Option&lt;T&gt;</code></a>, consuming <code>self</code>,\nand discarding the error, if any.</p>\n<h5 id=\"examples-4\"><a href=\"#examples-4\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"number\">2</span>);\n<span class=\"macro\">assert_eq!</span>(x.ok(), <span class=\"prelude-val\">Some</span>(<span class=\"number\">2</span>));\n\n<span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"string\">&quot;Nothing here&quot;</span>);\n<span class=\"macro\">assert_eq!</span>(x.ok(), <span class=\"prelude-val\">None</span>);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+x:+Result%3Cu32,+%26str%3E+=+Ok(2);%0Aassert_eq!(x.ok(),+Some(2));%0A%0Alet+x:+Result%3Cu32,+%26str%3E+=+Err(%22Nothing+here%22);%0Aassert_eq!(x.ok(),+None);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.err\" class=\"method\"><a class=\"src rightside\" href=\"src/core/result.rs.html#654-659\">source</a><h4 class=\"code-header\">pub fn <a href=\"core/result/enum.Result.html#tymethod.err\" class=\"fn\">err</a>(self) -&gt; <a class=\"enum\" href=\"core/option/enum.Option.html\" title=\"enum core::option::Option\">Option</a>&lt;E&gt;</h4></section></summary><div class=\"docblock\"><p>Converts from <code>Result&lt;T, E&gt;</code> to <a href=\"core/option/enum.Option.html\" title=\"enum core::option::Option\"><code>Option&lt;E&gt;</code></a>.</p>\n<p>Converts <code>self</code> into an <a href=\"core/option/enum.Option.html\" title=\"enum core::option::Option\"><code>Option&lt;E&gt;</code></a>, consuming <code>self</code>,\nand discarding the success value, if any.</p>\n<h5 id=\"examples-5\"><a href=\"#examples-5\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"number\">2</span>);\n<span class=\"macro\">assert_eq!</span>(x.err(), <span class=\"prelude-val\">None</span>);\n\n<span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"string\">&quot;Nothing here&quot;</span>);\n<span class=\"macro\">assert_eq!</span>(x.err(), <span class=\"prelude-val\">Some</span>(<span class=\"string\">&quot;Nothing here&quot;</span>));</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+x:+Result%3Cu32,+%26str%3E+=+Ok(2);%0Aassert_eq!(x.err(),+None);%0A%0Alet+x:+Result%3Cu32,+%26str%3E+=+Err(%22Nothing+here%22);%0Aassert_eq!(x.err(),+Some(%22Nothing+here%22));%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.as_ref\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"const since 1.48.0\">const: 1.48.0</span> · <a class=\"src\" href=\"src/core/result.rs.html#682-687\">source</a></span><h4 class=\"code-header\">pub const fn <a href=\"core/result/enum.Result.html#tymethod.as_ref\" class=\"fn\">as_ref</a>(&amp;self) -&gt; <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;<a class=\"primitive\" href=\"primitive.reference.html\">&amp;T</a>, <a class=\"primitive\" href=\"primitive.reference.html\">&amp;E</a>&gt;</h4></section></summary><div class=\"docblock\"><p>Converts from <code>&amp;Result&lt;T, E&gt;</code> to <code>Result&lt;&amp;T, &amp;E&gt;</code>.</p>\n<p>Produces a new <code>Result</code>, containing a reference\ninto the original, leaving the original in place.</p>\n<h5 id=\"examples-6\"><a href=\"#examples-6\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"number\">2</span>);\n<span class=\"macro\">assert_eq!</span>(x.as_ref(), <span class=\"prelude-val\">Ok</span>(<span class=\"kw-2\">&amp;</span><span class=\"number\">2</span>));\n\n<span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"string\">&quot;Error&quot;</span>);\n<span class=\"macro\">assert_eq!</span>(x.as_ref(), <span class=\"prelude-val\">Err</span>(<span class=\"kw-2\">&amp;</span><span class=\"string\">&quot;Error&quot;</span>));</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+x:+Result%3Cu32,+%26str%3E+=+Ok(2);%0Aassert_eq!(x.as_ref(),+Ok(%262));%0A%0Alet+x:+Result%3Cu32,+%26str%3E+=+Err(%22Error%22);%0Aassert_eq!(x.as_ref(),+Err(%26%22Error%22));%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.as_mut\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"const unstable\">const: <a href=\"https://github.com/rust-lang/rust/issues/82814\" title=\"Tracking issue for const_result\">unstable</a></span> · <a class=\"src\" href=\"src/core/result.rs.html#712-717\">source</a></span><h4 class=\"code-header\">pub fn <a href=\"core/result/enum.Result.html#tymethod.as_mut\" class=\"fn\">as_mut</a>(&amp;mut self) -&gt; <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;<a class=\"primitive\" href=\"primitive.reference.html\">&amp;mut T</a>, <a class=\"primitive\" href=\"primitive.reference.html\">&amp;mut E</a>&gt;</h4></section></summary><div class=\"docblock\"><p>Converts from <code>&amp;mut Result&lt;T, E&gt;</code> to <code>Result&lt;&amp;mut T, &amp;mut E&gt;</code>.</p>\n<h5 id=\"examples-7\"><a href=\"#examples-7\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">fn </span>mutate(r: <span class=\"kw-2\">&amp;mut </span><span class=\"prelude-ty\">Result</span>&lt;i32, i32&gt;) {\n    <span class=\"kw\">match </span>r.as_mut() {\n        <span class=\"prelude-val\">Ok</span>(v) =&gt; <span class=\"kw-2\">*</span>v = <span class=\"number\">42</span>,\n        <span class=\"prelude-val\">Err</span>(e) =&gt; <span class=\"kw-2\">*</span>e = <span class=\"number\">0</span>,\n    }\n}\n\n<span class=\"kw\">let </span><span class=\"kw-2\">mut </span>x: <span class=\"prelude-ty\">Result</span>&lt;i32, i32&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"number\">2</span>);\nmutate(<span class=\"kw-2\">&amp;mut </span>x);\n<span class=\"macro\">assert_eq!</span>(x.unwrap(), <span class=\"number\">42</span>);\n\n<span class=\"kw\">let </span><span class=\"kw-2\">mut </span>x: <span class=\"prelude-ty\">Result</span>&lt;i32, i32&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"number\">13</span>);\nmutate(<span class=\"kw-2\">&amp;mut </span>x);\n<span class=\"macro\">assert_eq!</span>(x.unwrap_err(), <span class=\"number\">0</span>);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Afn+mutate(r:+%26mut+Result%3Ci32,+i32%3E)+%7B%0A++++match+r.as_mut()+%7B%0A++++++++Ok(v)+=%3E+*v+=+42,%0A++++++++Err(e)+=%3E+*e+=+0,%0A++++%7D%0A%7D%0A%0Alet+mut+x:+Result%3Ci32,+i32%3E+=+Ok(2);%0Amutate(%26mut+x);%0Aassert_eq!(x.unwrap(),+42);%0A%0Alet+mut+x:+Result%3Ci32,+i32%3E+=+Err(13);%0Amutate(%26mut+x);%0Aassert_eq!(x.unwrap_err(),+0);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.map\" class=\"method\"><a class=\"src rightside\" href=\"src/core/result.rs.html#744-749\">source</a><h4 class=\"code-header\">pub fn <a href=\"core/result/enum.Result.html#tymethod.map\" class=\"fn\">map</a>&lt;U, F: <a class=\"trait\" href=\"core/ops/trait.FnOnce.html\" title=\"trait core::ops::FnOnce\">FnOnce</a>(T) -&gt; U&gt;(self, op: F) -&gt; <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;U, E&gt;</h4></section></summary><div class=\"docblock\"><p>Maps a <code>Result&lt;T, E&gt;</code> to <code>Result&lt;U, E&gt;</code> by applying a function to a\ncontained <a href=\"core/result/enum.Result.html#variant.Ok\" title=\"variant core::result::Result::Ok\"><code>Ok</code></a> value, leaving an <a href=\"core/result/enum.Result.html#variant.Err\" title=\"variant core::result::Result::Err\"><code>Err</code></a> value untouched.</p>\n<p>This function can be used to compose the results of two functions.</p>\n<h5 id=\"examples-8\"><a href=\"#examples-8\">Examples</a></h5>\n<p>Print the numbers on each line of a string multiplied by two.</p>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>line = <span class=\"string\">&quot;1\\n2\\n3\\n4\\n&quot;</span>;\n\n<span class=\"kw\">for </span>num <span class=\"kw\">in </span>line.lines() {\n    <span class=\"kw\">match </span>num.parse::&lt;i32&gt;().map(|i| i * <span class=\"number\">2</span>) {\n        <span class=\"prelude-val\">Ok</span>(n) =&gt; <span class=\"macro\">println!</span>(<span class=\"string\">&quot;{n}&quot;</span>),\n        <span class=\"prelude-val\">Err</span>(..) =&gt; {}\n    }\n}</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+line+=+%221%5Cn2%5Cn3%5Cn4%5Cn%22;%0A%0Afor+num+in+line.lines()+%7B%0A++++match+num.parse::%3Ci32%3E().map(%7Ci%7C+i+*+2)+%7B%0A++++++++Ok(n)+=%3E+println!(%22%7Bn%7D%22),%0A++++++++Err(..)+=%3E+%7B%7D%0A++++%7D%0A%7D%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.map_or\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.41.0\">1.41.0</span> · <a class=\"src\" href=\"src/core/result.rs.html#772-777\">source</a></span><h4 class=\"code-header\">pub fn <a href=\"core/result/enum.Result.html#tymethod.map_or\" class=\"fn\">map_or</a>&lt;U, F: <a class=\"trait\" href=\"core/ops/trait.FnOnce.html\" title=\"trait core::ops::FnOnce\">FnOnce</a>(T) -&gt; U&gt;(self, default: U, f: F) -&gt; U</h4></section></summary><div class=\"docblock\"><p>Returns the provided default (if <a href=\"core/result/enum.Result.html#variant.Err\" title=\"variant core::result::Result::Err\"><code>Err</code></a>), or\napplies a function to the contained value (if <a href=\"core/result/enum.Result.html#variant.Ok\" title=\"variant core::result::Result::Ok\"><code>Ok</code></a>).</p>\n<p>Arguments passed to <code>map_or</code> are eagerly evaluated; if you are passing\nthe result of a function call, it is recommended to use <a href=\"core/result/enum.Result.html#method.map_or_else\" title=\"method core::result::Result::map_or_else\"><code>map_or_else</code></a>,\nwhich is lazily evaluated.</p>\n<h5 id=\"examples-9\"><a href=\"#examples-9\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;<span class=\"kw\">_</span>, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"string\">&quot;foo&quot;</span>);\n<span class=\"macro\">assert_eq!</span>(x.map_or(<span class=\"number\">42</span>, |v| v.len()), <span class=\"number\">3</span>);\n\n<span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;<span class=\"kw-2\">&amp;</span>str, <span class=\"kw\">_</span>&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"string\">&quot;bar&quot;</span>);\n<span class=\"macro\">assert_eq!</span>(x.map_or(<span class=\"number\">42</span>, |v| v.len()), <span class=\"number\">42</span>);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+x:+Result%3C_,+%26str%3E+=+Ok(%22foo%22);%0Aassert_eq!(x.map_or(42,+%7Cv%7C+v.len()),+3);%0A%0Alet+x:+Result%3C%26str,+_%3E+=+Err(%22bar%22);%0Aassert_eq!(x.map_or(42,+%7Cv%7C+v.len()),+42);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.map_or_else\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.41.0\">1.41.0</span> · <a class=\"src\" href=\"src/core/result.rs.html#799-804\">source</a></span><h4 class=\"code-header\">pub fn <a href=\"core/result/enum.Result.html#tymethod.map_or_else\" class=\"fn\">map_or_else</a>&lt;U, D: <a class=\"trait\" href=\"core/ops/trait.FnOnce.html\" title=\"trait core::ops::FnOnce\">FnOnce</a>(E) -&gt; U, F: <a class=\"trait\" href=\"core/ops/trait.FnOnce.html\" title=\"trait core::ops::FnOnce\">FnOnce</a>(T) -&gt; U&gt;(\n    self,\n    default: D,\n    f: F\n) -&gt; U</h4></section></summary><div class=\"docblock\"><p>Maps a <code>Result&lt;T, E&gt;</code> to <code>U</code> by applying fallback function <code>default</code> to\na contained <a href=\"core/result/enum.Result.html#variant.Err\" title=\"variant core::result::Result::Err\"><code>Err</code></a> value, or function <code>f</code> to a contained <a href=\"core/result/enum.Result.html#variant.Ok\" title=\"variant core::result::Result::Ok\"><code>Ok</code></a> value.</p>\n<p>This function can be used to unpack a successful result\nwhile handling an error.</p>\n<h5 id=\"examples-10\"><a href=\"#examples-10\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>k = <span class=\"number\">21</span>;\n\n<span class=\"kw\">let </span>x : <span class=\"prelude-ty\">Result</span>&lt;<span class=\"kw\">_</span>, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"string\">&quot;foo&quot;</span>);\n<span class=\"macro\">assert_eq!</span>(x.map_or_else(|e| k * <span class=\"number\">2</span>, |v| v.len()), <span class=\"number\">3</span>);\n\n<span class=\"kw\">let </span>x : <span class=\"prelude-ty\">Result</span>&lt;<span class=\"kw-2\">&amp;</span>str, <span class=\"kw\">_</span>&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"string\">&quot;bar&quot;</span>);\n<span class=\"macro\">assert_eq!</span>(x.map_or_else(|e| k * <span class=\"number\">2</span>, |v| v.len()), <span class=\"number\">42</span>);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+k+=+21;%0A%0Alet+x+:+Result%3C_,+%26str%3E+=+Ok(%22foo%22);%0Aassert_eq!(x.map_or_else(%7Ce%7C+k+*+2,+%7Cv%7C+v.len()),+3);%0A%0Alet+x+:+Result%3C%26str,+_%3E+=+Err(%22bar%22);%0Aassert_eq!(x.map_or_else(%7Ce%7C+k+*+2,+%7Cv%7C+v.len()),+42);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.map_err\" class=\"method\"><a class=\"src rightside\" href=\"src/core/result.rs.html#826-831\">source</a><h4 class=\"code-header\">pub fn <a href=\"core/result/enum.Result.html#tymethod.map_err\" class=\"fn\">map_err</a>&lt;F, O: <a class=\"trait\" href=\"core/ops/trait.FnOnce.html\" title=\"trait core::ops::FnOnce\">FnOnce</a>(E) -&gt; F&gt;(self, op: O) -&gt; <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;T, F&gt;</h4></section></summary><div class=\"docblock\"><p>Maps a <code>Result&lt;T, E&gt;</code> to <code>Result&lt;T, F&gt;</code> by applying a function to a\ncontained <a href=\"core/result/enum.Result.html#variant.Err\" title=\"variant core::result::Result::Err\"><code>Err</code></a> value, leaving an <a href=\"core/result/enum.Result.html#variant.Ok\" title=\"variant core::result::Result::Ok\"><code>Ok</code></a> value untouched.</p>\n<p>This function can be used to pass through a successful result while handling\nan error.</p>\n<h5 id=\"examples-11\"><a href=\"#examples-11\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">fn </span>stringify(x: u32) -&gt; String { <span class=\"macro\">format!</span>(<span class=\"string\">&quot;error code: {x}&quot;</span>) }\n\n<span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, u32&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"number\">2</span>);\n<span class=\"macro\">assert_eq!</span>(x.map_err(stringify), <span class=\"prelude-val\">Ok</span>(<span class=\"number\">2</span>));\n\n<span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, u32&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"number\">13</span>);\n<span class=\"macro\">assert_eq!</span>(x.map_err(stringify), <span class=\"prelude-val\">Err</span>(<span class=\"string\">&quot;error code: 13&quot;</span>.to_string()));</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Afn+stringify(x:+u32)+-%3E+String+%7B+format!(%22error+code:+%7Bx%7D%22)+%7D%0A%0Alet+x:+Result%3Cu32,+u32%3E+=+Ok(2);%0Aassert_eq!(x.map_err(stringify),+Ok(2));%0A%0Alet+x:+Result%3Cu32,+u32%3E+=+Err(13);%0Aassert_eq!(x.map_err(stringify),+Err(%22error+code:+13%22.to_string()));%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.inspect\" class=\"method\"><a class=\"src rightside\" href=\"src/core/result.rs.html#848-854\">source</a><h4 class=\"code-header\">pub fn <a href=\"core/result/enum.Result.html#tymethod.inspect\" class=\"fn\">inspect</a>&lt;F: <a class=\"trait\" href=\"core/ops/trait.FnOnce.html\" title=\"trait core::ops::FnOnce\">FnOnce</a>(<a class=\"primitive\" href=\"primitive.reference.html\">&amp;T</a>)&gt;(self, f: F) -&gt; Self</h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>result_option_inspect</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/91345\">#91345</a>)</span></div></span></summary><div class=\"docblock\"><p>Calls the provided closure with a reference to the contained value (if <a href=\"core/result/enum.Result.html#variant.Ok\" title=\"variant core::result::Result::Ok\"><code>Ok</code></a>).</p>\n<h5 id=\"examples-12\"><a href=\"#examples-12\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"attr\">#![feature(result_option_inspect)]\n\n</span><span class=\"kw\">let </span>x: u8 = <span class=\"string\">&quot;4&quot;\n    </span>.parse::&lt;u8&gt;()\n    .inspect(|x| <span class=\"macro\">println!</span>(<span class=\"string\">&quot;original: {x}&quot;</span>))\n    .map(|x| x.pow(<span class=\"number\">3</span>))\n    .expect(<span class=\"string\">&quot;failed to parse number&quot;</span>);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A%23!%5Bfeature(result_option_inspect)%5D%0A%0Afn+main()+%7B%0Alet+x:+u8+=+%224%22%0A++++.parse::%3Cu8%3E()%0A++++.inspect(%7Cx%7C+println!(%22original:+%7Bx%7D%22))%0A++++.map(%7Cx%7C+x.pow(3))%0A++++.expect(%22failed+to+parse+number%22);%0A%7D&amp;version=nightly&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.inspect_err\" class=\"method\"><a class=\"src rightside\" href=\"src/core/result.rs.html#872-878\">source</a><h4 class=\"code-header\">pub fn <a href=\"core/result/enum.Result.html#tymethod.inspect_err\" class=\"fn\">inspect_err</a>&lt;F: <a class=\"trait\" href=\"core/ops/trait.FnOnce.html\" title=\"trait core::ops::FnOnce\">FnOnce</a>(<a class=\"primitive\" href=\"primitive.reference.html\">&amp;E</a>)&gt;(self, f: F) -&gt; Self</h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>result_option_inspect</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/91345\">#91345</a>)</span></div></span></summary><div class=\"docblock\"><p>Calls the provided closure with a reference to the contained error (if <a href=\"core/result/enum.Result.html#variant.Err\" title=\"variant core::result::Result::Err\"><code>Err</code></a>).</p>\n<h5 id=\"examples-13\"><a href=\"#examples-13\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"attr\">#![feature(result_option_inspect)]\n\n</span><span class=\"kw\">use </span>std::{fs, io};\n\n<span class=\"kw\">fn </span>read() -&gt; io::Result&lt;String&gt; {\n    fs::read_to_string(<span class=\"string\">&quot;address.txt&quot;</span>)\n        .inspect_err(|e| <span class=\"macro\">eprintln!</span>(<span class=\"string\">&quot;failed to read file: {e}&quot;</span>))\n}</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A%23!%5Bfeature(result_option_inspect)%5D%0A%0Afn+main()+%7B%0Ause+std::%7Bfs,+io%7D;%0A%0Afn+read()+-%3E+io::Result%3CString%3E+%7B%0A++++fs::read_to_string(%22address.txt%22)%0A++++++++.inspect_err(%7Ce%7C+eprintln!(%22failed+to+read+file:+%7Be%7D%22))%0A%7D%0A%7D&amp;version=nightly&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.as_deref\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.47.0\">1.47.0</span> · <a class=\"src\" href=\"src/core/result.rs.html#898-903\">source</a></span><h4 class=\"code-header\">pub fn <a href=\"core/result/enum.Result.html#tymethod.as_deref\" class=\"fn\">as_deref</a>(&amp;self) -&gt; <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;&amp;T::<a class=\"associatedtype\" href=\"core/ops/trait.Deref.html#associatedtype.Target\" title=\"type core::ops::Deref::Target\">Target</a>, <a class=\"primitive\" href=\"primitive.reference.html\">&amp;E</a>&gt;<span class=\"where fmt-newline\">where\n    T: <a class=\"trait\" href=\"core/ops/trait.Deref.html\" title=\"trait core::ops::Deref\">Deref</a>,</span></h4></section></summary><div class=\"docblock\"><p>Converts from <code>Result&lt;T, E&gt;</code> (or <code>&amp;Result&lt;T, E&gt;</code>) to <code>Result&lt;&amp;&lt;T as Deref&gt;::Target, &amp;E&gt;</code>.</p>\n<p>Coerces the <a href=\"core/result/enum.Result.html#variant.Ok\" title=\"variant core::result::Result::Ok\"><code>Ok</code></a> variant of the original <a href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\"><code>Result</code></a> via <a href=\"core/ops/trait.Deref.html\" title=\"trait core::ops::Deref\"><code>Deref</code></a>\nand returns the new <a href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\"><code>Result</code></a>.</p>\n<h5 id=\"examples-14\"><a href=\"#examples-14\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;String, u32&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"string\">&quot;hello&quot;</span>.to_string());\n<span class=\"kw\">let </span>y: <span class=\"prelude-ty\">Result</span>&lt;<span class=\"kw-2\">&amp;</span>str, <span class=\"kw-2\">&amp;</span>u32&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"string\">&quot;hello&quot;</span>);\n<span class=\"macro\">assert_eq!</span>(x.as_deref(), y);\n\n<span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;String, u32&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"number\">42</span>);\n<span class=\"kw\">let </span>y: <span class=\"prelude-ty\">Result</span>&lt;<span class=\"kw-2\">&amp;</span>str, <span class=\"kw-2\">&amp;</span>u32&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"kw-2\">&amp;</span><span class=\"number\">42</span>);\n<span class=\"macro\">assert_eq!</span>(x.as_deref(), y);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+x:+Result%3CString,+u32%3E+=+Ok(%22hello%22.to_string());%0Alet+y:+Result%3C%26str,+%26u32%3E+=+Ok(%22hello%22);%0Aassert_eq!(x.as_deref(),+y);%0A%0Alet+x:+Result%3CString,+u32%3E+=+Err(42);%0Alet+y:+Result%3C%26str,+%26u32%3E+=+Err(%2642);%0Aassert_eq!(x.as_deref(),+y);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.as_deref_mut\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.47.0\">1.47.0</span> · <a class=\"src\" href=\"src/core/result.rs.html#925-930\">source</a></span><h4 class=\"code-header\">pub fn <a href=\"core/result/enum.Result.html#tymethod.as_deref_mut\" class=\"fn\">as_deref_mut</a>(&amp;mut self) -&gt; <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;&amp;mut T::<a class=\"associatedtype\" href=\"core/ops/trait.Deref.html#associatedtype.Target\" title=\"type core::ops::Deref::Target\">Target</a>, <a class=\"primitive\" href=\"primitive.reference.html\">&amp;mut E</a>&gt;<span class=\"where fmt-newline\">where\n    T: <a class=\"trait\" href=\"core/ops/trait.DerefMut.html\" title=\"trait core::ops::DerefMut\">DerefMut</a>,</span></h4></section></summary><div class=\"docblock\"><p>Converts from <code>Result&lt;T, E&gt;</code> (or <code>&amp;mut Result&lt;T, E&gt;</code>) to <code>Result&lt;&amp;mut &lt;T as DerefMut&gt;::Target, &amp;mut E&gt;</code>.</p>\n<p>Coerces the <a href=\"core/result/enum.Result.html#variant.Ok\" title=\"variant core::result::Result::Ok\"><code>Ok</code></a> variant of the original <a href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\"><code>Result</code></a> via <a href=\"core/ops/trait.DerefMut.html\" title=\"trait core::ops::DerefMut\"><code>DerefMut</code></a>\nand returns the new <a href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\"><code>Result</code></a>.</p>\n<h5 id=\"examples-15\"><a href=\"#examples-15\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>s = <span class=\"string\">&quot;HELLO&quot;</span>.to_string();\n<span class=\"kw\">let </span><span class=\"kw-2\">mut </span>x: <span class=\"prelude-ty\">Result</span>&lt;String, u32&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"string\">&quot;hello&quot;</span>.to_string());\n<span class=\"kw\">let </span>y: <span class=\"prelude-ty\">Result</span>&lt;<span class=\"kw-2\">&amp;mut </span>str, <span class=\"kw-2\">&amp;mut </span>u32&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"kw-2\">&amp;mut </span>s);\n<span class=\"macro\">assert_eq!</span>(x.as_deref_mut().map(|x| { x.make_ascii_uppercase(); x }), y);\n\n<span class=\"kw\">let </span><span class=\"kw-2\">mut </span>i = <span class=\"number\">42</span>;\n<span class=\"kw\">let </span><span class=\"kw-2\">mut </span>x: <span class=\"prelude-ty\">Result</span>&lt;String, u32&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"number\">42</span>);\n<span class=\"kw\">let </span>y: <span class=\"prelude-ty\">Result</span>&lt;<span class=\"kw-2\">&amp;mut </span>str, <span class=\"kw-2\">&amp;mut </span>u32&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"kw-2\">&amp;mut </span>i);\n<span class=\"macro\">assert_eq!</span>(x.as_deref_mut().map(|x| { x.make_ascii_uppercase(); x }), y);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+mut+s+=+%22HELLO%22.to_string();%0Alet+mut+x:+Result%3CString,+u32%3E+=+Ok(%22hello%22.to_string());%0Alet+y:+Result%3C%26mut+str,+%26mut+u32%3E+=+Ok(%26mut+s);%0Aassert_eq!(x.as_deref_mut().map(%7Cx%7C+%7B+x.make_ascii_uppercase();+x+%7D),+y);%0A%0Alet+mut+i+=+42;%0Alet+mut+x:+Result%3CString,+u32%3E+=+Err(42);%0Alet+y:+Result%3C%26mut+str,+%26mut+u32%3E+=+Err(%26mut+i);%0Aassert_eq!(x.as_deref_mut().map(%7Cx%7C+%7B+x.make_ascii_uppercase();+x+%7D),+y);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.iter\" class=\"method\"><a class=\"src rightside\" href=\"src/core/result.rs.html#951-953\">source</a><h4 class=\"code-header\">pub fn <a href=\"core/result/enum.Result.html#tymethod.iter\" class=\"fn\">iter</a>(&amp;self) -&gt; <a class=\"struct\" href=\"core/result/struct.Iter.html\" title=\"struct core::result::Iter\">Iter</a>&lt;'_, T&gt; <a href=\"#\" class=\"tooltip\" data-notable-ty=\"Iter&lt;&#39;_, T&gt;\">ⓘ</a></h4></section></summary><div class=\"docblock\"><p>Returns an iterator over the possibly contained value.</p>\n<p>The iterator yields one value if the result is <a href=\"core/result/enum.Result.html#variant.Ok\" title=\"variant core::result::Result::Ok\"><code>Result::Ok</code></a>, otherwise none.</p>\n<h5 id=\"examples-16\"><a href=\"#examples-16\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"number\">7</span>);\n<span class=\"macro\">assert_eq!</span>(x.iter().next(), <span class=\"prelude-val\">Some</span>(<span class=\"kw-2\">&amp;</span><span class=\"number\">7</span>));\n\n<span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"string\">&quot;nothing!&quot;</span>);\n<span class=\"macro\">assert_eq!</span>(x.iter().next(), <span class=\"prelude-val\">None</span>);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+x:+Result%3Cu32,+%26str%3E+=+Ok(7);%0Aassert_eq!(x.iter().next(),+Some(%267));%0A%0Alet+x:+Result%3Cu32,+%26str%3E+=+Err(%22nothing!%22);%0Aassert_eq!(x.iter().next(),+None);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.iter_mut\" class=\"method\"><a class=\"src rightside\" href=\"src/core/result.rs.html#974-976\">source</a><h4 class=\"code-header\">pub fn <a href=\"core/result/enum.Result.html#tymethod.iter_mut\" class=\"fn\">iter_mut</a>(&amp;mut self) -&gt; <a class=\"struct\" href=\"core/result/struct.IterMut.html\" title=\"struct core::result::IterMut\">IterMut</a>&lt;'_, T&gt; <a href=\"#\" class=\"tooltip\" data-notable-ty=\"IterMut&lt;&#39;_, T&gt;\">ⓘ</a></h4></section></summary><div class=\"docblock\"><p>Returns a mutable iterator over the possibly contained value.</p>\n<p>The iterator yields one value if the result is <a href=\"core/result/enum.Result.html#variant.Ok\" title=\"variant core::result::Result::Ok\"><code>Result::Ok</code></a>, otherwise none.</p>\n<h5 id=\"examples-17\"><a href=\"#examples-17\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"number\">7</span>);\n<span class=\"kw\">match </span>x.iter_mut().next() {\n    <span class=\"prelude-val\">Some</span>(v) =&gt; <span class=\"kw-2\">*</span>v = <span class=\"number\">40</span>,\n    <span class=\"prelude-val\">None </span>=&gt; {},\n}\n<span class=\"macro\">assert_eq!</span>(x, <span class=\"prelude-val\">Ok</span>(<span class=\"number\">40</span>));\n\n<span class=\"kw\">let </span><span class=\"kw-2\">mut </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"string\">&quot;nothing!&quot;</span>);\n<span class=\"macro\">assert_eq!</span>(x.iter_mut().next(), <span class=\"prelude-val\">None</span>);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+mut+x:+Result%3Cu32,+%26str%3E+=+Ok(7);%0Amatch+x.iter_mut().next()+%7B%0A++++Some(v)+=%3E+*v+=+40,%0A++++None+=%3E+%7B%7D,%0A%7D%0Aassert_eq!(x,+Ok(40));%0A%0Alet+mut+x:+Result%3Cu32,+%26str%3E+=+Err(%22nothing!%22);%0Aassert_eq!(x.iter_mut().next(),+None);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.expect\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.4.0\">1.4.0</span> · <a class=\"src\" href=\"src/core/result.rs.html#1028-1036\">source</a></span><h4 class=\"code-header\">pub fn <a href=\"core/result/enum.Result.html#tymethod.expect\" class=\"fn\">expect</a>(self, msg: &amp;<a class=\"primitive\" href=\"primitive.str.html\">str</a>) -&gt; T<span class=\"where fmt-newline\">where\n    E: <a class=\"trait\" href=\"core/fmt/trait.Debug.html\" title=\"trait core::fmt::Debug\">Debug</a>,</span></h4></section></summary><div class=\"docblock\"><p>Returns the contained <a href=\"core/result/enum.Result.html#variant.Ok\" title=\"variant core::result::Result::Ok\"><code>Ok</code></a> value, consuming the <code>self</code> value.</p>\n<p>Because this function may panic, its use is generally discouraged.\nInstead, prefer to use pattern matching and handle the <a href=\"core/result/enum.Result.html#variant.Err\" title=\"variant core::result::Result::Err\"><code>Err</code></a>\ncase explicitly, or call <a href=\"core/result/enum.Result.html#method.unwrap_or\" title=\"method core::result::Result::unwrap_or\"><code>unwrap_or</code></a>, <a href=\"core/result/enum.Result.html#method.unwrap_or_else\" title=\"method core::result::Result::unwrap_or_else\"><code>unwrap_or_else</code></a>, or\n<a href=\"core/result/enum.Result.html#method.unwrap_or_default\" title=\"method core::result::Result::unwrap_or_default\"><code>unwrap_or_default</code></a>.</p>\n<h5 id=\"panics\"><a href=\"#panics\">Panics</a></h5>\n<p>Panics if the value is an <a href=\"core/result/enum.Result.html#variant.Err\" title=\"variant core::result::Result::Err\"><code>Err</code></a>, with a panic message including the\npassed message, and the content of the <a href=\"core/result/enum.Result.html#variant.Err\" title=\"variant core::result::Result::Err\"><code>Err</code></a>.</p>\n<h5 id=\"examples-18\"><a href=\"#examples-18\">Examples</a></h5>\n<div class=\"example-wrap should_panic\"><a href=\"#\" class=\"tooltip\" title=\"This example panics\">ⓘ</a><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"string\">&quot;emergency failure&quot;</span>);\nx.expect(<span class=\"string\">&quot;Testing expect&quot;</span>); <span class=\"comment\">// panics with `Testing expect: emergency failure`</span></code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+x:+Result%3Cu32,+%26str%3E+=+Err(%22emergency+failure%22);%0Ax.expect(%22Testing+expect%22);+//+panics+with+%60Testing+expect:+emergency+failure%60%0A%7D&amp;edition=2021\">Run</a></div>\n<h5 id=\"recommended-message-style\"><a href=\"#recommended-message-style\">Recommended Message Style</a></h5>\n<p>We recommend that <code>expect</code> messages are used to describe the reason you\n<em>expect</em> the <code>Result</code> should be <code>Ok</code>.</p>\n\n<div class=\"example-wrap should_panic\"><a href=\"#\" class=\"tooltip\" title=\"This example panics\">ⓘ</a><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>path = std::env::var(<span class=\"string\">&quot;IMPORTANT_PATH&quot;</span>)\n    .expect(<span class=\"string\">&quot;env variable `IMPORTANT_PATH` should be set by `wrapper_script.sh`&quot;</span>);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+path+=+std::env::var(%22IMPORTANT_PATH%22)%0A++++.expect(%22env+variable+%60IMPORTANT_PATH%60+should+be+set+by+%60wrapper_script.sh%60%22);%0A%7D&amp;edition=2021\">Run</a></div>\n<p><strong>Hint</strong>: If you’re having trouble remembering how to phrase expect\nerror messages remember to focus on the word “should” as in “env\nvariable should be set by blah” or “the given binary should be available\nand executable by the current user”.</p>\n<p>For more detail on expect message styles and the reasoning behind our recommendation please\nrefer to the section on <a href=\"../../std/error/index.html#common-message-styles\">“Common Message\nStyles”</a> in the\n<a href=\"../../std/error/index.html\"><code>std::error</code></a> module docs.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.unwrap\" class=\"method\"><a class=\"src rightside\" href=\"src/core/result.rs.html#1071-1079\">source</a><h4 class=\"code-header\">pub fn <a href=\"core/result/enum.Result.html#tymethod.unwrap\" class=\"fn\">unwrap</a>(self) -&gt; T<span class=\"where fmt-newline\">where\n    E: <a class=\"trait\" href=\"core/fmt/trait.Debug.html\" title=\"trait core::fmt::Debug\">Debug</a>,</span></h4></section></summary><div class=\"docblock\"><p>Returns the contained <a href=\"core/result/enum.Result.html#variant.Ok\" title=\"variant core::result::Result::Ok\"><code>Ok</code></a> value, consuming the <code>self</code> value.</p>\n<p>Because this function may panic, its use is generally discouraged.\nInstead, prefer to use pattern matching and handle the <a href=\"core/result/enum.Result.html#variant.Err\" title=\"variant core::result::Result::Err\"><code>Err</code></a>\ncase explicitly, or call <a href=\"core/result/enum.Result.html#method.unwrap_or\" title=\"method core::result::Result::unwrap_or\"><code>unwrap_or</code></a>, <a href=\"core/result/enum.Result.html#method.unwrap_or_else\" title=\"method core::result::Result::unwrap_or_else\"><code>unwrap_or_else</code></a>, or\n<a href=\"core/result/enum.Result.html#method.unwrap_or_default\" title=\"method core::result::Result::unwrap_or_default\"><code>unwrap_or_default</code></a>.</p>\n<h5 id=\"panics-1\"><a href=\"#panics-1\">Panics</a></h5>\n<p>Panics if the value is an <a href=\"core/result/enum.Result.html#variant.Err\" title=\"variant core::result::Result::Err\"><code>Err</code></a>, with a panic message provided by the\n<a href=\"core/result/enum.Result.html#variant.Err\" title=\"variant core::result::Result::Err\"><code>Err</code></a>’s value.</p>\n<h5 id=\"examples-19\"><a href=\"#examples-19\">Examples</a></h5>\n<p>Basic usage:</p>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"number\">2</span>);\n<span class=\"macro\">assert_eq!</span>(x.unwrap(), <span class=\"number\">2</span>);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+x:+Result%3Cu32,+%26str%3E+=+Ok(2);%0Aassert_eq!(x.unwrap(),+2);%0A%7D&amp;edition=2021\">Run</a></div>\n\n<div class=\"example-wrap should_panic\"><a href=\"#\" class=\"tooltip\" title=\"This example panics\">ⓘ</a><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"string\">&quot;emergency failure&quot;</span>);\nx.unwrap(); <span class=\"comment\">// panics with `emergency failure`</span></code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+x:+Result%3Cu32,+%26str%3E+=+Err(%22emergency+failure%22);%0Ax.unwrap();+//+panics+with+%60emergency+failure%60%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.unwrap_or_default\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.16.0\">1.16.0</span> · <a class=\"src\" href=\"src/core/result.rs.html#1108-1116\">source</a></span><h4 class=\"code-header\">pub fn <a href=\"core/result/enum.Result.html#tymethod.unwrap_or_default\" class=\"fn\">unwrap_or_default</a>(self) -&gt; T<span class=\"where fmt-newline\">where\n    T: <a class=\"trait\" href=\"core/default/trait.Default.html\" title=\"trait core::default::Default\">Default</a>,</span></h4></section></summary><div class=\"docblock\"><p>Returns the contained <a href=\"core/result/enum.Result.html#variant.Ok\" title=\"variant core::result::Result::Ok\"><code>Ok</code></a> value or a default</p>\n<p>Consumes the <code>self</code> argument then, if <a href=\"core/result/enum.Result.html#variant.Ok\" title=\"variant core::result::Result::Ok\"><code>Ok</code></a>, returns the contained\nvalue, otherwise if <a href=\"core/result/enum.Result.html#variant.Err\" title=\"variant core::result::Result::Err\"><code>Err</code></a>, returns the default value for that\ntype.</p>\n<h5 id=\"examples-20\"><a href=\"#examples-20\">Examples</a></h5>\n<p>Converts a string to an integer, turning poorly-formed strings\ninto 0 (the default value for integers). <a href=\"core/primitive.str.html#method.parse\" title=\"method str::parse\"><code>parse</code></a> converts\na string to any other type that implements <a href=\"core/str/trait.FromStr.html\" title=\"trait core::str::FromStr\"><code>FromStr</code></a>, returning an\n<a href=\"core/result/enum.Result.html#variant.Err\" title=\"variant core::result::Result::Err\"><code>Err</code></a> on error.</p>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>good_year_from_input = <span class=\"string\">&quot;1909&quot;</span>;\n<span class=\"kw\">let </span>bad_year_from_input = <span class=\"string\">&quot;190blarg&quot;</span>;\n<span class=\"kw\">let </span>good_year = good_year_from_input.parse().unwrap_or_default();\n<span class=\"kw\">let </span>bad_year = bad_year_from_input.parse().unwrap_or_default();\n\n<span class=\"macro\">assert_eq!</span>(<span class=\"number\">1909</span>, good_year);\n<span class=\"macro\">assert_eq!</span>(<span class=\"number\">0</span>, bad_year);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+good_year_from_input+=+%221909%22;%0Alet+bad_year_from_input+=+%22190blarg%22;%0Alet+good_year+=+good_year_from_input.parse().unwrap_or_default();%0Alet+bad_year+=+bad_year_from_input.parse().unwrap_or_default();%0A%0Aassert_eq!(1909,+good_year);%0Aassert_eq!(0,+bad_year);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.expect_err\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.17.0\">1.17.0</span> · <a class=\"src\" href=\"src/core/result.rs.html#1135-1143\">source</a></span><h4 class=\"code-header\">pub fn <a href=\"core/result/enum.Result.html#tymethod.expect_err\" class=\"fn\">expect_err</a>(self, msg: &amp;<a class=\"primitive\" href=\"primitive.str.html\">str</a>) -&gt; E<span class=\"where fmt-newline\">where\n    T: <a class=\"trait\" href=\"core/fmt/trait.Debug.html\" title=\"trait core::fmt::Debug\">Debug</a>,</span></h4></section></summary><div class=\"docblock\"><p>Returns the contained <a href=\"core/result/enum.Result.html#variant.Err\" title=\"variant core::result::Result::Err\"><code>Err</code></a> value, consuming the <code>self</code> value.</p>\n<h5 id=\"panics-2\"><a href=\"#panics-2\">Panics</a></h5>\n<p>Panics if the value is an <a href=\"core/result/enum.Result.html#variant.Ok\" title=\"variant core::result::Result::Ok\"><code>Ok</code></a>, with a panic message including the\npassed message, and the content of the <a href=\"core/result/enum.Result.html#variant.Ok\" title=\"variant core::result::Result::Ok\"><code>Ok</code></a>.</p>\n<h5 id=\"examples-21\"><a href=\"#examples-21\">Examples</a></h5>\n<div class=\"example-wrap should_panic\"><a href=\"#\" class=\"tooltip\" title=\"This example panics\">ⓘ</a><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"number\">10</span>);\nx.expect_err(<span class=\"string\">&quot;Testing expect_err&quot;</span>); <span class=\"comment\">// panics with `Testing expect_err: 10`</span></code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+x:+Result%3Cu32,+%26str%3E+=+Ok(10);%0Ax.expect_err(%22Testing+expect_err%22);+//+panics+with+%60Testing+expect_err:+10%60%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.unwrap_err\" class=\"method\"><a class=\"src rightside\" href=\"src/core/result.rs.html#1166-1174\">source</a><h4 class=\"code-header\">pub fn <a href=\"core/result/enum.Result.html#tymethod.unwrap_err\" class=\"fn\">unwrap_err</a>(self) -&gt; E<span class=\"where fmt-newline\">where\n    T: <a class=\"trait\" href=\"core/fmt/trait.Debug.html\" title=\"trait core::fmt::Debug\">Debug</a>,</span></h4></section></summary><div class=\"docblock\"><p>Returns the contained <a href=\"core/result/enum.Result.html#variant.Err\" title=\"variant core::result::Result::Err\"><code>Err</code></a> value, consuming the <code>self</code> value.</p>\n<h5 id=\"panics-3\"><a href=\"#panics-3\">Panics</a></h5>\n<p>Panics if the value is an <a href=\"core/result/enum.Result.html#variant.Ok\" title=\"variant core::result::Result::Ok\"><code>Ok</code></a>, with a custom panic message provided\nby the <a href=\"core/result/enum.Result.html#variant.Ok\" title=\"variant core::result::Result::Ok\"><code>Ok</code></a>’s value.</p>\n<h5 id=\"examples-22\"><a href=\"#examples-22\">Examples</a></h5>\n<div class=\"example-wrap should_panic\"><a href=\"#\" class=\"tooltip\" title=\"This example panics\">ⓘ</a><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"number\">2</span>);\nx.unwrap_err(); <span class=\"comment\">// panics with `2`</span></code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+x:+Result%3Cu32,+%26str%3E+=+Ok(2);%0Ax.unwrap_err();+//+panics+with+%602%60%0A%7D&amp;edition=2021\">Run</a></div>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"string\">&quot;emergency failure&quot;</span>);\n<span class=\"macro\">assert_eq!</span>(x.unwrap_err(), <span class=\"string\">&quot;emergency failure&quot;</span>);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+x:+Result%3Cu32,+%26str%3E+=+Err(%22emergency+failure%22);%0Aassert_eq!(x.unwrap_err(),+%22emergency+failure%22);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.into_ok\" class=\"method\"><a class=\"src rightside\" href=\"src/core/result.rs.html#1201-1209\">source</a><h4 class=\"code-header\">pub fn <a href=\"core/result/enum.Result.html#tymethod.into_ok\" class=\"fn\">into_ok</a>(self) -&gt; T<span class=\"where fmt-newline\">where\n    E: <a class=\"trait\" href=\"core/convert/trait.Into.html\" title=\"trait core::convert::Into\">Into</a>&lt;<a class=\"primitive\" href=\"primitive.never.html\">!</a>&gt;,</span></h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>unwrap_infallible</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/61695\">#61695</a>)</span></div></span></summary><div class=\"docblock\"><p>Returns the contained <a href=\"core/result/enum.Result.html#variant.Ok\" title=\"variant core::result::Result::Ok\"><code>Ok</code></a> value, but never panics.</p>\n<p>Unlike <a href=\"core/result/enum.Result.html#method.unwrap\" title=\"method core::result::Result::unwrap\"><code>unwrap</code></a>, this method is known to never panic on the\nresult types it is implemented for. Therefore, it can be used\ninstead of <code>unwrap</code> as a maintainability safeguard that will fail\nto compile if the error type of the <code>Result</code> is later changed\nto an error that can actually occur.</p>\n<h5 id=\"examples-23\"><a href=\"#examples-23\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code>\n<span class=\"kw\">fn </span>only_good_news() -&gt; <span class=\"prelude-ty\">Result</span>&lt;String, !&gt; {\n    <span class=\"prelude-val\">Ok</span>(<span class=\"string\">&quot;this is fine&quot;</span>.into())\n}\n\n<span class=\"kw\">let </span>s: String = only_good_news().into_ok();\n<span class=\"macro\">println!</span>(<span class=\"string\">&quot;{s}&quot;</span>);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A%23!%5Bfeature(never_type)%5D%0A%23!%5Bfeature(unwrap_infallible)%5D%0A%0Afn+main()+%7B%0Afn+only_good_news()+-%3E+Result%3CString,+!%3E+%7B%0A++++Ok(%22this+is+fine%22.into())%0A%7D%0A%0Alet+s:+String+=+only_good_news().into_ok();%0Aprintln!(%22%7Bs%7D%22);%0A%7D&amp;version=nightly&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.into_err\" class=\"method\"><a class=\"src rightside\" href=\"src/core/result.rs.html#1236-1244\">source</a><h4 class=\"code-header\">pub fn <a href=\"core/result/enum.Result.html#tymethod.into_err\" class=\"fn\">into_err</a>(self) -&gt; E<span class=\"where fmt-newline\">where\n    T: <a class=\"trait\" href=\"core/convert/trait.Into.html\" title=\"trait core::convert::Into\">Into</a>&lt;<a class=\"primitive\" href=\"primitive.never.html\">!</a>&gt;,</span></h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>unwrap_infallible</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/61695\">#61695</a>)</span></div></span></summary><div class=\"docblock\"><p>Returns the contained <a href=\"core/result/enum.Result.html#variant.Err\" title=\"variant core::result::Result::Err\"><code>Err</code></a> value, but never panics.</p>\n<p>Unlike <a href=\"core/result/enum.Result.html#method.unwrap_err\" title=\"method core::result::Result::unwrap_err\"><code>unwrap_err</code></a>, this method is known to never panic on the\nresult types it is implemented for. Therefore, it can be used\ninstead of <code>unwrap_err</code> as a maintainability safeguard that will fail\nto compile if the ok type of the <code>Result</code> is later changed\nto a type that can actually occur.</p>\n<h5 id=\"examples-24\"><a href=\"#examples-24\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code>\n<span class=\"kw\">fn </span>only_bad_news() -&gt; <span class=\"prelude-ty\">Result</span>&lt;!, String&gt; {\n    <span class=\"prelude-val\">Err</span>(<span class=\"string\">&quot;Oops, it failed&quot;</span>.into())\n}\n\n<span class=\"kw\">let </span>error: String = only_bad_news().into_err();\n<span class=\"macro\">println!</span>(<span class=\"string\">&quot;{error}&quot;</span>);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A%23!%5Bfeature(never_type)%5D%0A%23!%5Bfeature(unwrap_infallible)%5D%0A%0Afn+main()+%7B%0Afn+only_bad_news()+-%3E+Result%3C!,+String%3E+%7B%0A++++Err(%22Oops,+it+failed%22.into())%0A%7D%0A%0Alet+error:+String+=+only_bad_news().into_err();%0Aprintln!(%22%7Berror%7D%22);%0A%7D&amp;version=nightly&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.and\" class=\"method\"><a class=\"src rightside\" href=\"src/core/result.rs.html#1279-1284\">source</a><h4 class=\"code-header\">pub fn <a href=\"core/result/enum.Result.html#tymethod.and\" class=\"fn\">and</a>&lt;U&gt;(self, res: <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;U, E&gt;) -&gt; <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;U, E&gt;</h4></section></summary><div class=\"docblock\"><p>Returns <code>res</code> if the result is <a href=\"core/result/enum.Result.html#variant.Ok\" title=\"variant core::result::Result::Ok\"><code>Ok</code></a>, otherwise returns the <a href=\"core/result/enum.Result.html#variant.Err\" title=\"variant core::result::Result::Err\"><code>Err</code></a> value of <code>self</code>.</p>\n<p>Arguments passed to <code>and</code> are eagerly evaluated; if you are passing the\nresult of a function call, it is recommended to use <a href=\"core/result/enum.Result.html#method.and_then\" title=\"method core::result::Result::and_then\"><code>and_then</code></a>, which is\nlazily evaluated.</p>\n<h5 id=\"examples-25\"><a href=\"#examples-25\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"number\">2</span>);\n<span class=\"kw\">let </span>y: <span class=\"prelude-ty\">Result</span>&lt;<span class=\"kw-2\">&amp;</span>str, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"string\">&quot;late error&quot;</span>);\n<span class=\"macro\">assert_eq!</span>(x.and(y), <span class=\"prelude-val\">Err</span>(<span class=\"string\">&quot;late error&quot;</span>));\n\n<span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"string\">&quot;early error&quot;</span>);\n<span class=\"kw\">let </span>y: <span class=\"prelude-ty\">Result</span>&lt;<span class=\"kw-2\">&amp;</span>str, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"string\">&quot;foo&quot;</span>);\n<span class=\"macro\">assert_eq!</span>(x.and(y), <span class=\"prelude-val\">Err</span>(<span class=\"string\">&quot;early error&quot;</span>));\n\n<span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"string\">&quot;not a 2&quot;</span>);\n<span class=\"kw\">let </span>y: <span class=\"prelude-ty\">Result</span>&lt;<span class=\"kw-2\">&amp;</span>str, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"string\">&quot;late error&quot;</span>);\n<span class=\"macro\">assert_eq!</span>(x.and(y), <span class=\"prelude-val\">Err</span>(<span class=\"string\">&quot;not a 2&quot;</span>));\n\n<span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"number\">2</span>);\n<span class=\"kw\">let </span>y: <span class=\"prelude-ty\">Result</span>&lt;<span class=\"kw-2\">&amp;</span>str, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"string\">&quot;different result type&quot;</span>);\n<span class=\"macro\">assert_eq!</span>(x.and(y), <span class=\"prelude-val\">Ok</span>(<span class=\"string\">&quot;different result type&quot;</span>));</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+x:+Result%3Cu32,+%26str%3E+=+Ok(2);%0Alet+y:+Result%3C%26str,+%26str%3E+=+Err(%22late+error%22);%0Aassert_eq!(x.and(y),+Err(%22late+error%22));%0A%0Alet+x:+Result%3Cu32,+%26str%3E+=+Err(%22early+error%22);%0Alet+y:+Result%3C%26str,+%26str%3E+=+Ok(%22foo%22);%0Aassert_eq!(x.and(y),+Err(%22early+error%22));%0A%0Alet+x:+Result%3Cu32,+%26str%3E+=+Err(%22not+a+2%22);%0Alet+y:+Result%3C%26str,+%26str%3E+=+Err(%22late+error%22);%0Aassert_eq!(x.and(y),+Err(%22not+a+2%22));%0A%0Alet+x:+Result%3Cu32,+%26str%3E+=+Ok(2);%0Alet+y:+Result%3C%26str,+%26str%3E+=+Ok(%22different+result+type%22);%0Aassert_eq!(x.and(y),+Ok(%22different+result+type%22));%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.and_then\" class=\"method\"><a class=\"src rightside\" href=\"src/core/result.rs.html#1318-1323\">source</a><h4 class=\"code-header\">pub fn <a href=\"core/result/enum.Result.html#tymethod.and_then\" class=\"fn\">and_then</a>&lt;U, F: <a class=\"trait\" href=\"core/ops/trait.FnOnce.html\" title=\"trait core::ops::FnOnce\">FnOnce</a>(T) -&gt; <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;U, E&gt;&gt;(self, op: F) -&gt; <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;U, E&gt;</h4></section></summary><div class=\"docblock\"><p>Calls <code>op</code> if the result is <a href=\"core/result/enum.Result.html#variant.Ok\" title=\"variant core::result::Result::Ok\"><code>Ok</code></a>, otherwise returns the <a href=\"core/result/enum.Result.html#variant.Err\" title=\"variant core::result::Result::Err\"><code>Err</code></a> value of <code>self</code>.</p>\n<p>This function can be used for control flow based on <code>Result</code> values.</p>\n<h5 id=\"examples-26\"><a href=\"#examples-26\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">fn </span>sq_then_to_string(x: u32) -&gt; <span class=\"prelude-ty\">Result</span>&lt;String, <span class=\"kw-2\">&amp;</span><span class=\"lifetime\">&#39;static </span>str&gt; {\n    x.checked_mul(x).map(|sq| sq.to_string()).ok_or(<span class=\"string\">&quot;overflowed&quot;</span>)\n}\n\n<span class=\"macro\">assert_eq!</span>(<span class=\"prelude-val\">Ok</span>(<span class=\"number\">2</span>).and_then(sq_then_to_string), <span class=\"prelude-val\">Ok</span>(<span class=\"number\">4</span>.to_string()));\n<span class=\"macro\">assert_eq!</span>(<span class=\"prelude-val\">Ok</span>(<span class=\"number\">1_000_000</span>).and_then(sq_then_to_string), <span class=\"prelude-val\">Err</span>(<span class=\"string\">&quot;overflowed&quot;</span>));\n<span class=\"macro\">assert_eq!</span>(<span class=\"prelude-val\">Err</span>(<span class=\"string\">&quot;not a number&quot;</span>).and_then(sq_then_to_string), <span class=\"prelude-val\">Err</span>(<span class=\"string\">&quot;not a number&quot;</span>));</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Afn+sq_then_to_string(x:+u32)+-%3E+Result%3CString,+%26'static+str%3E+%7B%0A++++x.checked_mul(x).map(%7Csq%7C+sq.to_string()).ok_or(%22overflowed%22)%0A%7D%0A%0Aassert_eq!(Ok(2).and_then(sq_then_to_string),+Ok(4.to_string()));%0Aassert_eq!(Ok(1_000_000).and_then(sq_then_to_string),+Err(%22overflowed%22));%0Aassert_eq!(Err(%22not+a+number%22).and_then(sq_then_to_string),+Err(%22not+a+number%22));%0A%7D&amp;edition=2021\">Run</a></div>\n<p>Often used to chain fallible operations that may return <a href=\"core/result/enum.Result.html#variant.Err\" title=\"variant core::result::Result::Err\"><code>Err</code></a>.</p>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">use </span>std::{io::ErrorKind, path::Path};\n\n<span class=\"comment\">// Note: on Windows &quot;/&quot; maps to &quot;C:\\&quot;\n</span><span class=\"kw\">let </span>root_modified_time = Path::new(<span class=\"string\">&quot;/&quot;</span>).metadata().and_then(|md| md.modified());\n<span class=\"macro\">assert!</span>(root_modified_time.is_ok());\n\n<span class=\"kw\">let </span>should_fail = Path::new(<span class=\"string\">&quot;/bad/path&quot;</span>).metadata().and_then(|md| md.modified());\n<span class=\"macro\">assert!</span>(should_fail.is_err());\n<span class=\"macro\">assert_eq!</span>(should_fail.unwrap_err().kind(), ErrorKind::NotFound);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Ause+std::%7Bio::ErrorKind,+path::Path%7D;%0A%0A//+Note:+on+Windows+%22/%22+maps+to+%22C:%5C%22%0Alet+root_modified_time+=+Path::new(%22/%22).metadata().and_then(%7Cmd%7C+md.modified());%0Aassert!(root_modified_time.is_ok());%0A%0Alet+should_fail+=+Path::new(%22/bad/path%22).metadata().and_then(%7Cmd%7C+md.modified());%0Aassert!(should_fail.is_err());%0Aassert_eq!(should_fail.unwrap_err().kind(),+ErrorKind::NotFound);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.or\" class=\"method\"><a class=\"src rightside\" href=\"src/core/result.rs.html#1354-1359\">source</a><h4 class=\"code-header\">pub fn <a href=\"core/result/enum.Result.html#tymethod.or\" class=\"fn\">or</a>&lt;F&gt;(self, res: <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;T, F&gt;) -&gt; <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;T, F&gt;</h4></section></summary><div class=\"docblock\"><p>Returns <code>res</code> if the result is <a href=\"core/result/enum.Result.html#variant.Err\" title=\"variant core::result::Result::Err\"><code>Err</code></a>, otherwise returns the <a href=\"core/result/enum.Result.html#variant.Ok\" title=\"variant core::result::Result::Ok\"><code>Ok</code></a> value of <code>self</code>.</p>\n<p>Arguments passed to <code>or</code> are eagerly evaluated; if you are passing the\nresult of a function call, it is recommended to use <a href=\"core/result/enum.Result.html#method.or_else\" title=\"method core::result::Result::or_else\"><code>or_else</code></a>, which is\nlazily evaluated.</p>\n<h5 id=\"examples-27\"><a href=\"#examples-27\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"number\">2</span>);\n<span class=\"kw\">let </span>y: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"string\">&quot;late error&quot;</span>);\n<span class=\"macro\">assert_eq!</span>(x.or(y), <span class=\"prelude-val\">Ok</span>(<span class=\"number\">2</span>));\n\n<span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"string\">&quot;early error&quot;</span>);\n<span class=\"kw\">let </span>y: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"number\">2</span>);\n<span class=\"macro\">assert_eq!</span>(x.or(y), <span class=\"prelude-val\">Ok</span>(<span class=\"number\">2</span>));\n\n<span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"string\">&quot;not a 2&quot;</span>);\n<span class=\"kw\">let </span>y: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"string\">&quot;late error&quot;</span>);\n<span class=\"macro\">assert_eq!</span>(x.or(y), <span class=\"prelude-val\">Err</span>(<span class=\"string\">&quot;late error&quot;</span>));\n\n<span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"number\">2</span>);\n<span class=\"kw\">let </span>y: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"number\">100</span>);\n<span class=\"macro\">assert_eq!</span>(x.or(y), <span class=\"prelude-val\">Ok</span>(<span class=\"number\">2</span>));</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+x:+Result%3Cu32,+%26str%3E+=+Ok(2);%0Alet+y:+Result%3Cu32,+%26str%3E+=+Err(%22late+error%22);%0Aassert_eq!(x.or(y),+Ok(2));%0A%0Alet+x:+Result%3Cu32,+%26str%3E+=+Err(%22early+error%22);%0Alet+y:+Result%3Cu32,+%26str%3E+=+Ok(2);%0Aassert_eq!(x.or(y),+Ok(2));%0A%0Alet+x:+Result%3Cu32,+%26str%3E+=+Err(%22not+a+2%22);%0Alet+y:+Result%3Cu32,+%26str%3E+=+Err(%22late+error%22);%0Aassert_eq!(x.or(y),+Err(%22late+error%22));%0A%0Alet+x:+Result%3Cu32,+%26str%3E+=+Ok(2);%0Alet+y:+Result%3Cu32,+%26str%3E+=+Ok(100);%0Aassert_eq!(x.or(y),+Ok(2));%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.or_else\" class=\"method\"><a class=\"src rightside\" href=\"src/core/result.rs.html#1379-1384\">source</a><h4 class=\"code-header\">pub fn <a href=\"core/result/enum.Result.html#tymethod.or_else\" class=\"fn\">or_else</a>&lt;F, O: <a class=\"trait\" href=\"core/ops/trait.FnOnce.html\" title=\"trait core::ops::FnOnce\">FnOnce</a>(E) -&gt; <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;T, F&gt;&gt;(self, op: O) -&gt; <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;T, F&gt;</h4></section></summary><div class=\"docblock\"><p>Calls <code>op</code> if the result is <a href=\"core/result/enum.Result.html#variant.Err\" title=\"variant core::result::Result::Err\"><code>Err</code></a>, otherwise returns the <a href=\"core/result/enum.Result.html#variant.Ok\" title=\"variant core::result::Result::Ok\"><code>Ok</code></a> value of <code>self</code>.</p>\n<p>This function can be used for control flow based on result values.</p>\n<h5 id=\"examples-28\"><a href=\"#examples-28\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">fn </span>sq(x: u32) -&gt; <span class=\"prelude-ty\">Result</span>&lt;u32, u32&gt; { <span class=\"prelude-val\">Ok</span>(x * x) }\n<span class=\"kw\">fn </span>err(x: u32) -&gt; <span class=\"prelude-ty\">Result</span>&lt;u32, u32&gt; { <span class=\"prelude-val\">Err</span>(x) }\n\n<span class=\"macro\">assert_eq!</span>(<span class=\"prelude-val\">Ok</span>(<span class=\"number\">2</span>).or_else(sq).or_else(sq), <span class=\"prelude-val\">Ok</span>(<span class=\"number\">2</span>));\n<span class=\"macro\">assert_eq!</span>(<span class=\"prelude-val\">Ok</span>(<span class=\"number\">2</span>).or_else(err).or_else(sq), <span class=\"prelude-val\">Ok</span>(<span class=\"number\">2</span>));\n<span class=\"macro\">assert_eq!</span>(<span class=\"prelude-val\">Err</span>(<span class=\"number\">3</span>).or_else(sq).or_else(err), <span class=\"prelude-val\">Ok</span>(<span class=\"number\">9</span>));\n<span class=\"macro\">assert_eq!</span>(<span class=\"prelude-val\">Err</span>(<span class=\"number\">3</span>).or_else(err).or_else(err), <span class=\"prelude-val\">Err</span>(<span class=\"number\">3</span>));</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Afn+sq(x:+u32)+-%3E+Result%3Cu32,+u32%3E+%7B+Ok(x+*+x)+%7D%0Afn+err(x:+u32)+-%3E+Result%3Cu32,+u32%3E+%7B+Err(x)+%7D%0A%0Aassert_eq!(Ok(2).or_else(sq).or_else(sq),+Ok(2));%0Aassert_eq!(Ok(2).or_else(err).or_else(sq),+Ok(2));%0Aassert_eq!(Err(3).or_else(sq).or_else(err),+Ok(9));%0Aassert_eq!(Err(3).or_else(err).or_else(err),+Err(3));%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.unwrap_or\" class=\"method\"><a class=\"src rightside\" href=\"src/core/result.rs.html#1406-1411\">source</a><h4 class=\"code-header\">pub fn <a href=\"core/result/enum.Result.html#tymethod.unwrap_or\" class=\"fn\">unwrap_or</a>(self, default: T) -&gt; T</h4></section></summary><div class=\"docblock\"><p>Returns the contained <a href=\"core/result/enum.Result.html#variant.Ok\" title=\"variant core::result::Result::Ok\"><code>Ok</code></a> value or a provided default.</p>\n<p>Arguments passed to <code>unwrap_or</code> are eagerly evaluated; if you are passing\nthe result of a function call, it is recommended to use <a href=\"core/result/enum.Result.html#method.unwrap_or_else\" title=\"method core::result::Result::unwrap_or_else\"><code>unwrap_or_else</code></a>,\nwhich is lazily evaluated.</p>\n<h5 id=\"examples-29\"><a href=\"#examples-29\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>default = <span class=\"number\">2</span>;\n<span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"number\">9</span>);\n<span class=\"macro\">assert_eq!</span>(x.unwrap_or(default), <span class=\"number\">9</span>);\n\n<span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"string\">&quot;error&quot;</span>);\n<span class=\"macro\">assert_eq!</span>(x.unwrap_or(default), default);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+default+=+2;%0Alet+x:+Result%3Cu32,+%26str%3E+=+Ok(9);%0Aassert_eq!(x.unwrap_or(default),+9);%0A%0Alet+x:+Result%3Cu32,+%26str%3E+=+Err(%22error%22);%0Aassert_eq!(x.unwrap_or(default),+default);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.unwrap_or_else\" class=\"method\"><a class=\"src rightside\" href=\"src/core/result.rs.html#1427-1432\">source</a><h4 class=\"code-header\">pub fn <a href=\"core/result/enum.Result.html#tymethod.unwrap_or_else\" class=\"fn\">unwrap_or_else</a>&lt;F: <a class=\"trait\" href=\"core/ops/trait.FnOnce.html\" title=\"trait core::ops::FnOnce\">FnOnce</a>(E) -&gt; T&gt;(self, op: F) -&gt; T</h4></section></summary><div class=\"docblock\"><p>Returns the contained <a href=\"core/result/enum.Result.html#variant.Ok\" title=\"variant core::result::Result::Ok\"><code>Ok</code></a> value or computes it from a closure.</p>\n<h5 id=\"examples-30\"><a href=\"#examples-30\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">fn </span>count(x: <span class=\"kw-2\">&amp;</span>str) -&gt; usize { x.len() }\n\n<span class=\"macro\">assert_eq!</span>(<span class=\"prelude-val\">Ok</span>(<span class=\"number\">2</span>).unwrap_or_else(count), <span class=\"number\">2</span>);\n<span class=\"macro\">assert_eq!</span>(<span class=\"prelude-val\">Err</span>(<span class=\"string\">&quot;foo&quot;</span>).unwrap_or_else(count), <span class=\"number\">3</span>);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Afn+count(x:+%26str)+-%3E+usize+%7B+x.len()+%7D%0A%0Aassert_eq!(Ok(2).unwrap_or_else(count),+2);%0Aassert_eq!(Err(%22foo%22).unwrap_or_else(count),+3);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.unwrap_unchecked\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.58.0\">1.58.0</span> · <a class=\"src\" href=\"src/core/result.rs.html#1457-1464\">source</a></span><h4 class=\"code-header\">pub unsafe fn <a href=\"core/result/enum.Result.html#tymethod.unwrap_unchecked\" class=\"fn\">unwrap_unchecked</a>(self) -&gt; T</h4></section></summary><div class=\"docblock\"><p>Returns the contained <a href=\"core/result/enum.Result.html#variant.Ok\" title=\"variant core::result::Result::Ok\"><code>Ok</code></a> value, consuming the <code>self</code> value,\nwithout checking that the value is not an <a href=\"core/result/enum.Result.html#variant.Err\" title=\"variant core::result::Result::Err\"><code>Err</code></a>.</p>\n<h5 id=\"safety\"><a href=\"#safety\">Safety</a></h5>\n<p>Calling this method on an <a href=\"core/result/enum.Result.html#variant.Err\" title=\"variant core::result::Result::Err\"><code>Err</code></a> is <em><a href=\"https://doc.rust-lang.org/reference/behavior-considered-undefined.html\">undefined behavior</a></em>.</p>\n<h5 id=\"examples-31\"><a href=\"#examples-31\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"number\">2</span>);\n<span class=\"macro\">assert_eq!</span>(<span class=\"kw\">unsafe </span>{ x.unwrap_unchecked() }, <span class=\"number\">2</span>);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+x:+Result%3Cu32,+%26str%3E+=+Ok(2);%0Aassert_eq!(unsafe+%7B+x.unwrap_unchecked()+%7D,+2);%0A%7D&amp;edition=2021\">Run</a></div>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"string\">&quot;emergency failure&quot;</span>);\n<span class=\"kw\">unsafe </span>{ x.unwrap_unchecked(); } <span class=\"comment\">// Undefined behavior!</span></code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+x:+Result%3Cu32,+%26str%3E+=+Err(%22emergency+failure%22);%0Aunsafe+%7B+x.unwrap_unchecked();+%7D+//+Undefined+behavior!%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.unwrap_err_unchecked\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.58.0\">1.58.0</span> · <a class=\"src\" href=\"src/core/result.rs.html#1489-1496\">source</a></span><h4 class=\"code-header\">pub unsafe fn <a href=\"core/result/enum.Result.html#tymethod.unwrap_err_unchecked\" class=\"fn\">unwrap_err_unchecked</a>(self) -&gt; E</h4></section></summary><div class=\"docblock\"><p>Returns the contained <a href=\"core/result/enum.Result.html#variant.Err\" title=\"variant core::result::Result::Err\"><code>Err</code></a> value, consuming the <code>self</code> value,\nwithout checking that the value is not an <a href=\"core/result/enum.Result.html#variant.Ok\" title=\"variant core::result::Result::Ok\"><code>Ok</code></a>.</p>\n<h5 id=\"safety-1\"><a href=\"#safety-1\">Safety</a></h5>\n<p>Calling this method on an <a href=\"core/result/enum.Result.html#variant.Ok\" title=\"variant core::result::Result::Ok\"><code>Ok</code></a> is <em><a href=\"https://doc.rust-lang.org/reference/behavior-considered-undefined.html\">undefined behavior</a></em>.</p>\n<h5 id=\"examples-32\"><a href=\"#examples-32\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"number\">2</span>);\n<span class=\"kw\">unsafe </span>{ x.unwrap_err_unchecked() }; <span class=\"comment\">// Undefined behavior!</span></code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+x:+Result%3Cu32,+%26str%3E+=+Ok(2);%0Aunsafe+%7B+x.unwrap_err_unchecked()+%7D;+//+Undefined+behavior!%0A%7D&amp;edition=2021\">Run</a></div>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"string\">&quot;emergency failure&quot;</span>);\n<span class=\"macro\">assert_eq!</span>(<span class=\"kw\">unsafe </span>{ x.unwrap_err_unchecked() }, <span class=\"string\">&quot;emergency failure&quot;</span>);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+x:+Result%3Cu32,+%26str%3E+=+Err(%22emergency+failure%22);%0Aassert_eq!(unsafe+%7B+x.unwrap_err_unchecked()+%7D,+%22emergency+failure%22);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details></div></details>",0,"core::fmt::Result"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-FromResidual%3CResult%3CInfallible,+E%3E%3E-for-Result%3CT,+F%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/result.rs.html#1958-1966\">source</a><a href=\"#impl-FromResidual%3CResult%3CInfallible,+E%3E%3E-for-Result%3CT,+F%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, E, F: <a class=\"trait\" href=\"core/convert/trait.From.html\" title=\"trait core::convert::From\">From</a>&lt;E&gt;&gt; <a class=\"trait\" href=\"core/ops/trait.FromResidual.html\" title=\"trait core::ops::FromResidual\">FromResidual</a>&lt;<a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;<a class=\"enum\" href=\"core/convert/enum.Infallible.html\" title=\"enum core::convert::Infallible\">Infallible</a>, E&gt;&gt; for <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;T, F&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_residual\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/result.rs.html#1961-1965\">source</a><a href=\"#method.from_residual\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/ops/trait.FromResidual.html#tymethod.from_residual\" class=\"fn\">from_residual</a>(residual: <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;<a class=\"enum\" href=\"core/convert/enum.Infallible.html\" title=\"enum core::convert::Infallible\">Infallible</a>, E&gt;) -&gt; Self</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>try_trait_v2</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/84277\">#84277</a>)</span></div></span><div class='docblock'>Constructs the type from a compatible <code>Residual</code> type. <a href=\"core/ops/trait.FromResidual.html#tymethod.from_residual\">Read more</a></div></details></div></details>","FromResidual<Result<Infallible, E>>","core::fmt::Result"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-PartialOrd-for-Result%3CT,+E%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/result.rs.html#498\">source</a><a href=\"#impl-PartialOrd-for-Result%3CT,+E%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T: <a class=\"trait\" href=\"core/cmp/trait.PartialOrd.html\" title=\"trait core::cmp::PartialOrd\">PartialOrd</a>, E: <a class=\"trait\" href=\"core/cmp/trait.PartialOrd.html\" title=\"trait core::cmp::PartialOrd\">PartialOrd</a>&gt; <a class=\"trait\" href=\"core/cmp/trait.PartialOrd.html\" title=\"trait core::cmp::PartialOrd\">PartialOrd</a> for <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;T, E&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.partial_cmp\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/result.rs.html#498\">source</a><a href=\"#method.partial_cmp\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/cmp/trait.PartialOrd.html#tymethod.partial_cmp\" class=\"fn\">partial_cmp</a>(&amp;self, other: &amp;<a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;T, E&gt;) -&gt; <a class=\"enum\" href=\"core/option/enum.Option.html\" title=\"enum core::option::Option\">Option</a>&lt;<a class=\"enum\" href=\"core/cmp/enum.Ordering.html\" title=\"enum core::cmp::Ordering\">Ordering</a>&gt;</h4></section></summary><div class='docblock'>This method returns an ordering between <code>self</code> and <code>other</code> values if one exists. <a href=\"core/cmp/trait.PartialOrd.html#tymethod.partial_cmp\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.lt\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/cmp.rs.html#1122-1124\">source</a><a href=\"#method.lt\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/cmp/trait.PartialOrd.html#method.lt\" class=\"fn\">lt</a>(&amp;self, other: <a class=\"primitive\" href=\"primitive.reference.html\">&amp;Rhs</a>) -&gt; <a class=\"primitive\" href=\"primitive.bool.html\">bool</a></h4></section></summary><div class='docblock'>This method tests less than (for <code>self</code> and <code>other</code>) and is used by the <code>&lt;</code> operator. <a href=\"core/cmp/trait.PartialOrd.html#method.lt\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.le\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/cmp.rs.html#1139-1141\">source</a><a href=\"#method.le\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/cmp/trait.PartialOrd.html#method.le\" class=\"fn\">le</a>(&amp;self, other: <a class=\"primitive\" href=\"primitive.reference.html\">&amp;Rhs</a>) -&gt; <a class=\"primitive\" href=\"primitive.bool.html\">bool</a></h4></section></summary><div class='docblock'>This method tests less than or equal to (for <code>self</code> and <code>other</code>) and is used by the <code>&lt;=</code>\noperator. <a href=\"core/cmp/trait.PartialOrd.html#method.le\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.gt\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/cmp.rs.html#1155-1157\">source</a><a href=\"#method.gt\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/cmp/trait.PartialOrd.html#method.gt\" class=\"fn\">gt</a>(&amp;self, other: <a class=\"primitive\" href=\"primitive.reference.html\">&amp;Rhs</a>) -&gt; <a class=\"primitive\" href=\"primitive.bool.html\">bool</a></h4></section></summary><div class='docblock'>This method tests greater than (for <code>self</code> and <code>other</code>) and is used by the <code>&gt;</code> operator. <a href=\"core/cmp/trait.PartialOrd.html#method.gt\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.ge\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/cmp.rs.html#1172-1174\">source</a><a href=\"#method.ge\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/cmp/trait.PartialOrd.html#method.ge\" class=\"fn\">ge</a>(&amp;self, other: <a class=\"primitive\" href=\"primitive.reference.html\">&amp;Rhs</a>) -&gt; <a class=\"primitive\" href=\"primitive.bool.html\">bool</a></h4></section></summary><div class='docblock'>This method tests greater than or equal to (for <code>self</code> and <code>other</code>) and is used by the <code>&gt;=</code>\noperator. <a href=\"core/cmp/trait.PartialOrd.html#method.ge\">Read more</a></div></details></div></details>","PartialOrd","core::fmt::Result"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-IntoIterator-for-Result%3CT,+E%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/result.rs.html#1697-1720\">source</a><a href=\"#impl-IntoIterator-for-Result%3CT,+E%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, E&gt; <a class=\"trait\" href=\"core/iter/trait.IntoIterator.html\" title=\"trait core::iter::IntoIterator\">IntoIterator</a> for <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;T, E&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.into_iter\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/result.rs.html#1717-1719\">source</a><a href=\"#method.into_iter\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/iter/trait.IntoIterator.html#tymethod.into_iter\" class=\"fn\">into_iter</a>(self) -&gt; <a class=\"struct\" href=\"core/result/struct.IntoIter.html\" title=\"struct core::result::IntoIter\">IntoIter</a>&lt;T&gt; <a href=\"#\" class=\"tooltip\" data-notable-ty=\"IntoIter&lt;T&gt;\">ⓘ</a></h4></section></summary><div class=\"docblock\"><p>Returns a consuming iterator over the possibly contained value.</p>\n<p>The iterator yields one value if the result is <a href=\"core/result/enum.Result.html#variant.Ok\" title=\"variant core::result::Result::Ok\"><code>Result::Ok</code></a>, otherwise none.</p>\n<h5 id=\"examples\"><a href=\"#examples\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Ok</span>(<span class=\"number\">5</span>);\n<span class=\"kw\">let </span>v: Vec&lt;u32&gt; = x.into_iter().collect();\n<span class=\"macro\">assert_eq!</span>(v, [<span class=\"number\">5</span>]);\n\n<span class=\"kw\">let </span>x: <span class=\"prelude-ty\">Result</span>&lt;u32, <span class=\"kw-2\">&amp;</span>str&gt; = <span class=\"prelude-val\">Err</span>(<span class=\"string\">&quot;nothing!&quot;</span>);\n<span class=\"kw\">let </span>v: Vec&lt;u32&gt; = x.into_iter().collect();\n<span class=\"macro\">assert_eq!</span>(v, []);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+x:+Result%3Cu32,+%26str%3E+=+Ok(5);%0Alet+v:+Vec%3Cu32%3E+=+x.into_iter().collect();%0Aassert_eq!(v,+%5B5%5D);%0A%0Alet+x:+Result%3Cu32,+%26str%3E+=+Err(%22nothing!%22);%0Alet+v:+Vec%3Cu32%3E+=+x.into_iter().collect();%0Aassert_eq!(v,+%5B%5D);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle\" open><summary><section id=\"associatedtype.Item\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Item\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"core/iter/trait.IntoIterator.html#associatedtype.Item\" class=\"associatedtype\">Item</a> = T</h4></section></summary><div class='docblock'>The type of the elements being iterated over.</div></details><details class=\"toggle\" open><summary><section id=\"associatedtype.IntoIter\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.IntoIter\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"core/iter/trait.IntoIterator.html#associatedtype.IntoIter\" class=\"associatedtype\">IntoIter</a> = <a class=\"struct\" href=\"core/result/struct.IntoIter.html\" title=\"struct core::result::IntoIter\">IntoIter</a>&lt;T&gt;</h4></section></summary><div class='docblock'>Which kind of iterator are we turning this into?</div></details></div></details>","IntoIterator","core::fmt::Result"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Debug-for-Result%3CT,+E%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/result.rs.html#498\">source</a><a href=\"#impl-Debug-for-Result%3CT,+E%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T: <a class=\"trait\" href=\"core/fmt/trait.Debug.html\" title=\"trait core::fmt::Debug\">Debug</a>, E: <a class=\"trait\" href=\"core/fmt/trait.Debug.html\" title=\"trait core::fmt::Debug\">Debug</a>&gt; <a class=\"trait\" href=\"core/fmt/trait.Debug.html\" title=\"trait core::fmt::Debug\">Debug</a> for <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;T, E&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.fmt\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/result.rs.html#498\">source</a><a href=\"#method.fmt\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/fmt/trait.Debug.html#tymethod.fmt\" class=\"fn\">fmt</a>(&amp;self, f: &amp;mut <a class=\"struct\" href=\"core/fmt/struct.Formatter.html\" title=\"struct core::fmt::Formatter\">Formatter</a>&lt;'_&gt;) -&gt; <a class=\"type\" href=\"core/fmt/type.Result.html\" title=\"type core::fmt::Result\">Result</a></h4></section></summary><div class='docblock'>Formats the value using the given formatter. <a href=\"core/fmt/trait.Debug.html#tymethod.fmt\">Read more</a></div></details></div></details>","Debug","core::fmt::Result"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Hash-for-Result%3CT,+E%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/result.rs.html#498\">source</a><a href=\"#impl-Hash-for-Result%3CT,+E%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T: <a class=\"trait\" href=\"core/hash/trait.Hash.html\" title=\"trait core::hash::Hash\">Hash</a>, E: <a class=\"trait\" href=\"core/hash/trait.Hash.html\" title=\"trait core::hash::Hash\">Hash</a>&gt; <a class=\"trait\" href=\"core/hash/trait.Hash.html\" title=\"trait core::hash::Hash\">Hash</a> for <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;T, E&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.hash\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/result.rs.html#498\">source</a><a href=\"#method.hash\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/hash/trait.Hash.html#tymethod.hash\" class=\"fn\">hash</a>&lt;__H: <a class=\"trait\" href=\"core/hash/trait.Hasher.html\" title=\"trait core::hash::Hasher\">Hasher</a>&gt;(&amp;self, state: <a class=\"primitive\" href=\"primitive.reference.html\">&amp;mut __H</a>)</h4></section></summary><div class='docblock'>Feeds this value into the given <a href=\"core/hash/trait.Hasher.html\" title=\"trait core::hash::Hasher\"><code>Hasher</code></a>. <a href=\"core/hash/trait.Hash.html#tymethod.hash\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.hash_slice\" class=\"method trait-impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.3.0\">1.3.0</span> · <a class=\"src\" href=\"src/core/hash/mod.rs.html#242-249\">source</a></span><a href=\"#method.hash_slice\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/hash/trait.Hash.html#method.hash_slice\" class=\"fn\">hash_slice</a>&lt;H: <a class=\"trait\" href=\"core/hash/trait.Hasher.html\" title=\"trait core::hash::Hasher\">Hasher</a>&gt;(data: &amp;<a class=\"primitive\" href=\"primitive.slice.html\">[Self]</a>, state: <a class=\"primitive\" href=\"primitive.reference.html\">&amp;mut H</a>)<span class=\"where fmt-newline\">where\n    Self: <a class=\"trait\" href=\"core/marker/trait.Sized.html\" title=\"trait core::marker::Sized\">Sized</a>,</span></h4></section></summary><div class='docblock'>Feeds a slice of this type into the given <a href=\"core/hash/trait.Hasher.html\" title=\"trait core::hash::Hasher\"><code>Hasher</code></a>. <a href=\"core/hash/trait.Hash.html#method.hash_slice\">Read more</a></div></details></div></details>","Hash","core::fmt::Result"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Try-for-Result%3CT,+E%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/result.rs.html#1939-1955\">source</a><a href=\"#impl-Try-for-Result%3CT,+E%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, E&gt; <a class=\"trait\" href=\"core/ops/trait.Try.html\" title=\"trait core::ops::Try\">Try</a> for <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;T, E&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"core/ops/trait.Try.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = T</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>try_trait_v2</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/84277\">#84277</a>)</span></div></span><div class='docblock'>The type of the value produced by <code>?</code> when <em>not</em> short-circuiting.</div></details><details class=\"toggle\" open><summary><section id=\"associatedtype.Residual\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Residual\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"core/ops/trait.Try.html#associatedtype.Residual\" class=\"associatedtype\">Residual</a> = <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;<a class=\"enum\" href=\"core/convert/enum.Infallible.html\" title=\"enum core::convert::Infallible\">Infallible</a>, E&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>try_trait_v2</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/84277\">#84277</a>)</span></div></span><div class='docblock'>The type of the value passed to <a href=\"core/ops/trait.FromResidual.html#tymethod.from_residual\" title=\"associated function core::ops::FromResidual::from_residual\"><code>FromResidual::from_residual</code></a>\nas part of <code>?</code> when short-circuiting. <a href=\"core/ops/trait.Try.html#associatedtype.Residual\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_output\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/result.rs.html#1944-1946\">source</a><a href=\"#method.from_output\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/ops/trait.Try.html#tymethod.from_output\" class=\"fn\">from_output</a>(output: Self::<a class=\"associatedtype\" href=\"core/ops/trait.Try.html#associatedtype.Output\" title=\"type core::ops::Try::Output\">Output</a>) -&gt; Self</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>try_trait_v2</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/84277\">#84277</a>)</span></div></span><div class='docblock'>Constructs the type from its <code>Output</code> type. <a href=\"core/ops/trait.Try.html#tymethod.from_output\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.branch\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/result.rs.html#1949-1954\">source</a><a href=\"#method.branch\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/ops/trait.Try.html#tymethod.branch\" class=\"fn\">branch</a>(self) -&gt; <a class=\"enum\" href=\"core/ops/enum.ControlFlow.html\" title=\"enum core::ops::ControlFlow\">ControlFlow</a>&lt;Self::<a class=\"associatedtype\" href=\"core/ops/trait.Try.html#associatedtype.Residual\" title=\"type core::ops::Try::Residual\">Residual</a>, Self::<a class=\"associatedtype\" href=\"core/ops/trait.Try.html#associatedtype.Output\" title=\"type core::ops::Try::Output\">Output</a>&gt;</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>try_trait_v2</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/84277\">#84277</a>)</span></div></span><div class='docblock'>Used in <code>?</code> to decide whether the operator should produce a value\n(because this returned <a href=\"core/ops/enum.ControlFlow.html#variant.Continue\" title=\"variant core::ops::ControlFlow::Continue\"><code>ControlFlow::Continue</code></a>)\nor propagate a value back to the caller\n(because this returned <a href=\"core/ops/enum.ControlFlow.html#variant.Break\" title=\"variant core::ops::ControlFlow::Break\"><code>ControlFlow::Break</code></a>). <a href=\"core/ops/trait.Try.html#tymethod.branch\">Read more</a></div></details></div></details>","Try","core::fmt::Result"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-FromResidual%3CYeet%3CE%3E%3E-for-Result%3CT,+F%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/result.rs.html#1969-1974\">source</a><a href=\"#impl-FromResidual%3CYeet%3CE%3E%3E-for-Result%3CT,+F%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, E, F: <a class=\"trait\" href=\"core/convert/trait.From.html\" title=\"trait core::convert::From\">From</a>&lt;E&gt;&gt; <a class=\"trait\" href=\"core/ops/trait.FromResidual.html\" title=\"trait core::ops::FromResidual\">FromResidual</a>&lt;<a class=\"struct\" href=\"core/ops/struct.Yeet.html\" title=\"struct core::ops::Yeet\">Yeet</a>&lt;E&gt;&gt; for <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;T, F&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_residual\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/result.rs.html#1971-1973\">source</a><a href=\"#method.from_residual\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/ops/trait.FromResidual.html#tymethod.from_residual\" class=\"fn\">from_residual</a>(ops::Yeet: <a class=\"struct\" href=\"core/ops/struct.Yeet.html\" title=\"struct core::ops::Yeet\">Yeet</a>&lt;E&gt;) -&gt; Self</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>try_trait_v2</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/84277\">#84277</a>)</span></div></span><div class='docblock'>Constructs the type from a compatible <code>Residual</code> type. <a href=\"core/ops/trait.FromResidual.html#tymethod.from_residual\">Read more</a></div></details></div></details>","FromResidual<Yeet<E>>","core::fmt::Result"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Sum%3CResult%3CU,+E%3E%3E-for-Result%3CT,+E%3E\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.16.0\">1.16.0</span> · <a class=\"src\" href=\"src/core/iter/traits/accum.rs.html#153-181\">source</a></span><a href=\"#impl-Sum%3CResult%3CU,+E%3E%3E-for-Result%3CT,+E%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, U, E&gt; <a class=\"trait\" href=\"core/iter/trait.Sum.html\" title=\"trait core::iter::Sum\">Sum</a>&lt;<a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;U, E&gt;&gt; for <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;T, E&gt;<span class=\"where fmt-newline\">where\n    T: <a class=\"trait\" href=\"core/iter/trait.Sum.html\" title=\"trait core::iter::Sum\">Sum</a>&lt;U&gt;,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.sum\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/iter/traits/accum.rs.html#175-180\">source</a><a href=\"#method.sum\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/iter/trait.Sum.html#tymethod.sum\" class=\"fn\">sum</a>&lt;I&gt;(iter: I) -&gt; <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;T, E&gt;<span class=\"where fmt-newline\">where\n    I: <a class=\"trait\" href=\"core/iter/trait.Iterator.html\" title=\"trait core::iter::Iterator\">Iterator</a>&lt;Item = <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;U, E&gt;&gt;,</span></h4></section></summary><div class=\"docblock\"><p>Takes each element in the <a href=\"core/iter/trait.Iterator.html\" title=\"trait core::iter::Iterator\"><code>Iterator</code></a>: if it is an <a href=\"core/result/enum.Result.html#variant.Err\" title=\"variant core::result::Result::Err\"><code>Err</code></a>, no further\nelements are taken, and the <a href=\"core/result/enum.Result.html#variant.Err\" title=\"variant core::result::Result::Err\"><code>Err</code></a> is returned. Should no <a href=\"core/result/enum.Result.html#variant.Err\" title=\"variant core::result::Result::Err\"><code>Err</code></a>\noccur, the sum of all elements is returned.</p>\n<h5 id=\"examples\"><a href=\"#examples\">Examples</a></h5>\n<p>This sums up every integer in a vector, rejecting the sum if a negative\nelement is encountered:</p>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>f = |<span class=\"kw-2\">&amp;</span>x: <span class=\"kw-2\">&amp;</span>i32| <span class=\"kw\">if </span>x &lt; <span class=\"number\">0 </span>{ <span class=\"prelude-val\">Err</span>(<span class=\"string\">&quot;Negative element found&quot;</span>) } <span class=\"kw\">else </span>{ <span class=\"prelude-val\">Ok</span>(x) };\n<span class=\"kw\">let </span>v = <span class=\"macro\">vec!</span>[<span class=\"number\">1</span>, <span class=\"number\">2</span>];\n<span class=\"kw\">let </span>res: <span class=\"prelude-ty\">Result</span>&lt;i32, <span class=\"kw\">_</span>&gt; = v.iter().map(f).sum();\n<span class=\"macro\">assert_eq!</span>(res, <span class=\"prelude-val\">Ok</span>(<span class=\"number\">3</span>));\n<span class=\"kw\">let </span>v = <span class=\"macro\">vec!</span>[<span class=\"number\">1</span>, -<span class=\"number\">2</span>];\n<span class=\"kw\">let </span>res: <span class=\"prelude-ty\">Result</span>&lt;i32, <span class=\"kw\">_</span>&gt; = v.iter().map(f).sum();\n<span class=\"macro\">assert_eq!</span>(res, <span class=\"prelude-val\">Err</span>(<span class=\"string\">&quot;Negative element found&quot;</span>));</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+f+=+%7C%26x:+%26i32%7C+if+x+%3C+0+%7B+Err(%22Negative+element+found%22)+%7D+else+%7B+Ok(x)+%7D;%0Alet+v+=+vec!%5B1,+2%5D;%0Alet+res:+Result%3Ci32,+_%3E+=+v.iter().map(f).sum();%0Aassert_eq!(res,+Ok(3));%0Alet+v+=+vec!%5B1,+-2%5D;%0Alet+res:+Result%3Ci32,+_%3E+=+v.iter().map(f).sum();%0Aassert_eq!(res,+Err(%22Negative+element+found%22));%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details></div></details>","Sum<Result<U, E>>","core::fmt::Result"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Clone-for-Result%3CT,+E%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/result.rs.html#1673-1694\">source</a><a href=\"#impl-Clone-for-Result%3CT,+E%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, E&gt; <a class=\"trait\" href=\"core/clone/trait.Clone.html\" title=\"trait core::clone::Clone\">Clone</a> for <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;T, E&gt;<span class=\"where fmt-newline\">where\n    T: <a class=\"trait\" href=\"core/clone/trait.Clone.html\" title=\"trait core::clone::Clone\">Clone</a>,\n    E: <a class=\"trait\" href=\"core/clone/trait.Clone.html\" title=\"trait core::clone::Clone\">Clone</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.clone\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/result.rs.html#1679-1684\">source</a><a href=\"#method.clone\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/clone/trait.Clone.html#tymethod.clone\" class=\"fn\">clone</a>(&amp;self) -&gt; Self</h4></section></summary><div class='docblock'>Returns a copy of the value. <a href=\"core/clone/trait.Clone.html#tymethod.clone\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.clone_from\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/result.rs.html#1687-1693\">source</a><a href=\"#method.clone_from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/clone/trait.Clone.html#method.clone_from\" class=\"fn\">clone_from</a>(&amp;mut self, source: <a class=\"primitive\" href=\"primitive.reference.html\">&amp;Self</a>)</h4></section></summary><div class='docblock'>Performs copy-assignment from <code>source</code>. <a href=\"core/clone/trait.Clone.html#method.clone_from\">Read more</a></div></details></div></details>","Clone","core::fmt::Result"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Ord-for-Result%3CT,+E%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/result.rs.html#498\">source</a><a href=\"#impl-Ord-for-Result%3CT,+E%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T: <a class=\"trait\" href=\"core/cmp/trait.Ord.html\" title=\"trait core::cmp::Ord\">Ord</a>, E: <a class=\"trait\" href=\"core/cmp/trait.Ord.html\" title=\"trait core::cmp::Ord\">Ord</a>&gt; <a class=\"trait\" href=\"core/cmp/trait.Ord.html\" title=\"trait core::cmp::Ord\">Ord</a> for <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;T, E&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.cmp\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/result.rs.html#498\">source</a><a href=\"#method.cmp\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/cmp/trait.Ord.html#tymethod.cmp\" class=\"fn\">cmp</a>(&amp;self, other: &amp;<a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;T, E&gt;) -&gt; <a class=\"enum\" href=\"core/cmp/enum.Ordering.html\" title=\"enum core::cmp::Ordering\">Ordering</a></h4></section></summary><div class='docblock'>This method returns an <a href=\"core/cmp/enum.Ordering.html\" title=\"enum core::cmp::Ordering\"><code>Ordering</code></a> between <code>self</code> and <code>other</code>. <a href=\"core/cmp/trait.Ord.html#tymethod.cmp\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.max\" class=\"method trait-impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.21.0\">1.21.0</span> · <a class=\"src\" href=\"src/core/cmp.rs.html#826-831\">source</a></span><a href=\"#method.max\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/cmp/trait.Ord.html#method.max\" class=\"fn\">max</a>(self, other: Self) -&gt; Self<span class=\"where fmt-newline\">where\n    Self: <a class=\"trait\" href=\"core/marker/trait.Sized.html\" title=\"trait core::marker::Sized\">Sized</a>,</span></h4></section></summary><div class='docblock'>Compares and returns the maximum of two values. <a href=\"core/cmp/trait.Ord.html#method.max\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.min\" class=\"method trait-impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.21.0\">1.21.0</span> · <a class=\"src\" href=\"src/core/cmp.rs.html#846-851\">source</a></span><a href=\"#method.min\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/cmp/trait.Ord.html#method.min\" class=\"fn\">min</a>(self, other: Self) -&gt; Self<span class=\"where fmt-newline\">where\n    Self: <a class=\"trait\" href=\"core/marker/trait.Sized.html\" title=\"trait core::marker::Sized\">Sized</a>,</span></h4></section></summary><div class='docblock'>Compares and returns the minimum of two values. <a href=\"core/cmp/trait.Ord.html#method.min\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.clamp\" class=\"method trait-impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.50.0\">1.50.0</span> · <a class=\"src\" href=\"src/core/cmp.rs.html#871-884\">source</a></span><a href=\"#method.clamp\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/cmp/trait.Ord.html#method.clamp\" class=\"fn\">clamp</a>(self, min: Self, max: Self) -&gt; Self<span class=\"where fmt-newline\">where\n    Self: <a class=\"trait\" href=\"core/marker/trait.Sized.html\" title=\"trait core::marker::Sized\">Sized</a> + <a class=\"trait\" href=\"core/cmp/trait.PartialOrd.html\" title=\"trait core::cmp::PartialOrd\">PartialOrd</a>,</span></h4></section></summary><div class='docblock'>Restrict a value to a certain interval. <a href=\"core/cmp/trait.Ord.html#method.clamp\">Read more</a></div></details></div></details>","Ord","core::fmt::Result"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Product%3CResult%3CU,+E%3E%3E-for-Result%3CT,+E%3E\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.16.0\">1.16.0</span> · <a class=\"src\" href=\"src/core/iter/traits/accum.rs.html#184-211\">source</a></span><a href=\"#impl-Product%3CResult%3CU,+E%3E%3E-for-Result%3CT,+E%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, U, E&gt; <a class=\"trait\" href=\"core/iter/trait.Product.html\" title=\"trait core::iter::Product\">Product</a>&lt;<a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;U, E&gt;&gt; for <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;T, E&gt;<span class=\"where fmt-newline\">where\n    T: <a class=\"trait\" href=\"core/iter/trait.Product.html\" title=\"trait core::iter::Product\">Product</a>&lt;U&gt;,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.product\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/iter/traits/accum.rs.html#205-210\">source</a><a href=\"#method.product\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/iter/trait.Product.html#tymethod.product\" class=\"fn\">product</a>&lt;I&gt;(iter: I) -&gt; <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;T, E&gt;<span class=\"where fmt-newline\">where\n    I: <a class=\"trait\" href=\"core/iter/trait.Iterator.html\" title=\"trait core::iter::Iterator\">Iterator</a>&lt;Item = <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;U, E&gt;&gt;,</span></h4></section></summary><div class=\"docblock\"><p>Takes each element in the <a href=\"core/iter/trait.Iterator.html\" title=\"trait core::iter::Iterator\"><code>Iterator</code></a>: if it is an <a href=\"core/result/enum.Result.html#variant.Err\" title=\"variant core::result::Result::Err\"><code>Err</code></a>, no further\nelements are taken, and the <a href=\"core/result/enum.Result.html#variant.Err\" title=\"variant core::result::Result::Err\"><code>Err</code></a> is returned. Should no <a href=\"core/result/enum.Result.html#variant.Err\" title=\"variant core::result::Result::Err\"><code>Err</code></a>\noccur, the product of all elements is returned.</p>\n<h5 id=\"examples\"><a href=\"#examples\">Examples</a></h5>\n<p>This multiplies each number in a vector of strings,\nif a string could not be parsed the operation returns <code>Err</code>:</p>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>nums = <span class=\"macro\">vec!</span>[<span class=\"string\">&quot;5&quot;</span>, <span class=\"string\">&quot;10&quot;</span>, <span class=\"string\">&quot;1&quot;</span>, <span class=\"string\">&quot;2&quot;</span>];\n<span class=\"kw\">let </span>total: <span class=\"prelude-ty\">Result</span>&lt;usize, <span class=\"kw\">_</span>&gt; = nums.iter().map(|w| w.parse::&lt;usize&gt;()).product();\n<span class=\"macro\">assert_eq!</span>(total, <span class=\"prelude-val\">Ok</span>(<span class=\"number\">100</span>));\n<span class=\"kw\">let </span>nums = <span class=\"macro\">vec!</span>[<span class=\"string\">&quot;5&quot;</span>, <span class=\"string\">&quot;10&quot;</span>, <span class=\"string\">&quot;one&quot;</span>, <span class=\"string\">&quot;2&quot;</span>];\n<span class=\"kw\">let </span>total: <span class=\"prelude-ty\">Result</span>&lt;usize, <span class=\"kw\">_</span>&gt; = nums.iter().map(|w| w.parse::&lt;usize&gt;()).product();\n<span class=\"macro\">assert!</span>(total.is_err());</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+nums+=+vec!%5B%225%22,+%2210%22,+%221%22,+%222%22%5D;%0Alet+total:+Result%3Cusize,+_%3E+=+nums.iter().map(%7Cw%7C+w.parse::%3Cusize%3E()).product();%0Aassert_eq!(total,+Ok(100));%0Alet+nums+=+vec!%5B%225%22,+%2210%22,+%22one%22,+%222%22%5D;%0Alet+total:+Result%3Cusize,+_%3E+=+nums.iter().map(%7Cw%7C+w.parse::%3Cusize%3E()).product();%0Aassert!(total.is_err());%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details></div></details>","Product<Result<U, E>>","core::fmt::Result"],["<section id=\"impl-Eq-for-Result%3CT,+E%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/result.rs.html#498\">source</a><a href=\"#impl-Eq-for-Result%3CT,+E%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T: <a class=\"trait\" href=\"core/cmp/trait.Eq.html\" title=\"trait core::cmp::Eq\">Eq</a>, E: <a class=\"trait\" href=\"core/cmp/trait.Eq.html\" title=\"trait core::cmp::Eq\">Eq</a>&gt; <a class=\"trait\" href=\"core/cmp/trait.Eq.html\" title=\"trait core::cmp::Eq\">Eq</a> for <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;T, E&gt;</h3></section>","Eq","core::fmt::Result"],["<section id=\"impl-Copy-for-Result%3CT,+E%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/result.rs.html#498\">source</a><a href=\"#impl-Copy-for-Result%3CT,+E%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T: <a class=\"trait\" href=\"core/marker/trait.Copy.html\" title=\"trait core::marker::Copy\">Copy</a>, E: <a class=\"trait\" href=\"core/marker/trait.Copy.html\" title=\"trait core::marker::Copy\">Copy</a>&gt; <a class=\"trait\" href=\"core/marker/trait.Copy.html\" title=\"trait core::marker::Copy\">Copy</a> for <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;T, E&gt;</h3></section>","Copy","core::fmt::Result"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-PartialEq-for-Result%3CT,+E%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/result.rs.html#498\">source</a><a href=\"#impl-PartialEq-for-Result%3CT,+E%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T: <a class=\"trait\" href=\"core/cmp/trait.PartialEq.html\" title=\"trait core::cmp::PartialEq\">PartialEq</a>, E: <a class=\"trait\" href=\"core/cmp/trait.PartialEq.html\" title=\"trait core::cmp::PartialEq\">PartialEq</a>&gt; <a class=\"trait\" href=\"core/cmp/trait.PartialEq.html\" title=\"trait core::cmp::PartialEq\">PartialEq</a> for <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;T, E&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.eq\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/result.rs.html#498\">source</a><a href=\"#method.eq\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/cmp/trait.PartialEq.html#tymethod.eq\" class=\"fn\">eq</a>(&amp;self, other: &amp;<a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;T, E&gt;) -&gt; <a class=\"primitive\" href=\"primitive.bool.html\">bool</a></h4></section></summary><div class='docblock'>This method tests for <code>self</code> and <code>other</code> values to be equal, and is used\nby <code>==</code>.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.ne\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/cmp.rs.html#239-241\">source</a><a href=\"#method.ne\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/cmp/trait.PartialEq.html#method.ne\" class=\"fn\">ne</a>(&amp;self, other: <a class=\"primitive\" href=\"primitive.reference.html\">&amp;Rhs</a>) -&gt; <a class=\"primitive\" href=\"primitive.bool.html\">bool</a></h4></section></summary><div class='docblock'>This method tests for <code>!=</code>. The default implementation is almost always\nsufficient, and should not be overridden without very good reason.</div></details></div></details>","PartialEq","core::fmt::Result"],["<section id=\"impl-StructuralEq-for-Result%3CT,+E%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/result.rs.html#498\">source</a><a href=\"#impl-StructuralEq-for-Result%3CT,+E%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, E&gt; <a class=\"trait\" href=\"core/marker/trait.StructuralEq.html\" title=\"trait core::marker::StructuralEq\">StructuralEq</a> for <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;T, E&gt;</h3></section>","StructuralEq","core::fmt::Result"],["<section id=\"impl-StructuralPartialEq-for-Result%3CT,+E%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/result.rs.html#498\">source</a><a href=\"#impl-StructuralPartialEq-for-Result%3CT,+E%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, E&gt; <a class=\"trait\" href=\"core/marker/trait.StructuralPartialEq.html\" title=\"trait core::marker::StructuralPartialEq\">StructuralPartialEq</a> for <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;T, E&gt;</h3></section>","StructuralPartialEq","core::fmt::Result"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-FromIterator%3CResult%3CA,+E%3E%3E-for-Result%3CV,+E%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/result.rs.html#1889-1936\">source</a><a href=\"#impl-FromIterator%3CResult%3CA,+E%3E%3E-for-Result%3CV,+E%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;A, E, V: <a class=\"trait\" href=\"core/iter/trait.FromIterator.html\" title=\"trait core::iter::FromIterator\">FromIterator</a>&lt;A&gt;&gt; <a class=\"trait\" href=\"core/iter/trait.FromIterator.html\" title=\"trait core::iter::FromIterator\">FromIterator</a>&lt;<a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;A, E&gt;&gt; for <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;V, E&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_iter\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/result.rs.html#1933-1935\">source</a><a href=\"#method.from_iter\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/iter/trait.FromIterator.html#tymethod.from_iter\" class=\"fn\">from_iter</a>&lt;I: <a class=\"trait\" href=\"core/iter/trait.IntoIterator.html\" title=\"trait core::iter::IntoIterator\">IntoIterator</a>&lt;Item = <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;A, E&gt;&gt;&gt;(iter: I) -&gt; <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;V, E&gt;</h4></section></summary><div class=\"docblock\"><p>Takes each element in the <code>Iterator</code>: if it is an <code>Err</code>, no further\nelements are taken, and the <code>Err</code> is returned. Should no <code>Err</code> occur, a\ncontainer with the values of each <code>Result</code> is returned.</p>\n<p>Here is an example which increments every integer in a vector,\nchecking for overflow:</p>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>v = <span class=\"macro\">vec!</span>[<span class=\"number\">1</span>, <span class=\"number\">2</span>];\n<span class=\"kw\">let </span>res: <span class=\"prelude-ty\">Result</span>&lt;Vec&lt;u32&gt;, <span class=\"kw-2\">&amp;</span><span class=\"lifetime\">&#39;static </span>str&gt; = v.iter().map(|x: <span class=\"kw-2\">&amp;</span>u32|\n    x.checked_add(<span class=\"number\">1</span>).ok_or(<span class=\"string\">&quot;Overflow!&quot;</span>)\n).collect();\n<span class=\"macro\">assert_eq!</span>(res, <span class=\"prelude-val\">Ok</span>(<span class=\"macro\">vec!</span>[<span class=\"number\">2</span>, <span class=\"number\">3</span>]));</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+v+=+vec!%5B1,+2%5D;%0Alet+res:+Result%3CVec%3Cu32%3E,+%26'static+str%3E+=+v.iter().map(%7Cx:+%26u32%7C%0A++++x.checked_add(1).ok_or(%22Overflow!%22)%0A).collect();%0Aassert_eq!(res,+Ok(vec!%5B2,+3%5D));%0A%7D&amp;edition=2021\">Run</a></div>\n<p>Here is another example that tries to subtract one from another list\nof integers, this time checking for underflow:</p>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>v = <span class=\"macro\">vec!</span>[<span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">0</span>];\n<span class=\"kw\">let </span>res: <span class=\"prelude-ty\">Result</span>&lt;Vec&lt;u32&gt;, <span class=\"kw-2\">&amp;</span><span class=\"lifetime\">&#39;static </span>str&gt; = v.iter().map(|x: <span class=\"kw-2\">&amp;</span>u32|\n    x.checked_sub(<span class=\"number\">1</span>).ok_or(<span class=\"string\">&quot;Underflow!&quot;</span>)\n).collect();\n<span class=\"macro\">assert_eq!</span>(res, <span class=\"prelude-val\">Err</span>(<span class=\"string\">&quot;Underflow!&quot;</span>));</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+v+=+vec!%5B1,+2,+0%5D;%0Alet+res:+Result%3CVec%3Cu32%3E,+%26'static+str%3E+=+v.iter().map(%7Cx:+%26u32%7C%0A++++x.checked_sub(1).ok_or(%22Underflow!%22)%0A).collect();%0Aassert_eq!(res,+Err(%22Underflow!%22));%0A%7D&amp;edition=2021\">Run</a></div>\n<p>Here is a variation on the previous example, showing that no\nfurther elements are taken from <code>iter</code> after the first <code>Err</code>.</p>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>v = <span class=\"macro\">vec!</span>[<span class=\"number\">3</span>, <span class=\"number\">2</span>, <span class=\"number\">1</span>, <span class=\"number\">10</span>];\n<span class=\"kw\">let </span><span class=\"kw-2\">mut </span>shared = <span class=\"number\">0</span>;\n<span class=\"kw\">let </span>res: <span class=\"prelude-ty\">Result</span>&lt;Vec&lt;u32&gt;, <span class=\"kw-2\">&amp;</span><span class=\"lifetime\">&#39;static </span>str&gt; = v.iter().map(|x: <span class=\"kw-2\">&amp;</span>u32| {\n    shared += x;\n    x.checked_sub(<span class=\"number\">2</span>).ok_or(<span class=\"string\">&quot;Underflow!&quot;</span>)\n}).collect();\n<span class=\"macro\">assert_eq!</span>(res, <span class=\"prelude-val\">Err</span>(<span class=\"string\">&quot;Underflow!&quot;</span>));\n<span class=\"macro\">assert_eq!</span>(shared, <span class=\"number\">6</span>);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+v+=+vec!%5B3,+2,+1,+10%5D;%0Alet+mut+shared+=+0;%0Alet+res:+Result%3CVec%3Cu32%3E,+%26'static+str%3E+=+v.iter().map(%7Cx:+%26u32%7C+%7B%0A++++shared+%2B=+x;%0A++++x.checked_sub(2).ok_or(%22Underflow!%22)%0A%7D).collect();%0Aassert_eq!(res,+Err(%22Underflow!%22));%0Aassert_eq!(shared,+6);%0A%7D&amp;edition=2021\">Run</a></div>\n<p>Since the third element caused an underflow, no further elements were taken,\nso the final value of <code>shared</code> is 6 (= <code>3 + 2 + 1</code>), not 16.</p>\n</div></details></div></details>","FromIterator<Result<A, E>>","core::fmt::Result"]]
};if (window.register_type_impls) {window.register_type_impls(type_impls);} else {window.pending_type_impls = type_impls;}})()