/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.util;

import org.jetbrains.kotlin.com.intellij.openapi.util.Condition;
import org.jetbrains.kotlin.com.intellij.util.Function;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Conditions {
    public static final Condition<Object> TRUE = Condition.TRUE;
    public static final Condition<Object> FALSE = Condition.FALSE;

    public static <T> Condition<T> alwaysTrue() {
        return TRUE;
    }

    public static <T> Condition<T> alwaysFalse() {
        return FALSE;
    }

    public static <T> Condition<T> notNull() {
        return Condition.NOT_NULL;
    }

    public static <T> Condition<T> instanceOf(final Class<?> clazz) {
        return new Condition<T>(){

            @Override
            public boolean value(T t) {
                return clazz.isInstance(t);
            }
        };
    }

    public static <T> Condition<T> not(Condition<T> c) {
        if (c == TRUE) {
            return Conditions.alwaysFalse();
        }
        if (c == FALSE) {
            return Conditions.alwaysTrue();
        }
        if (c instanceof Not) {
            return ((Not)c).c;
        }
        return new Not<T>(c);
    }

    public static <T> Condition<T> and(Condition<T> c1, Condition<T> c2) {
        return Conditions.and2(c1, c2);
    }

    public static <T> Condition<T> and2(Condition<? super T> c1, Condition<? super T> c2) {
        if (c1 == TRUE || c2 == FALSE) {
            return c2;
        }
        if (c2 == TRUE || c1 == FALSE) {
            return c1;
        }
        return new And<T>(c1, c2);
    }

    public static <A, B> Condition<A> compose(final Function<? super A, B> fun, final Condition<? super B> condition) {
        return new Condition<A>(){

            @Override
            public boolean value(A o) {
                return condition.value(fun.fun(o));
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class And<T>
    implements Condition<T> {
        final Condition<? super T> c1;
        final Condition<? super T> c2;

        And(Condition<? super T> c1, Condition<? super T> c2) {
            this.c1 = c1;
            this.c2 = c2;
        }

        @Override
        public boolean value(T object) {
            return this.c1.value(object) && this.c2.value(object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Not<T>
    implements Condition<T> {
        final Condition<T> c;

        Not(Condition<T> c) {
            this.c = c;
        }

        @Override
        public boolean value(T value) {
            return !this.c.value(value);
        }
    }
}

