/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.tasks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.hash.HashCode;

public class BuildCacheKeyInputs {
    private final String taskClass;
    private final HashCode classLoaderHash;
    private final List<HashCode> actionClassLoaderHashes;
    private final ImmutableList<String> actionClassNames;
    private final ImmutableSortedMap<String, HashCode> inputValueHashes;
    private final ImmutableSortedMap<String, CurrentFileCollectionFingerprint> inputFiles;
    private final ImmutableSortedSet<String> inputPropertiesLoadedByUnknownClassLoader;
    private final ImmutableSortedSet<String> outputPropertyNames;

    public BuildCacheKeyInputs(@Nullable String taskClass, @Nullable HashCode classLoaderHash, @Nullable List<HashCode> actionClassLoaderHashes, @Nullable ImmutableList<String> actionClassNames, @Nullable ImmutableSortedMap<String, HashCode> inputValueHashes, @Nullable ImmutableSortedMap<String, CurrentFileCollectionFingerprint> inputFiles, @Nullable ImmutableSortedSet<String> inputPropertiesLoadedByUnknownClassLoader, @Nullable ImmutableSortedSet<String> outputPropertyNames) {
        this.taskClass = taskClass;
        this.inputValueHashes = inputValueHashes;
        this.inputFiles = inputFiles;
        this.inputPropertiesLoadedByUnknownClassLoader = inputPropertiesLoadedByUnknownClassLoader;
        this.classLoaderHash = classLoaderHash;
        this.actionClassLoaderHashes = actionClassLoaderHashes;
        this.actionClassNames = actionClassNames;
        this.outputPropertyNames = outputPropertyNames;
    }

    @Nullable
    public String getTaskClass() {
        return this.taskClass;
    }

    @Nullable
    public ImmutableSortedMap<String, HashCode> getInputValueHashes() {
        return this.inputValueHashes;
    }

    @Nullable
    public ImmutableSortedMap<String, CurrentFileCollectionFingerprint> getInputFiles() {
        return this.inputFiles;
    }

    @Nullable
    public ImmutableSortedSet<String> getInputPropertiesLoadedByUnknownClassLoader() {
        return this.inputPropertiesLoadedByUnknownClassLoader;
    }

    @Nullable
    public HashCode getClassLoaderHash() {
        return this.classLoaderHash;
    }

    @Nullable
    public List<HashCode> getActionClassLoaderHashes() {
        return this.actionClassLoaderHashes;
    }

    @Nullable
    public ImmutableList<String> getActionClassNames() {
        return this.actionClassNames;
    }

    @Nullable
    public ImmutableSortedSet<String> getOutputPropertyNames() {
        return this.outputPropertyNames;
    }

    public String toString() {
        return "BuildCacheKeyInputs{classLoaderHash=" + this.classLoaderHash + ", actionClassLoaderHashes=" + this.actionClassLoaderHashes + ", actionClassNames=" + this.actionClassNames + ", inputValueHashes=" + this.inputValueHashes + ", inputFiles=" + this.inputFiles + ", inputPropertyNamesLoadedByUnknownClassLoader=" + this.inputPropertiesLoadedByUnknownClassLoader + ", outputPropertyNames=" + this.outputPropertyNames + '}';
    }
}

