// Copyright 2015 Keybase, Inc. All rights reserved. Use of
// this source code is governed by the included BSD license.

package libkb

import "strings"

var apiCAOverrideForTest = ""

// GetBundledCAsFromHost returns in root CA in []byte for given host, or nil if
// no matching CA is found for host.
func GetBundledCAsFromHost(host string) (rootCA []byte, ok bool) {
	host = strings.TrimSpace(strings.ToLower(host))
	realAPICA := APICA
	if len(apiCAOverrideForTest) > 0 {
		realAPICA = apiCAOverrideForTest
	}
	switch {
	case (host == "api.keybase.io" || host == "api-0.core.keybaseapi.com" || host == "api-1.core.keybaseapi.com"):
		return []byte(realAPICA), true

	// Staging CA.
	case strings.HasSuffix(host, "dev.keybase.io"),
		strings.HasSuffix(host, "dev.keybaseapi.com"):
		return []byte(KBFSDevCA), true

	// Prod CA.
	case strings.HasSuffix(host, "kbfs.keybase.io"),
		strings.HasSuffix(host, "kbfs.keybaseapi.com"):
		return []byte(KBFSProdCA), true

	// We have services using both CAs on this domain, so need to bundle both.
	case strings.HasSuffix(host, "core.keybase.io"),
		strings.HasSuffix(host, "core.keybaseapi.com"):
		return []byte(realAPICA + KBFSProdCA), true

	default:
		return nil, false
	}
}

const APICA = `
-----BEGIN CERTIFICATE-----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-----END CERTIFICATE-----
`

const KBFSProdCA = `
-----BEGIN CERTIFICATE-----
MIIFkjCCA3qgAwIBAgIRALpii0WkmMIt0pcl7fLxvogwDQYJKoZIhvcNAQELBQAw
UTESMBAGCgmSJomT8ixkARkWAmlvMRwwGgYKCZImiZPyLGQBGRYMa2Jmcy5rZXli
YXNlMR0wGwYDVQQDDBRLZXliYXNlIEtCRlMgQ0EgcHJvZDAgFw0xNzA5MjYxNzA3
NDJaGA83MDE0MDYwMjE3MDc0MlowUTESMBAGCgmSJomT8ixkARkWAmlvMRwwGgYK
CZImiZPyLGQBGRYMa2Jmcy5rZXliYXNlMR0wGwYDVQQDDBRLZXliYXNlIEtCRlMg
Q0EgcHJvZDCCAiIwDQYJKoZIhvcNAQEBBQADggIPADCCAgoCggIBALtjrV8B+9ly
JjyMBX3m+9O8UbotvW9OQrPbQwVUY4LG8UJEeFETjtrZlYH4MZM7QhltBgxhnPlt
elCFxquCZTo8TScDzc6GdWZrvewDWjQTWRvxmNX++3dq5U9mbY8NqONoMoA9V4ZF
HL2xKrOITum0dSYjAzxfx5ofvdlmZ9MXTSDRu04lB0b0i2k3MnOfGQW7fxUA11lS
O5b3QrTvae20Pzhb5psjKUiaHDGMzulVO+Lz1gdsotahgxe/NCWiGjdS3OcjRbAV
BqNu7K/4xbxb580P1MOE+HSrziF3RDUSuryCzP8YMMqRXIf4rjaFYFrpazKbMoqG
pFZ//935i1lUopmIuaAkQjz/8Y11hYkdvSqVTHH0kyX7/kbEm+yIkLzn3VzoSJ5X
EL07XmHNY46LXBeDtIs3+Fdg0ISSMeHuSVYsm/TFK1VOrsToj8mbA0mF96laNMP6
d8OPWIVCbMN48MuZCT22gZCyAeHO57vXdd0Lg456WCcYcm3rQAHP0xoiHDLGxpoF
Yawl4dpj3qEdV1XJH0LQE450FVSrwfwL2FcH2+/6GVBhPEeJQgCECVbOwCbp/BPW
85Q7GntStVQQH89CqJnZEa1hglMwhaWCxVGfFDsPpM8GCh+BfXuSpQTlvOojo518
VRHxlMduI42VZMhnmHw7G4WorhhRC6inAgMBAAGjYzBhMA8GA1UdEwEB/wQFMAMB
Af8wDgYDVR0PAQH/BAQDAgEGMB0GA1UdDgQWBBRQmQ3lv6fySPlfpNjyUKG3wzh9
5jAfBgNVHSMEGDAWgBRQmQ3lv6fySPlfpNjyUKG3wzh95jANBgkqhkiG9w0BAQsF
AAOCAgEAEoOPz2/LQJZQId69QR5nedpoWZ7d7ob0tkM0/+S5fIgQCCsC31417pRD
QxFuPPnYh5XaEcdzWq3ECGMZZfSsDmfgJSgPwCOwtK6rXshKK+W66PK2/OGQD3Jx
QuBzBN1ZGT6saXg1pjhY1gdYCXuYiszXoYjpJZnp+sKegRB5BujEn9a1dnBCjVM3
BzXBB9PI34yc1+OJ6RusZtMa9fNgNAKJdMSTkCzVEU9qh3MhkqD/xEneUsZmdSDk
skv6/B1fpes0ctZM/JV99FrKDqq7eWnAlsF0e6GdnWL5MNOW0UupPK8edcDjr9op
cULw/+/2Hp60r50L1WWIcYEjrVmGIMpybrX1eqNilpJSjgrhX0ZqtiHh03+DcxXw
kZHxDQZf1bn+WwMxy0nb6YNBwcBXZEePb4S5KKy4V0T10YEDv7oOMrF6wIy/MxtU
wXHjIp+cd+lZkMngsGYZQExt9dq2BVmAncUiXj4ZAGQjpgSjaEuFkKDxEnRU908n
s+ljmQv1mMwPJqVyR+VIcwmAzhDSK1bwRpKgPjhkB10fBbiqPVllPuU40lSWCGEA
JB1KvwsOTY92T/h43MIeXWD2q1yzLtNmXp434uTUiZZwu2rFUYJTwagGp+z7d8TO
Zdjxkm8d4rsrfgqIWXdOQejJwYm8+LpRiOcUNpA47JR5l+HQAMQ=
-----END CERTIFICATE-----
` /* ^ created on 9/26/2017; expires on 06/02/7014 */ + `
-----BEGIN CERTIFICATE-----
MIIDkDCCAnigAwIBAgIRAL1MQ3C37AuGO8gFqfhqb9EwDQYJKoZIhvcNAQELBQAw
UTESMBAGCgmSJomT8ixkARkWAmlvMRwwGgYKCZImiZPyLGQBGRYMa2Jmcy5rZXli
YXNlMR0wGwYDVQQDDBRLZXliYXNlIEtCRlMgQ0EgcHJvZDAeFw0xNTExMDgyMzM3
MDFaFw0xNzExMDcyMzM3MDFaMFExEjAQBgoJkiaJk/IsZAEZFgJpbzEcMBoGCgmS
JomT8ixkARkWDGtiZnMua2V5YmFzZTEdMBsGA1UEAwwUS2V5YmFzZSBLQkZTIENB
IHByb2QwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCr9ttTzL093jPt
WstzWR19qvLprd778ALqShZYZughuXPULgOck4AQW27vlp1nY8+7sBnWgstzL6Gv
dTQU61e34yOeAFYyKoWPFHyeo/g1y+LANgLdLbeOatOlWyM2sb/f0K3SKpusp/9J
0ylpDyko97MAI28spwX1d7L/qlDV6ryce4GrzElp3J8j3TZ3cju5rEldn8BSnLYw
i/2/Sc93GwhkjI03MZvuWaJQXQjTMALVzx5gFzshUymV4yrJfQbmBTwODf1yucsQ
NrWDiKWcFXe5dR8BWBZG7lslZeGYaHQ6lc3TgGwaPobpaZpzVEt3Crb9HAuTVl8/
Ynlw2XvzAgMBAAGjYzBhMA8GA1UdEwEB/wQFMAMBAf8wDgYDVR0PAQH/BAQDAgEG
MB0GA1UdDgQWBBSg9AYko8IqCwg2awZOZO6TW+ITsjAfBgNVHSMEGDAWgBSg9AYk
o8IqCwg2awZOZO6TW+ITsjANBgkqhkiG9w0BAQsFAAOCAQEAAJ2oOlY+DCDWr73m
TrR3Kfx+bDzvU1IZviKKooGGPjG+apcz5rWoKhjkO593ORCrygAvITnAI4v2Eaic
h2zYfWkOnCI2YYvVChR0TSJfa2+gxZFUqxRb68zMgcTxGZTZUonEX4nCJjkrSx3M
ATZkFWJDPPVci6o87VbpnKOc3mep3i1s3Cvw0GMHP+yVgw8Y0BpXII5hGbCODmoh
d2mdg2gjlOVBCfTEAe7cgUx9/lraQwUurUjDO3g54NZo/pcoc9koIW+Ai+saF5gA
UnFkqAOuEw0y4Fxzr9pw9naKF3KMlEJf6CiDJ4xspNzPZFupuepKitRrlrzofYuW
OXgZAw==
-----END CERTIFICATE-----
` /* ^ expires on 11/7/2017 */

const KBFSDevCA = `
-----BEGIN CERTIFICATE-----
MIIFjTCCA3WgAwIBAgIQFpAR2yGFjPGpRawSbyV+JzANBgkqhkiG9w0BAQsFADBP
MRIwEAYKCZImiZPyLGQBGRYCaW8xGzAZBgoJkiaJk/IsZAEZFgtkZXYua2V5YmFz
ZTEcMBoGA1UEAwwTS2V5YmFzZSBLQkZTIENBIGRldjAgFw0xNzA5MjYxNzA3MDZa
GA83MDE0MDYwMjE3MDcwNlowTzESMBAGCgmSJomT8ixkARkWAmlvMRswGQYKCZIm
iZPyLGQBGRYLZGV2LmtleWJhc2UxHDAaBgNVBAMME0tleWJhc2UgS0JGUyBDQSBk
ZXYwggIiMA0GCSqGSIb3DQEBAQUAA4ICDwAwggIKAoICAQCfzXIB3edtDpdpyOrS
8rSBL6STOIucCQUf8737uk1FyA8kg84YCyDUtGFe242tCncQMJ3i/3Fo4542txKf
UQ6C7XCIUKP76ZvnG6N+KJkb0Tnr3N6pOYj0xQE6dldcXHNOgOC14m84mDABH0L9
0ZSpsVKmS7svn+Nr5y8hO9J2gg8/HBGl6MupJci4VGaTFgzT22D7IvjsBEcr4Pwd
qX6VafdeXlRONrVvPTHWJilpwpDkOo2EV6Un+61bVxTejFVsDpSRlwxE/R4zUJjm
sscE0GOpyZRyzmdAPlzEVhTqlMTjpFyODukQnXUq8CvkoZzzc+aCCFQbRw33T3eF
Je+pjqJS38pzQeaxCWs35WG53+xqiAuGVuXTcc5R31gVK2E92UmrGL96V9gRSTfg
YEoT4wVHzFscMIQUpKqQ2uoJm1asiOcJG6rPFSrkTTMSiCu1ITXeL62dj7Id+6gT
wdUv/r2W8tt4cCv24mfZPKI1cHjXUjZFslHJtFXn1kG19ka+JLj7kIAeglCona22
xTwdsla5nsAX2xOhtiteYlmmOkhIj3CJLDm86PYcTcsTByiDqNdgUdFGk4uvnSph
1yW/NulAuY4BX7yIRGqwGLgQQvnsbdsvcH+kYxu3I2nNz8dsaoAsX6cMSLQ9tH/I
6Cu/3jaXanvem7yFnfuFuO3abQIDAQABo2MwYTAPBgNVHRMBAf8EBTADAQH/MA4G
A1UdDwEB/wQEAwIBBjAdBgNVHQ4EFgQUknKQ73ecH+pEfJicSJdhi7Ud4ekwHwYD
VR0jBBgwFoAUknKQ73ecH+pEfJicSJdhi7Ud4ekwDQYJKoZIhvcNAQELBQADggIB
AI8dK0HiAvXtdvU3sMdK1K18JKroirK7yJL2MPKAy5Fr8IT30g/9zsoWY22zTRbD
iTcvjAoK/9DlcTSdxjYqh5s8D5jALBOxWi9e6TFWK71m6eec103TJJIOtwS2jC6u
R3hk1W56XL7cbdptAtrUfcEf3iohbnORdd50iAsGOAl/Iv4FduQeGZNJXIBpINYc
Mjo8CLA5Iw94XlyCcc8OJPYEk33Af2MiYCnccndWlophZq8fpLTaEcPGtlIYv2sA
sJhGWAdvEtZ9RoI5Rp66NuP7ZuD8GSjBwglC4PsKQS+7VdLOtt2HrzX3ZXp9DT9T
zjt/PriziUbyadK8PaYaJzTkGgJe4J0nA0UlNbRl8peEpepomPG2SyJSuNpkWh0d
zHeusngGowrBMqn54hmBwGaAGPA+b4faIq9sHnZm1TRlg0f7GeQegeJhjigAsv7q
iq2keQ2AXXnb1SUU2NbQ6GcdNEdi1eaatiWCkmp+pZLOAAJq7FsQiOF0oqo6OicX
gRQVL8BaIiQ6OQYO+XpLP0Efji0aK11X0yh02oUjdTWGBfQyBAFtccwUUDZZEaRV
FWG2uwh+ewaxA+3q+goIbIpzwbV8HMUcBAvEGajprdkv0Qmv3PY/ZVW+Y1SaSlIN
We3c57PSYN4UV4034Wr8gAZY5nzlYb0irQnl/Kw5oyNP
-----END CERTIFICATE-----
` /* ^ created on 9/26/2017; expires on 06/02/7014 */ + `
-----BEGIN CERTIFICATE-----
MIIDjDCCAnSgAwIBAgIRANRMeoRz3Xg5c8kT2f5k9wMwDQYJKoZIhvcNAQELBQAw
TzESMBAGCgmSJomT8ixkARkWAmlvMRswGQYKCZImiZPyLGQBGRYLZGV2LmtleWJh
c2UxHDAaBgNVBAMME0tleWJhc2UgS0JGUyBDQSBkZXYwHhcNMTUwOTIzMTk0NzM3
WhcNMTcwOTIyMTk0NzM3WjBPMRIwEAYKCZImiZPyLGQBGRYCaW8xGzAZBgoJkiaJ
k/IsZAEZFgtkZXYua2V5YmFzZTEcMBoGA1UEAwwTS2V5YmFzZSBLQkZTIENBIGRl
djCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBALWCTpo8NNeGM6nIkNW+
4qiM8ocuFjDw2Er6XJhncgj7xjTGf/9yZqnXeGHyHGT66AtKl5bc8son4+npWmvs
47OXORF7YGi89d9KBlIC4NCetZLBSVWiSG+XXSKrmIffi6D0UojpZc2blnzgejEO
ii1uCDSaj6TRLcC8z/eXKq+DtPcfNnPL0pu5CiUNrH1cA9PS+jO1OonCGPG5yVjW
bBw0nQfThhapm9IohtdbYzlQiSbE1+3ctNwCPLas3mmUWkcrrVbn1Fa54LnfNR2u
pnZRNZ7czfB/vtymUJ6/y8dLYTmnzMFFYy416FOmvr4NqLBkaMWg9xp+KeR30044
AicCAwEAAaNjMGEwDwYDVR0TAQH/BAUwAwEB/zAOBgNVHQ8BAf8EBAMCAQYwHQYD
VR0OBBYEFBdb6+h+Qq5vXUWo99QbatQTX6u+MB8GA1UdIwQYMBaAFBdb6+h+Qq5v
XUWo99QbatQTX6u+MA0GCSqGSIb3DQEBCwUAA4IBAQArhp0KXfJHEhVcUXqYYjdn
pZQjq3+0aKjMjgnVWekxwwBARh4ycy2e7066ru1eDZr6myGYK+/vjXituWtq7/c/
Fifezgje6o9lB1TPamgQeE8slqqAgc3OxTqbAAf+rxJelcI6aOm7tqX04k8Aiuhm
dr64cM/NsZTKUbrCHCVNHPNj8wWkrb9pbXH/q0+Gt/gw4MiL6p1YuSr4SIENqDpP
VFiOCcbOSiw5OHPe/VwLts/g3e3NSXqd53nQW1/CgpSBdT73oWw+SBfv21KuJN5K
745S8d9JfbLItWgM73o94MSLOpUEl2F7qqXj2eOBEYWIMbRjMMZ7Vzmuo5wo3M8i
-----END CERTIFICATE-----
` /* ^ expired on 9/22/2017 */
