// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/discoveryengine/v1beta/import_config.proto

package discoveryengine

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	date "google.golang.org/genproto/googleapis/type/date"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Indicates how imported documents are reconciled with the existing documents
// created or imported before.
type ImportDocumentsRequest_ReconciliationMode int32

const (
	// Defaults to INCREMENTAL.
	ImportDocumentsRequest_RECONCILIATION_MODE_UNSPECIFIED ImportDocumentsRequest_ReconciliationMode = 0
	// Inserts new documents or updates existing documents.
	ImportDocumentsRequest_INCREMENTAL ImportDocumentsRequest_ReconciliationMode = 1
	// Calculates diff and replaces the entire document dataset. Existing
	// documents may be deleted if they are not present in the source location.
	ImportDocumentsRequest_FULL ImportDocumentsRequest_ReconciliationMode = 2
)

// Enum value maps for ImportDocumentsRequest_ReconciliationMode.
var (
	ImportDocumentsRequest_ReconciliationMode_name = map[int32]string{
		0: "RECONCILIATION_MODE_UNSPECIFIED",
		1: "INCREMENTAL",
		2: "FULL",
	}
	ImportDocumentsRequest_ReconciliationMode_value = map[string]int32{
		"RECONCILIATION_MODE_UNSPECIFIED": 0,
		"INCREMENTAL":                     1,
		"FULL":                            2,
	}
)

func (x ImportDocumentsRequest_ReconciliationMode) Enum() *ImportDocumentsRequest_ReconciliationMode {
	p := new(ImportDocumentsRequest_ReconciliationMode)
	*p = x
	return p
}

func (x ImportDocumentsRequest_ReconciliationMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ImportDocumentsRequest_ReconciliationMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_discoveryengine_v1beta_import_config_proto_enumTypes[0].Descriptor()
}

func (ImportDocumentsRequest_ReconciliationMode) Type() protoreflect.EnumType {
	return &file_google_cloud_discoveryengine_v1beta_import_config_proto_enumTypes[0]
}

func (x ImportDocumentsRequest_ReconciliationMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ImportDocumentsRequest_ReconciliationMode.Descriptor instead.
func (ImportDocumentsRequest_ReconciliationMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_import_config_proto_rawDescGZIP(), []int{7, 0}
}

// Google Cloud Storage location for input content.
// format.
type GcsSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Google Cloud Storage URIs to input files. URI can be up to
	// 2000 characters long. URIs can match the full object path (for example,
	// `gs://bucket/directory/object.json`) or a pattern matching one or more
	// files, such as `gs://bucket/directory/*.json`. A request can
	// contain at most 100 files, and each file can be up to 2 GB.
	InputUris []string `protobuf:"bytes,1,rep,name=input_uris,json=inputUris,proto3" json:"input_uris,omitempty"`
	// The schema to use when parsing the data from the source.
	//
	// Supported values for imports:
	//
	// * `user_event` (default): One JSON
	// [UserEvent][google.cloud.discoveryengine.v1beta.UserEvent] per line.
	//
	// * `document` (default): One JSON
	// [Document][google.cloud.discoveryengine.v1beta.Document] per line. Each
	// document must
	//
	//	have a valid
	//	[Document.id][google.cloud.discoveryengine.v1beta.Document.id].
	DataSchema string `protobuf:"bytes,2,opt,name=data_schema,json=dataSchema,proto3" json:"data_schema,omitempty"`
}

func (x *GcsSource) Reset() {
	*x = GcsSource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1beta_import_config_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GcsSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GcsSource) ProtoMessage() {}

func (x *GcsSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_import_config_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GcsSource.ProtoReflect.Descriptor instead.
func (*GcsSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_import_config_proto_rawDescGZIP(), []int{0}
}

func (x *GcsSource) GetInputUris() []string {
	if x != nil {
		return x.InputUris
	}
	return nil
}

func (x *GcsSource) GetDataSchema() string {
	if x != nil {
		return x.DataSchema
	}
	return ""
}

// BigQuery source import data from.
type BigQuerySource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// BigQuery table partition info. Leave this empty if the BigQuery table
	// is not partitioned.
	//
	// Types that are assignable to Partition:
	//
	//	*BigQuerySource_PartitionDate
	Partition isBigQuerySource_Partition `protobuf_oneof:"partition"`
	// The project ID (can be project # or ID) that the BigQuery source is in with
	// a length limit of 128 characters. If not specified, inherits the project
	// ID from the parent request.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. The BigQuery data set to copy the data from with a length limit
	// of 1,024 characters.
	DatasetId string `protobuf:"bytes,2,opt,name=dataset_id,json=datasetId,proto3" json:"dataset_id,omitempty"`
	// Required. The BigQuery table to copy the data from with a length limit of
	// 1,024 characters.
	TableId string `protobuf:"bytes,3,opt,name=table_id,json=tableId,proto3" json:"table_id,omitempty"`
	// Intermediate Cloud Storage directory used for the import with a length
	// limit of 2,000 characters. Can be specified if one wants to have the
	// BigQuery export to a specific Cloud Storage directory.
	GcsStagingDir string `protobuf:"bytes,4,opt,name=gcs_staging_dir,json=gcsStagingDir,proto3" json:"gcs_staging_dir,omitempty"`
	// The schema to use when parsing the data from the source.
	//
	// Supported values for imports:
	//
	// * `user_event` (default): One JSON
	// [UserEvent][google.cloud.discoveryengine.v1beta.UserEvent] per line.
	//
	// * `document` (default): One JSON
	// [Document][google.cloud.discoveryengine.v1beta.Document] per line. Each
	// document must have a valid [document.id][].
	DataSchema string `protobuf:"bytes,6,opt,name=data_schema,json=dataSchema,proto3" json:"data_schema,omitempty"`
}

func (x *BigQuerySource) Reset() {
	*x = BigQuerySource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1beta_import_config_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BigQuerySource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BigQuerySource) ProtoMessage() {}

func (x *BigQuerySource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_import_config_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BigQuerySource.ProtoReflect.Descriptor instead.
func (*BigQuerySource) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_import_config_proto_rawDescGZIP(), []int{1}
}

func (m *BigQuerySource) GetPartition() isBigQuerySource_Partition {
	if m != nil {
		return m.Partition
	}
	return nil
}

func (x *BigQuerySource) GetPartitionDate() *date.Date {
	if x, ok := x.GetPartition().(*BigQuerySource_PartitionDate); ok {
		return x.PartitionDate
	}
	return nil
}

func (x *BigQuerySource) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *BigQuerySource) GetDatasetId() string {
	if x != nil {
		return x.DatasetId
	}
	return ""
}

func (x *BigQuerySource) GetTableId() string {
	if x != nil {
		return x.TableId
	}
	return ""
}

func (x *BigQuerySource) GetGcsStagingDir() string {
	if x != nil {
		return x.GcsStagingDir
	}
	return ""
}

func (x *BigQuerySource) GetDataSchema() string {
	if x != nil {
		return x.DataSchema
	}
	return ""
}

type isBigQuerySource_Partition interface {
	isBigQuerySource_Partition()
}

type BigQuerySource_PartitionDate struct {
	// BigQuery time partitioned table's _PARTITIONDATE in YYYY-MM-DD format.
	PartitionDate *date.Date `protobuf:"bytes,5,opt,name=partition_date,json=partitionDate,proto3,oneof"`
}

func (*BigQuerySource_PartitionDate) isBigQuerySource_Partition() {}

// Configuration of destination for Import related errors.
type ImportErrorConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Errors destination.
	//
	// Types that are assignable to Destination:
	//
	//	*ImportErrorConfig_GcsPrefix
	Destination isImportErrorConfig_Destination `protobuf_oneof:"destination"`
}

func (x *ImportErrorConfig) Reset() {
	*x = ImportErrorConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1beta_import_config_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImportErrorConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportErrorConfig) ProtoMessage() {}

func (x *ImportErrorConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_import_config_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportErrorConfig.ProtoReflect.Descriptor instead.
func (*ImportErrorConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_import_config_proto_rawDescGZIP(), []int{2}
}

func (m *ImportErrorConfig) GetDestination() isImportErrorConfig_Destination {
	if m != nil {
		return m.Destination
	}
	return nil
}

func (x *ImportErrorConfig) GetGcsPrefix() string {
	if x, ok := x.GetDestination().(*ImportErrorConfig_GcsPrefix); ok {
		return x.GcsPrefix
	}
	return ""
}

type isImportErrorConfig_Destination interface {
	isImportErrorConfig_Destination()
}

type ImportErrorConfig_GcsPrefix struct {
	// Google Cloud Storage prefix for import errors. This must be an empty,
	// existing Cloud Storage directory. Import errors will be written to
	// sharded files in this directory, one per line, as a JSON-encoded
	// `google.rpc.Status` message.
	GcsPrefix string `protobuf:"bytes,1,opt,name=gcs_prefix,json=gcsPrefix,proto3,oneof"`
}

func (*ImportErrorConfig_GcsPrefix) isImportErrorConfig_Destination() {}

// Request message for the ImportUserEvents request.
type ImportUserEventsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The desired input source of the user event data.
	//
	// Types that are assignable to Source:
	//
	//	*ImportUserEventsRequest_InlineSource_
	//	*ImportUserEventsRequest_GcsSource
	//	*ImportUserEventsRequest_BigquerySource
	Source isImportUserEventsRequest_Source `protobuf_oneof:"source"`
	// Required. Parent DataStore resource name, of the form
	// `projects/{project}/locations/{location}/dataStores/{data_store}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The desired location of errors incurred during the Import. Cannot be set
	// for inline user event imports.
	ErrorConfig *ImportErrorConfig `protobuf:"bytes,5,opt,name=error_config,json=errorConfig,proto3" json:"error_config,omitempty"`
}

func (x *ImportUserEventsRequest) Reset() {
	*x = ImportUserEventsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1beta_import_config_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImportUserEventsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportUserEventsRequest) ProtoMessage() {}

func (x *ImportUserEventsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_import_config_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportUserEventsRequest.ProtoReflect.Descriptor instead.
func (*ImportUserEventsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_import_config_proto_rawDescGZIP(), []int{3}
}

func (m *ImportUserEventsRequest) GetSource() isImportUserEventsRequest_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (x *ImportUserEventsRequest) GetInlineSource() *ImportUserEventsRequest_InlineSource {
	if x, ok := x.GetSource().(*ImportUserEventsRequest_InlineSource_); ok {
		return x.InlineSource
	}
	return nil
}

func (x *ImportUserEventsRequest) GetGcsSource() *GcsSource {
	if x, ok := x.GetSource().(*ImportUserEventsRequest_GcsSource); ok {
		return x.GcsSource
	}
	return nil
}

func (x *ImportUserEventsRequest) GetBigquerySource() *BigQuerySource {
	if x, ok := x.GetSource().(*ImportUserEventsRequest_BigquerySource); ok {
		return x.BigquerySource
	}
	return nil
}

func (x *ImportUserEventsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ImportUserEventsRequest) GetErrorConfig() *ImportErrorConfig {
	if x != nil {
		return x.ErrorConfig
	}
	return nil
}

type isImportUserEventsRequest_Source interface {
	isImportUserEventsRequest_Source()
}

type ImportUserEventsRequest_InlineSource_ struct {
	// Required. The Inline source for the input content for UserEvents.
	InlineSource *ImportUserEventsRequest_InlineSource `protobuf:"bytes,2,opt,name=inline_source,json=inlineSource,proto3,oneof"`
}

type ImportUserEventsRequest_GcsSource struct {
	// Required. Google Cloud Storage location for the input content.
	GcsSource *GcsSource `protobuf:"bytes,3,opt,name=gcs_source,json=gcsSource,proto3,oneof"`
}

type ImportUserEventsRequest_BigquerySource struct {
	// Required. BigQuery input source.
	BigquerySource *BigQuerySource `protobuf:"bytes,4,opt,name=bigquery_source,json=bigquerySource,proto3,oneof"`
}

func (*ImportUserEventsRequest_InlineSource_) isImportUserEventsRequest_Source() {}

func (*ImportUserEventsRequest_GcsSource) isImportUserEventsRequest_Source() {}

func (*ImportUserEventsRequest_BigquerySource) isImportUserEventsRequest_Source() {}

// Response of the ImportUserEventsRequest. If the long running
// operation was successful, then this message is returned by the
// google.longrunning.Operations.response field if the operation was successful.
type ImportUserEventsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A sample of errors encountered while processing the request.
	ErrorSamples []*status.Status `protobuf:"bytes,1,rep,name=error_samples,json=errorSamples,proto3" json:"error_samples,omitempty"`
	// Echoes the destination for the complete errors if this field was set in
	// the request.
	ErrorConfig *ImportErrorConfig `protobuf:"bytes,2,opt,name=error_config,json=errorConfig,proto3" json:"error_config,omitempty"`
	// Count of user events imported with complete existing Documents.
	JoinedEventsCount int64 `protobuf:"varint,3,opt,name=joined_events_count,json=joinedEventsCount,proto3" json:"joined_events_count,omitempty"`
	// Count of user events imported, but with Document information not found
	// in the existing Branch.
	UnjoinedEventsCount int64 `protobuf:"varint,4,opt,name=unjoined_events_count,json=unjoinedEventsCount,proto3" json:"unjoined_events_count,omitempty"`
}

func (x *ImportUserEventsResponse) Reset() {
	*x = ImportUserEventsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1beta_import_config_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImportUserEventsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportUserEventsResponse) ProtoMessage() {}

func (x *ImportUserEventsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_import_config_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportUserEventsResponse.ProtoReflect.Descriptor instead.
func (*ImportUserEventsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_import_config_proto_rawDescGZIP(), []int{4}
}

func (x *ImportUserEventsResponse) GetErrorSamples() []*status.Status {
	if x != nil {
		return x.ErrorSamples
	}
	return nil
}

func (x *ImportUserEventsResponse) GetErrorConfig() *ImportErrorConfig {
	if x != nil {
		return x.ErrorConfig
	}
	return nil
}

func (x *ImportUserEventsResponse) GetJoinedEventsCount() int64 {
	if x != nil {
		return x.JoinedEventsCount
	}
	return 0
}

func (x *ImportUserEventsResponse) GetUnjoinedEventsCount() int64 {
	if x != nil {
		return x.UnjoinedEventsCount
	}
	return 0
}

// Metadata related to the progress of the Import operation. This will be
// returned by the google.longrunning.Operation.metadata field.
type ImportUserEventsMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Operation create time.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Operation last update time. If the operation is done, this is also the
	// finish time.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Count of entries that were processed successfully.
	SuccessCount int64 `protobuf:"varint,3,opt,name=success_count,json=successCount,proto3" json:"success_count,omitempty"`
	// Count of entries that encountered errors while processing.
	FailureCount int64 `protobuf:"varint,4,opt,name=failure_count,json=failureCount,proto3" json:"failure_count,omitempty"`
}

func (x *ImportUserEventsMetadata) Reset() {
	*x = ImportUserEventsMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1beta_import_config_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImportUserEventsMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportUserEventsMetadata) ProtoMessage() {}

func (x *ImportUserEventsMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_import_config_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportUserEventsMetadata.ProtoReflect.Descriptor instead.
func (*ImportUserEventsMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_import_config_proto_rawDescGZIP(), []int{5}
}

func (x *ImportUserEventsMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *ImportUserEventsMetadata) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *ImportUserEventsMetadata) GetSuccessCount() int64 {
	if x != nil {
		return x.SuccessCount
	}
	return 0
}

func (x *ImportUserEventsMetadata) GetFailureCount() int64 {
	if x != nil {
		return x.FailureCount
	}
	return 0
}

// Metadata related to the progress of the ImportDocuments operation. This will
// be returned by the google.longrunning.Operation.metadata field.
type ImportDocumentsMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Operation create time.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Operation last update time. If the operation is done, this is also the
	// finish time.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Count of entries that were processed successfully.
	SuccessCount int64 `protobuf:"varint,3,opt,name=success_count,json=successCount,proto3" json:"success_count,omitempty"`
	// Count of entries that encountered errors while processing.
	FailureCount int64 `protobuf:"varint,4,opt,name=failure_count,json=failureCount,proto3" json:"failure_count,omitempty"`
}

func (x *ImportDocumentsMetadata) Reset() {
	*x = ImportDocumentsMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1beta_import_config_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImportDocumentsMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportDocumentsMetadata) ProtoMessage() {}

func (x *ImportDocumentsMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_import_config_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportDocumentsMetadata.ProtoReflect.Descriptor instead.
func (*ImportDocumentsMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_import_config_proto_rawDescGZIP(), []int{6}
}

func (x *ImportDocumentsMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *ImportDocumentsMetadata) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *ImportDocumentsMetadata) GetSuccessCount() int64 {
	if x != nil {
		return x.SuccessCount
	}
	return 0
}

func (x *ImportDocumentsMetadata) GetFailureCount() int64 {
	if x != nil {
		return x.FailureCount
	}
	return 0
}

// Request message for Import methods.
type ImportDocumentsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The source of the input.
	//
	// Types that are assignable to Source:
	//
	//	*ImportDocumentsRequest_InlineSource_
	//	*ImportDocumentsRequest_GcsSource
	//	*ImportDocumentsRequest_BigquerySource
	Source isImportDocumentsRequest_Source `protobuf_oneof:"source"`
	// Required. The parent branch resource name, such as
	// `projects/{project}/locations/{location}/dataStores/{data_store}/branches/{branch}`.
	// Requires create/update permission.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The desired location of errors incurred during the Import.
	ErrorConfig *ImportErrorConfig `protobuf:"bytes,5,opt,name=error_config,json=errorConfig,proto3" json:"error_config,omitempty"`
	// The mode of reconciliation between existing documents and the documents to
	// be imported. Defaults to
	// [ReconciliationMode.INCREMENTAL][google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.ReconciliationMode.INCREMENTAL].
	ReconciliationMode ImportDocumentsRequest_ReconciliationMode `protobuf:"varint,6,opt,name=reconciliation_mode,json=reconciliationMode,proto3,enum=google.cloud.discoveryengine.v1beta.ImportDocumentsRequest_ReconciliationMode" json:"reconciliation_mode,omitempty"`
}

func (x *ImportDocumentsRequest) Reset() {
	*x = ImportDocumentsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1beta_import_config_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImportDocumentsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportDocumentsRequest) ProtoMessage() {}

func (x *ImportDocumentsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_import_config_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportDocumentsRequest.ProtoReflect.Descriptor instead.
func (*ImportDocumentsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_import_config_proto_rawDescGZIP(), []int{7}
}

func (m *ImportDocumentsRequest) GetSource() isImportDocumentsRequest_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (x *ImportDocumentsRequest) GetInlineSource() *ImportDocumentsRequest_InlineSource {
	if x, ok := x.GetSource().(*ImportDocumentsRequest_InlineSource_); ok {
		return x.InlineSource
	}
	return nil
}

func (x *ImportDocumentsRequest) GetGcsSource() *GcsSource {
	if x, ok := x.GetSource().(*ImportDocumentsRequest_GcsSource); ok {
		return x.GcsSource
	}
	return nil
}

func (x *ImportDocumentsRequest) GetBigquerySource() *BigQuerySource {
	if x, ok := x.GetSource().(*ImportDocumentsRequest_BigquerySource); ok {
		return x.BigquerySource
	}
	return nil
}

func (x *ImportDocumentsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ImportDocumentsRequest) GetErrorConfig() *ImportErrorConfig {
	if x != nil {
		return x.ErrorConfig
	}
	return nil
}

func (x *ImportDocumentsRequest) GetReconciliationMode() ImportDocumentsRequest_ReconciliationMode {
	if x != nil {
		return x.ReconciliationMode
	}
	return ImportDocumentsRequest_RECONCILIATION_MODE_UNSPECIFIED
}

type isImportDocumentsRequest_Source interface {
	isImportDocumentsRequest_Source()
}

type ImportDocumentsRequest_InlineSource_ struct {
	// The Inline source for the input content for documents.
	InlineSource *ImportDocumentsRequest_InlineSource `protobuf:"bytes,2,opt,name=inline_source,json=inlineSource,proto3,oneof"`
}

type ImportDocumentsRequest_GcsSource struct {
	// Google Cloud Storage location for the input content.
	GcsSource *GcsSource `protobuf:"bytes,3,opt,name=gcs_source,json=gcsSource,proto3,oneof"`
}

type ImportDocumentsRequest_BigquerySource struct {
	// BigQuery input source.
	BigquerySource *BigQuerySource `protobuf:"bytes,4,opt,name=bigquery_source,json=bigquerySource,proto3,oneof"`
}

func (*ImportDocumentsRequest_InlineSource_) isImportDocumentsRequest_Source() {}

func (*ImportDocumentsRequest_GcsSource) isImportDocumentsRequest_Source() {}

func (*ImportDocumentsRequest_BigquerySource) isImportDocumentsRequest_Source() {}

// Response of the
// [ImportDocumentsRequest][google.cloud.discoveryengine.v1beta.ImportDocumentsRequest].
// If the long running operation is done, then this message is returned by the
// google.longrunning.Operations.response field if the operation was successful.
type ImportDocumentsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A sample of errors encountered while processing the request.
	ErrorSamples []*status.Status `protobuf:"bytes,1,rep,name=error_samples,json=errorSamples,proto3" json:"error_samples,omitempty"`
	// Echoes the destination for the complete errors in the request if set.
	ErrorConfig *ImportErrorConfig `protobuf:"bytes,2,opt,name=error_config,json=errorConfig,proto3" json:"error_config,omitempty"`
}

func (x *ImportDocumentsResponse) Reset() {
	*x = ImportDocumentsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1beta_import_config_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImportDocumentsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportDocumentsResponse) ProtoMessage() {}

func (x *ImportDocumentsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_import_config_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportDocumentsResponse.ProtoReflect.Descriptor instead.
func (*ImportDocumentsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_import_config_proto_rawDescGZIP(), []int{8}
}

func (x *ImportDocumentsResponse) GetErrorSamples() []*status.Status {
	if x != nil {
		return x.ErrorSamples
	}
	return nil
}

func (x *ImportDocumentsResponse) GetErrorConfig() *ImportErrorConfig {
	if x != nil {
		return x.ErrorConfig
	}
	return nil
}

// The inline source for the input config for ImportUserEvents method.
type ImportUserEventsRequest_InlineSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A list of user events to import. Recommended max of 10k items.
	UserEvents []*UserEvent `protobuf:"bytes,1,rep,name=user_events,json=userEvents,proto3" json:"user_events,omitempty"`
}

func (x *ImportUserEventsRequest_InlineSource) Reset() {
	*x = ImportUserEventsRequest_InlineSource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1beta_import_config_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImportUserEventsRequest_InlineSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportUserEventsRequest_InlineSource) ProtoMessage() {}

func (x *ImportUserEventsRequest_InlineSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_import_config_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportUserEventsRequest_InlineSource.ProtoReflect.Descriptor instead.
func (*ImportUserEventsRequest_InlineSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_import_config_proto_rawDescGZIP(), []int{3, 0}
}

func (x *ImportUserEventsRequest_InlineSource) GetUserEvents() []*UserEvent {
	if x != nil {
		return x.UserEvents
	}
	return nil
}

// The inline source for the input config for ImportDocuments method.
type ImportDocumentsRequest_InlineSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A list of documents to update/create. Each document must have a
	// valid [Document.id][google.cloud.discoveryengine.v1beta.Document.id].
	// Recommended max of 100 items.
	Documents []*Document `protobuf:"bytes,1,rep,name=documents,proto3" json:"documents,omitempty"`
}

func (x *ImportDocumentsRequest_InlineSource) Reset() {
	*x = ImportDocumentsRequest_InlineSource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1beta_import_config_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImportDocumentsRequest_InlineSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportDocumentsRequest_InlineSource) ProtoMessage() {}

func (x *ImportDocumentsRequest_InlineSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_import_config_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportDocumentsRequest_InlineSource.ProtoReflect.Descriptor instead.
func (*ImportDocumentsRequest_InlineSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_import_config_proto_rawDescGZIP(), []int{7, 0}
}

func (x *ImportDocumentsRequest_InlineSource) GetDocuments() []*Document {
	if x != nil {
		return x.Documents
	}
	return nil
}

var File_google_cloud_discoveryengine_v1beta_import_config_proto protoreflect.FileDescriptor

var file_google_cloud_discoveryengine_v1beta_import_config_proto_rawDesc = []byte{
	0x0a, 0x37, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72,
	0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x1a, 0x1f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64,
	0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x32, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65,
	0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f,
	0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x34,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69, 0x73,
	0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x2f, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70,
	0x63, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x16,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x64, 0x61, 0x74, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x50, 0x0a, 0x09, 0x47, 0x63, 0x73, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x75, 0x72, 0x69,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x69, 0x6e,
	0x70, 0x75, 0x74, 0x55, 0x72, 0x69, 0x73, 0x12, 0x1f, 0x0a, 0x0b, 0x64, 0x61, 0x74, 0x61, 0x5f,
	0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x64, 0x61,
	0x74, 0x61, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x22, 0x85, 0x02, 0x0a, 0x0e, 0x42, 0x69, 0x67,
	0x51, 0x75, 0x65, 0x72, 0x79, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x3a, 0x0a, 0x0e, 0x70,
	0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70,
	0x65, 0x2e, 0x44, 0x61, 0x74, 0x65, 0x48, 0x00, 0x52, 0x0d, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x22, 0x0a, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65,
	0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x09, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x49, 0x64, 0x12, 0x1e, 0x0a, 0x08, 0x74, 0x61,
	0x62, 0x6c, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x07, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x49, 0x64, 0x12, 0x26, 0x0a, 0x0f, 0x67, 0x63,
	0x73, 0x5f, 0x73, 0x74, 0x61, 0x67, 0x69, 0x6e, 0x67, 0x5f, 0x64, 0x69, 0x72, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0d, 0x67, 0x63, 0x73, 0x53, 0x74, 0x61, 0x67, 0x69, 0x6e, 0x67, 0x44,
	0x69, 0x72, 0x12, 0x1f, 0x0a, 0x0b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d,
	0x61, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x53, 0x63, 0x68,
	0x65, 0x6d, 0x61, 0x42, 0x0b, 0x0a, 0x09, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0x43, 0x0a, 0x11, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x1f, 0x0a, 0x0a, 0x67, 0x63, 0x73, 0x5f, 0x70, 0x72, 0x65,
	0x66, 0x69, 0x78, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x09, 0x67, 0x63, 0x73,
	0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x42, 0x0d, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xe0, 0x04, 0x0a, 0x17, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74,
	0x55, 0x73, 0x65, 0x72, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x75, 0x0a, 0x0d, 0x69, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x49, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72,
	0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x49,
	0x6d, 0x70, 0x6f, 0x72, 0x74, 0x55, 0x73, 0x65, 0x72, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x49, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x48, 0x00, 0x52, 0x0c, 0x69, 0x6e, 0x6c, 0x69,
	0x6e, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x54, 0x0a, 0x0a, 0x67, 0x63, 0x73, 0x5f,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63,
	0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x2e, 0x47, 0x63, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x48, 0x00, 0x52, 0x09, 0x67, 0x63, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x63,
	0x0a, 0x0f, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79,
	0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x42, 0x69,
	0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x48, 0x00, 0x52, 0x0e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x12, 0x48, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x64, 0x69, 0x73,
	0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61,
	0x53, 0x74, 0x6f, 0x72, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x59, 0x0a,
	0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74,
	0x45, 0x72, 0x72, 0x6f, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0b, 0x65, 0x72, 0x72,
	0x6f, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a, 0x64, 0x0a, 0x0c, 0x49, 0x6e, 0x6c, 0x69,
	0x6e, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x54, 0x0a, 0x0b, 0x75, 0x73, 0x65, 0x72,
	0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73,
	0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0a, 0x75, 0x73, 0x65, 0x72, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x42, 0x08,
	0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0x92, 0x02, 0x0a, 0x18, 0x49, 0x6d, 0x70,
	0x6f, 0x72, 0x74, 0x55, 0x73, 0x65, 0x72, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x37, 0x0a, 0x0d, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x73,
	0x61, 0x6d, 0x70, 0x6c, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x52, 0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x73, 0x12, 0x59,
	0x0a, 0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72,
	0x74, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0b, 0x65, 0x72,
	0x72, 0x6f, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x2e, 0x0a, 0x13, 0x6a, 0x6f, 0x69,
	0x6e, 0x65, 0x64, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x11, 0x6a, 0x6f, 0x69, 0x6e, 0x65, 0x64, 0x45, 0x76,
	0x65, 0x6e, 0x74, 0x73, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x32, 0x0a, 0x15, 0x75, 0x6e, 0x6a,
	0x6f, 0x69, 0x6e, 0x65, 0x64, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x5f, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x13, 0x75, 0x6e, 0x6a, 0x6f, 0x69, 0x6e,
	0x65, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0xde, 0x01,
	0x0a, 0x18, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x55, 0x73, 0x65, 0x72, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0c, 0x73, 0x75, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x66, 0x61, 0x69,
	0x6c, 0x75, 0x72, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x0c, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0xdd,
	0x01, 0x0a, 0x17, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0c, 0x73, 0x75, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x66, 0x61, 0x69,
	0x6c, 0x75, 0x72, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x0c, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0x9f,
	0x06, 0x0a, 0x16, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x6f, 0x0a, 0x0d, 0x69, 0x6e, 0x6c,
	0x69, 0x6e, 0x65, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x49, 0x6e,
	0x6c, 0x69, 0x6e, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x48, 0x00, 0x52, 0x0c, 0x69, 0x6e,
	0x6c, 0x69, 0x6e, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x4f, 0x0a, 0x0a, 0x67, 0x63,
	0x73, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x47, 0x63, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x48, 0x00,
	0x52, 0x09, 0x67, 0x63, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x5e, 0x0a, 0x0f, 0x62,
	0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75,
	0x65, 0x72, 0x79, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x48, 0x00, 0x52, 0x0e, 0x62, 0x69, 0x67,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x45, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x27, 0x0a, 0x25, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x59, 0x0a, 0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72,
	0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x49,
	0x6d, 0x70, 0x6f, 0x72, 0x74, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x52, 0x0b, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x7f, 0x0a,
	0x13, 0x72, 0x65, 0x63, 0x6f, 0x6e, 0x63, 0x69, 0x6c, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x6d, 0x6f, 0x64, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x4e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76,
	0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x52, 0x65, 0x63, 0x6f, 0x6e, 0x63, 0x69, 0x6c,
	0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x52, 0x12, 0x72, 0x65, 0x63, 0x6f,
	0x6e, 0x63, 0x69, 0x6c, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x1a, 0x60,
	0x0a, 0x0c, 0x49, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x50,
	0x0a, 0x09, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73,
	0x22, 0x54, 0x0a, 0x12, 0x52, 0x65, 0x63, 0x6f, 0x6e, 0x63, 0x69, 0x6c, 0x69, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x23, 0x0a, 0x1f, 0x52, 0x45, 0x43, 0x4f, 0x4e, 0x43,
	0x49, 0x4c, 0x49, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x49,
	0x4e, 0x43, 0x52, 0x45, 0x4d, 0x45, 0x4e, 0x54, 0x41, 0x4c, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04,
	0x46, 0x55, 0x4c, 0x4c, 0x10, 0x02, 0x42, 0x08, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x22, 0xad, 0x01, 0x0a, 0x17, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x37, 0x0a, 0x0d,
	0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63,
	0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x53, 0x61,
	0x6d, 0x70, 0x6c, 0x65, 0x73, 0x12, 0x59, 0x0a, 0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f,
	0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x52, 0x0b, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x42, 0x99, 0x02, 0x0a, 0x27, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x42, 0x11, 0x49, 0x6d,
	0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50,
	0x01, 0x5a, 0x52, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67,
	0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x3b, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0xa2, 0x02, 0x0f, 0x44, 0x49, 0x53, 0x43, 0x4f, 0x56, 0x45, 0x52,
	0x59, 0x45, 0x4e, 0x47, 0x49, 0x4e, 0x45, 0xaa, 0x02, 0x23, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79,
	0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x56, 0x31, 0x42, 0x65, 0x74, 0x61, 0xca, 0x02, 0x23,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x44, 0x69, 0x73,
	0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x5c, 0x56, 0x31, 0x62,
	0x65, 0x74, 0x61, 0xea, 0x02, 0x26, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x45, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x62, 0x06, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_discoveryengine_v1beta_import_config_proto_rawDescOnce sync.Once
	file_google_cloud_discoveryengine_v1beta_import_config_proto_rawDescData = file_google_cloud_discoveryengine_v1beta_import_config_proto_rawDesc
)

func file_google_cloud_discoveryengine_v1beta_import_config_proto_rawDescGZIP() []byte {
	file_google_cloud_discoveryengine_v1beta_import_config_proto_rawDescOnce.Do(func() {
		file_google_cloud_discoveryengine_v1beta_import_config_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_discoveryengine_v1beta_import_config_proto_rawDescData)
	})
	return file_google_cloud_discoveryengine_v1beta_import_config_proto_rawDescData
}

var file_google_cloud_discoveryengine_v1beta_import_config_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_discoveryengine_v1beta_import_config_proto_msgTypes = make([]protoimpl.MessageInfo, 11)
var file_google_cloud_discoveryengine_v1beta_import_config_proto_goTypes = []interface{}{
	(ImportDocumentsRequest_ReconciliationMode)(0), // 0: google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.ReconciliationMode
	(*GcsSource)(nil),                            // 1: google.cloud.discoveryengine.v1beta.GcsSource
	(*BigQuerySource)(nil),                       // 2: google.cloud.discoveryengine.v1beta.BigQuerySource
	(*ImportErrorConfig)(nil),                    // 3: google.cloud.discoveryengine.v1beta.ImportErrorConfig
	(*ImportUserEventsRequest)(nil),              // 4: google.cloud.discoveryengine.v1beta.ImportUserEventsRequest
	(*ImportUserEventsResponse)(nil),             // 5: google.cloud.discoveryengine.v1beta.ImportUserEventsResponse
	(*ImportUserEventsMetadata)(nil),             // 6: google.cloud.discoveryengine.v1beta.ImportUserEventsMetadata
	(*ImportDocumentsMetadata)(nil),              // 7: google.cloud.discoveryengine.v1beta.ImportDocumentsMetadata
	(*ImportDocumentsRequest)(nil),               // 8: google.cloud.discoveryengine.v1beta.ImportDocumentsRequest
	(*ImportDocumentsResponse)(nil),              // 9: google.cloud.discoveryengine.v1beta.ImportDocumentsResponse
	(*ImportUserEventsRequest_InlineSource)(nil), // 10: google.cloud.discoveryengine.v1beta.ImportUserEventsRequest.InlineSource
	(*ImportDocumentsRequest_InlineSource)(nil),  // 11: google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.InlineSource
	(*date.Date)(nil),                            // 12: google.type.Date
	(*status.Status)(nil),                        // 13: google.rpc.Status
	(*timestamppb.Timestamp)(nil),                // 14: google.protobuf.Timestamp
	(*UserEvent)(nil),                            // 15: google.cloud.discoveryengine.v1beta.UserEvent
	(*Document)(nil),                             // 16: google.cloud.discoveryengine.v1beta.Document
}
var file_google_cloud_discoveryengine_v1beta_import_config_proto_depIdxs = []int32{
	12, // 0: google.cloud.discoveryengine.v1beta.BigQuerySource.partition_date:type_name -> google.type.Date
	10, // 1: google.cloud.discoveryengine.v1beta.ImportUserEventsRequest.inline_source:type_name -> google.cloud.discoveryengine.v1beta.ImportUserEventsRequest.InlineSource
	1,  // 2: google.cloud.discoveryengine.v1beta.ImportUserEventsRequest.gcs_source:type_name -> google.cloud.discoveryengine.v1beta.GcsSource
	2,  // 3: google.cloud.discoveryengine.v1beta.ImportUserEventsRequest.bigquery_source:type_name -> google.cloud.discoveryengine.v1beta.BigQuerySource
	3,  // 4: google.cloud.discoveryengine.v1beta.ImportUserEventsRequest.error_config:type_name -> google.cloud.discoveryengine.v1beta.ImportErrorConfig
	13, // 5: google.cloud.discoveryengine.v1beta.ImportUserEventsResponse.error_samples:type_name -> google.rpc.Status
	3,  // 6: google.cloud.discoveryengine.v1beta.ImportUserEventsResponse.error_config:type_name -> google.cloud.discoveryengine.v1beta.ImportErrorConfig
	14, // 7: google.cloud.discoveryengine.v1beta.ImportUserEventsMetadata.create_time:type_name -> google.protobuf.Timestamp
	14, // 8: google.cloud.discoveryengine.v1beta.ImportUserEventsMetadata.update_time:type_name -> google.protobuf.Timestamp
	14, // 9: google.cloud.discoveryengine.v1beta.ImportDocumentsMetadata.create_time:type_name -> google.protobuf.Timestamp
	14, // 10: google.cloud.discoveryengine.v1beta.ImportDocumentsMetadata.update_time:type_name -> google.protobuf.Timestamp
	11, // 11: google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.inline_source:type_name -> google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.InlineSource
	1,  // 12: google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.gcs_source:type_name -> google.cloud.discoveryengine.v1beta.GcsSource
	2,  // 13: google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.bigquery_source:type_name -> google.cloud.discoveryengine.v1beta.BigQuerySource
	3,  // 14: google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.error_config:type_name -> google.cloud.discoveryengine.v1beta.ImportErrorConfig
	0,  // 15: google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.reconciliation_mode:type_name -> google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.ReconciliationMode
	13, // 16: google.cloud.discoveryengine.v1beta.ImportDocumentsResponse.error_samples:type_name -> google.rpc.Status
	3,  // 17: google.cloud.discoveryengine.v1beta.ImportDocumentsResponse.error_config:type_name -> google.cloud.discoveryengine.v1beta.ImportErrorConfig
	15, // 18: google.cloud.discoveryengine.v1beta.ImportUserEventsRequest.InlineSource.user_events:type_name -> google.cloud.discoveryengine.v1beta.UserEvent
	16, // 19: google.cloud.discoveryengine.v1beta.ImportDocumentsRequest.InlineSource.documents:type_name -> google.cloud.discoveryengine.v1beta.Document
	20, // [20:20] is the sub-list for method output_type
	20, // [20:20] is the sub-list for method input_type
	20, // [20:20] is the sub-list for extension type_name
	20, // [20:20] is the sub-list for extension extendee
	0,  // [0:20] is the sub-list for field type_name
}

func init() { file_google_cloud_discoveryengine_v1beta_import_config_proto_init() }
func file_google_cloud_discoveryengine_v1beta_import_config_proto_init() {
	if File_google_cloud_discoveryengine_v1beta_import_config_proto != nil {
		return
	}
	file_google_cloud_discoveryengine_v1beta_document_proto_init()
	file_google_cloud_discoveryengine_v1beta_user_event_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_discoveryengine_v1beta_import_config_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GcsSource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1beta_import_config_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BigQuerySource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1beta_import_config_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImportErrorConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1beta_import_config_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImportUserEventsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1beta_import_config_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImportUserEventsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1beta_import_config_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImportUserEventsMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1beta_import_config_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImportDocumentsMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1beta_import_config_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImportDocumentsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1beta_import_config_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImportDocumentsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1beta_import_config_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImportUserEventsRequest_InlineSource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1beta_import_config_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImportDocumentsRequest_InlineSource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_discoveryengine_v1beta_import_config_proto_msgTypes[1].OneofWrappers = []interface{}{
		(*BigQuerySource_PartitionDate)(nil),
	}
	file_google_cloud_discoveryengine_v1beta_import_config_proto_msgTypes[2].OneofWrappers = []interface{}{
		(*ImportErrorConfig_GcsPrefix)(nil),
	}
	file_google_cloud_discoveryengine_v1beta_import_config_proto_msgTypes[3].OneofWrappers = []interface{}{
		(*ImportUserEventsRequest_InlineSource_)(nil),
		(*ImportUserEventsRequest_GcsSource)(nil),
		(*ImportUserEventsRequest_BigquerySource)(nil),
	}
	file_google_cloud_discoveryengine_v1beta_import_config_proto_msgTypes[7].OneofWrappers = []interface{}{
		(*ImportDocumentsRequest_InlineSource_)(nil),
		(*ImportDocumentsRequest_GcsSource)(nil),
		(*ImportDocumentsRequest_BigquerySource)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_discoveryengine_v1beta_import_config_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   11,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_discoveryengine_v1beta_import_config_proto_goTypes,
		DependencyIndexes: file_google_cloud_discoveryengine_v1beta_import_config_proto_depIdxs,
		EnumInfos:         file_google_cloud_discoveryengine_v1beta_import_config_proto_enumTypes,
		MessageInfos:      file_google_cloud_discoveryengine_v1beta_import_config_proto_msgTypes,
	}.Build()
	File_google_cloud_discoveryengine_v1beta_import_config_proto = out.File
	file_google_cloud_discoveryengine_v1beta_import_config_proto_rawDesc = nil
	file_google_cloud_discoveryengine_v1beta_import_config_proto_goTypes = nil
	file_google_cloud_discoveryengine_v1beta_import_config_proto_depIdxs = nil
}
