/*-
 *
 *             Coda: an Experimental Distributed File System
 *                              Release 3.1
 *
 *           Copyright (c) 1987-1998 Carnegie Mellon University
 *                          All Rights Reserved
 *
 * Permission  to  use, copy, modify and distribute this software and its
 * documentation is hereby granted,  provided  that  both  the  copyright
 * notice  and  this  permission  notice  appear  in  all  copies  of the
 * software, derivative works or  modified  versions,  and  any  portions
 * thereof, and that both notices appear in supporting documentation, and
 * that credit is given to Carnegie Mellon University  in  all  documents
 * and publicity pertaining to direct or indirect use of this code or its
 * derivatives.
 *
 * CODA IS AN EXPERIMENTAL SOFTWARE SYSTEM AND IS  KNOWN  TO  HAVE  BUGS,
 * SOME  OF  WHICH MAY HAVE SERIOUS CONSEQUENCES.  CARNEGIE MELLON ALLOWS
 * FREE USE OF THIS SOFTWARE IN ITS "AS IS" CONDITION.   CARNEGIE  MELLON
 * DISCLAIMS  ANY  LIABILITY  OF  ANY  KIND  FOR  ANY  DAMAGES WHATSOEVER
 * RESULTING DIRECTLY OR INDIRECTLY FROM THE USE OF THIS SOFTWARE  OR  OF
 * ANY DERIVATIVE WORK.
 *
 * Carnegie  Mellon  encourages  users  of  this  software  to return any
 * improvements or extensions that  they  make,  and  to  grant  Carnegie
 * Mellon the rights to redistribute these changes without encumbrance.
 *
 * 	@(#) src/sys/cfs/coda_vfsops.h,v 1.1.1.1 1998/08/29 21:14:52 rvb Exp $
 * $FreeBSD: stable/8/sys/fs/coda/coda_vfsops.h 208702 2010-06-01 14:29:26Z rwatson $
 */

#ifndef _CODA_VFSOPS_H_
#define	_CODA_VFSOPS_H_

/*
 * cfid structure:
 *
 * This overlays the fid structure (see vfs.h); only used below and will
 * probably go away.
 */
struct cfid {
	u_short	cfid_len;
	u_short	padding;
	struct CodaFid	cfid_fid;
};

struct mbuf;
struct mount;
int	coda_vfsopstats_init(void);
int	coda_fhtovp(struct mount *, struct fid *, struct mbuf *,
	    struct vnode **, int *, struct ucred **);

vfs_mount_t	coda_mount;
vfs_unmount_t	coda_unmount;
vfs_root_t	coda_root;
vfs_statfs_t	coda_statfs;
vfs_sync_t	coda_sync;

#endif /* !_CODA_VFSOPS_H_ */
