.\" Man page for manpath
.\"
.\" Copyright (c) 1990, 1991, John W. Eaton.
.\"
.\" You may distribute under the terms of the GNU General Public
.\" License as specified in the README file that comes with the man 1.0
.\" distribution.
.\"
.\" John W. Eaton
.\" jwe@che.utexas.edu
.\" Department of Chemical Engineering
.\" The University of Texas at Austin
.\" Austin, Texas  78712
.\"
.\" $FreeBSD: stable/4/gnu/usr.bin/man/manpath/manpath.man 84469 2001-10-04 13:02:24Z ru $
.Dd August 16, 1999
.Dt MANPATH 1
.Os
.Sh NAME
.Nm manpath
.Nd determine user's search path for man pages
.Sh SYNOPSIS
.Nm
.Op Fl dLq
.Sh DESCRIPTION
.Nm Manpath
tries to determine the user's manpath from a set of system
defaults and the user's
.Ev PATH ,
echoing the result to the standard output.
Warnings and errors are written to the standard error.
If a directory in the user's path is not listed in the
.Pa %manpath_config_file%
file,
.Nm
looks for the subdirectories
.Pa man
or
.Pa MAN .
If they exist, they are added to the search path.
If they do not exist, but the directory ends in
.Pa /bin ,
.Nm
replaces
.Pa /bin
with
.Pa /man
and checks if that directory exists.
If it exists, it is added to the search path.
.Pp
.Nm Manpath
is used by
.Xr man 1
to determine the search path, so users normally don't need to set the
.Ev MANPATH
environment variable directly.
.Pp
The options are as follows:
.Bl -tag -width Fl
.It Fl d
Output additional debug information.
.It Fl L
Output man locales list (if exist).
.It Fl q
Operate quietly.
Only echo the final result.
.El
.Sh ENVIRONMENT
.Bl -tag -width MANLOCALES -compact
.It Ev MANPATH
If
.Ev MANPATH
is set,
.Nm
echoes its value on the standard output and issues a warning on the
standard error.
.It Ev MANLOCALES
If
.Ev MANLOCALES
is set and
.Fl L
option is set,
.Nm
echoes its value on the standard output and issues a warning on the
standard error.
.El
.Sh FILES
.Bl -tag -width %manpath_config_file% -compact
.It Pa %manpath_config_file%
System configuration file.
.El
.Sh SEE ALSO
.Xr apropos 1 ,
.Xr man 1 ,
.Xr whatis 1
.Sh BUGS
None known.
