--- src/libpki/prqp/prqp_asn1.h.orig	2023-06-27 08:58:28.483798000 +0200
+++ src/libpki/prqp/prqp_asn1.h	2023-06-27 13:17:52.673161000 +0200
@@ -73,8 +73,13 @@
 // DECLARE_ASN1_SET_OF(CERT_IDENTIFIER)
 
 DECLARE_ASN1_FUNCTIONS(CERT_IDENTIFIER)
-CERT_IDENTIFIER *CERT_IDENTIFIER_dup( CERT_IDENTIFIER *cid );
 
+#if OPENSSL_VERSION_NUMBER >= 0x30000000L
+CERT_IDENTIFIER *CERT_IDENTIFIER_dup ( const CERT_IDENTIFIER *cid );
+#else
+CERT_IDENTIFIER *CERT_IDENTIFIER_dup ( CERT_IDENTIFIER *cid );
+#endif
+
 /* ResourceIdentifier ::= SEQUENCE {
  *      resourceId      OBJECT IDENTIFIER,
  *      version         [0] INTEGER     OPTIONAL }
@@ -128,7 +133,11 @@
 
 DECLARE_ASN1_FUNCTIONS(PKI_PRQP_REQ)
 
+#if OPENSSL_VERSION_NUMBER >= 0x30000000L
+PKI_PRQP_REQ * PKI_PRQP_REQ_dup ( const PKI_PRQP_REQ *x );
+#else
 PKI_PRQP_REQ * PKI_PRQP_REQ_dup ( PKI_PRQP_REQ *x );
+#endif
 
 /* PKIStatus ::= INTEGER {
  * 	ok		{0},
@@ -207,7 +216,11 @@
 DECLARE_ASN1_FUNCTIONS(RESOURCE_RESPONSE_TOKEN)
 DECLARE_STACK_OF(RESOURCE_RESPONSE_TOKEN)
 
+#if OPENSSL_VERSION_NUMBER >= 0x30000000L
+RESOURCE_RESPONSE_TOKEN * RESOURCE_RESPONSE_TOKEN_dup ( const RESOURCE_RESPONSE_TOKEN * p );
+#else
 RESOURCE_RESPONSE_TOKEN * RESOURCE_RESPONSE_TOKEN_dup ( RESOURCE_RESPONSE_TOKEN * p );
+#endif
 
 /* TBSRespData ::= {
  *	version		INTEGER { v(1) },
@@ -239,7 +252,11 @@
 
 DECLARE_ASN1_FUNCTIONS(PKI_PRQP_RESP)
 
+#if OPENSSL_VERSION_NUMBER >= 0x30000000L
+PKI_PRQP_RESP * PKI_PRQP_RESP_dup ( const PKI_PRQP_RESP *x );
+#else
 PKI_PRQP_RESP * PKI_PRQP_RESP_dup ( PKI_PRQP_RESP *x );
+#endif
 
 /* Crypto Functionality */
 /*
