#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['myst_parser',
 'myst_parser.config',
 'myst_parser.mdit_to_docutils',
 'myst_parser.parsers',
 'myst_parser.sphinx_ext']

package_data = \
{'': ['*']}

install_requires = \
['docutils>=0.15,<0.20',
 'jinja2',
 'markdown-it-py>=1.0.0,<3.0.0',
 'mdit-py-plugins~=0.3.1',
 'pyyaml',
 'sphinx>=4,<6',
 'typing-extensions']

extras_require = \
{'code_style': ['pre-commit~=2.12'],
 'linkify': ['linkify-it-py~=1.0'],
 'rtd': ['ipython',
         'sphinx-book-theme',
         'sphinx-design',
         'sphinxext-rediraffe~=0.2.7',
         'sphinxcontrib.mermaid~=0.7.1',
         'sphinxext-opengraph~=0.6.3'],
 'testing': ['beautifulsoup4',
             'coverage[toml]',
             'pytest>=6,<7',
             'pytest-cov',
             'pytest-regressions',
             'pytest-param-files~=0.3.4',
             'sphinx-pytest',
             'sphinx<5.2']}

entry_points = \
{'console_scripts': ['myst-anchors = myst_parser.cli:print_anchors',
                     'myst-docutils-html = '
                     'myst_parser.parsers.docutils_:cli_html',
                     'myst-docutils-html5 = '
                     'myst_parser.parsers.docutils_:cli_html5',
                     'myst-docutils-latex = '
                     'myst_parser.parsers.docutils_:cli_latex',
                     'myst-docutils-pseudoxml = '
                     'myst_parser.parsers.docutils_:cli_pseudoxml',
                     'myst-docutils-xml = '
                     'myst_parser.parsers.docutils_:cli_xml']}

setup(name='myst-parser',
      version='%%PORTVERSION%%',
      description='An extended commonmark compliant parser, with bridges to docutils & sphinx.',
      author=None,
      author_email='Chris Sewell <chrisj_sewell@hotmail.com>',
      url=None,
      packages=packages,
      package_data=package_data,
      install_requires=install_requires,
      extras_require=extras_require,
      entry_points=entry_points,
      python_requires='>=3.7',
     )
