#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['asdf_transform_schemas']

package_data = \
{'': ['*']}

package_dir = \
{'': 'src'}

install_requires = \
['asdf-standard >= 1.0.1']

extras_require = \
{':python_version<"3.9"': ['importlib_resources >= 3'],
 'docs': ['toml',
          'sphinx',
          'sphinx-asdf >= 0.1.3',
          'sphinx-astropy',
          'astropy >= 5.0.4',
          'graphviz',
          'matplotlib',
          'docutils',
          'sphinx-rtd-theme'],
 'test': ['asdf >= 2.8.0', 'asdf-astropy', 'scipy', 'pytest']}

entry_points = \
{'asdf.resource_mappings': ['asdf_transform_schemas = '
                            'asdf_transform_schemas.integration:get_resource_mappings']}

setup(name='asdf_transform_schemas',
      version='%%PORTVERSION%%',
      description='ASDF schemas for transforms',
      author=None,
      author_email='The ASDF Developers <help@stsci.edu>',
      url=None,
      packages=packages,
      package_data=package_data,
      package_dir=package_dir,
      install_requires=install_requires,
      extras_require=extras_require,
      entry_points=entry_points,
      python_requires='>=3.8',
     )
