#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['markdown_it',
 'markdown_it.cli',
 'markdown_it.common',
 'markdown_it.helpers',
 'markdown_it.presets',
 'markdown_it.rules_block',
 'markdown_it.rules_core',
 'markdown_it.rules_inline']

package_data = \
{'': ['*']}

install_requires = \
['mdurl~=0.1']

extras_require = \
{":python_version<'3.8'": ['typing_extensions>=3.7.4'],
 'benchmarking': ['psutil', 'pytest', 'pytest-benchmark~=3.2'],
 'code_style': ['pre-commit==2.6'],
 'compare': ['commonmark~=0.9.1',
             'markdown~=3.3.6',
             'mistletoe~=0.8.1',
             'mistune~=2.0.2',
             'panflute~=2.1.3'],
 'linkify': ['linkify-it-py~=1.0'],
 'plugins': ['mdit-py-plugins'],
 'profiling': ['gprof2dot'],
 'rtd': ['attrs',
         'myst-parser',
         'pyyaml',
         'sphinx',
         'sphinx-copybutton',
         'sphinx-design',
         'sphinx_book_theme'],
 'testing': ['coverage', 'pytest', 'pytest-cov', 'pytest-regressions']}

entry_points = \
{'console_scripts': ['markdown-it = markdown_it.cli.parse:main']}

setup(name='markdown-it-py',
      version='%%PORTVERSION%%',
      description='Python port of markdown-it. Markdown parsing, done right!',
      author=None,
      author_email='Chris Sewell <chrisj_sewell@hotmail.com>',
      url=None,
      packages=packages,
      package_data=package_data,
      install_requires=install_requires,
      extras_require=extras_require,
      entry_points=entry_points,
      python_requires='>=3.7',
     )
