--- third_party/skia/src/ports/SkFontHost_FreeType_common.cpp.orig	2021-08-19 14:15:44 UTC
+++ third_party/skia/src/ports/SkFontHost_FreeType_common.cpp
@@ -712,7 +712,11 @@ void colrv1_draw_paint(SkCanvas* canvas,
             canvas->drawPaint(colrPaint);
             break;
         }
+#if FREETYPE_MAJOR > 2 || (FREETYPE_MAJOR == 2 && FREETYPE_MINOR >= 11)
+        case FT_COLR_PAINTFORMAT_TRANSFORM:
+#else
         case FT_COLR_PAINTFORMAT_TRANSFORMED:
+#endif
         case FT_COLR_PAINTFORMAT_TRANSLATE:
         case FT_COLR_PAINTFORMAT_ROTATE:
         case FT_COLR_PAINTFORMAT_SKEW:
@@ -759,10 +763,17 @@ void colrv1_transform(SkCanvas* canvas, FT_Face face, 
     SkMatrix transform;
 
     switch (colrv1_paint.format) {
+#if FREETYPE_MAJOR > 2 || (FREETYPE_MAJOR == 2 && FREETYPE_MINOR >= 11)
+        case FT_COLR_PAINTFORMAT_TRANSFORM: {
+            transform = ToSkMatrix(colrv1_paint.u.transform.affine);
+            break;
+        }
+#else
         case FT_COLR_PAINTFORMAT_TRANSFORMED: {
             transform = ToSkMatrix(colrv1_paint.u.transformed.affine);
             break;
         }
+#endif
         case FT_COLR_PAINTFORMAT_TRANSLATE: {
             transform = SkMatrix::Translate(
                 SkFixedToScalar(colrv1_paint.u.translate.dx),
@@ -880,10 +891,17 @@ bool colrv1_traverse_paint(SkCanvas* canvas,
             traverse_result = colrv1_start_glyph(canvas, palette, face, paint.u.colr_glyph.glyphID,
                                                  FT_COLOR_NO_ROOT_TRANSFORM);
             break;
+#if FREETYPE_MAJOR > 2 || (FREETYPE_MAJOR == 2 && FREETYPE_MINOR >= 11)
+        case FT_COLR_PAINTFORMAT_TRANSFORM:
+            colrv1_transform(canvas, face, paint);
+            traverse_result = colrv1_traverse_paint(canvas, palette, face,
+                                                    paint.u.transform.paint, visited_set);
+#else
         case FT_COLR_PAINTFORMAT_TRANSFORMED:
             colrv1_transform(canvas, face, paint);
             traverse_result = colrv1_traverse_paint(canvas, palette, face,
                                                     paint.u.transformed.paint, visited_set);
+#endif
             break;
         case FT_COLR_PAINTFORMAT_TRANSLATE:
             colrv1_transform(canvas, face, paint);
