type int = Int.int
functor MLBLexFun (structure Tokens : MLB_TOKENS)=
   struct
    structure UserDeclarations =
      struct
(* Copyright (C) 2004-2006 Henry Cejtin, Matthew Fluet, Suresh
 *    Jagannathan, and Stephen Weeks.
 *
 * MLton is released under a BSD-style license.
 * See the file MLton-LICENSE for details.
 *)

type int = Int.t

type svalue = Tokens.svalue
type pos = SourcePos.t
type lexresult = (svalue, pos) Tokens.token
type lexarg = {source: Source.t}
type arg = lexarg
type ('a,'b) token = ('a,'b) Tokens.token

val charlist: string list ref = ref []
val colNum: int ref = ref 0
val commentLevel: int ref = ref 0
val commentStart = ref SourcePos.bogus
val lineFile: File.t ref = ref ""
val lineNum: int ref = ref 0
val stringStart = ref SourcePos.bogus

fun lineDirective (source, file, yypos) =
   Source.lineDirective (source, file,
                         {lineNum = !lineNum,
                          lineStart = yypos - !colNum})
fun addString (s: string) = charlist := s :: (!charlist)
fun addChar (c: char) = addString (String.fromChar c)

fun inc (ri as ref (i: int)) = (ri := i + 1)
fun dec (ri as ref (i: int)) = (ri := i-1)

fun error (source, left, right, msg) = 
   Control.errorStr (Region.make {left = Source.getPos (source, left),
                                  right = Source.getPos (source, right)},
                     msg)

fun stringError (source, right, msg) =
   Control.errorStr (Region.make {left = !stringStart,
                                  right = Source.getPos (source, right)},
                     msg)

val eof: lexarg -> lexresult =
   fn {source, ...} =>
   let
      val pos = Source.lineStart source
      val _ =
         if !commentLevel > 0
            then Control.errorStr (Region.make {left = !commentStart,
                                                right = pos},
                                   "unclosed comment")
         else ()
   in
      Tokens.EOF (pos, pos)
   end

val size = String.size

fun tok (t, s, l, r) =
   let
      val l = Source.getPos (s, l)
      val r = Source.getPos (s, r)
      val _ =
         if true
            then ()
         else
            print (concat ["tok (",
                           SourcePos.toString l,
                           ", " ,
                           SourcePos.toString r,
                           ")\n"])
   in
      t (l, r)
   end

fun tok' (t, x, s, l) = tok (fn (l, r) => t (x, l, r), s, l, l + size x)

end (* end of user routines *)
exception LexError (* raised if illegal leaf action tried *)
structure Internal =
	struct

datatype yyfinstate = N of int
type statedata = {fin : yyfinstate list, trans: string}
(* transition & final state table *)
val tab = let
val s = [ 
 (0, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (1, 
"\017\017\017\017\017\017\017\017\017\127\130\017\127\129\017\017\
\\017\017\017\017\017\017\017\017\017\017\017\017\017\017\017\017\
\\127\017\126\017\125\017\017\017\117\017\017\017\116\095\115\096\
\\095\095\095\095\095\095\095\095\095\095\017\094\017\093\017\017\
\\017\018\018\018\018\018\018\018\018\018\018\018\018\018\018\018\
\\018\018\018\018\018\018\018\018\018\018\018\017\017\017\017\088\
\\017\084\079\018\018\076\069\018\018\067\018\018\060\018\018\056\
\\018\018\018\039\018\018\018\018\018\018\018\017\017\017\017\017\
\\017"
),
 (3, 
"\131\131\131\131\131\131\131\131\131\131\136\131\131\131\131\131\
\\131\131\131\131\131\131\131\131\131\131\131\131\131\131\131\131\
\\131\131\131\131\131\131\131\131\134\131\132\131\131\131\131\131\
\\131\131\131\131\131\131\131\131\131\131\131\131\131\131\131\131\
\\131\131\131\131\131\131\131\131\131\131\131\131\131\131\131\131\
\\131\131\131\131\131\131\131\131\131\131\131\131\131\131\131\131\
\\131\131\131\131\131\131\131\131\131\131\131\131\131\131\131\131\
\\131\131\131\131\131\131\131\131\131\131\131\131\131\131\131\131\
\\131"
),
 (5, 
"\137\137\137\137\137\137\137\137\137\137\165\137\137\164\137\137\
\\137\137\137\137\137\137\137\137\137\137\137\137\137\137\137\137\
\\138\138\163\138\138\138\138\138\138\138\138\138\138\138\138\138\
\\138\138\138\138\138\138\138\138\138\138\138\138\138\138\138\138\
\\138\138\138\138\138\138\138\138\138\138\138\138\138\138\138\138\
\\138\138\138\138\138\138\138\138\138\138\138\138\139\138\138\138\
\\138\138\138\138\138\138\138\138\138\138\138\138\138\138\138\138\
\\138\138\138\138\138\138\138\138\138\138\138\138\138\138\138\137\
\\137"
),
 (7, 
"\166\166\166\166\166\166\166\166\166\168\171\166\168\170\166\166\
\\166\166\166\166\166\166\166\166\166\166\166\166\166\166\166\166\
\\168\166\166\166\166\166\166\166\166\166\166\166\166\166\166\166\
\\166\166\166\166\166\166\166\166\166\166\166\166\166\166\166\166\
\\166\166\166\166\166\166\166\166\166\166\166\166\166\166\166\166\
\\166\166\166\166\166\166\166\166\166\166\166\166\167\166\166\166\
\\166\166\166\166\166\166\166\166\166\166\166\166\166\166\166\166\
\\166\166\166\166\166\166\166\166\166\166\166\166\166\166\166\166\
\\166"
),
 (9, 
"\172\172\172\172\172\172\172\172\172\172\000\172\172\172\172\172\
\\172\172\172\172\172\172\172\172\172\172\172\172\172\172\172\172\
\\172\172\172\172\172\172\172\172\172\172\175\172\172\172\172\172\
\\173\173\173\173\173\173\173\173\173\173\172\172\172\172\172\172\
\\172\172\172\172\172\172\172\172\172\172\172\172\172\172\172\172\
\\172\172\172\172\172\172\172\172\172\172\172\172\172\172\172\172\
\\172\172\172\172\172\172\172\172\172\172\172\172\172\172\172\172\
\\172\172\172\172\172\172\172\172\172\172\172\172\172\172\172\172\
\\172"
),
 (11, 
"\177\177\177\177\177\177\177\177\177\177\000\177\177\177\177\177\
\\177\177\177\177\177\177\177\177\177\177\177\177\177\177\177\177\
\\177\177\177\177\177\177\177\177\177\177\177\177\177\177\180\177\
\\178\178\178\178\178\178\178\178\178\178\177\177\177\177\177\177\
\\177\177\177\177\177\177\177\177\177\177\177\177\177\177\177\177\
\\177\177\177\177\177\177\177\177\177\177\177\177\177\177\177\177\
\\177\177\177\177\177\177\177\177\177\177\177\177\177\177\177\177\
\\177\177\177\177\177\177\177\177\177\177\177\177\177\177\177\177\
\\177"
),
 (13, 
"\172\172\172\172\172\172\172\172\172\184\000\172\184\172\172\172\
\\172\172\172\172\172\172\172\172\172\172\172\172\172\172\172\172\
\\184\172\183\172\172\172\172\172\172\172\181\172\172\172\172\172\
\\172\172\172\172\172\172\172\172\172\172\172\172\172\172\172\172\
\\172\172\172\172\172\172\172\172\172\172\172\172\172\172\172\172\
\\172\172\172\172\172\172\172\172\172\172\172\172\172\172\172\172\
\\172\172\172\172\172\172\172\172\172\172\172\172\172\172\172\172\
\\172\172\172\172\172\172\172\172\172\172\172\172\172\172\172\172\
\\172"
),
 (15, 
"\187\187\187\187\187\187\187\187\187\187\188\187\187\187\187\187\
\\187\187\187\187\187\187\187\187\187\187\187\187\187\187\187\187\
\\187\187\191\187\187\187\187\187\187\187\189\187\187\187\187\187\
\\187\187\187\187\187\187\187\187\187\187\187\187\187\187\187\187\
\\187\187\187\187\187\187\187\187\187\187\187\187\187\187\187\187\
\\187\187\187\187\187\187\187\187\187\187\187\187\187\187\187\187\
\\187\187\187\187\187\187\187\187\187\187\187\187\187\187\187\187\
\\187\187\187\187\187\187\187\187\187\187\187\187\187\187\187\187\
\\187"
),
 (18, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\030\000\000\038\000\000\000\000\000\021\022\020\
\\019\019\019\019\019\019\019\019\019\019\000\000\000\000\000\000\
\\000\019\019\019\019\019\019\019\019\019\019\019\019\019\019\019\
\\019\019\019\019\019\019\019\019\019\019\019\000\000\000\000\019\
\\000\019\019\019\019\019\019\019\019\019\019\019\019\019\019\019\
\\019\019\019\019\019\019\019\019\019\019\019\000\000\000\000\000\
\\000"
),
 (20, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\035\000\000\000\000\000\000\000\000\021\033\000\
\\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\000\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\021\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\
\\000"
),
 (21, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\030\000\000\000\000\000\000\000\000\021\022\020\
\\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\000\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\021\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\
\\000"
),
 (22, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\027\000\000\000\000\000\000\000\000\023\000\000\
\\023\023\023\023\023\023\023\023\023\023\000\000\000\000\000\000\
\\000\023\023\023\023\023\023\023\023\023\023\023\023\023\023\023\
\\023\023\023\023\023\023\023\023\023\023\023\000\000\000\000\023\
\\000\023\023\023\023\023\023\023\023\023\023\023\023\023\023\023\
\\023\023\023\023\023\023\023\023\023\023\023\000\000\000\000\000\
\\000"
),
 (23, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\024\000\000\000\000\000\000\000\000\023\022\020\
\\023\023\023\023\023\023\023\023\023\023\000\000\000\000\000\000\
\\000\023\023\023\023\023\023\023\023\023\023\023\023\023\023\023\
\\023\023\023\023\023\023\023\023\023\023\023\000\000\000\000\023\
\\000\023\023\023\023\023\023\023\023\023\023\023\023\023\023\023\
\\023\023\023\023\023\023\023\023\023\023\023\000\000\000\000\000\
\\000"
),
 (24, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\025\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (25, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\026\026\026\026\026\026\026\026\026\026\026\026\026\026\026\
\\026\026\026\026\026\026\026\026\026\026\026\000\000\000\000\026\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (26, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\023\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\026\026\026\026\026\026\026\026\026\026\026\026\026\026\026\
\\026\026\026\026\026\026\026\026\026\026\026\000\000\000\000\026\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (27, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\028\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (28, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\029\029\029\029\029\029\029\029\029\029\029\029\029\029\029\
\\029\029\029\029\029\029\029\029\029\029\029\000\000\000\000\029\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (29, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\023\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\029\029\029\029\029\029\029\029\029\029\029\029\029\029\029\
\\029\029\029\029\029\029\029\029\029\029\029\000\000\000\000\029\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (30, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\031\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (31, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\032\032\032\032\032\032\032\032\032\032\032\032\032\032\032\
\\032\032\032\032\032\032\032\032\032\032\032\000\000\000\000\032\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (32, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\021\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\032\032\032\032\032\032\032\032\032\032\032\032\032\032\032\
\\032\032\032\032\032\032\032\032\032\032\032\000\000\000\000\032\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (33, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\034\020\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (34, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\020\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (35, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\036\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (36, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\037\037\037\037\037\037\037\037\037\037\037\037\037\037\037\
\\037\037\037\037\037\037\037\037\037\037\037\000\000\000\000\037\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (37, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\021\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\037\037\037\037\037\037\037\037\037\037\037\037\037\037\037\
\\037\037\037\037\037\037\037\037\037\037\037\000\000\000\000\037\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (38, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\038\000\000\000\000\000\000\000\000\
\\038\038\038\038\038\038\038\038\038\038\000\000\000\000\000\000\
\\000\038\038\038\038\038\038\038\038\038\038\038\038\038\038\038\
\\038\038\038\038\038\038\038\038\038\038\038\000\000\000\000\038\
\\000\038\038\038\038\038\038\038\038\038\038\038\038\038\038\038\
\\038\038\038\038\038\038\038\038\038\038\038\000\000\000\000\000\
\\000"
),
 (39, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\030\000\000\038\000\000\000\000\000\021\022\020\
\\019\019\019\019\019\019\019\019\019\019\000\000\000\000\000\000\
\\000\019\019\019\019\019\019\019\019\019\019\019\019\019\019\019\
\\019\019\019\019\019\019\019\019\019\019\019\000\000\000\000\019\
\\000\019\019\019\019\019\019\019\019\048\019\019\019\019\019\019\
\\019\019\019\019\040\019\019\019\019\019\019\000\000\000\000\000\
\\000"
),
 (40, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\030\000\000\038\000\000\000\000\000\021\022\020\
\\019\019\019\019\019\019\019\019\019\019\000\000\000\000\000\000\
\\000\019\019\019\019\019\019\019\019\019\019\019\019\019\019\019\
\\019\019\019\019\019\019\019\019\019\019\019\000\000\000\000\019\
\\000\019\019\019\019\019\019\019\019\019\019\019\019\019\019\019\
\\019\019\041\019\019\019\019\019\019\019\019\000\000\000\000\000\
\\000"
),
 (41, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\030\000\000\038\000\000\000\000\000\021\022\020\
\\019\019\019\019\019\019\019\019\019\019\000\000\000\000\000\000\
\\000\019\019\019\019\019\019\019\019\019\019\019\019\019\019\019\
\\019\019\019\019\019\019\019\019\019\019\019\000\000\000\000\019\
\\000\019\019\019\019\019\019\019\019\019\019\019\019\019\019\019\
\\019\019\019\019\019\042\019\019\019\019\019\000\000\000\000\000\
\\000"
),
 (42, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\030\000\000\038\000\000\000\000\000\021\022\020\
\\019\019\019\019\019\019\019\019\019\019\000\000\000\000\000\000\
\\000\019\019\019\019\019\019\019\019\019\019\019\019\019\019\019\
\\019\019\019\019\019\019\019\019\019\019\019\000\000\000\000\019\
\\000\019\019\043\019\019\019\019\019\019\019\019\019\019\019\019\
\\019\019\019\019\019\019\019\019\019\019\019\000\000\000\000\000\
\\000"
),
 (43, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\030\000\000\038\000\000\000\000\000\021\022\020\
\\019\019\019\019\019\019\019\019\019\019\000\000\000\000\000\000\
\\000\019\019\019\019\019\019\019\019\019\019\019\019\019\019\019\
\\019\019\019\019\019\019\019\019\019\019\019\000\000\000\000\019\
\\000\019\019\019\019\019\019\019\019\019\019\019\019\019\019\019\
\\019\019\019\019\044\019\019\019\019\019\019\000\000\000\000\000\
\\000"
),
 (44, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\030\000\000\038\000\000\000\000\000\021\022\020\
\\019\019\019\019\019\019\019\019\019\019\000\000\000\000\000\000\
\\000\019\019\019\019\019\019\019\019\019\019\019\019\019\019\019\
\\019\019\019\019\019\019\019\019\019\019\019\000\000\000\000\019\
\\000\019\019\019\019\019\019\019\019\019\019\019\019\019\019\019\
\\019\019\019\019\019\045\019\019\019\019\019\000\000\000\000\000\
\\000"
),
 (45, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\030\000\000\038\000\000\000\000\000\021\022\020\
\\019\019\019\019\019\019\019\019\019\019\000\000\000\000\000\000\
\\000\019\019\019\019\019\019\019\019\019\019\019\019\019\019\019\
\\019\019\019\019\019\019\019\019\019\019\019\000\000\000\000\019\
\\000\019\019\019\019\019\019\019\019\019\019\019\019\019\019\019\
\\019\019\046\019\019\019\019\019\019\019\019\000\000\000\000\000\
\\000"
),
 (46, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\030\000\000\038\000\000\000\000\000\021\022\020\
\\019\019\019\019\019\019\019\019\019\019\000\000\000\000\000\000\
\\000\019\019\019\019\019\019\019\019\019\019\019\019\019\019\019\
\\019\019\019\019\019\019\019\019\019\019\019\000\000\000\000\019\
\\000\019\019\019\019\047\019\019\019\019\019\019\019\019\019\019\
\\019\019\019\019\019\019\019\019\019\019\019\000\000\000\000\000\
\\000"
),
 (48, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\030\000\000\038\000\000\000\000\000\021\022\020\
\\019\019\019\019\019\019\019\019\019\019\000\000\000\000\000\000\
\\000\019\019\019\019\019\019\019\019\019\019\019\019\019\019\019\
\\019\019\019\019\019\019\019\019\019\019\019\000\000\000\000\019\
\\000\019\019\019\019\019\019\049\019\019\019\019\019\019\019\019\
\\019\019\019\019\019\019\019\019\019\019\019\000\000\000\000\000\
\\000"
),
 (49, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\030\000\000\038\000\000\000\000\000\021\022\020\
\\019\019\019\019\019\019\019\019\019\019\000\000\000\000\000\000\
\\000\019\019\019\019\019\019\019\019\019\019\019\019\019\019\019\
\\019\019\019\019\019\019\019\019\019\019\019\000\000\000\000\019\
\\000\019\019\019\019\019\019\019\019\019\019\019\019\019\050\019\
\\019\019\019\019\019\019\019\019\019\019\019\000\000\000\000\000\
\\000"
),
 (50, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\030\000\000\038\000\000\000\000\000\021\022\020\
\\019\019\019\019\019\019\019\019\019\019\000\000\000\000\000\000\
\\000\019\019\019\019\019\019\019\019\019\019\019\019\019\019\019\
\\019\019\019\019\019\019\019\019\019\019\019\000\000\000\000\019\
\\000\051\019\019\019\019\019\019\019\019\019\019\019\019\019\019\
\\019\019\019\019\019\019\019\019\019\019\019\000\000\000\000\000\
\\000"
),
 (51, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\030\000\000\038\000\000\000\000\000\021\022\020\
\\019\019\019\019\019\019\019\019\019\019\000\000\000\000\000\000\
\\000\019\019\019\019\019\019\019\019\019\019\019\019\019\019\019\
\\019\019\019\019\019\019\019\019\019\019\019\000\000\000\000\019\
\\000\019\019\019\019\019\019\019\019\019\019\019\019\019\019\019\
\\019\019\019\019\052\019\019\019\019\019\019\000\000\000\000\000\
\\000"
),
 (52, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\030\000\000\038\000\000\000\000\000\021\022\020\
\\019\019\019\019\019\019\019\019\019\019\000\000\000\000\000\000\
\\000\019\019\019\019\019\019\019\019\019\019\019\019\019\019\019\
\\019\019\019\019\019\019\019\019\019\019\019\000\000\000\000\019\
\\000\019\019\019\019\019\019\019\019\019\019\019\019\019\019\019\
\\019\019\019\019\019\053\019\019\019\019\019\000\000\000\000\000\
\\000"
),
 (53, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\030\000\000\038\000\000\000\000\000\021\022\020\
\\019\019\019\019\019\019\019\019\019\019\000\000\000\000\000\000\
\\000\019\019\019\019\019\019\019\019\019\019\019\019\019\019\019\
\\019\019\019\019\019\019\019\019\019\019\019\000\000\000\000\019\
\\000\019\019\019\019\019\019\019\019\019\019\019\019\019\019\019\
\\019\019\054\019\019\019\019\019\019\019\019\000\000\000\000\000\
\\000"
),
 (54, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\030\000\000\038\000\000\000\000\000\021\022\020\
\\019\019\019\019\019\019\019\019\019\019\000\000\000\000\000\000\
\\000\019\019\019\019\019\019\019\019\019\019\019\019\019\019\019\
\\019\019\019\019\019\019\019\019\019\019\019\000\000\000\000\019\
\\000\019\019\019\019\055\019\019\019\019\019\019\019\019\019\019\
\\019\019\019\019\019\019\019\019\019\019\019\000\000\000\000\000\
\\000"
),
 (56, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\030\000\000\038\000\000\000\000\000\021\022\020\
\\019\019\019\019\019\019\019\019\019\019\000\000\000\000\000\000\
\\000\019\019\019\019\019\019\019\019\019\019\019\019\019\019\019\
\\019\019\019\019\019\019\019\019\019\019\019\000\000\000\000\019\
\\000\019\019\019\019\019\019\019\019\019\019\019\019\019\019\019\
\\057\019\019\019\019\019\019\019\019\019\019\000\000\000\000\000\
\\000"
),
 (57, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\030\000\000\038\000\000\000\000\000\021\022\020\
\\019\019\019\019\019\019\019\019\019\019\000\000\000\000\000\000\
\\000\019\019\019\019\019\019\019\019\019\019\019\019\019\019\019\
\\019\019\019\019\019\019\019\019\019\019\019\000\000\000\000\019\
\\000\019\019\019\019\058\019\019\019\019\019\019\019\019\019\019\
\\019\019\019\019\019\019\019\019\019\019\019\000\000\000\000\000\
\\000"
),
 (58, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\030\000\000\038\000\000\000\000\000\021\022\020\
\\019\019\019\019\019\019\019\019\019\019\000\000\000\000\000\000\
\\000\019\019\019\019\019\019\019\019\019\019\019\019\019\019\019\
\\019\019\019\019\019\019\019\019\019\019\019\000\000\000\000\019\
\\000\019\019\019\019\019\019\019\019\019\019\019\019\019\059\019\
\\019\019\019\019\019\019\019\019\019\019\019\000\000\000\000\000\
\\000"
),
 (60, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\030\000\000\038\000\000\000\000\000\021\022\020\
\\019\019\019\019\019\019\019\019\019\019\000\000\000\000\000\000\
\\000\019\019\019\019\019\019\019\019\019\019\019\019\019\019\019\
\\019\019\019\019\019\019\019\019\019\019\019\000\000\000\000\019\
\\000\019\019\019\019\065\019\019\019\019\019\019\019\019\019\061\
\\019\019\019\019\019\019\019\019\019\019\019\000\000\000\000\000\
\\000"
),
 (61, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\030\000\000\038\000\000\000\000\000\021\022\020\
\\019\019\019\019\019\019\019\019\019\019\000\000\000\000\000\000\
\\000\019\019\019\019\019\019\019\019\019\019\019\019\019\019\019\
\\019\019\019\019\019\019\019\019\019\019\019\000\000\000\000\019\
\\000\019\019\062\019\019\019\019\019\019\019\019\019\019\019\019\
\\019\019\019\019\019\019\019\019\019\019\019\000\000\000\000\000\
\\000"
),
 (62, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\030\000\000\038\000\000\000\000\000\021\022\020\
\\019\019\019\019\019\019\019\019\019\019\000\000\000\000\000\000\
\\000\019\019\019\019\019\019\019\019\019\019\019\019\019\019\019\
\\019\019\019\019\019\019\019\019\019\019\019\000\000\000\000\019\
\\000\063\019\019\019\019\019\019\019\019\019\019\019\019\019\019\
\\019\019\019\019\019\019\019\019\019\019\019\000\000\000\000\000\
\\000"
),
 (63, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\030\000\000\038\000\000\000\000\000\021\022\020\
\\019\019\019\019\019\019\019\019\019\019\000\000\000\000\000\000\
\\000\019\019\019\019\019\019\019\019\019\019\019\019\019\019\019\
\\019\019\019\019\019\019\019\019\019\019\019\000\000\000\000\019\
\\000\019\019\019\019\019\019\019\019\019\019\019\064\019\019\019\
\\019\019\019\019\019\019\019\019\019\019\019\000\000\000\000\000\
\\000"
),
 (65, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\030\000\000\038\000\000\000\000\000\021\022\020\
\\019\019\019\019\019\019\019\019\019\019\000\000\000\000\000\000\
\\000\019\019\019\019\019\019\019\019\019\019\019\019\019\019\019\
\\019\019\019\019\019\019\019\019\019\019\019\000\000\000\000\019\
\\000\019\019\019\019\019\019\019\019\019\019\019\019\019\019\019\
\\019\019\019\019\066\019\019\019\019\019\019\000\000\000\000\000\
\\000"
),
 (67, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\030\000\000\038\000\000\000\000\000\021\022\020\
\\019\019\019\019\019\019\019\019\019\019\000\000\000\000\000\000\
\\000\019\019\019\019\019\019\019\019\019\019\019\019\019\019\019\
\\019\019\019\019\019\019\019\019\019\019\019\000\000\000\000\019\
\\000\019\019\019\019\019\019\019\019\019\019\019\019\019\068\019\
\\019\019\019\019\019\019\019\019\019\019\019\000\000\000\000\000\
\\000"
),
 (69, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\030\000\000\038\000\000\000\000\000\021\022\020\
\\019\019\019\019\019\019\019\019\019\019\000\000\000\000\000\000\
\\000\019\019\019\019\019\019\019\019\019\019\019\019\019\019\019\
\\019\019\019\019\019\019\019\019\019\019\019\000\000\000\000\019\
\\000\019\019\019\019\019\019\019\019\019\019\019\019\019\019\019\
\\019\019\019\019\019\070\019\019\019\019\019\000\000\000\000\000\
\\000"
),
 (70, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\030\000\000\038\000\000\000\000\000\021\022\020\
\\019\019\019\019\019\019\019\019\019\019\000\000\000\000\000\000\
\\000\019\019\019\019\019\019\019\019\019\019\019\019\019\019\019\
\\019\019\019\019\019\019\019\019\019\019\019\000\000\000\000\019\
\\000\019\019\019\019\019\019\019\019\019\019\019\019\019\071\019\
\\019\019\019\019\019\019\019\019\019\019\019\000\000\000\000\000\
\\000"
),
 (71, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\030\000\000\038\000\000\000\000\000\021\022\020\
\\019\019\019\019\019\019\019\019\019\019\000\000\000\000\000\000\
\\000\019\019\019\019\019\019\019\019\019\019\019\019\019\019\019\
\\019\019\019\019\019\019\019\019\019\019\019\000\000\000\000\019\
\\000\019\019\072\019\019\019\019\019\019\019\019\019\019\019\019\
\\019\019\019\019\019\019\019\019\019\019\019\000\000\000\000\000\
\\000"
),
 (72, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\030\000\000\038\000\000\000\000\000\021\022\020\
\\019\019\019\019\019\019\019\019\019\019\000\000\000\000\000\000\
\\000\019\019\019\019\019\019\019\019\019\019\019\019\019\019\019\
\\019\019\019\019\019\019\019\019\019\019\019\000\000\000\000\019\
\\000\019\019\019\019\019\019\019\019\019\019\019\019\019\019\019\
\\019\019\019\019\073\019\019\019\019\019\019\000\000\000\000\000\
\\000"
),
 (73, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\030\000\000\038\000\000\000\000\000\021\022\020\
\\019\019\019\019\019\019\019\019\019\019\000\000\000\000\000\000\
\\000\019\019\019\019\019\019\019\019\019\019\019\019\019\019\019\
\\019\019\019\019\019\019\019\019\019\019\019\000\000\000\000\019\
\\000\019\019\019\019\019\019\019\019\019\019\019\019\019\019\074\
\\019\019\019\019\019\019\019\019\019\019\019\000\000\000\000\000\
\\000"
),
 (74, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\030\000\000\038\000\000\000\000\000\021\022\020\
\\019\019\019\019\019\019\019\019\019\019\000\000\000\000\000\000\
\\000\019\019\019\019\019\019\019\019\019\019\019\019\019\019\019\
\\019\019\019\019\019\019\019\019\019\019\019\000\000\000\000\019\
\\000\019\019\019\019\019\019\019\019\019\019\019\019\019\019\019\
\\019\019\075\019\019\019\019\019\019\019\019\000\000\000\000\000\
\\000"
),
 (76, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\030\000\000\038\000\000\000\000\000\021\022\020\
\\019\019\019\019\019\019\019\019\019\019\000\000\000\000\000\000\
\\000\019\019\019\019\019\019\019\019\019\019\019\019\019\019\019\
\\019\019\019\019\019\019\019\019\019\019\019\000\000\000\000\019\
\\000\019\019\019\019\019\019\019\019\019\019\019\019\019\077\019\
\\019\019\019\019\019\019\019\019\019\019\019\000\000\000\000\000\
\\000"
),
 (77, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\030\000\000\038\000\000\000\000\000\021\022\020\
\\019\019\019\019\019\019\019\019\019\019\000\000\000\000\000\000\
\\000\019\019\019\019\019\019\019\019\019\019\019\019\019\019\019\
\\019\019\019\019\019\019\019\019\019\019\019\000\000\000\000\019\
\\000\019\019\019\078\019\019\019\019\019\019\019\019\019\019\019\
\\019\019\019\019\019\019\019\019\019\019\019\000\000\000\000\000\
\\000"
),
 (79, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\030\000\000\038\000\000\000\000\000\021\022\020\
\\019\019\019\019\019\019\019\019\019\019\000\000\000\000\000\000\
\\000\019\019\019\019\019\019\019\019\019\019\019\019\019\019\019\
\\019\019\019\019\019\019\019\019\019\019\019\000\000\000\000\019\
\\000\080\019\019\019\019\019\019\019\019\019\019\019\019\019\019\
\\019\019\019\019\019\019\019\019\019\019\019\000\000\000\000\000\
\\000"
),
 (80, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\030\000\000\038\000\000\000\000\000\021\022\020\
\\019\019\019\019\019\019\019\019\019\019\000\000\000\000\000\000\
\\000\019\019\019\019\019\019\019\019\019\019\019\019\019\019\019\
\\019\019\019\019\019\019\019\019\019\019\019\000\000\000\000\019\
\\000\019\019\019\019\019\019\019\019\019\019\019\019\019\019\019\
\\019\019\019\081\019\019\019\019\019\019\019\000\000\000\000\000\
\\000"
),
 (81, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\030\000\000\038\000\000\000\000\000\021\022\020\
\\019\019\019\019\019\019\019\019\019\019\000\000\000\000\000\000\
\\000\019\019\019\019\019\019\019\019\019\019\019\019\019\019\019\
\\019\019\019\019\019\019\019\019\019\019\019\000\000\000\000\019\
\\000\019\019\019\019\019\019\019\019\082\019\019\019\019\019\019\
\\019\019\019\019\019\019\019\019\019\019\019\000\000\000\000\000\
\\000"
),
 (82, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\030\000\000\038\000\000\000\000\000\021\022\020\
\\019\019\019\019\019\019\019\019\019\019\000\000\000\000\000\000\
\\000\019\019\019\019\019\019\019\019\019\019\019\019\019\019\019\
\\019\019\019\019\019\019\019\019\019\019\019\000\000\000\000\019\
\\000\019\019\019\019\019\019\019\019\019\019\019\019\019\019\019\
\\019\019\019\083\019\019\019\019\019\019\019\000\000\000\000\000\
\\000"
),
 (84, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\030\000\000\038\000\000\000\000\000\021\022\020\
\\019\019\019\019\019\019\019\019\019\019\000\000\000\000\000\000\
\\000\019\019\019\019\019\019\019\019\019\019\019\019\019\019\019\
\\019\019\019\019\019\019\019\019\019\019\019\000\000\000\000\019\
\\000\019\019\019\019\019\019\019\019\019\019\019\019\019\085\019\
\\019\019\019\019\019\019\019\019\019\019\019\000\000\000\000\000\
\\000"
),
 (85, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\030\000\000\038\000\000\000\000\000\021\022\020\
\\019\019\019\019\019\019\019\019\019\019\000\000\000\000\000\000\
\\000\019\019\019\019\019\019\019\019\019\019\019\019\019\019\019\
\\019\019\019\019\019\019\019\019\019\019\019\000\000\000\000\019\
\\000\019\019\019\087\019\019\019\019\019\019\019\019\019\086\019\
\\019\019\019\019\019\019\019\019\019\019\019\000\000\000\000\000\
\\000"
),
 (88, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\030\000\000\000\000\000\000\000\000\021\022\020\
\\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\000\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\021\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\089\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\
\\000"
),
 (89, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\030\000\000\000\000\000\000\000\000\021\022\020\
\\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\000\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\021\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\090\021\021\021\021\021\021\021\021\000\000\000\000\000\
\\000"
),
 (90, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\030\000\000\000\000\000\000\000\000\021\022\020\
\\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\000\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\021\
\\000\021\021\021\021\021\021\021\021\091\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\
\\000"
),
 (91, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\030\000\000\000\000\000\000\000\000\021\022\020\
\\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\000\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\021\
\\000\021\021\021\021\021\021\021\021\021\021\021\021\092\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\
\\000"
),
 (96, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\101\000\000\000\000\000\000\000\000\097\099\000\
\\097\097\097\097\097\097\097\097\097\097\000\000\000\000\000\000\
\\000\097\097\097\097\097\097\097\097\097\097\097\097\097\097\097\
\\097\097\097\097\097\097\097\097\097\097\097\000\000\000\000\097\
\\000\097\097\097\097\097\097\097\097\097\097\097\097\097\097\097\
\\097\097\097\097\097\097\097\097\097\097\097\000\000\000\000\000\
\\000"
),
 (97, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\112\000\000\000\000\000\000\000\000\097\104\098\
\\097\097\097\097\097\097\097\097\097\097\000\000\000\000\000\000\
\\000\097\097\097\097\097\097\097\097\097\097\097\097\097\097\097\
\\097\097\097\097\097\097\097\097\097\097\097\000\000\000\000\097\
\\000\097\097\097\097\097\097\097\097\097\097\097\097\097\097\097\
\\097\097\097\097\097\097\097\097\097\097\097\000\000\000\000\000\
\\000"
),
 (99, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\100\098\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (100, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\098\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (101, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\102\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (102, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\103\103\103\103\103\103\103\103\103\103\103\103\103\103\103\
\\103\103\103\103\103\103\103\103\103\103\103\000\000\000\000\103\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (103, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\097\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\103\103\103\103\103\103\103\103\103\103\103\103\103\103\103\
\\103\103\103\103\103\103\103\103\103\103\103\000\000\000\000\103\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (104, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\109\000\000\000\000\000\000\000\000\105\000\000\
\\105\105\105\105\105\105\105\105\105\105\000\000\000\000\000\000\
\\000\105\105\105\105\105\105\105\105\105\105\105\105\105\105\105\
\\105\105\105\105\105\105\105\105\105\105\105\000\000\000\000\105\
\\000\105\105\105\105\105\105\105\105\105\105\105\105\105\105\105\
\\105\105\105\105\105\105\105\105\105\105\105\000\000\000\000\000\
\\000"
),
 (105, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\106\000\000\000\000\000\000\000\000\105\104\098\
\\105\105\105\105\105\105\105\105\105\105\000\000\000\000\000\000\
\\000\105\105\105\105\105\105\105\105\105\105\105\105\105\105\105\
\\105\105\105\105\105\105\105\105\105\105\105\000\000\000\000\105\
\\000\105\105\105\105\105\105\105\105\105\105\105\105\105\105\105\
\\105\105\105\105\105\105\105\105\105\105\105\000\000\000\000\000\
\\000"
),
 (106, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\107\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (107, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\108\108\108\108\108\108\108\108\108\108\108\108\108\108\108\
\\108\108\108\108\108\108\108\108\108\108\108\000\000\000\000\108\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (108, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\105\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\108\108\108\108\108\108\108\108\108\108\108\108\108\108\108\
\\108\108\108\108\108\108\108\108\108\108\108\000\000\000\000\108\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (109, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\110\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (110, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\111\111\111\111\111\111\111\111\111\111\111\111\111\111\111\
\\111\111\111\111\111\111\111\111\111\111\111\000\000\000\000\111\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (111, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\105\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\111\111\111\111\111\111\111\111\111\111\111\111\111\111\111\
\\111\111\111\111\111\111\111\111\111\111\111\000\000\000\000\111\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (112, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\113\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (113, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\114\114\114\114\114\114\114\114\114\114\114\114\114\114\114\
\\114\114\114\114\114\114\114\114\114\114\114\000\000\000\000\114\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (114, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\097\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\114\114\114\114\114\114\114\114\114\114\114\114\114\114\114\
\\114\114\114\114\114\114\114\114\114\114\114\000\000\000\000\114\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (117, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\118\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (118, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\119\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (119, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\120\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (120, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\121\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (121, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\122\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (122, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\123\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (123, 
"\000\000\000\000\000\000\000\000\000\124\000\000\124\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\124\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (127, 
"\000\000\000\000\000\000\000\000\000\128\000\000\128\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\128\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (129, 
"\000\000\000\000\000\000\000\000\000\000\130\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (132, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\133\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (134, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\135\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (139, 
"\000\000\000\000\000\000\000\000\000\160\162\000\160\161\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\160\000\159\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\156\156\156\156\156\156\156\156\156\156\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\155\000\152\000\
\\000\151\150\000\000\000\149\000\000\000\000\000\000\000\148\000\
\\000\000\147\000\146\141\140\000\000\000\000\000\000\000\000\000\
\\000"
),
 (141, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\142\142\142\142\142\142\142\142\142\142\000\000\000\000\000\000\
\\000\142\142\142\142\142\142\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\142\142\142\142\142\142\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (142, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\143\143\143\143\143\143\143\143\143\143\000\000\000\000\000\000\
\\000\143\143\143\143\143\143\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\143\143\143\143\143\143\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (143, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\144\144\144\144\144\144\144\144\144\144\000\000\000\000\000\000\
\\000\144\144\144\144\144\144\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\144\144\144\144\144\144\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (144, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\145\145\145\145\145\145\145\145\145\145\000\000\000\000\000\000\
\\000\145\145\145\145\145\145\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\145\145\145\145\145\145\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (152, 
"\153\153\153\153\153\153\153\153\153\153\000\153\153\153\153\153\
\\153\153\153\153\153\153\153\153\153\153\153\153\153\153\153\153\
\\153\153\153\153\153\153\153\153\153\153\153\153\153\153\153\153\
\\153\153\153\153\153\153\153\153\153\153\153\153\153\153\153\153\
\\154\154\154\154\154\154\154\154\154\154\154\154\154\154\154\154\
\\154\154\154\154\154\154\154\154\154\154\154\154\154\154\154\154\
\\153\153\153\153\153\153\153\153\153\153\153\153\153\153\153\153\
\\153\153\153\153\153\153\153\153\153\153\153\153\153\153\153\153\
\\153"
),
 (156, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\157\157\157\157\157\157\157\157\157\157\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (157, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\158\158\158\158\158\158\158\158\158\158\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (160, 
"\000\000\000\000\000\000\000\000\000\160\000\000\160\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\160\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (161, 
"\000\000\000\000\000\000\000\000\000\000\162\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (164, 
"\000\000\000\000\000\000\000\000\000\000\165\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (168, 
"\000\000\000\000\000\000\000\000\000\169\000\000\169\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\169\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (170, 
"\000\000\000\000\000\000\000\000\000\000\171\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (173, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\174\174\174\174\174\174\174\174\174\174\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (175, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\176\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (178, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\179\179\179\179\179\179\179\179\179\179\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (181, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\182\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (184, 
"\000\000\000\000\000\000\000\000\000\186\000\000\186\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\186\000\185\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (187, 
"\188\188\188\188\188\188\188\188\188\188\188\188\188\188\188\188\
\\188\188\188\188\188\188\188\188\188\188\188\188\188\188\188\188\
\\188\188\000\188\188\188\188\188\188\188\188\188\188\188\188\188\
\\188\188\188\188\188\188\188\188\188\188\188\188\188\188\188\188\
\\188\188\188\188\188\188\188\188\188\188\188\188\188\188\188\188\
\\188\188\188\188\188\188\188\188\188\188\188\188\188\188\188\188\
\\188\188\188\188\188\188\188\188\188\188\188\188\188\188\188\188\
\\188\188\188\188\188\188\188\188\188\188\188\188\188\188\188\188\
\\188"
),
 (189, 
"\188\188\188\188\188\188\188\188\188\188\188\188\188\188\188\188\
\\188\188\188\188\188\188\188\188\188\188\188\188\188\188\188\188\
\\188\188\000\188\188\188\188\188\188\190\188\188\188\188\188\188\
\\188\188\188\188\188\188\188\188\188\188\188\188\188\188\188\188\
\\188\188\188\188\188\188\188\188\188\188\188\188\188\188\188\188\
\\188\188\188\188\188\188\188\188\188\188\188\188\188\188\188\188\
\\188\188\188\188\188\188\188\188\188\188\188\188\188\188\188\188\
\\188\188\188\188\188\188\188\188\188\188\188\188\188\188\188\188\
\\188"
),
 (191, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\192\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (192, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\193\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
(0, "")]
fun f x = x 
val s = map f (rev (tl (rev s))) 
exception LexHackingError 
fun look ((j,x)::r, i) = if i = j then x else look(r, i) 
  | look ([], i) = raise LexHackingError
fun g {fin=x, trans=i} = {fin=x, trans=look(s,i)} 
in Vector.fromList(map g 
[{fin = [], trans = 0},
{fin = [(N 2)], trans = 1},
{fin = [(N 2)], trans = 1},
{fin = [], trans = 3},
{fin = [], trans = 3},
{fin = [], trans = 5},
{fin = [], trans = 5},
{fin = [(N 323)], trans = 7},
{fin = [(N 323)], trans = 7},
{fin = [], trans = 9},
{fin = [], trans = 9},
{fin = [], trans = 11},
{fin = [], trans = 11},
{fin = [], trans = 13},
{fin = [], trans = 13},
{fin = [(N 223)], trans = 15},
{fin = [(N 223)], trans = 15},
{fin = [(N 204)], trans = 0},
{fin = [(N 90),(N 185),(N 204)], trans = 18},
{fin = [(N 90),(N 185)], trans = 18},
{fin = [], trans = 20},
{fin = [(N 185)], trans = 21},
{fin = [], trans = 22},
{fin = [(N 185)], trans = 23},
{fin = [], trans = 24},
{fin = [], trans = 25},
{fin = [], trans = 26},
{fin = [], trans = 27},
{fin = [], trans = 28},
{fin = [], trans = 29},
{fin = [], trans = 30},
{fin = [], trans = 31},
{fin = [], trans = 32},
{fin = [], trans = 33},
{fin = [], trans = 34},
{fin = [], trans = 35},
{fin = [], trans = 36},
{fin = [], trans = 37},
{fin = [(N 90)], trans = 38},
{fin = [(N 90),(N 185),(N 204)], trans = 39},
{fin = [(N 90),(N 185)], trans = 40},
{fin = [(N 90),(N 185)], trans = 41},
{fin = [(N 90),(N 185)], trans = 42},
{fin = [(N 90),(N 185)], trans = 43},
{fin = [(N 90),(N 185)], trans = 44},
{fin = [(N 90),(N 185)], trans = 45},
{fin = [(N 90),(N 185)], trans = 46},
{fin = [(N 87),(N 90),(N 185)], trans = 18},
{fin = [(N 90),(N 185)], trans = 48},
{fin = [(N 90),(N 185)], trans = 49},
{fin = [(N 90),(N 185)], trans = 50},
{fin = [(N 90),(N 185)], trans = 51},
{fin = [(N 90),(N 185)], trans = 52},
{fin = [(N 90),(N 185)], trans = 53},
{fin = [(N 90),(N 185)], trans = 54},
{fin = [(N 77),(N 90),(N 185)], trans = 18},
{fin = [(N 90),(N 185),(N 204)], trans = 56},
{fin = [(N 90),(N 185)], trans = 57},
{fin = [(N 90),(N 185)], trans = 58},
{fin = [(N 67),(N 90),(N 185)], trans = 18},
{fin = [(N 90),(N 185),(N 204)], trans = 60},
{fin = [(N 90),(N 185)], trans = 61},
{fin = [(N 90),(N 185)], trans = 62},
{fin = [(N 90),(N 185)], trans = 63},
{fin = [(N 62),(N 90),(N 185)], trans = 18},
{fin = [(N 90),(N 185)], trans = 65},
{fin = [(N 56),(N 90),(N 185)], trans = 18},
{fin = [(N 90),(N 185),(N 204)], trans = 67},
{fin = [(N 52),(N 90),(N 185)], trans = 18},
{fin = [(N 90),(N 185),(N 204)], trans = 69},
{fin = [(N 90),(N 185)], trans = 70},
{fin = [(N 90),(N 185)], trans = 71},
{fin = [(N 90),(N 185)], trans = 72},
{fin = [(N 90),(N 185)], trans = 73},
{fin = [(N 90),(N 185)], trans = 74},
{fin = [(N 49),(N 90),(N 185)], trans = 18},
{fin = [(N 90),(N 185),(N 204)], trans = 76},
{fin = [(N 90),(N 185)], trans = 77},
{fin = [(N 41),(N 90),(N 185)], trans = 18},
{fin = [(N 90),(N 185),(N 204)], trans = 79},
{fin = [(N 90),(N 185)], trans = 80},
{fin = [(N 31),(N 90),(N 185)], trans = 81},
{fin = [(N 90),(N 185)], trans = 82},
{fin = [(N 37),(N 90),(N 185)], trans = 18},
{fin = [(N 90),(N 185),(N 204)], trans = 84},
{fin = [(N 90),(N 185)], trans = 85},
{fin = [(N 23),(N 90),(N 185)], trans = 18},
{fin = [(N 27),(N 90),(N 185)], trans = 18},
{fin = [(N 185),(N 204)], trans = 88},
{fin = [(N 185)], trans = 89},
{fin = [(N 185)], trans = 90},
{fin = [(N 185)], trans = 91},
{fin = [(N 13),(N 185)], trans = 21},
{fin = [(N 19),(N 204)], trans = 0},
{fin = [(N 17),(N 204)], trans = 0},
{fin = [(N 185),(N 204)], trans = 21},
{fin = [(N 204)], trans = 96},
{fin = [(N 185)], trans = 97},
{fin = [], trans = 96},
{fin = [], trans = 99},
{fin = [], trans = 100},
{fin = [], trans = 101},
{fin = [], trans = 102},
{fin = [], trans = 103},
{fin = [], trans = 104},
{fin = [(N 185)], trans = 105},
{fin = [], trans = 106},
{fin = [], trans = 107},
{fin = [], trans = 108},
{fin = [], trans = 109},
{fin = [], trans = 110},
{fin = [], trans = 111},
{fin = [], trans = 112},
{fin = [], trans = 113},
{fin = [], trans = 114},
{fin = [(N 204)], trans = 33},
{fin = [(N 15),(N 204)], trans = 0},
{fin = [(N 204)], trans = 117},
{fin = [(N 202)], trans = 118},
{fin = [], trans = 119},
{fin = [], trans = 120},
{fin = [], trans = 121},
{fin = [], trans = 122},
{fin = [], trans = 123},
{fin = [(N 199)], trans = 123},
{fin = [(N 204)], trans = 35},
{fin = [(N 187),(N 204)], trans = 0},
{fin = [(N 2),(N 204)], trans = 127},
{fin = [(N 2)], trans = 127},
{fin = [(N 7),(N 204)], trans = 129},
{fin = [(N 7)], trans = 0},
{fin = [(N 242)], trans = 0},
{fin = [(N 242)], trans = 132},
{fin = [(N 240)], trans = 0},
{fin = [(N 242)], trans = 134},
{fin = [(N 235)], trans = 0},
{fin = [(N 237)], trans = 0},
{fin = [(N 315)], trans = 0},
{fin = [(N 313),(N 315)], trans = 0},
{fin = [(N 305),(N 313),(N 315)], trans = 139},
{fin = [(N 265)], trans = 0},
{fin = [], trans = 141},
{fin = [], trans = 142},
{fin = [], trans = 143},
{fin = [], trans = 144},
{fin = [(N 285)], trans = 0},
{fin = [(N 262)], trans = 0},
{fin = [(N 259)], trans = 0},
{fin = [(N 256)], trans = 0},
{fin = [(N 253)], trans = 0},
{fin = [(N 250)], trans = 0},
{fin = [(N 247)], trans = 0},
{fin = [], trans = 152},
{fin = [(N 273)], trans = 0},
{fin = [(N 269),(N 273)], trans = 0},
{fin = [(N 291)], trans = 0},
{fin = [], trans = 156},
{fin = [], trans = 157},
{fin = [(N 278)], trans = 0},
{fin = [(N 288)], trans = 0},
{fin = [(N 297)], trans = 160},
{fin = [(N 303)], trans = 161},
{fin = [(N 303)], trans = 0},
{fin = [(N 244),(N 313),(N 315)], trans = 0},
{fin = [(N 310),(N 315)], trans = 164},
{fin = [(N 310)], trans = 0},
{fin = [(N 327)], trans = 0},
{fin = [(N 325),(N 327)], trans = 0},
{fin = [(N 323),(N 327)], trans = 168},
{fin = [(N 323)], trans = 168},
{fin = [(N 320),(N 327)], trans = 170},
{fin = [(N 320)], trans = 0},
{fin = [(N 232)], trans = 0},
{fin = [(N 207),(N 232)], trans = 173},
{fin = [(N 207)], trans = 173},
{fin = [(N 232)], trans = 175},
{fin = [(N 230)], trans = 0},
{fin = [(N 214)], trans = 0},
{fin = [(N 212),(N 214)], trans = 178},
{fin = [(N 212)], trans = 178},
{fin = [(N 209),(N 214)], trans = 0},
{fin = [(N 232)], trans = 181},
{fin = [(N 217),(N 230)], trans = 0},
{fin = [(N 221),(N 232)], trans = 0},
{fin = [(N 232)], trans = 184},
{fin = [(N 221)], trans = 0},
{fin = [], trans = 184},
{fin = [(N 223),(N 232)], trans = 187},
{fin = [(N 223)], trans = 187},
{fin = [(N 223),(N 232)], trans = 189},
{fin = [(N 223),(N 230)], trans = 187},
{fin = [(N 232)], trans = 191},
{fin = [], trans = 192},
{fin = [(N 227)], trans = 0}])
end
structure StartStates =
	struct
	datatype yystartstate = STARTSTATE of int

(* start state definitions *)

val A = STARTSTATE 3;
val F = STARTSTATE 7;
val INITIAL = STARTSTATE 1;
val L = STARTSTATE 9;
val LL = STARTSTATE 11;
val LLC = STARTSTATE 13;
val LLCQ = STARTSTATE 15;
val S = STARTSTATE 5;

end
type result = UserDeclarations.lexresult
	exception LexerError (* raised if illegal leaf action tried *)
end

type int = Int.int
fun makeLexer (yyinput: int -> string) =
let	val yygone0:int= ~1
	val yyb = ref "\n" 		(* buffer *)
	val yybl: int ref = ref 1		(*buffer length *)
	val yybufpos: int ref = ref 1		(* location of next character to use *)
	val yygone: int ref = ref yygone0	(* position in file of beginning of buffer *)
	val yydone = ref false		(* eof found yet? *)
	val yybegin: int ref = ref 1		(*Current 'start state' for lexer *)

	val YYBEGIN = fn (Internal.StartStates.STARTSTATE x) =>
		 yybegin := x

fun lex (yyarg as ({source})) =
let fun continue() : Internal.result = 
  let fun scan (s,AcceptingLeaves : Internal.yyfinstate list list,l,i0: int) =
	let fun action (i: int,nil) = raise LexError
	| action (i,nil::l) = action (i-1,l)
	| action (i,(node::acts)::l) =
		case node of
		    Internal.N yyk => 
			(let fun yymktext() = String.substring(!yyb,i0,i-i0)
			     val yypos: int = i0+ !yygone
			fun REJECT() = action(i,acts::l)
			open UserDeclarations Internal.StartStates
 in (yybufpos := i; case yyk of 

			(* Application actions *)

  13 => (tok (Tokens.PRIM, source, yypos, yypos + 4))
| 15 => (tok (Tokens.COMMA, source, yypos, yypos + 1))
| 17 => (tok (Tokens.SEMICOLON, source, yypos, yypos + 1))
| 185 => let val yytext=yymktext() in tok' (Tokens.FILE, yytext, source, yypos) end
| 187 => (charlist := [""]
                    ; stringStart := Source.getPos (source, yypos)
                    ; YYBEGIN S
                    ; continue ())
| 19 => (tok (Tokens.EQUALOP, source, yypos, yypos + 1))
| 199 => (YYBEGIN L
                    ; commentStart := Source.getPos (source, yypos)
                    ; commentLevel := 1
                    ; continue ())
| 2 => (continue ())
| 202 => (YYBEGIN A
                    ; commentLevel := 1
                    ; commentStart := Source.getPos (source, yypos)
                    ; continue ())
| 204 => (error (source, yypos, yypos + 1, "illegal token") ;
                    continue ())
| 207 => let val yytext=yymktext() in YYBEGIN LL
                    ; (lineNum := valOf (Int.fromString yytext)
                       ; colNum := 1)
                      handle Overflow => YYBEGIN A
                    ; continue () end
| 209 => ((* cheat: take n > 0 dots *) continue ())
| 212 => let val yytext=yymktext() in YYBEGIN LLC
                    ; (colNum := valOf (Int.fromString yytext))
                      handle Overflow => YYBEGIN A
                    ; continue () end
| 214 => (YYBEGIN LLC; continue ()
                (* note hack, since ml-lex chokes on the empty string for 0* *))
| 217 => (YYBEGIN INITIAL
                    ; lineDirective (source, NONE, yypos + 2)
                    ; commentLevel := 0; charlist := []; continue ())
| 221 => (YYBEGIN LLCQ; continue ())
| 223 => let val yytext=yymktext() in lineFile := yytext; continue () end
| 227 => (YYBEGIN INITIAL
                    ; lineDirective (source, SOME (!lineFile), yypos + 3)
                    ; commentLevel := 0; charlist := []; continue ())
| 23 => (tok (Tokens.ANN, source, yypos, yypos + 3))
| 230 => (YYBEGIN INITIAL; commentLevel := 0; charlist := []; continue ())
| 232 => (YYBEGIN A; continue ())
| 235 => (inc commentLevel; continue ())
| 237 => (Source.newline (source, yypos) ; continue ())
| 240 => (dec commentLevel
                    ; if 0 = !commentLevel then YYBEGIN INITIAL else ()
                    ; continue ())
| 242 => (continue ())
| 244 => (let
                       val s = concat (rev (!charlist))
                       val _ = charlist := nil
                       fun make (t, v) =
                          t (v, !stringStart, Source.getPos (source, yypos + 1))
                    in YYBEGIN INITIAL
                       ; make (Tokens.STRING, s)
                    end)
| 247 => (addChar #"\a"; continue ())
| 250 => (addChar #"\b"; continue ())
| 253 => (addChar #"\f"; continue ())
| 256 => (addChar #"\n"; continue ())
| 259 => (addChar #"\r"; continue ())
| 262 => (addChar #"\t"; continue ())
| 265 => (addChar #"\v"; continue ())
| 269 => let val yytext=yymktext() in addChar (Char.chr(Char.ord(String.sub(yytext, 2))
                                      -Char.ord #"@"))
                    ; continue () end
| 27 => (tok (Tokens.AND, source, yypos, yypos + 3))
| 273 => (error (source, yypos, yypos + 2,
                           "illegal control escape; must be one of @ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_")
                    ; continue ())
| 278 => let val yytext=yymktext() in let
                       val x =
                          Char.ord(String.sub(yytext, 1)) * 100
                          + Char.ord(String.sub(yytext, 2)) * 10
                          + Char.ord(String.sub(yytext, 3))
                          - (Char.ord #"0") * 111
                    in (if x > 255
                           then stringError (source, yypos,
                                             "illegal ascii escape")
                        else addChar(Char.chr x);
                           continue ())
                    end end
| 285 => let val yytext=yymktext() in let
                       val x = 
                          StringCvt.scanString
                          (Pervasive.Int.scan StringCvt.HEX)
                          (String.substring (yytext, 2, 4))
                       fun err () =
                          stringError (source, yypos,
                                       "illegal unicode escape")
                    in (case x of
                          SOME x => if x > 255
                                       then err()
                                    else addChar(Char.chr x)
                        | _ => err())
                        ; continue ()
                    end end
| 288 => (addString "\""; continue ())
| 291 => (addString "\\"; continue ())
| 297 => (YYBEGIN F; continue ())
| 303 => (Source.newline (source, yypos) ; YYBEGIN F ; continue ())
| 305 => (stringError (source, yypos, "illegal string escape")
                    ; continue ())
| 31 => (tok (Tokens.BAS, source, yypos, yypos + 3))
| 310 => (Source.newline (source, yypos)
                    ; stringError (source, yypos, "unclosed string")
                    ; continue ())
| 313 => let val yytext=yymktext() in addString yytext; continue () end
| 315 => (stringError (source, yypos + 1, "illegal character in string")
                    ; continue ())
| 320 => (Source.newline (source, yypos) ; continue ())
| 323 => (continue ())
| 325 => (YYBEGIN S
                    ; stringStart := Source.getPos (source, yypos)
                    ; continue ())
| 327 => (stringError (source, yypos, "unclosed string")
                    ; continue ())
| 37 => (tok (Tokens.BASIS, source, yypos, yypos + 5))
| 41 => (tok (Tokens.END, source, yypos, yypos + 3))
| 49 => (tok (Tokens.FUNCTOR, source, yypos, yypos + 7))
| 52 => (tok (Tokens.IN, source, yypos, yypos + 2))
| 56 => (tok (Tokens.LET, source, yypos, yypos + 3))
| 62 => (tok (Tokens.LOCAL, source, yypos, yypos + 5))
| 67 => (tok (Tokens.OPEN, source, yypos, yypos + 4))
| 7 => (Source.newline (source, yypos); continue ())
| 77 => (tok (Tokens.SIGNATURE, source, yypos, yypos + 9))
| 87 => (tok (Tokens.STRUCTURE, source, yypos, yypos + 9))
| 90 => let val yytext=yymktext() in tok' (Tokens.ID, yytext, source, yypos) end
| _ => raise Internal.LexerError

		) end )

	val {fin,trans} = Vector.sub (Internal.tab, s)
	val NewAcceptingLeaves = fin::AcceptingLeaves
	in if l = !yybl then
	     if trans = #trans(Vector.sub(Internal.tab,0))
	       then action(l,NewAcceptingLeaves
) else	    let val newchars= if !yydone then "" else yyinput 1024
	    in if (String.size newchars)=0
		  then (yydone := true;
		        if (l=i0) then UserDeclarations.eof yyarg
		                  else action(l,NewAcceptingLeaves))
		  else (if i0=l then yyb := newchars
		     else yyb := String.substring(!yyb,i0,l-i0)^newchars;
		     yygone := !yygone+i0;
		     yybl := String.size (!yyb);
		     scan (s,AcceptingLeaves,l-i0,0))
	    end
	  else let val NewChar = Char.ord (CharVector.sub (!yyb,l))
		val NewChar = if NewChar<128 then NewChar else 128
		val NewState = Char.ord (CharVector.sub (trans,NewChar))
		in if NewState=0 then action(l,NewAcceptingLeaves)
		else scan(NewState,NewAcceptingLeaves,l+1,i0)
	end
	end
(*
	val start= if String.substring(!yyb,!yybufpos-1,1)="\n"
then !yybegin+1 else !yybegin
*)
	in scan(!yybegin (* start *),nil,!yybufpos,!yybufpos)
    end
in continue end
  in lex
  end
end
