(* Copyright 1996-1998 John D. Polstra.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgment:
 *      This product includes software developed by John D. Polstra.
 * 4. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: SplitLogger.i3,v 1.6 1998/03/18 05:42:55 jdp Exp $ *)

(* A "SplitLogger.T", or split logger, is a general-purpose device for
   splitting, teeing, or filtering log messages according to their
   priority levels. *)

INTERFACE SplitLogger;

IMPORT Logger;

TYPE
  T <: Public;

  Public = Logger.T OBJECT METHODS
    init(child1, child2: Logger.T;
	 levels1 := SET OF Logger.Priority{
	    Logger.Priority.Emerg .. Logger.Priority.Warning};
	 levels2 := SET OF Logger.Priority{
	    Logger.Priority.Notice .. Logger.Priority.Debug}): T;
  END;

(* Messages at priorities in "levels1" are forwarded to "child1".  Messages
   at priorities in "levels2" are forwarded to "child2".  Either or both of
   "child1" and "child2" may be "NIL". *)

END SplitLogger.
