!set lang_exists=yes

<p>
  Quand vous travaillez avec WIMS, vous aurez souvent besoin d'entrer des
  expressions mathmatiques.
</p>
Ces expressions mathmatiques peuvent tre tapes de faon habituelle&nbsp;:
<ul>
  <li>
    <code>3*x+5</code> pour
    !insmath 3x+5
  </li><li>
    <code>sin(pi*x)</code> pour
    !insmath sin(pi*x)
  </li><li>
    <code>y^3+1</code> pour
    !insmath y^3+1
  </li><li>
    <code>(x+1)/(y-1)</code> pour
    !insmath {x+1 \over y-1}
  </li><li>etc...</li>
</ul>

<p>
  De plus, WIMS contient un analyseur intelligent capable de corriger des
  ``erreurs'' communes dans les expressions mathmatiques. Par exemple,
  <span class="tt">3x+5</span>
  sera corrig en <span class="tt">3*x+5</span>, <span class="tt">sin x</span> corrig en
  <span class="tt">sin(x)</span>, etc. Mais nous ne vous conseillons pas de vous appuyer trop
  fort sur ce correcteur, car des ambiguts dans les expressions
  peuvent conduire parfois  des interprtations errones. Il sera toujours mieux
  de taper les expressions de faon ``correcte'', mme si cela est parfois un
  peu gnant.
</p><p>
  Voici une liste de fonctions mathmatiques et la faon (correcte) de les
  entrer. Ces fonctions sont reconnues par WIMS partout o elles ont un sens.
  (Certains modules peuvent accepter des fonctions supplmentaires&nbsp;;
  veuillez consulter les pages d'aide de ces modules.)
</p><p>
  !set x=<i class="wims_mathfont">x</i>
  !set y=<i class="wims_mathfont">y</i>
  Vous pouvez remplacer $x par toute sous-expression dans le tableau ci-dessous.
</p>

!set table_th = Fonction, Description, Code  crire

!set table_descs=La constante dArchimde\
base de log naturelle\
valeur absolue de $x\
signe de $x\
racine carre de $x\
l'entier le plus proche de $x\
le plus grand entier\
le plus petit entier\
exponentiel\
log naturel\
log de base 10\
sinus trigonomtrique\
cosinus trigonomtrique\
tangente trigonomtrique\
cotangente trigonomtrique\
sinus trigonomtrique rciproque\
csinus trigonomtrique rciproque\
tangente trigonomtrique rciproque\
sinus hyperbolique\
cosinus hyperbolique\
tangente hyperbolique\
sinus hyperbolique rciproque\
cosinus hyperbolique rciproque\
tangente hyperbolique rciproque\
le plus grand entre $x et $y\
le plus petit entre $x et $y\
PGCD (Plus Grand Commun Diviseur)\
PPCM (Plus Petit Commun Multiple)\

!read 1/math.phtml.common
