/*
 * Copyright 2023 KylinSoft Co., Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef PCIDEVICE_H
#define PCIDEVICE_H

#include <QObject>
#include <QVector>

#include "devicepowerinfo.h"
extern "C"{
#include "pci/pci.h"
}

#define PCI_DEVICE_PATH "/sys/bus/pci/devices/"
#define PCI_BLOCK_DEVICE_PATH "/sys/block/"

class PciDevice : public QObject
{
    Q_OBJECT
public:
    explicit PciDevice(QObject *parent = nullptr);

signals:

private:
    QVector<DevicePowerInfo *> m_devicePowerInfo;

    QString m_controlFile;

    void getPCIDevicePowerInfo();
    void getAtaDevicePowerInfo(const QString &parentDir);
    void getBlockDevicePowerInfo();
    bool deviceHasRuntimePM(const QString &devPath);

    QString lookupPciDeviceName(const QString &devPath);

public:
    int getPCIDeviceNum();
    QString getDeviceName(int deviceIndex);
    QString getCurrentPowerStat(int deviceIndex);
    QString getDefaultPowerStat(int deviceIndex);

    bool setPowerStat(int deviceIndex, const QString &stat);
    bool setAllDevicePowerStat(const QString &stat);
    void printAllDeviceInfo();
};

#endif // PCIDEVICE_H
