/*
 * Decompiled with CFR 0.152.
 */
package javax.naming;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import org.apache.harmony.jndi.internal.nls.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeName
implements Name {
    private static final long serialVersionUID = 1667768148915813118L;
    private static final int OUT_OF_QUOTE = 0;
    private static final int IN_SINGLE_QUOTE = 1;
    private static final int IN_DOUBLE_QUOTE = 2;
    private static final int QUOTE_ENDED = 3;
    private transient Vector<String> elems;

    private CompositeName(List<String> elements) {
        this.elems = new Vector<String>(elements);
    }

    protected CompositeName(Enumeration<String> elements) {
        this.elems = new Vector();
        while (elements.hasMoreElements()) {
            this.elems.add(elements.nextElement());
        }
    }

    public CompositeName() {
        this.elems = new Vector();
    }

    public CompositeName(String name) throws InvalidNameException {
        this.elems = CompositeName.parseName(name);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Vector<String> parseName(String name) throws InvalidNameException {
        Vector<String> l = new Vector<String>();
        if (CompositeName.isAllSlash(name)) {
            int i = 0;
            while (i < name.length()) {
                l.add("");
                ++i;
            }
            return l;
        }
        if (name.indexOf(34) < 0 && name.indexOf(39) < 0 && name.indexOf(92) < 0) {
            int i = 0;
            int j = 0;
            while ((j = name.indexOf(47, i)) >= 0) {
                l.add(name.substring(i, j));
                i = j + 1;
            }
            l.add(name.substring(i));
            return l;
        }
        char[] chars = name.toCharArray();
        StringBuilder buf = new StringBuilder();
        int status = 0;
        int i = 0;
        while (i < chars.length) {
            char c = chars[i];
            if (status == 3) {
                if (c != '/') throw new InvalidNameException(Messages.getString("jndi.0C"));
                l.add(buf.toString());
                buf.setLength(0);
                status = 0;
            } else if (c == '\\') {
                try {
                    char nc = chars[++i];
                    if (nc == '\\' || nc == '\'' || nc == '\"' || nc == '/') {
                        buf.append(nc);
                    }
                    buf.append(c);
                    buf.append(nc);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw new InvalidNameException(Messages.getString("jndi.0D"));
                }
            } else if (c != '/' && c != '\"' && c != '\'') {
                buf.append(c);
            } else if (status == 0 && c == '/') {
                l.add(buf.toString());
                buf.setLength(0);
            } else if (status == 0 && c == '\'' && buf.length() == 0) {
                status = 1;
            } else if (status == 0 && c == '\"' && buf.length() == 0) {
                status = 2;
            } else if (status == 1 && c == '\'') {
                status = 3;
            } else if (status == 2 && c == '\"') {
                status = 3;
            } else {
                buf.append(c);
            }
            ++i;
        }
        l.add(buf.toString());
        if (status == 0 || status == 3) return l;
        throw new InvalidNameException(Messages.getString("jndi.0E"));
    }

    private static boolean isAllSlash(String name) {
        int i = 0;
        while (i < name.length()) {
            if (name.charAt(i) != '/') {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static String formatName(Vector<String> elems) {
        if (CompositeName.isAllEmptyElements(elems)) {
            StringBuilder buf = new StringBuilder();
            int i = 0;
            while (i < elems.size()) {
                buf.append("/");
                ++i;
            }
            return buf.toString();
        }
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (i < elems.size()) {
            String elem = elems.get(i);
            if (i > 0) {
                buf.append("/");
            }
            if (elem.indexOf(47) < 0 && elem.indexOf(92) < 0 && elem.indexOf(39) < 0 && elem.indexOf(34) < 0) {
                buf.append(elem);
            } else {
                char[] chars;
                char[] cArray = chars = elem.toCharArray();
                int n = 0;
                int n2 = cArray.length;
                while (n < n2) {
                    char c = cArray[n];
                    if (c == '/' || c == '\\' || c == '\'' || c == '\"') {
                        buf.append('\\');
                    }
                    buf.append(c);
                    ++n;
                }
            }
            ++i;
        }
        return buf.toString();
    }

    private static boolean isAllEmptyElements(Vector<String> elems) {
        int i = 0;
        while (i < elems.size()) {
            String elem = elems.get(i);
            if (elem.length() > 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public Enumeration<String> getAll() {
        return this.elems.elements();
    }

    @Override
    public String get(int index) {
        return this.elems.get(index);
    }

    @Override
    public Name getPrefix(int index) {
        if (index < 0 || index > this.elems.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return new CompositeName(this.elems.subList(0, index));
    }

    @Override
    public Name getSuffix(int index) {
        if (index < 0 || index > this.elems.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return new CompositeName(this.elems.subList(index, this.elems.size()));
    }

    @Override
    public Name addAll(Name name) throws InvalidNameException {
        if (name == null) {
            throw new NullPointerException();
        }
        if (!(name instanceof CompositeName)) {
            throw new InvalidNameException(Messages.getString("jndi.0F"));
        }
        Enumeration<String> enumeration = name.getAll();
        while (enumeration.hasMoreElements()) {
            this.elems.add(enumeration.nextElement());
        }
        return this;
    }

    @Override
    public Name addAll(int index, Name name) throws InvalidNameException {
        if (name == null) {
            throw new NullPointerException();
        }
        if (!(name instanceof CompositeName)) {
            throw new InvalidNameException(Messages.getString("jndi.0F"));
        }
        if (index < 0 || index > this.elems.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Enumeration<String> enumeration = name.getAll();
        while (enumeration.hasMoreElements()) {
            this.elems.add(index++, enumeration.nextElement());
        }
        return this;
    }

    @Override
    public Name add(String element) throws InvalidNameException {
        this.elems.add(element);
        return this;
    }

    @Override
    public Name add(int index, String element) throws InvalidNameException {
        if (index < 0 || index > this.elems.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.elems.add(index, element);
        return this;
    }

    @Override
    public Object remove(int index) throws InvalidNameException {
        if (index < 0 || index >= this.elems.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.elems.remove(index);
    }

    @Override
    public int size() {
        return this.elems.size();
    }

    @Override
    public boolean isEmpty() {
        return this.elems.isEmpty();
    }

    @Override
    public boolean startsWith(Name name) {
        if (!(name instanceof CompositeName)) {
            return false;
        }
        if (name.size() > this.elems.size()) {
            return false;
        }
        Enumeration<String> enumeration = name.getAll();
        int i = 0;
        while (enumeration.hasMoreElements()) {
            String me = this.elems.get(i);
            String he = enumeration.nextElement();
            if (me == null ? he != null : !me.equals(he)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public boolean endsWith(Name name) {
        if (!(name instanceof CompositeName)) {
            return false;
        }
        if (name.size() > this.elems.size()) {
            return false;
        }
        Enumeration<String> enumeration = name.getAll();
        int i = this.elems.size() - name.size();
        while (enumeration.hasMoreElements()) {
            String me = this.elems.get(i);
            String he = enumeration.nextElement();
            if (me == null ? he != null : !me.equals(he)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public int compareTo(Object o) {
        if (o instanceof CompositeName) {
            CompositeName he = (CompositeName)o;
            int i = 0;
            while (i < this.elems.size() && i < he.elems.size()) {
                int r = this.elems.get(i).compareTo(he.elems.get(i));
                if (r != 0) {
                    return r;
                }
                ++i;
            }
            if (this.elems.size() == he.elems.size()) {
                return 0;
            }
            if (this.elems.size() < he.elems.size()) {
                return -1;
            }
            return 1;
        }
        throw new ClassCastException();
    }

    @Override
    public Object clone() {
        return new CompositeName(this.elems);
    }

    public String toString() {
        return CompositeName.formatName(this.elems);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CompositeName)) {
            return false;
        }
        return this.elems.equals(((CompositeName)o).elems);
    }

    public int hashCode() {
        int sum = 0;
        int i = 0;
        while (i < this.elems.size()) {
            sum += this.elems.get(i).hashCode();
            ++i;
        }
        return sum;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        oos.writeInt(this.elems.size());
        for (String element : this.elems) {
            oos.writeObject(element);
        }
    }

    private void readObject(ObjectInputStream ois) throws OptionalDataException, ClassNotFoundException, IOException {
        ois.defaultReadObject();
        int size = ois.readInt();
        this.elems = new Vector();
        int i = 0;
        while (i < size) {
            this.elems.add((String)ois.readObject());
            ++i;
        }
    }
}

