#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2020 Mopi
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# A Space Adventure
# send your bug reports to bugs@dotslashplay.it
###

script_version=20240915.1

PLAYIT_COMPATIBILITY_LEVEL='2.30'

GAME_ID='a-space-adventure'
GAME_NAME='A Space Adventure'

ARCHIVE_BASE_0_NAME='asa_remastered_full_drm_free.zip'
ARCHIVE_BASE_0_MD5='af67e83c12c3d0a722af35c71a5678bc'
ARCHIVE_BASE_0_VERSION='1.0-itch.2018.01.10'
ARCHIVE_BASE_0_SIZE='980000'
ARCHIVE_BASE_0_URL='https://the-icehouse.itch.io/asa2015'

VISIONAIRE_NAME='asa_r_windows'

CONTENT_PATH_DEFAULT='.'
CONTENT_GAME0_DATA_FILES="
${VISIONAIRE_NAME}.vis"
CONTENT_DOC0_DATA_FILES='
readme.txt'

WINE_PERSISTENT_DIRECTORIES='
users/${USER}/AppData/Local/Simon Says Play/ASA Remastered'

PKG_BIN_ARCH='32'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default
(
	cd "${PLAYIT_WORKDIR}/gamedata/$(content_path_default)"

	# Convert all paths to lowercase
	tolower .
)

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
