#
#
#   This is metafontMode version 1.0.1
#
#
#
##############################################################################################
#                                                                                            #
#   MetafontMode is a mode for the text editor Alpha: it is designed to make writing,        #
#   processing and testing of Metafont source files much easier. Metafont is                 #
#   the programming language written, as a companion to TeX, by Donald Knuth in              #
#   order to create characters, fonts, font families (and many others things).               #
#   Once Metafont mode is installed, the opening of a Metafont source file (i-e              #
#   with extension .mf) invokes a new menu (called Metafont !) in the menu bar with          #
#   the following features :                                                                 #
#     easy insertion of all the basic Metafont commands (with electric stops).              #
#     syntax colorizing.                                                                    #
#   -  file marking.                                                                         #
#     capacity to process a source file from within Alpha with various.                     #
#      flags, printer modes, input base files.                                               #
#   -  editing the log file.                                                                 #
#   -  capacity to make the pk file; to make and to edit the property list for a font.       #
#   -  capacity to process an entire folder of mf source files.                              #
#                                                                                            #
##############################################################################################
#
# 
# 
# 
# #    As of this release, only  CMacTeX Metafont and OzMetafont are supported (+ together with
# #    gftopk and vftopl).
# 
# 
# 
#
########################################################################################
#                                                                                      #
#   ============================                                                       #
#   Installation Instructions                                                          #
#   ============================                                                       #
#                                                                                      #
#                                                                                      #
#   Automatic installation :                                                           #
#                                                                                      #
#   Open the "OPEN TO INSTALL" file. Opening this file indicates to Alpha that a       #
#   new package has to be installed : the procedure is automatic. Alpha knows          #
#   where to store the different elements of you Metafont Mode package.                #
#                                                                                      #
#   Manual installation :                                                              #
#                                                                                      #
#   1-  put the "metafontMode.tcl" file in the "Modes" subfolder of the "Tcl"          #
#   folder which is located at the same level as your Alpha application                #
#                                                                                      #
#   2-  put the "Metafont Help" file in the "Help" folder located at the same level    #
#   as your Alpha application. Next time you launch Alpha, you will have a             #
#   "Metafont Help" item in the Help menu to edit this file.                           #
#                                                                                      #
#   3-  launch Alpha. You need to rebuild the package indices and the tcl              #
#   ones. 'Rebuild Package Indices' is in the Config->Packages menu, and "Rebuild Tcl  #
#   Indices" is in the Tcl menu (press cmd-Y to open a tcl shell).                     #
#                                                                                      #
#   4-  quit Alpha and relaunch it : there you are.                                    #
#                                                                                      #
#                                                                                      #
#           More explanations come in the Metafont Help file.                          #
#                                                                                      #
########################################################################################
## 
 ### 
 ## Author :  Bernard Desgraupes  
 ## e-mail:  berdesg@easynet.fr
 ## www: <http://perso.easynet.fr/~berdesg/metafont.html>
 ###
##
## 
 # Copyright (c) 1999  Bernard Desgraupes
 # 
 # This	program	is free	software; you can redistribute it and/or modify
 # it under	the	terms of the GNU General Public	License	as published by
 # the Free	Software Foundation; either	version	2 of the License, or
 # (at your	option)	any	later version.
 # 
 # This	program	is distributed in the hope that	it will	be useful,
 # but WITHOUT ANY WARRANTY; without even the implied warranty of
 # MERCHANTABILITY or FITNESS FOR A	PARTICULAR PURPOSE.	 See the
 # GNU General Public License for more details.
 # 
 # You should have received	a copy of the GNU General Public License
 # along with this program;	if not,	write to the Free Software
 # Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,	USA.
 ##


alpha::mode Mf 1.0.1 mfMenu {*.mf *.fpl} mfMenu {
	addMenu mfMenu "Metafont"
} maintainer {
	"Bernard Desgraupes" berdesg@easynet.fr <http://perso.easynet.fr/~berdesg/metafont.html> 
} uninstall this-file help {file "Metafont Help"}


#######   Preferences  #############

newPref f wordWrap {0} Mf
newPref f autoMark {1} Mf
# Flags for the six Metafont particular processing options
# By default none of them is set
newPref f gfcorners 0 Mf  shadowMf
newPref f imagerules 0 Mf   shadowMf
newPref f nodisplays 0 Mf   shadowMf
newPref f notransforms 0 Mf   shadowMf
newPref f screenstrokes 0 Mf   shadowMf
newPref f screenchars 0 Mf   shadowMf
# Name of the printer mode for Metafont : for instance cx at 300dpi, 
# canonex at 600dpi etc.
newPref v mfModeForPrinter canonex Mf
newPref v prefixString {% } Mf
newPref v funcExpr {[a-zA-Z_]*\(} Mf
newPref v wordBreak {[_\w]+} Mf
newPref v wordBreakPreface {[^_\w]} Mf
# Here we allow the user to define his own 
# denomination for the beginchar macro :
newPref v userBeginchar beginchar Mf
# Default colo(u)rs for the keywords
newPref v commentColor red Mf
newPref v funcColor cyan Mf
newPref v keywordColor blue Mf
newPref v stringColor green Mf
# Metafont menu, when used for the first time, must determine
# which Metafont application is installed. The lookForMetafont proc will do
# that automatically, but this choice can be overriden afterwards
# in the mode specific prefs.
newPref v mfAppSig {} Mf 
# Folder where Metafont sends its output to
newPref folder outputFolder $HOME Mf
# Where is the file modes.mf defining the parameters of 
# all the possible Metafont modes :
newPref file pathToModesMfFile {} Mf
# Where is the file plain.mf defining the Metafont's basic macros :
newPref file pathToPlainMfFile {} Mf


### 
 #     Initialization of some variables
###
set Mffilename [file tail [win::Current]]
set chosenMode proof
set mag 1
set magstep 0
set magflag 0
set magstepflag 0
set Mfbasefile ""
set Mfbasefileflag 0
set tfmfile ""
set prefixtfm "("
set prefixfpl "("
set prefixgf "("
set prefixlog "("
set fromfolder "("
set mfwd $HOME
set mfset 0
set gfall(CMT3) "("
set gfall(OzMF) "("



proc mfMenu {} {}

hook::register activateHook rebuildOtherfiles Mf

#############  Select the Metafont application when using this mode for the first time #############

if {$MfmodeVars(mfAppSig)== ""} {
	set mfsignlist [list "CMacTex mf" "OzMetafont" "DirectTeXPro mf"]
	set sig [listpick -p "Select your Metafont application"  $mfsignlist]
	switch $sig {
		"CMacTex mf" {set mfAppSig "CMT3"}
		"OzMetafont" {set mfAppSig "OzMF"}
		"DirectTeXPro mf" {set mfAppSig "TeX+"}
		}
	removeArrDef MfmodeVars mfAppSig
	set MfmodeVars(mfAppSig) $mfAppSig
 	addArrDef MfmodeVars mfAppSig $mfAppSig
}

##############################################
#                                            #
#   #########   Metafont Menu  ###########   #
#                                            #
##############################################

menu::buildProc mfMenu menu::buildMf
menu::buildProc otherFiles menu::buildotherFiles

proc menu::buildMf {} {
	global mfMenu otherFiles Mffilename
	set ma {
	"/M<B<OswitchToMetafont"
	"(-"
	"/R<UrunTheBuffer"
	"saveAndRun"
	"<S<B/FrunAFile"
	"<S<I<B/FrunAFolder"
	"(-"
{Menu -n "metafontMode" -p choosemodeProc {
	"proof"
	"smoke"
	"localfont"
	"userDefined"
	}
}
{Menu -n "processingOptions" -p processingoptProc {
	"mag..."
	"magstep..."
	"baseFile..."
	"(-"
	"gfcorners"
	"imagerules"
	"nodisplays"
	"notransforms"
	"screenchars"
	"screenstrokes"
	"(-"
	"clearAllOptions"
	}
}
	"(-"
}
	lappend ma [list Menu -n otherFiles {}]
	append ma {
	  "(-"
	  "newFontTemplate"
	  "(-"
{Menu -n "variables" -p variablesProc {	
	" boolean"
	" numeric"
	" pair"
	" path"
	" pen"
	" picture"
	" string"
	" transform"
	}
}
{Menu -n "boolean" -p booleanProc {	
	" charexists"
	" cycle"
	" false"
	" known"
	" true"
	" unknown"
	}
}
{Menu -n "functions" -p functionsProc {	
	" angle"
	" ceilling"
	" floor"
	" cosd"
	" sind"
	" mexp"
	" mlog"
	" sqrt"
	"(-"
	" eps"
	" epsilon"
	" infinity"
	"(-"
	" round"
	" hround"
	" vround"
	"(-"
	" solve"
	" tolerance"
	"(-"
	" normaldeviate"
	" randomseed"
	" uniformdeviate"
	" whatever"
	}
}
{Menu -n "positioning" -p positioningProc {	
	" clearxy"
	" direction"
	" directionpoint"
	" directiontime"
	" penoffset"
	" pointof"
	" precontrolof"
	" postcontrolof"
	" intersectionpoint"
	" intersectiontimes"
	"(-"
	" good.bot"
	" good.lft"
	" good.rt"
	" good.top"
	" good.x"
	" good.y"
	"(-"
	" xpart"
	" xxpart"
	" xypart"
	" ypart"
	" yxpart"
	" yypart"
	}
}
{Menu -n "paths" -p pathsProc {	
	" flex"
	" fullcircle"
	" halfcircle"
	" quartercircle"
	" superellipse"
	" unitsquare"
	"(-"
	" makepath"
	" interpath"
	" subpath"
	" tensepath"
	" counterclockwise"
	" reverse"
	"(-"
	" turningnumber"
	}
}
{Menu -n "pens" -p pensProc {	
	" clear_pen_memory"
	" clearpen"
	" currentpen"
	" makepen"
	" nullpen"
	" savepen"
	"(-"
	" pencircle"
	" pencircle..."
	" pensquare"
	" pensquare..."
	" penrazor"
	" penspeck"
	"(-"
	" pen_bot"
	" pen_lft"
	" pen_rt"
	" pen_top"
	" pickup"
	}
}
{Menu -n "pictures" -p picturesProc {	
	" blankpicture"
	" clearit"
	" currentpicture"
	" nullpicture"
	"(-"
	" totalweight"
	" unitpixel"
	}
}
{Menu -n "strings" -p stringsProc {	
	" ditto"
	" jobname"
	" readstring"
	" substring"
	}
}
{Menu -n "transformations" -p transformationsProc {	
	" currenttransform"
	" identity"
	" inverse"
	" reflectedabout"
	" rotated"
	" rotatedaround"
	" scaled"
	" shifted"
	" slanted"
	" transformed"
	" xscaled"
	" yscaled"
	" zscaled"
	}
}
{Menu -n "definitions" -p definitionsProc {	
	" defenddef"
	" suffix"
	" expr"
	" text"
	" primarydefenddef"
	" secondarydefenddef"
	" tertiarydefenddef"
	" vardefenddef"
	" begingroupendgroup"
	}
}
{Menu -n "conditions" -p conditionsProc {	
	" forendfor"
	" foreverendfor"
	" forsuffixesendfor"
	" iffi"
	" ifelseifelsefi"
	" downto"
	" upto"
	" stepuntil"
	" exitif"
	" exitunless"
	}
}
{Menu -n "drawing" -p drawingProc {	
	" addtoalso"
	" addtocontour"
	" addtocontourwithpen"
	" addtocontourwithweight"
	" addtodoublepathwithpen"
	" addtodoublepathwithweight"
	" culldropping"
	" culldroppingwithweight"
	" cullkeeping"
	" cullkeepingwithweight"
	" cullit"
	" cutdraw"
	" cutoff"
	" draw"
	" drawdot"
	" erase"
	" fill"
	" filldraw"
	" penpos"
	" penstroke"
	" undraw"
	" undrawdot"
	" unfill"
	" unfilldraw"
	}
}
{Menu -n "characters" -p charactersProc {	
	" begincharendchar"
	" extra_beginchar"
	" extra_endchar"
	}
}
{Menu -n "units" -p unitsProc {	
	" blacker"
	" fillin"
	" o_correction"
	" fix_units"
	" mode_setup"
	" pixels_per_inchs"
	}
}
{Menu -n "pixellisation" -p pixellisationProc {	
	" define_pixels"
	" define_blacker_pixels"
	" define_good_x_pixels"
	" define_good_y_pixels"
	" define_corrected_pixels"
	" define_horizontal_corrected_pixels"
	" define_whole_pixels"
	" define_whole_blacker_pixels"
	" define_whole_vertical_pixels"
	" define_whole_vertical_blacker_pixels"
	}
}
{Menu -n "fontDefinitions" -p fontdefinitionsProc {	
	" charlist"
	" extensible"
	" font_coding_scheme"
	" font_extra_space"
	" font_identifier"
	" font_normal_shrink"
	" font_normal_space"
	" font_normal_stretch"
	" font_quad"
	" font_size"
	" font_slant"
	" font_x_height"
	" fontdimen"
	" headerbytes"
	" ligtable"
	" kern"
	}
}
{Menu -n "displaying" -p displayingProc {	
	" currentwindow"
	" displayinwindow"
	" openwindowfromtoat"
	" screen_cols"
	" screen_rows"
	" screenrule"
	}
}
{Menu -n "output" -p outputProc {	
	" openit"
	" shipit"
	" showit"
	"(-"
	" labels"
	" labelsrangethru"
	" penlabels"
	" makelabel"
	" makegrid..."
	"(-"
	" proofoffset"
	" proofrule"
	" proofrulethickness"
	"(-"
	" grayfont"
	" labelfont"
	" slantfont"
	" titlefont"
	}
}
{Menu -n "debugging" -p debuggingProc {	
	" errhelp"
	" errmessage"
	" message"
	" stop"
	"(-"
	" show"
	" showdependencies"
	" showstats"
	" showtoken"
	" showvariable"
	"(-"
	" loggingall"
	" tracingall"
	" tracingnone"
	"(-"
	" batchmode"
	" errorstopmode"
	" nonstopmode"
	" scrollmode"
	}
}
{Menu -n "misc" -p miscProc {	
	" capsule_def"
	" expandafter"
	" gobble"
	" gobbled"
	" interact"
	" numtok"
	" scantokens"
	" special"
	" numspecial"
	}
}
{Menu -n "internalVariables" -p varintProc {	
	" autorounding"
	" designsize"
	" fontmaking"
	" granularity"
	" pausing"
	" proofing"
	" showstopping"
	" smoothing"
	"(-"
	" charcode"
	" chardp"
	" chardx"
	" chardy"
	" charext"
	" charht"
	" charic"
	" charwd"
	"(-"
	" hppp"
	" vppp"
	"(-"
	" xoffset"
	" yoffset"
	"(-"
	" day"
	" month"
	" year"
	" time"
	"(-"
	" tracingcapsules"
	" tracingchoices"
	" tracingcommands"
	" tracingedges"
	" tracingequations"
	" tracingmacros"
	" tracingonline"
	" tracingoutput"
	" tracingpens"
	" tracingrestores"
	" tracingspecs"
	" tracingstats"
	" tracingtitles"
	" turningcheck"
	" warningcheck"
	}
}
}
	return [list build $ma mfmenuProc {otherFiles} $mfMenu]
}

proc menu::buildotherFiles {} {
	global Mffilename MfmodeVars outputFolder fromfolder
	global prefixtfm prefixfpl prefixgf prefixlog gfall mfAppSig
  	set rootname [file rootname [file tail [win::Current]]]
	set logname "${rootname}.log"
	
# 	lappend ma "<S<I${fromfolder}convertAllGfToPk"
	
	set ma "<S${prefixgf}convertGfToPk"
	lappend ma "<S<I$gfall($MfmodeVars(mfAppSig))convertAllGfToPk"
	lappend ma 	"<E<S${prefixtfm}convert $rootname.tfm to pl"
	lappend ma 	"<S<I${fromfolder}convertAllTfmToPl"
	lappend ma 	"tfmToPl..."
	lappend ma 	"(-"
	lappend ma	"<S${prefixlog}open $rootname.log"
	lappend ma	"<S<I${fromfolder}openAllLogFiles"
	lappend ma "<E<S${prefixfpl}openPropertyList" 
	lappend ma "<S<I${fromfolder}openAllPropertyLists" 
	foreach i {"(-"  "(-" "openModes.mf" "openPlain.mf"} {
	lappend ma $i
		}
	append ma {
	  "(-"
{Menu -n "removeFiles" -p removefilesProc {	
	"allLogFiles" 
	"allGfFiles" 
	"allPkFiles" 
	"allTfmFiles"
	"allPlFiles"
	"(-"
	"allOfThem"
	}
}
}
	return [list build $ma otherfilesProc]
}

menu::buildSome mfMenu 

markMenuItem metafontMode proof 1

################################################################
#                     Menus and submenus procs                 #
################################################################


############  Top menu procs ##############

proc mfmenuProc {menu item} {
	global fullMffilename tailMffilename MfmodeVars cmdline
	switch $item {
		"switchToMetafont" {app::launchFore CMT3}
		"runTheBuffer" {
			set fullMffilename [win::Current]
			set tailMffilename [file tail $fullMffilename]
			checkdirty
			runbufferProc}
		"saveAndRun" {
			save
			set fullMffilename [win::Current]
			set tailMffilename [file tail $fullMffilename]
			runbufferProc
			}
		"runAFile" {
			catch {getfile "Find a \".mf\" file to process"}  fullMffilename
			edit $fullMffilename
			if [file exists $fullMffilename] {
				set tailMffilename [file tail $fullMffilename]
				runbufferProc
				}
			}
		"runAFolder" {runafolderProc}
		"newFontTemplate" {newtemplateProc}
	}
}

proc findmoderes {} {
	global MfmodeVars mfAppSig chosenMode
	if {$chosenMode == "proof"} {
	return [list "proof" "2602"]
	}
	if {$chosenMode == "smoke"} {
	return [list "smoke" "2602"]
	}
	set rootname [file rootname [file tail [win::Current]]]
	if {[file exists $MfmodeVars(pathToModesMfFile) ]} {
		message "reading $MfmodeVars(pathToModesMfFile)"
		catch {open "$MfmodeVars(pathToModesMfFile)"} fileId
		catch {read $fileId} textlog
		# First we find the value of localfont
		if {$chosenMode == "localfont"} {
			regexp {localfont([^\;]*)\;} $textlog blabla localMfmode
			set localMfmode [string trim $localMfmode " :="]
		} elseif {$chosenMode == "smoke"} {
			set localMfmode $chosenMode
		} else {
			set localMfmode $MfmodeVars(mfModeForPrinter)			
		}
		# Then we find the resolution in dpi
		set start [string first "mode_def $localMfmode" $textlog]
		if {$start == -1} {
			alertnote "Unknown mode $localMfmode."
			return
		}
		set textlog [string range $textlog $start end]
		regexp {pixels_per_inch[^0-9)]*([0-9]*)} $textlog blabla resdpi
		return [list $localMfmode $resdpi]
	} else {
		alertnote "Can't find file modes.mf : set the path in the Current Mode Prefs."
		return [list "proof" "2602"]
	}
}

proc otherfilesProc {submenu item} {
	global rootname MfmodeVars outputFolder mfAppSig gffile mfwd prefixfpl
	switch -regexp $item {
		"convertGfToPk"  {
			findrootnameProc
			findgfFile
			dopkProc
		}
		"convert.*\.tfm"  {
# 			if [app::isRunning CMTk] {sendQuitEvent 'CMTk'}
			findoutputfolder
			findrootnameProc
			doplProc
			set prefixfpl ""
			menu::buildSome otherFiles
			editplProc
		}
		"tfmToPl..." {
			global tfmfile rootname
			catch {getfile "Select a tfm file"}  tfmfile
			if {$tfmfile == ""} {
				return} else {
					set rootname [file rootname [file tail $tfmfile]]
					doplProc
					editplProc
					set tfmfile ""
					}
				}
		"open.*\.log$" {
				findrootnameProc
				switch $MfmodeVars(mfAppSig) {
					"CMT3" { 	
						findoutputfolder
						if {![file exists $MfmodeVars(outputFolder):${rootname}.log]} {
							alertnote "Can't find file ${rootname}.log."
							return} else {
								edit -r "$MfmodeVars(outputFolder):${rootname}.log"
							}
						}
						"OzMF" {
							set logdirname [file dirname [win::Current]]
							if {![file exists $logdirname:${rootname}.log]} {
								alertnote "Can't find file ${rootname}.log. Check that the \"delete_log\" flag in OzMetafont configs is set to false."
								return} else {
									edit -r "$logdirname:${rootname}.log"
								}
							}
						"TeX+"  {
							alertnote "Support for Direct Tex Pro still to be done. Sorry !"
						}
					}
				}
		"openPropertyList" {
					findrootnameProc
					editplProc
				}
		"convertAllGfToPk" {convertallProc gftopk}
		"convertAllTfmToPl" {convertallProc vftopl}
		"openAllLogFiles" {allAuxfilesProc log}
		"openAllPropertyLists" {
					switch $MfmodeVars(mfAppSig) {
						"CMT3" {allAuxfilesProc fpl}
						"OzMF" {allAuxfilesProc pl}
						"TeX+" {allAuxfilesProc pl}
					}
				}
		"openModes.mf" {openmodesmfProc}
		"openPlain.mf" {openplainmfProc}
	}
}
		
# Here we define a proc to dimm/undimm the items of the OtherFiles submenu
# depending on the existence of auxiliary files
proc rebuildOtherfiles {name} {
	global mfMenu otherFiles Mffilename
	global MfmodeVars outputFolder mfAppSig
	global prefixgf prefixlog prefixtfm prefixfpl
	set Mffilename [file tail [win::Current]]
	switch $MfmodeVars(mfAppSig) {
		"CMT3" { 	
			set Mfdirname $MfmodeVars(outputFolder)
		}
		"OzMF" {
			set Mfdirname [file dirname [win::Current]]
			}
		"TeX+"  {
			alertnote "Support for Direct Tex Pro still to be done. Sorry !"
			set Mfdirname $MfmodeVars(outputFolder)
		}
	}
	if {![regexp ".mf" $Mffilename] && ![regexp ".fpl" $Mffilename]} {
		set prefixgf "("
		set prefixlog "("
		set prefixtfm "("
		set prefixfpl "("
		} else {
			set rootname [file rootname $Mffilename]
			set logname "${rootname}.log"
			if [file exists $Mfdirname:${logname}] {
				set prefixgf ""
				set prefixlog ""
			} else {
				set	prefixgf "("
				set	prefixlog "("}
			if [file exists $Mfdirname:${rootname}.tfm] {
				set prefixtfm ""
			} else {
				set	prefixtfm "("}
			if [file exists $Mfdirname:${rootname}.fpl] {
				set prefixfpl ""
				} elseif [file exists $Mfdirname:${rootname}.pl] {
					set prefixfpl ""
				} else {
				set	prefixfpl "("}
		}
	menu::buildSome otherFiles
}

# Here are the procs to process the source files
proc runbufferProc {} {
	global fullMffilename tailMffilename cmdline addcmdline MfmodeVars mfAppSig 
	global prefixtfm prefixfpl prefixgf prefixlog chosenMode resol
	if {[string length $MfmodeVars(mfAppSig)]} {
		app::launchFore "$MfmodeVars(mfAppSig)"
		switch $MfmodeVars(mfAppSig) {
			"CMT3" { 	
				buildCMTcmdLine
				doMfscript
			}
			"OzMF" {
				if {$chosenMode == "proof"} {
					doMfscript
					updateprefixes
				} else {
					set resol "[findmoderes]"
					buildOZmakeLine
					createmakefile
					runmakefile
					updateprefixes
				}
			}
			"TeX+"  {
				app::launchFore "ALFA"
				alertnote "Support for Direct Tex Pro still to be done. Sorry !"
				return
			}
		}
		menu::buildSome otherFiles
	} else {
		alertnote "No Mf app. selected. Select it in the Current mode preferences."
	}
}

proc runafolderProc {} {
	global fullMffilename tailMffilename cmdline folderpath fromfolder
	global MfmodeVars outputFolder mfAppSig chosenMode resol filesindir ext
	catch {get_directory -p "Select a folder."} folderpath
	if {$folderpath == ""} { return }
	set ext ".mf"
	set filesindir [glob -nocomplain "$folderpath:*$ext"]
	set longueur [llength $filesindir]
	if {$longueur == 0} {
		alertnote "No \"$ext\" file in this folder."
		return } 
	if {[string length $MfmodeVars(mfAppSig)]} {
		app::launchFore "$MfmodeVars(mfAppSig)"
		switch $MfmodeVars(mfAppSig) {
			"CMT3" {domaketexpk}
			"OzMF" {domaketexpk}
			"TeX+"  {
				app::launchFore "ALFA"
				alertnote "Support for Direct Tex Pro still to be done. Sorry !"
				return
			}
		}
		set fromfolder ""
		menu::buildSome otherFiles
	} else {
		alertnote "No Mf app. selected. Select it in the Current mode preferences."
	}					
}	
	

proc domaketexpk {} {
	global fullMffilename tailMffilename cmdline folderpath fromfolder
	global chosenMode resol filesindir
	global MfmodeVars outputFolder mfAppSig ext
	if {[file exists "$folderpath:tmpall.make" ]} {
		removeFile "$folderpath:tmpall.make"
	}
	switch [buttonAlert "OK to process all \"$ext\" files from $folderpath ?  This folder must be on a path searched by Metafont." "yes" "cancel" ] {
		"yes" {
			set fileId [open "$folderpath:tmpall.make" a+] 
			set resol  "[findmoderes]"
			foreach file $filesindir {
				set fullMffilename $file
				set tailMffilename [file tail $file]
				buildOZmakeLine
				puts $fileId $cmdline
			}
			close $fileId
			runmakeallfile
		}
		"cancel" {
			switchTo 'ALFA'
			return 
		}
	}
}

proc checkdirty {} {
		if {[winDirty]} {
		case [askyesno -c "Dirty window '[lindex [winNames] 0]'. Do you want to save it ?"] in {
			"yes" {save}
			"no" {}
			"cancel" {return}
			}
		}
}

####################  Scripts and auxiliary programms  #########################

proc buildCMTcmdLine {} {
	global cmdline fullMffilename tailMffilename MfmodeVars chosenMode mfModeForPrinter outputFolder
	global proof smoke localfont userDefined script
	global gfcorners imagerules nodisplays
	global notransforms screenchars screenstrokes
	global mag magstep magflag magstepflag Mfbasefile Mfbasefileflag
	global prefixtfm prefixfpl prefixgf prefixlog
	set cmdline "mf "
#    choosing the mode
	if {$chosenMode != "proof"} {
		if {$chosenMode == "smoke" || $chosenMode == "localfont"} {
			append cmdline "\\mode=$chosenMode; "
			} else {
			append cmdline "\\mode=$MfmodeVars(mfModeForPrinter);"}
		} else {append cmdline "\\ "}
#   Do we magnify ?
   	if {$magflag == 1} {append cmdline "mag=$mag; "
		} elseif {$magstepflag == 1} {
			append cmdline "mag=magstep\($magstep\); "
			}
#    Add the (optional!) options if the corresponding flag is set
	if $screenchars {append cmdline "screenchars; "}
	if $screenstrokes {
			if {$chosenMode != "proof"} {
			alertnote "The \"screenstrokes\" option is for proof mode only. I'll ignore it."
			mfToggle screenstrokes
			shadowMf screenstrokes
		} else {
		append cmdline "screenstrokes; "}
	}
	if $imagerules {
		append cmdline "imagerules; "}
	if $gfcorners {
		append cmdline "gfcorners; "}
	if $nodisplays {
		if {$chosenMode != "proof"} {
			alertnote "The \"nodisplays\" option is for proof mode only. I'll ignore it."
		} elseif {$screenchars || $screenstrokes} {beep 
			alertnote "Contradictory options : you can't use \"nodisplays\" with \"screenchars\" or \"screenstrokes\". I'll ignore it."
			mfToggle nodisplays
			shadowMf nodisplays
		} else {
		append cmdline "nodisplays; "}
	}
	if $notransforms {
		append cmdline "notransforms; "}
#    Input a base file if any
	if {$Mfbasefileflag == 1} {
		append cmdline "input $Mfbasefile;"
		}
#   Now the file to process. Since version 2.2.1 of CMaCTeX Metafont there is a new syntax 
# 	for the Apple event : the destination folder is included in the script line
# 	and introduced by -@
	if {[lindex [getMfVersion] 1] <= 2.2} {
			append cmdline "input $tailMffilename;"
		} else {
			append cmdline "input $tailMffilename -@ [set MfmodeVars(outputFolder)]:"
		}
	set cmdline [curlyq $cmdline]
# 	Finally we update prefixes to rebuild accordingly the Other Files submenu
	updateprefixes
}

proc buildOZmakeLine {} {
	global cmdline fullMffilename tailMffilename MfmodeVars chosenMode
	global proof smoke localfont userDefined script resol mfModeForPrinter
	global gfcorners imagerules nodisplays
	global notransforms screenchars screenstrokes
	global mag magstep magflag magstepflag Mfbasefile Mfbasefileflag
	global prefixtfm prefixfpl prefixgf prefixlog
# OzMetafont cannot receive a complete command line through an Apple Event. 
# The workaround is to create a ".make" file which OzMetafont will process 
# with its built-in MakeTeXPK.
#	 	Side effect : the "pk" files will be done in the same time,
#	 	thus no need to invoke gftopk after that.
	set cmdline "MakeTeXPK [file rootname $tailMffilename] "
# What is the resolution corresponding to the printer mode ? We look for it in the
# modes.mf file.
	append cmdline "[lindex $resol 1] [lindex $resol 1] "
#   Do we magnify ?
	if {$magflag == 1} {append cmdline "$mag "
	} elseif {$magstepflag == 1} {
	append cmdline "magstep\($magstep\) "
	} else {
	append cmdline "1 "}
#   Choose the mode
	if {$chosenMode == "localfont"} {
		append cmdline 	"[lindex $resol 0]"	
	} elseif {$chosenMode == "proof" || $chosenMode == "smoke"} {
		append cmdline "$chosenMode"
	} else {
		append cmdline $MfmodeVars(mfModeForPrinter)
	}
#    Add the (optional!) options if the corresponding flag is set
	if $screenchars {append cmdline ";screenchars"}
	if $screenstrokes {
		if {$chosenMode != "proof"} {
			alertnote "The \"screenstrokes\" option is for proof mode only. I'll ignore it."
			mfToggle screenstrokes
			shadowMf screenstrokes
		} else {
			append cmdline ";screenstrokes"}
		}
		if $imagerules {
			append cmdline ";imagerules"}
		if $gfcorners {
			append cmdline ";gfcorners"}
		if $nodisplays {
			if {$chosenMode != "proof"} {
				alertnote "The \"nodisplays\" option is for proof mode only. I'll ignore it."
			} elseif {$screenchars || $screenstrokes} {beep 
				alertnote "Contradictory options : you can't use \"nodisplays\" with \"screenchars\" or \"screenstrokes\". I'll ignore it."
				mfToggle nodisplays
				shadowMf nodisplays
			} else {
				append cmdline ";nodisplays"}
			}
		if $notransforms {
			append cmdline ";notransforms"}
#    Input a base file if any
		if {$Mfbasefileflag == 1} {
			append cmdline ";input $Mfbasefile"
		}
# 	Finally we update prefixes to rebuild the "Other Files" submenu
	updateprefixes
}
				
proc doMfscript {} {
	global cmdline addcmdline fullMffilename script rootname
	global MfmodeVars mfAppSig
	switch $MfmodeVars(mfAppSig) {
		"CMT3" { 	
 			eval "AEBuild -t 6000 'CMT3'" CMTX exec {----} [list $cmdline] 
			}
		"OzMF" {
			app::launchFore "OzMF"
			dosc -c 'OzMF' -k 'aevt' -e 'odoc' -t 600 -r -f $fullMffilename
			}
		"TeX+"  {
			alertnote "Support for Direct Tex Pro still to be done. Sorry !"
		}
	}
}

proc createmakefile {} {
	global cmdline fullMffilename
	set fileId [open "[file dirname $fullMffilename]:tmp.make" w+] 
	puts $fileId $cmdline
	close $fileId
}
	
proc runmakefile {} {
	global fullMffilename
	app::launchFore "OzMF"
	dosc -c 'OzMF' -k 'aevt' -e 'odoc' -t 600 -r -f "[file dirname $fullMffilename]:tmp.make"
}
		
proc runmakeallfile {} {
	global folderpath MfmodeVars mfAppSig
	switch $MfmodeVars(mfAppSig) {
		"CMT3" {
			app::launchFore "CMT9"
			dosc -c 'CMT9' -k 'aevt' -e 'odoc' -t 600 -r -f "$folderpath:tmpall.make"
		}
		"OzMF" {
			app::launchFore "OzMF"
			dosc -c 'OzMF' -k 'aevt' -e 'odoc' -t 600 -r -f "$folderpath:tmpall.make"							
		}
	}
}
	
proc updateprefixes {} {
	global prefixtfm prefixfpl prefixgf prefixlog chosenMode
	if {$chosenMode == "proof"  || $chosenMode == "smoke"} {
		set prefixtfm "("
			} else {
		set prefixtfm ""}
	set prefixfpl "("
	set prefixgf ""
	set prefixlog ""
}


# This proc calls gftopk up
proc dopkProc {} {
	global gffile MfmodeVars outputFolder mfAppSig mfset 
	global mfwd folderpath
	switch $MfmodeVars(mfAppSig) {
		"CMT3" {
			if {![file exists $mfwd:$gffile]} {
				alertnote "Can't find file $gffile."
				return}
			set pkcmdline "gftopk $mfwd:$gffile"
			app::launchFore "CMTe"
			set pkcmdline [curlyq $pkcmdline]
			eval "AEBuild 'CMTe'" CMTX exec {----} [list $pkcmdline]
			}
		"OzMF" {
			if {![file exists $mfwd:$gffile]} {
				alertnote "Can't find file $gffile. Check that the \"delete_gf\" flag in OzMetafont configs is set to false."
				return}
			app::launchFore "OzMF"
			dosc -c 'OzMF' -k 'aevt' -e 'odoc' -t 6000 -r -f "$mfwd:$gffile"
			}
		"TeX+"  {
			alertnote "Support for Direct Tex Pro still to be done. Sorry !"
		}
	}
}

# This proc calls vftopl up
proc doplProc {} {
	global rootname MfmodeVars outputFolder mfAppSig tfmfile mfset 
	global mfwd folderpath
	switch $MfmodeVars(mfAppSig) {
		"CMT3" { 	
			if $mfset {
			set mfwd $folderpath
			} else {set mfwd $MfmodeVars(outputFolder)}
			if {$tfmfile != ""} {
				set plcmdline "tftopl $tfmfile $mfwd:${rootname}.fpl"
			} else {
				if {![file exists $mfwd:${rootname}.tfm]} {
					alertnote "Can't find file ${rootname}.tfm. Check your mode (no tfm in proof or smoke modes)."
					return}
				set plcmdline "tftopl $mfwd:${rootname}.tfm $mfwd:${rootname}.fpl"
			}
			app::launchFore "CMTk"
			set plcmdline [curlyq $plcmdline]
			eval "AEBuild -r 'CMTk'" CMTX exec {----} [list $plcmdline]
# 			app::launchFore "ALFA"
		}
		"OzMF" {
			if $mfset {
			set mfwd $folderpath
			} else {set mfwd [file dirname [win::Current]]}
			if {![file exists $mfwd:${rootname}.tfm]} {
				alertnote "Can't find file ${rootname}.tfm. Check that the \"delete_tfm\" flag in OzMetafont configs is set to false."
				return}
			app::launchBack "OzMF"
			if {$tfmfile != ""} {
			dosc -c 'OzMF' -k 'aevt' -e 'odoc' -t 600 -r -f $tfmfile				
				} else {
			dosc -c 'OzMF' -k 'aevt' -e 'odoc' -t 600 -r -f "$mfwd:${rootname}.tfm"
			app::launchFore "ALFA"
			}
		}
		"TeX+"  {
			alertnote "Support for Direct Tex Pro still to be done. Sorry !"
		}
	}
}

proc editplProc {} {
		global rootname MfmodeVars outputFolder mfAppSig 
		global mfwd tfmfile
	switch $MfmodeVars(mfAppSig) {
		"CMT3" { 	
			while {![file exists "$mfwd:${rootname}.fpl"]} {}
			edit -r "$mfwd:${rootname}.fpl"
			if [app::isRunning CMTk] {sendQuitEvent 'CMTk'}
		}
		"OzMF" {
			if {$tfmfile != ""} {
				if {[file exists "[file dirname $tfmfile]:[file rootname [file tail $tfmfile]].pl"]} {
					edit -r "[file dirname $tfmfile]:[file rootname [file tail $tfmfile]].pl"
				} else {alertnote "Can't find [file rootname [file tail $tfmfile]].pl"}
			} else {
				if {[file exists "$mfwd:${rootname}.pl"]} {
					edit -r "$mfwd:${rootname}.pl"
				} else {alertnote "Can't find ${rootname}.pl in $mfwd."}
			}
		}
		"TeX+"  {
			alertnote "Support for Direct Tex Pro still to be done. Sorry !"
		}
	}
			set prefixfpl ""
			menu::buildSome otherFiles
}


#########   Choosing Metafont printer mode for processing   ##################

proc choosemodeProc {menu item} {
		global MfmodeVars mfModeForPrinter chosenMode
		global proof smoke localfont userDefined
	switch $item {
		"proof" {set chosenMode proof
			choosemodeMark proof
			dimmOtherfiles
			message "mode proof - no tfm produced"
			}
		"smoke" {set chosenMode smoke
			choosemodeMark smoke
			dimmOtherfiles
			message "mode smoke - no tfm produced"
			}
		"localfont" {set chosenMode localfont
			choosemodeMark localfont
			undimmOtherfiles
			}
		"userDefined" {set chosenMode $MfmodeVars(mfModeForPrinter)
			choosemodeMark userDefined
			undimmOtherfiles
			alertnote "Current user defined mode is $MfmodeVars(mfModeForPrinter). You can change this in the Current Mode Prefs."
		}
	}
}

proc choosemodeMark {var} {
			clearAllModes
			markMenuItem metafontMode $var 1
}

proc clearAllModes {} {
	global proof smoke localfont userDefined
		foreach i {"proof" "smoke" "localfont" "userDefined"} {
			markMenuItem metafontMode $i 0
			} 
}



#####################   Metafont processing Options   ######################################

proc processingoptProc {menu item} {
	global mag magstep magflag magstepflag Mfbasefileflag
	global MfmodeVars Mfbasefile
	switch $item {	
	"mag..." {
			catch {prompt "Choose a magnification" $mag} res
			if {$res == "cancel"} {return}
			if {$res == 1} {
					set magflag 0
					set mag $res
					markMenuItem processingOptions "mag..." $magflag
				} else {
					set magstep 0
					set magstepflag 0
					set magflag 1
					set mag $res
					markMenuItem processingOptions "mag..." $magflag
					markMenuItem processingOptions "magstep..." $magstepflag
					}
		}
	"magstep..." {
			catch {prompt "Choose a magstep coefficient " $magstep} res
			if {$res == "cancel"} {return}
			if {$res == 0} {
					set magstepflag 0
					set magstep $res
					markMenuItem processingOptions "magstep..." $magstepflag
				} else {
					set mag 1
					set magflag 0
					set magstepflag 1
					set magstep $res
					markMenuItem processingOptions "mag..." $magflag
					markMenuItem processingOptions "magstep..." $magstepflag
					}
		}
	"baseFile..." {
		catch {getfile "Select a base file"} Mfbasefilepath
		set Mfbasefile [file tail $Mfbasefilepath] 
		set Mfbasefileflag 1
		markMenuItem processingOptions "baseFile..." $Mfbasefileflag
	}
	"gfcorners" {mfToggle gfcorners}
	"imagerules" {mfToggle imagerules}
	"nodisplays" {mfToggle nodisplays}
	"notransforms" {mfToggle notransforms}
	"screenchars" {mfToggle screenchars}
	"screenstrokes" {mfToggle screenstrokes}
	"clearAllOptions" {clearAllOptionsProc}
	}	
}


proc mfToggle {var} {
	global $var
	set $var [expr [set $var] ? 0 : 1]
	synchroniseModeVar $var
	shadowMf $var
}


proc shadowMf {name} {
	global gfcorners imagerules nodisplays
	global notransforms screenchars screenstrokes
	switch $name {
		"gfcorners"	{
			markMenuItem processingOptions gfcorners $gfcorners
		 }
		"imagerules"	{
			markMenuItem processingOptions imagerules $imagerules
		 }
		"nodisplays"	{
			markMenuItem processingOptions nodisplays $nodisplays
		 }
		"notransforms"	{
			markMenuItem processingOptions notransforms $notransforms
		 }
		"screenchars"	{
			markMenuItem processingOptions screenchars $screenchars
		 }
		"screenstrokes"	{
			markMenuItem processingOptions screenstrokes $screenstrokes
		 }
	}
}

proc clearAllOptionsProc {} {
	global gfcorners imagerules nodisplays
	global notransforms screenchars screenstrokes
	global mag magflag magstep magstepflag Mfbasefile Mfbasefileflag
		foreach i {"gfcorners" "imagerules" "nodisplays" "notransforms" "screenchars" "screenstrokes"} {
			set $i 0
			shadowMf $i
			}
		set mag 1
		set magflag 0
		set magstep 0
		set magstepflag 0
		set Mfbasefileflag 0
		set Mfbasefile ""
		markMenuItem processingOptions "baseFile..." $Mfbasefileflag
		markMenuItem processingOptions "mag..." $magflag
		markMenuItem processingOptions "magstep..." $magstepflag
}

proc dimmOtherfiles {} {
		enableMenuItem otherFiles "convertTfmToPl" 0
		enableMenuItem otherFiles "openPropertyList" 0
}

proc undimmOtherfiles {} {
		enableMenuItem otherFiles "convertTfmToPl" 1
		enableMenuItem otherFiles "openPropertyList" 1
}


######################   Related files procs  #####################################

proc getMfVersion {} {
	set sig "CMT3"
	set vers [objectProperty 'MACS' vers "obj {want:type(file), seld:$sig, form:fcrt, from:'null'()}"]
	if {[regexp {\.* (.*).*\\}$} $vers longvers numvers]} {
	return [list [string trim $longvers "\r\}"] [string trim $numvers "\r\}"]]
	} else {alertnote "Can't get version info"}
}

proc getFSSpec {directory} {
	global res 
	set res [AEBuild -r 'MACS' core getd {----} "obj{want:type('cobj'), from:'null'(), form:'name', seld:[curlyq $directory]}"  rtyp fss]
	if { [regexp {\(.*)\} $res blabla fssreco] } {
	return $fssreco
	} else {alertnote "Couldn't find FSSpec Record"}
}

# This proc looks in the current log file for a line indicating the name of
# the output file produced by Metafont so that we do not have to calculate
# the extension (which depends on the printer mode and the magnification)
proc findgfFile {} {
	global rootname MfmodeVars outputFolder mfAppSig gffile 
	global folderpath mfwd mfset
	switch $MfmodeVars(mfAppSig) {
		"CMT3" { 	
			if $mfset {
				set mfwd $folderpath
			} else {set mfwd $MfmodeVars(outputFolder)}
			if {![file exists $mfwd:${rootname}.log]} {
				beep 
				alertnote "Can't find file ${rootname}.log ; did you process ${rootname}.mf ?"
				return}
				catch {open "$mfwd:${rootname}.log"} fileId
			}
			"OzMF" {
				if $mfset {
					set mfwd $folderpath
				} else {set mfwd [file dirname [win::Current]]}
				if {![file exists $mfwd:${rootname}.log]} {
					beep 
					alertnote "Can't find file ${rootname}.log ; did you process ${rootname}.mf ? Check that the \"delete_log\" flag in OzMetafont configs is set to false."
					return}
					catch {open "$mfwd:${rootname}.log"} fileId
				}
				"TeX+"  {
					alertnote "Support for Direct Tex Pro still to be done. Sorry !"
				}
			}
			catch {read $fileId} textlog
			set textlog [split $textlog]
			catch {lsearch   -regexp  $textlog .*gf} indx
			if {[expr $indx > 0]} {
				set gffile [lindex $textlog $indx]
			} else {
				alertnote "According to ${rootname}.log, no gf output written."
			}
		}
		
proc findoutputfolder {} {
	global MfmodeVars outputFolder
	if {$MfmodeVars(outputFolder) == "" } {
		catch {get_directory -p "Select the output folder"} rootpath
		set MfmodeVars(outputFolder) [set rootpath]
 		addArrDef MfmodeVars outputFolder $rootpath
	}
}

proc findrootnameProc {} {
	global rootname 
  	set rootname [file rootname [file tail [win::Current]]]
	return
}

proc openmodesmfProc {} {
			global  MfmodeVars pathToModesMfFile
			if {[file exists $MfmodeVars(pathToModesMfFile) ]} {
			message "opening $MfmodeVars(pathToModesMfFile)"
			edit -r $MfmodeVars(pathToModesMfFile) 
			} else {
			alertnote "Can't find file modes.mf : where is it ?"
			catch	{getfile "Find file modes.mf"}  chemin
			removeArrDef MfmodeVars pathToModesMfFile
			set pathToModesMfFile $chemin
			set MfmodeVars(pathToModesMfFile) [set chemin]
 			addArrDef MfmodeVars pathToModesMfFile $chemin
  			edit -r $MfmodeVars(pathToModesMfFile)
			}
}

proc openplainmfProc  {} {
			global  MfmodeVars pathToPlainMfFile
			if {[file exists $MfmodeVars(pathToPlainMfFile) ]} {
			message "opening $MfmodeVars(pathToPlainMfFile)"
			edit -r $MfmodeVars(pathToPlainMfFile) 
			} else {
			alertnote "Can't find file plain.mf : where is it ?"
			catch	{getfile "Find file plain.mf"}  chemin
			removeArrDef MfmodeVars pathToPlainMfFile
			set pathToPlainMfFile $chemin
			set MfmodeVars(pathToPlainMfFile) [set chemin]
 			addArrDef MfmodeVars pathToPlainMfFile $chemin
  			edit -r $MfmodeVars(pathToPlainMfFile)
			}
}

proc deleteallfilesProc {ext} { 
	global MfmodeVars outputFolder
	switch $MfmodeVars(mfAppSig) {
		"CMT3" { 	
			set currentdir $MfmodeVars(outputFolder)
		}
		"OzMF" {
			set currentdir [file dirname [win::Current]]	
		}
		"TeX+"  {
			alertnote "Support for Direct Tex Pro still to be done. Sorry !"
			return
		}
	}
	if {![regexp "gf" $ext] && ![regexp "pk" $ext]} {
		set ext ".$ext"
	}
	set filesindir [glob -nocomplain "$currentdir:*$ext"]
	switch [buttonAlert "OK to remove all \"$ext\" files from $currentdir ?" "yes" "cancel" ] {
		"yes" {
			set longueur [llength $filesindir]
			if {$longueur == 0} {
				alertnote "No \"$ext\" file in output folder."
				return }
			foreach Mffile $filesindir {
				removeFile $Mffile
				message "$longueur file(s) removed"
			}
		}
		"cancel" {return}
	}
}
	
proc allAuxfilesProc {ext} {
	global Mffilename cmdline fromfolder MfmodeVars outputFolder folderpath
	findoutputfolder
	set mtf ".mf"
	set i 0
	set filesindir [glob -nocomplain "$folderpath:*$mtf"]
	set longueur [llength $filesindir]
	if {$longueur == 0} { 
		alertnote "Folder $folderpath is empty"
		return } 
	foreach Mffile $filesindir {
		if {[file exists "[string trimright $Mffile {.mf}].$ext"]} {
		edit -r "[string trimright $Mffile {.mf}].$ext"
		} else {set i [expr $i + 1]}
	}
	if {$i == $longueur} {
		alertnote "No \".$ext\" file(s)"
		} elseif {[expr $i > 0]} {alertnote "$i \".$ext\" file(s) missing."}
}

proc convertallProc {applic} {
	global cmdline fromfolder MfmodeVars outputFolder folderpath
	global rootname gffile mfset mfwd
	set i 0
	set mfset 1
	set ext(gftopk) "log"
	set ext(vftopl) "tfm"
	set filesindir [glob -nocomplain "$folderpath:*.mf"]
	set longueur [llength $filesindir]
	if {$longueur == 0} {set mfset 0
		return } 
	switch [buttonAlert "Process all the files in $folderpath with $applic ? " "yes" "cancel" ] {
		"yes" {
			foreach Mffile $filesindir {
			set rootname [file rootname [file tail $Mffile]]
			if {[file exists "$folderpath:$rootname.$ext($applic)"]} {
				switch $applic {
					"gftopk" {				
						findgfFile
						if {![file exists "$folderpath:$gffile"]} {
							set i [expr $i + 1]
							}
						dopkProc
						}
					"vftopl" {				
						doplProc
						while {![file exists "$mfwd:${rootname}.fpl"]} {}
						sendQuitEvent 'CMTk'
						set longueur [expr $longueur - 1]
						app::launchFore "ALFA"
						if [expr $longueur > 0] {
							alertnote "Click to proceed : $longueur files left."
							}
						}
					}				
				} else {
						alertnote "Can't find file $folderpath:$rootname.$ext($applic). Check the Metafont mode."
						set i [expr $i + 1]
						}
			}
		}
		"cancel" {set i $longueur}
	}
		set mfset 0
		if {$i == [llength $filesindir]} {
		alertnote "No \"pk\" file(s) computed."
		} elseif {[expr $i > 0]} {alertnote "$i \"pk\" file(s) missing. Check your \"log\" and your \"gf\" files."}
}

proc removefilesProc {menu item} {
	global MfmodeVars mfAppSig
	switch $item {	
		"allLogFiles"  {deleteallfilesProc log}
		"allGfFiles"  {deleteallfilesProc gf}
		"allPkFiles"  {deleteallfilesProc pk}
		"allTfmFiles" {deleteallfilesProc tfm}
		"allPlFiles" {
			switch $MfmodeVars(mfAppSig) {
				"CMT3" {deleteallfilesProc fpl}
				"OzMF" {deleteallfilesProc pl}
				"TeX+" {alertnote "Support for Direct Tex Pro still to be done. Sorry !"}
			}
		}
		"allOfThem" {
			foreach ext {"log" "gf" "pk" "tfm" "fpl" "pl"} {
				deleteallfilesProc $ext
			}
		}
	}
}
	
######################   Insert commands submenus   #####################################

proc newtemplateProc {} {
	new -n "newfont.mf"
# 	Ask how many chars in the font
	beep
	catch {prompt "How many chars in the new font ?" 128} nbchr
	if {$nbchr == "cancel"} {
		return
	} elseif {![isPositiveInteger $nbchr]} {
		beep
		message "invalid input: please enter a positive integer"
		return
	}
# 	Preambule instruction
	set t "\% This file : \n"
	append t "\% Created : [creationdate]\n"	
	append t "\% Author : \n"	
	append t "\% e-mail : \n"	
	append t "\% Comments :\n%\n%\n%\n\n"	
	append t "font_size  pt\#;    \% the \"design size\" of this font\n\n"
	append t "mode_setup;"
	append t "\n\n\%\%\%\% Parameters \%\%\%\%\n\n"
	append t "\n\n\%\%\%\% Pixellisation \%\%\%\%\n\n"
	append t "define_pixels();\n"
	append t "define_whole_pixels();\n"
	append t "define_whole_vertical_pixels();\n"
	append t "define_blacker_pixels();\n"
	append t "define_good_x_pixels();\n"
	append t "define_good_y_pixels();\n"
	append t "define_corrected_pixels();\n"
	append t "define_horizontal_corrected_pixels();\n"
	append t "\n\n\%\%\%\% Macros and definitions \%\%\%\%\n\n"
	append t "\n\n\%\%\%\% Drawing instruction for the characters \%\%\%\%\n\n"
	insertText $t
	set i 0
	for {set i 0} {$i < $nbchr} {incr i} {
			insertText "beginchar([set i],,,);\"\";\n\n\n\nendchar;\n\n"
		}
# 	Postambule instruction
	set t "\n\n\%\%\%\% Ligtables and kerning \%\%\%\%\n\n"
	append t "ligtable \"\": \"\" kern  \#;\n"
	append t "\n\n\%\%\%\% General Font Parameters \%\%\%\%\n\n"	
	append t "font_slant:= ;\n"
	append t "font_normal_space:= ;\n"
	append t "font_normal_stretch:= ;\n"
	append t "font_normal_shrink:=;\n"
	append t "font_quad:= ;\n"
	append t "font_x_height:= ;\n"
	append t "font_extra_space:= ;\n"
	append t "\nfont_coding_scheme:= \"\";\n"
	append t "font_identifier:= \"\";\n"
	append t "\n\nbye"
	insertText $t
}

proc creationdate {} {
	set date [lindex [mtime [now] long] 0]
	append date " - [lindex [mtime [now] long] 1]"
	return $date	
}

proc variablesProc {menu item} {
	switch $item {	
	" boolean" {insertObject "boolean ;\n"}
	" numeric" {insertObject "numeric ;\n"}
	" pair" {insertObject "pair ;\n"}
	" path" {insertObject "path ;\n"}
	" pen" {insertObject "pen ;\n"}
	" picture" {insertObject "picture ;\n"}
	" string" {insertObject "string ;\n"}
	" transform" {insertObject "transform ;\n"}
	}
}
proc booleanProc {menu item} {
	switch $item {	
	" charexists" {insertObject "charexists ;\n"}
	" cycle" {insertObject "cycle ;\n"}
	" false" {insertObject "false ;\n"}
	" known" {insertObject "known ;\n"}
	" true" {insertObject "true ;\n"}
	" unknown" {insertObject "unknown ;\n"}
	}
}
proc functionsProc {menu item} {
	switch $item {	
	" angle" {insertObject "angle ;\n"}
	" ceilling" {insertObject "ceilling ;\n"}
	" floor" {insertObject "floor()"}
	" cosd" {insertObject "cosd()"}
	" sind" {insertObject "sind()"}
	" mexp" {insertObject "mexp()"}
	" mlog" {insertObject "mlog()"}
	" sqrt" {insertObject "sqrt()"}
	" eps" {insertObject "eps "}
	" epsilon" {insertObject "epsilon "}
	" infinity" {insertObject "infinity "}
	" round" {insertObject "round()"}
	" hround" {insertObject "hround()"}
	" vround" {insertObject "vround()"}
	" solve" {insertObject "solve ;\n"}
	" tolerance" {insertObject "tolerance= ;\n"}
	" normaldeviate" {insertObject "normaldeviate()"}
	" randomseed" {insertObject "randomseed:= ;\n"}
	" uniformdeviate" {insertObject "uniformdeviate()"}
	" whatever" {insertObject "whatever "}
	}
}

proc positioningProc {menu item} {
	switch $item {	
	" clearxy" {insertObject "clearxy ;\n"}
	" direction" {insertObject "direction  of "}
	" directionpoint" {insertObject "directionpoint  of "}
	" directiontime" {insertObject "directiontime  of ;\n"}
	" penoffset" {insertObject "penoffset  of "}
	" pointof" {insertObject "point  of "}
	" precontrolof" {insertObject "precontrol  of "}
	" postcontrolof" {insertObject "postcontrol  of "}
	" intersectionpoint" {insertObject "  intersectionpoint "}
	" intersectiontimes" {insertObject " intersectiontimes "}
	" good.bot" {insertObject "good.bot "}
	" good.lft" {insertObject "good.lft "}
	" good.rt" {insertObject "good.rt "}
	" good.top" {insertObject "good.top "}
	" good.x" {insertObject "good.x "}
	" good.y" {insertObject "good.y "}
	" xpart" {insertObject "xpart()"}
	" xxpart" {insertObject "xxpart()"}
	" xypart" {insertObject "xypart()"}
	" ypart" {insertObject "ypart()"}
	" yxpart" {insertObject "yxpar()"}
	" yypart" {insertObject "yypart()"}
	}
}
proc pathsProc {menu item} {
	switch $item {	
	" flex" {mkflexProc}
	" fullcircle" {insertObject "fullcircle "}
	" halfcircle" {insertObject "halfcircle "}
	" quartercircle" {insertObject "quartercircle "}
	" superellipse" {insertObject "superellipse(,,,,);\n"}
	" unitsquare" {insertObject "unitsquare "}
	" makepath" {insertObject "makepath ;\n"}
	" interpath" {insertObject "interpath(,,);\n"}
	" subpath" {insertObject "subpath(,) of "}
	" tensepath" {insertObject "tensepath "}
	" counterclockwise" {insertObject "counterclockwise "}
	" reverse" {insertObject "reverse "}
	" turningnumber" {insertObject "turningnumber "}
	}
}
proc pensProc {menu item} {
	switch $item {	
	" clear_pen_memory" {insertObject "clear_pen_memory;"}
	" clearpen" {insertObject "clearpen;"}
	" currentpen" {insertObject "currentpen "}
	" makepen" {insertObject "makepen "}
	" nullpen" {insertObject "nullpen;"}
	" savepen" {insertObject ":=savepen;"}
	" pencircle" {insertObject "pencircle "}
	" pencircle..." {insertObject "pencircle  xscaled  yscaled ;\n"}
	" pensquare" {insertObject "pensquare "}
	" pensquare..." {insertObject "pensquare  xscaled  yscaled ;\n"}
	" penrazor" {insertObject "penrazor;"}
	" penspeck" {insertObject "penspeck;"}
	" pen_bot" {insertObject "pen_bot"}
	" pen_lft" {insertObject "pen_lft"}
	" pen_rt" {insertObject "pen_rt"}
	" pen_top" {insertObject "pen_top"}
	" pickup" {insertObject "pickup "}
	}
}
proc picturesProc {menu item} {
	switch $item {	
	" blankpicture" {insertObject "blankpicture"}
	" clearit" {insertObject "clearit ;\n"}
	" currentpicture" {insertObject "currentpicture"}
	" nullpicture" {insertObject "nullpicture"}
	" totalweight" {insertObject "totalweight "}
	" unitpixel" {insertObject "unitpixel"}
	}
}
proc stringsProc {menu item} {
	switch $item {	
	" ditto" {insertObject "ditto"}
	" jobname" {insertObject "jobname"}
	" readstring" {insertObject ":=readstring;"}
	" substring" {insertObject "substring(,) of "}
	}
}
proc transformationsProc {menu item} {
	switch $item {	
	" currenttransform" {insertObject "currenttransform "}
	" identity" {insertObject "identity "}
	" inverse" {insertObject "inverse "}
	" reflectedabout" {insertObject "reflectedabout(,) "}
	" rotated" {insertObject "rotated "}
	" rotatedaround" {insertObject "rotatedaround(,) "}
	" scaled" {insertObject "scaled "}
	" shifted" {insertObject "shifted "}
	" slanted" {insertObject "slanted "}
	" transformed" {insertObject "transformed "}
	" xscaled" {insertObject "xscaled "}
	" yscaled" {insertObject "yscaled "}
	" zscaled" {insertObject "zscaled "}
	}
}
proc definitionsProc {menu item} {
	switch $item {	
	" defenddef" {insertObject "def =\n\nenddef;\n"}
	" suffix" {insertObject "(suffix )"}
	" expr" {insertObject "(expr )"}
	" text" {insertObject "(text )"}
	" primarydefenddef" {insertObject "primarydef =\n\nenddef;\n"}
	" secondarydefenddef" {insertObject "secondarydef =\n\nenddef;\n"}
	" tertiarydefenddef" {insertObject "tertiarydef =\n\nenddef;\n"}
	" vardefenddef" {insertObject "vardef =\n\nenddef;\n"}
	" begingroupendgroup" {insertObject "begingroup \nendgroup;\n"}
	}
}
proc conditionsProc {menu item} {
	switch $item {	
	" forendfor" {insertObject "for  :  endfor;\n"}
	" foreverendfor" {insertObject "forever  endfor;\n"}
	" forsuffixesendfor" {insertObject "forsuffixes  :  endfor;\n"}
	" iffi" {insertObject "if  :  fi\n"}
	" ifelseifelsefi" {insertObject "if  elseif  else  fi\n"}
	" downto" {insertObject "downto "}
	" upto" {insertObject "upto "}
	" stepuntil" {insertObject "step  until  : "}
	" exitif" {insertObject "exitif ;"}
	" exitunless" {insertObject "exitunless ;"}
	}
}
proc drawingProc {menu item} {
	switch $item {	
	" addtoalso" {insertObject "addto  also ;\n"}
	" addtocontour" {insertObject "addto  contour  ;\n"}
	" addtocontourwithpen" {insertObject "addto  contour  withpen ;\n"}
	" addtocontourwithweight" {insertObject "addto  contour  withweight ;\n"}
	" addtodoublepathwithpen" {insertObject "addto  doublepath  withpen ;\n"}
	" addtodoublepathwithweight" {insertObject "addto  doublepath  withweight ;\n"}
	" culldropping" {insertObject "cull  dropping (,);\n"}
	" culldroppingwithweight" {insertObject "cull  dropping (,) withweight ;\n"}
	" cullkeeping" {insertObject "cull  keeping (,);\n"}
	" cullkeepingwithweight" {insertObject "cull  keeping (,) withweight ;\n"}
	" cullit" {insertObject "cullit ;\n"}
	" cutdraw" {insertObject "cutdraw "}
	" cutoff" {insertObject "cutoff(,);\n"}
	" draw" {insertObject "draw "}
	" drawdot" {insertObject "drawdot ;\n"}
	" erase" {insertObject "erase ;\n"}
	" fill" {insertObject "fill ;\n"}
	" filldraw" {insertObject "filldraw ;\n"}
	" penpos" {insertObject "penpos(,);\n"}
	" penstroke" {insertObject "penstroke ;\n"}
	" undraw" {insertObject "undraw ;\n"}
	" undrawdot" {insertObject "undrawdot ;\n"}
	" unfill" {insertObject "unfill ;\n"}
	" unfilldraw" {insertObject "unfilldraw ;\n"}
	}
}
proc charactersProc {menu item} {
	switch $item {	
	" begincharendchar" {insertObject "beginchar(\"\",,,);\"\";\n\nendchar;\n"}
	" extra_beginchar" {insertObject "extra_beginchar:=\"  \";\n"}
	" extra_endchar" {insertObject "extra_endchar:=\"  \";\n"}
	}
}
proc unitsProc {menu item} {
	switch $item {	
	" blacker" {insertObject "blacker=;\n"}
	" fillin" {insertObject "fillin=;\n"}
	" o_correction" {insertObject "o_correction= ;\n"}
	" fix_units" {insertObject "def fix_units= ;\nenddef\n"}
	" mode_setup" {insertObject "mode_setup;\n"}
	" pixels_per_inchs" {insertObject "pixels_per_inchs=;\n"}
	}
}
proc pixellisationProc {menu item} {
	switch $item {	
	" define_pixels" {insertObject "define_pixels();\n"}
	" define_blacker_pixels" {insertObject "define_blacker_pixels();\n"}
	" define_good_x_pixels" {insertObject "define_good_x_pixels();\n"}
	" define_good_y_pixels" {insertObject "define_good_y_pixels();\n"}
	" define_corrected_pixels" {insertObject "define_corrected_pixels();\n"}
	" define_horizontal_corrected_pixels" {insertObject "define_horizontal_corrected_pixels();\n"}
	" define_whole_pixels" {insertObject "define_whole_pixels();\n"}
	" define_whole_blacker_pixels" {insertObject "define_whole_blacker_pixels();\n"}
	" define_whole_vertical_pixels" {insertObject "define_whole_vertical_pixels();\n"}
	" define_whole_vertical_blacker_pixels" {insertObject "define_whole_vertical_blacker_pixels();\n"}
	}
}
proc fontdefinitionsProc {menu item} {
	switch $item {	
	" charlist" {insertObject "charlist :  :  :  : "}
	" extensible" {insertObject "extensible : , , , "}
	" font_coding_scheme" {insertObject "font_coding_scheme:= \"\";\n"}
	" font_extra_space" {insertObject "font_extra_space:= ;\n"}
	" font_identifier" {insertObject "font_identifier:= \"\";\n"}
	" font_normal_shrink" {insertObject "font_normal_shrink:= ;\n"}
	" font_normal_space" {insertObject "font_normal_space:= ;\n"}
	" font_normal_stretch" {insertObject "font_normal_stretch:= ;\n"}
	" font_quad" {insertObject "font_quad:= ;\n"}
	" font_size" {insertObject "font_size:= ;\n"}
	" font_slant" {insertObject "font_slant:= ;\n"}
	" font_x_height" {insertObject "font_x_height:= ;\n"}
	" fontdimen" {insertObject "fontdimen : , , , \n"}
	" headerbytes" {insertObject "headerbytes : , , , "}
	" ligtable" {insertObject "ligtable \"\" : \"\" =: oct\"\";\n"}
	" kern" {insertObject "kern \#"}
	}
}
proc displayingProc {menu item} {
	switch $item {	
	" currentwindow" {insertObject "currentwindow:= ;\n"}
	" displayinwindow" {insertObject "display  inwindow ;\n"}
	" openwindowfromtoat" {insertObject "openwindow  from (,) to (,) at (,);\n"}
	" screen_cols" {insertObject "screen_cols:= ;\n"}
	" screen_rows" {insertObject "screen_rows:= ;\n"}
	" screenrule" {insertObject "screenrule(,);\n"}
	}
}
proc outputProc {menu item} {
	switch $item {	
	" openit" {insertObject "openit;\n"}
	" shipit" {insertObject "shipit;\n"}
	" showit" {insertObject "showit;\n"}
	" labels" {insertObject "labels();\n"}
	" labelsrangethru" {insertObject "labels(range  thru );\n"}
	" penlabels" {insertObject "penlabels();\n"}
	" makelabel" {insertObject "makelabel(\"\",);\n"}
	" makegrid..." {mkgridProc}
	" proofoffset" {insertObject "proofoffset(,);\n"}
	" proofrule" {insertObject "proofrule(,);\n"}
	" proofrulethickness" {insertObject "proofrulethickness:=;\n"}
	" grayfont" {insertObject "grayfont \"\";\n"}
	" labelfont" {insertObject "labelfont \"\";\n"}
	" slantfont" {insertObject "slantfont \"\";\n"}
	" titlefont" {insertObject "titlefont \"\";\n"}
	}
}
proc debuggingProc {menu item} {
	switch $item {	
	" errhelp" {insertObject "errhelp "}
	" errmessage" {insertObject "errmessage \"\";\n"}
	" message" {insertObject "message \"\";\n"}
	" stop" {insertObject "stop;\n"}
	" show" {insertObject "show ;\n"}
	" showdependencies" {insertObject "showdependencies;\n"}
	" showstats" {insertObject "showstats;\n"}
	" showtoken" {insertObject "showtoken ;\n"}
	" showvariable" {insertObject "showvariable ;\n"}
	" loggingall" {insertObject "loggingall:= \n"}
	" tracingall" {insertObject "tracingall:= \n"}
	" tracingnone" {insertObject "tracingnone:= \n"}
	" batchmode" {insertObject "batchmode;\n"}
	" errorstopmode" {insertObject "errorstopmode;\n"}
	" nonstopmode" {insertObject "nonstopmode;\n"}
	" scrollmode" {insertObject "scrollmode;\n"}
	}
}
proc miscProc {menu item} {
	switch $item {	
	" capsule_def" {insertObject "capsule_def ;\n"}
	" expandafter" {insertObject "expandafter "}
	" gobble" {insertObject "gobble "}
	" gobbled" {insertObject "gobbled "}
	" interact" {insertObject "interact;\n"}
	" numtok" {insertObject "numtok "}
	" scantokens" {insertObject "scantokens "}
	" special" {insertObject "special \" \";\n"}
	" numspecial" {insertObject "numspecial ;\n"}
	}
}
proc varintProc {menu item} {
	switch $item {	
	" autorounding" {insertObject "autorounding:= ;\n"}
	" designsize" {insertObject "designsize:= ;\n"}
	" fontmaking" {insertObject "fontmaking:= ;\n"}
	" granularity" {insertObject "granularity:= ;\n"}
	" pausing" {insertObject "pausing:= ;\n"}
	" proofing" {insertObject "proofing:= ;\n"}
	" showstopping" {insertObject "showstopping:= ;\n"}
	" smoothing" {insertObject "smoothing:= ;\n"}
	" charcode" {insertObject "charcode:= ;\n"}
	" chardp" {insertObject "chardp:= ;\n"}
	" chardx" {insertObject "chardx:= ;\n"}
	" chardy" {insertObject "chardy:= ;\n"}
	" charext" {insertObject "charext:= ;\n"}
	" charht" {insertObject "charht:= ;\n"}
	" charic" {insertObject "charic:= ;\n"}
	" charwd" {insertObject "charwd:= ;\n"}
	" hppp" {insertObject "hppp:= ;\n"}
	" vppp" {insertObject "vppp:= ;\n"}
	" xoffset" {insertObject "xoffset:= ;\n"}
	" yoffset" {insertObject "yoffset:= ;\n"}
	" day" {insertObject "day;"}
	" month" {insertObject "month;"}
	" year" {insertObject "year;"}
	" time" {insertObject "time;"}
	" tracingcapsules" {insertObject "tracingcapsules:= ;\n"}
	" tracingchoices" {insertObject "tracingchoices:= ;\n"}
	" tracingcommands" {insertObject "tracingcommands:= ;\n"}
	" tracingedges" {insertObject "tracingedges:= ;\n"}
	" tracingequations" {insertObject "tracingequations:= ;\n"}
	" tracingmacros" {insertObject "tracingmacros:= ;\n"}
	" tracingonline" {insertObject "tracingonline:= ;\n"}
	" tracingoutput" {insertObject "tracingoutput:= ;\n"}
	" tracingpens" {insertObject "tracingpens:= ;\n"}
	" tracingrestores" {insertObject "tracingrestores:= ;\n"}
	" tracingspecs" {insertObject "tracingspecs:= ;\n"}
	" tracingstats" {insertObject "tracingstats:= ;\n"}
	" tracingtitles" {insertObject "tracingtitles:= ;\n"}
	" turningcheck" {insertObject "turningcheck:= ;\n"}
	" warningcheck" {insertObject "warningcheck:= ;\n"}
	}
}

# In this proc, choose the number of horizontal and vertical lines
# in a grid
proc mkgridProc {} {
	set macroName "makegrid"
	beep
	catch {prompt "$macroName:  how many x-coordinates ?" 3} numbx
	if {$numbx == "cancel"} {
		return
	} elseif {![isPositiveInteger $numbx]} {
		beep
		message "invalid input: please enter a positive integer"
		return
	}
	catch {prompt "$macroName:  how many y-coordinates ?" 3} numby
	if {$numby == "cancel"} {
		return
	} elseif {![isPositiveInteger $numby]} {
		beep
		message "invalid input: please enter a positive integer"
		return
	}
	if {$numbx && $numby} {
		set body "makegrid("
		for {set i 1} {$i < $numbx} {incr i} {
			append body ","
		}
		append body ")("
		for {set i 1} {$i < $numby} {incr i} {
			append body ","
		}
		append body ");\n"
	} else {
		set body "\r"
	}
	insertObject $body
}

# In this proc, choose the number of points on a flex path
proc mkflexProc {} {
	set macroName "flex"
	beep
	catch {prompt "$macroName:  how many points on the flex-path ?" 3} numbp
	if {$numbp == "cancel"} {
		return
	} elseif {![isPositiveInteger $numbp]} {
		beep
		message "invalid input: please enter a positive integer"
		return
	}
	if {$numbp} {
		set body "flex("
		for {set i 1} {$i < $numbp} {incr i} {
			append body ","
		}
		append body ") "
	} else {
		set body "\r"
	}
	insertObject $body
}


#########   Syntax Colorizing  ###########

set	mfKeyWords	{ 
abs addto also and angle at autorounding batchmode beginchar begingroup blacker 
blankpicture boolean bot bye byte capsule_def ceilling change_width char character 
charcode chardp chardx chardy charexists charext charht charic charlist 
charwd checksum clear_pen_memory clearit clearpen clearxy codingscheme  comment contour 
cosd counterclockwise cull cullit currentpen currentpicture currenttransform 
currentwindow cutdraw cutoff cycle day decimal decr def define_blacker_pixels 
define_good_x_pixels define_good_y_pixels define_pixels define_whole_pixels designsize 
direction directionpoint directiontime display displaying ditto dotprod doublepath downto 
draw drawdot dropping else elseif end endchar enddef endfor endgroup eps epsilon 
erase errhelp errmessage errorstopmode exitif exitunless extensible extra_beginchar extra_endchar 
extraspace face false family fi fill filldraw fillin fix_units flex floor font_coding_scheme font_extra_space 
font_identifier font_normal_shrink font_normal_space font_normal_stretch font_quad 
font_size font_slant font_x_height fontdimen fontmaking forever forsuffixes from 
fullcircle gfcorners gobble gobbled good.bot good.lft good.rt good.top good.x good.y 
granularity grayfont halfcircle headerbytes hex hide hppp hround identity if imagerules 
incr infinity input interact interim interpath intersectionpoint intersectiontimes 
inverse inwindow italcorr jobname join_radius keeping kern known label labelfont labels length 
let lft ligtable loggingall makegrid makelabel makepath makepen max message mexp min 
mlog mode_setup month nodisplays nonstopmode normaldeviate not notransforms 
nullpen nullpicture numeric numspecial numtok o_correction oct 
odd openit openwindow or pair path pausing pen pen_bot pen_lft 
pen_rt pen_top pencircle penlabels penoffset penpos penrazor penspeck pensquare 
penstroke pickup picture pixels_per_inchs point postcontrol precontrol primarydef 
proofing proofoffset proofrule proofrulethickness quad quartercircle range readstring reflectedabout 
reverse rotated rotatedaround round rt save savepen scaled scantokens screen_cols 
screen_rows screenchars screenrule screenstrokes scrollmode secondarydef shifted shipit show 
showdependencies showit showstats showstopping showtoken showvariable shrink sind slant slanted 
slantfont smoothing solve space special sqrt step stop str stretch string subpath substring superellipse 
tensepath tertiarydef thru time titlefont to tolerance top totalweight tracingall tracingcapsules 
tracingchoices tracingcommands tracingedges tracingequations tracingmacros tracingnone 
tracingonline tracingoutput tracingpens tracingrestores tracingspecs tracingstats 
tracingtitles tracingtitles transform transformed true turningcheck turningnumber 
undraw undrawdot unfill unfilldraw uniformdeviate unitpixel unitsquare unknown until 
upto vardef vppp vround warningcheck whatever withpen withweight xheight xoffset xpart xscaled 
xxpart xypart year yoffset yoffset ypart yscaled yxpart yypart zscaled 
}


regModeKeywords  -e {%} -c $MfmodeVars(commentColor) \
  -k $MfmodeVars(keywordColor)  -s $MfmodeVars(stringColor) Mf $mfKeyWords
unset mfKeyWords

############   Completions  ################

set completions(Mf) {completion::electric}

set Mfelectrics(for)  "  :  endfor;\n"
set Mfelectrics(beginchar)   "(\"\",,,);\"\";\n\nendchar;\n"
set Mfelectrics(def)   " =\n\nenddef;\n"
set Mfelectrics(primarydef)   " =\n\nenddef;\n"
set Mfelectrics(secondarydef)   " =\n\nenddef;\n"
set Mfelectrics(tertiarydef)   " =\n\nenddef;\n"
set Mfelectrics(vardef)   " =\n\nenddef;\n"
set Mfelectrics(begingroup)   " \nendgroup;\n"
set Mfelectrics(forever)   "  endfor;\n"
set Mfelectrics(forsuffixes)   "  :  endfor;\n"
set Mfelectrics(if)   "  :  fi\n"


############   Key Bindings  ################

# Are there bindings necessary in this mode ?

##########    File Marking  ############
# All the "def" and "vardef" definitions in a mf source file will be marked in the "M" 
# pop-up menu (top right of the current window). All the beginchar/endchar groups will 
# be marked too (even if you changed the name of this environment in the mode specific prefs :
# if you chose to call them "myfontchar" then all the "myfontchar" instructions will be marked)

proc Mf::MarkFile {} {
	global MfmodeVars
	set bgnch $MfmodeVars(userBeginchar)
	set end [maxPos]
	set pos 0
 	while {![catch {search -f 1 -r 1 -m 0 -i 0 {^'$bgnch'[ _\w\d\(\"]*|^def[ _\w]*|^vardef[ _\w]*} $pos} res]} {
		set start [lindex $res 0]
		set end [lindex $res 1]
		set txt [getText [expr $start - 1] $end]
		set pos [nextLineStart $start]
		set inds($txt) [lineStart [expr $start - 1]]
	}

	if {[info exists inds]} {
 		foreach f [lsort [array names inds]] {
			set next [nextLineStart $inds($f)]
			setNamedMark $f $inds($f) $next $next
		}
	}
	set end [maxPos]
	set pos 0
 	while {![catch {search -f 1 -r 0 -m 0 -i 0 $bgnch $pos} res]} {
		set start [lindex $res 0]
		set end [nextLineStart $start]
		set txt [getText [expr $start - 1] $end]
		set pos [nextLineStart $start]
		set inds($txt) [lineStart [expr $start - 1]]
	}

	if {[info exists inds]} {
 		foreach f [lsort [array names inds]] {
			set next [nextLineStart $inds($f)]
			setNamedMark $f $inds($f) $next $next
		}
	}
}

