#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>

#include <forms.h>

#include "load_data.h"
#include "main_window.h"
#include "load_window.h"
#include "message_window.h"


extern BS_data_list data;
extern char   field_name_list[][32];
extern FD_main_window *main_window;
extern FD_load_window *load_window;
extern FD_message_window *message_window;

char file_names[200][500];
char bibinputs[250];

BS_data_list load_data();

void
fields(char buffer[BUFFERSIZE], BS_data_list entry)
{
  int i,j,irun,fieldindex,start,end,brackets;

  char field[100];

  /* besetze entry vor mit 0-Eintragen gibt adressen fuer realloc*/

  irun=-1;
  while(++irun < MAXFIELDS)
    {
      entry->field_text[irun]=(char *)malloc(1);
      memset(entry->field_text[irun],'\0',1);
    }

  /* remove '\n', double spaces and space before/after `{`/`}`     */
  while(strstr(buffer," }"))
    memmove(strstr(buffer," }"),strstr(buffer," }")+1,strlen(buffer));
  while(strstr(buffer,"{ "))
    memmove(strstr(buffer,"{ ")+1,strstr(buffer,"{ ")+2,strlen(buffer));
  while(strstr(buffer,"\n"))*strstr(buffer,"\n")=' ';
  while(strstr(buffer,"  "))
    memmove(strstr(buffer,"  "),strstr(buffer,"  ")+1,strlen(buffer));

  irun=strstr(buffer,entry->keyword)-&buffer[0];
  brackets=1;
  while(irun < strlen(buffer))
    {
      /* search field name */
      while(buffer[++irun] != ',' && irun < strlen(buffer))
	if(buffer[irun]=='}')
	  brackets--;
      while(isalnum(buffer[++irun]) == 0 && irun < strlen(buffer))
	if(buffer[irun]=='}')
	  brackets--;
      start=irun;
      while(isalnum(buffer[++irun]))
	;
      end=irun;
      if(brackets > 0)
	{

	  /* write field name to variable field */
	  memmove(field,buffer+start,end-start);
	  memset(field+end-start,'\0',1);

	  /* change to upper case */
	  i=-1;
	  while(++i< strlen(field))field[i]=toupper(field[i]);

	  /* find index number for field */
	  /* compare to list predefined in load_data.h */
	  fieldindex=i=-1;
	  while(++i<  MAXFIELDS)
	    {
	      if(strcmp(field_name_list[i],field) == 0)
		{
		  fieldindex=i;
		  i=MAXFIELDS;
		}

	      /* for not predefined field names */
	      /* reached end of list with entries 
		 without finding matching field name */
	      if(strlen(field_name_list[i]) == 0 && fieldindex == -1)
		{
		  /* add field name to list */
		  memmove(&field_name_list[i],field,strlen(field));
		  fieldindex=i;
		  i=MAXFIELDS;
		}
	    }
	  
	  /* search field_text in buffer */
	  
	  while(buffer[++irun] != '{');
	  
	  start=irun+1;
	  brackets++;
	  while(brackets > 1)
	    {
	      irun++;
	      if(buffer[irun]=='{' && buffer[irun-1]!='\\')brackets++;
	      if(buffer[irun]=='}' && buffer[irun-1]!='\\')brackets--;
	    }
	  end=irun;
	  entry->field_text[fieldindex]=
	    (char *)realloc(entry->field_text[fieldindex],
			    end-start+2);
	  memmove(entry->field_text[fieldindex],buffer+start,end-start);
	  memset(entry->field_text[fieldindex]+end-start,'\0',1);
	  /* strcat(entry->field_text[fieldindex],""); */
	}
    }

}

/*---------------------------------------------------------------------*/

void
search_keyword(char buffer[BUFFERSIZE], BS_data_list entry)
{

  int irun,irun1,start;
  char keyword[200];

  irun=MIN(strstr(buffer,"{")-&buffer[0],
	  strstr(buffer,"\(")-&buffer[0]);
  
  while(buffer[++irun] == ' ');
 
  start=irun;
  
  while(buffer[irun] != ' ' && buffer[irun] != ',')
    {
      keyword[irun-start]=buffer[irun];
      irun++;
    }
  keyword[irun-start]='\0';


  /* Save keyword */
  entry->keyword=(char *)malloc(strlen(keyword)+1);
  memmove(entry->keyword,keyword,strlen(keyword)+1);

}

/*----------------------------------------------------------------------------*/

int 
check_buffer(char buffer[BUFFERSIZE],  
		 char file_name[100],
		 char entry_type[20])
{
  char entry_types[500];
  char message[200];

  int valid,entrytypelen,irun;

  sprintf(entry_types,ENTRYTYPES);

  valid=0;
  if(strstr(buffer,"{") !=0 || 
     strstr(buffer," ") !=0 ||
     strstr(buffer,"\(") !=0)
    {
      entrytypelen=MIN(strstr(buffer,"{")-&buffer[0],
		       strstr(buffer,"\(")-&buffer[0]);
      entrytypelen=MIN(entrytypelen,
		       strstr(buffer," ")-&buffer[0]);
      
      sprintf(entry_type,"");
      strncat(entry_type,buffer,MIN(20,entrytypelen));

      irun=entrytypelen;
      while(irun > 0)
	{
	  if( entry_type[irun]> 'Z')
	    entry_type[irun]=entry_type[irun]-('z'-'Z');
	  irun--;
	}
      valid=(int)strstr(entry_types,entry_type);
    }
  
  if(valid == 0)
    {
      sprintf(entry_type,"");
      strncat(entry_type,buffer,MIN(20,entrytypelen));
      printf("\007");
      sprintf(message,"\007 \nAttention! In file: %s",file_name);
      fl_addto_browser(message_window->messages,message);
      sprintf(message,"%s... \n is not the begin of a valid BibTeX entry!!!\n",entry_type);
      fl_addto_browser(message_window->messages,message);
    }
  return valid;
}

void
cb_load_dir(FL_OBJECT *ob, long button)
{
  FILE *fileliste;

  char file_name[200];
  char command[100];
  int i;

  i=0;
  do i++;
  while(fl_isselected_browser_line(load_window->load_dir,i)==0);
  
  if(strcmp("../",
	    fl_get_browser_line(load_window->load_dir,i))!=0 &&
     strcmp("./",
	    fl_get_browser_line(load_window->load_dir,i))!=0
     )
    strcat(bibinputs,
	   fl_get_browser_line(load_window->load_dir,i));
  else
    {
      if(strcmp("../",
		fl_get_browser_line(load_window->load_dir,i))==0)
	{
	  i=strlen(bibinputs)-1;
	  while(bibinputs[--i]!= '/' && i>0)
	    bibinputs[i]=0;
	}
    }
  sprintf(command,"ls -apw 1 %s  > %s/.fileliste",
	  bibinputs,getenv("HOME"));

  system(command);
  
  sprintf(file_name,"%s/.fileliste",getenv("HOME"));
  /* open list */
  fileliste=fopen(file_name,"r");
  
  fl_clear_browser(load_window->load_dir);
  while(fgets(file_name,200,fileliste)!=NULL)
    if(file_name[strlen(file_name)-2]=='/')
      {
	file_name[strlen(file_name)-1]=0;
	fl_addto_browser(load_window->load_dir,file_name);
      }
  fl_set_browser_topline(load_window->load_dir,1);
  fclose(fileliste);
  
  /* list  bib-files to file */
  sprintf(command,"ls -apw 1 %s*.bib > %s/.fileliste",
	  bibinputs,getenv("HOME"));/**/
    system(command);
    
    sprintf(file_name,"%s/.fileliste",getenv("HOME"));
    /* open list */
    fileliste=fopen(file_name,"r");
    
    fl_clear_browser(load_window->load_files);
    while(fgets(file_name,200,fileliste)!=NULL)
    {
      while(strstr(file_name,"/"))
	memmove(file_name,strstr(file_name,"/")+1,strlen(file_name));
      file_name[strlen(file_name)-1]=0; 
      fl_addto_browser(load_window->load_files,file_name);
    }
    fl_set_browser_topline(load_window->load_files,1);
    fclose(fileliste);
    sprintf(command,"rm %s/.fileliste",getenv("HOME"));
    system(command);
    
}

void
cb_load_done(FL_OBJECT *ob, long button)
{
  char command[250];
  int i,j;

  i=1;
  j=0;
  do
    {
      if(fl_isselected_browser_line(load_window->load_files,i)!=0)
	sprintf(file_names[j++],"%s",
		fl_get_browser_line(load_window->load_files,i));
    }
  while(i++<fl_get_browser_maxline(load_window->load_files));
  sprintf(file_names[j],"\0");
    
  if(j)
    {

      
      fl_hide_form(load_window->load_window);  
      
      if(load_data());
      {
	list_data(0);
	fl_set_menu_item_mode(main_window->file,3,FL_PUP_NONE);
	fl_set_menu_item_mode(main_window->edit,1,FL_PUP_NONE);
	fl_set_menu_item_mode(main_window->edit,2,FL_PUP_NONE);
	fl_set_menu_item_mode(main_window->edit,3,FL_PUP_NONE);
	fl_set_menu_item_mode(main_window->edit,4,FL_PUP_NONE);
	fl_set_menu_item_mode(main_window->edit,5,FL_PUP_NONE);
	fl_activate_object(main_window->sort_by);
	fl_activate_object(main_window->list_column_choice);
	fl_activate_object(main_window->main_search);
      }
      fl_activate_form(main_window->main_window);  
    }
}

/*----------------------------------------------------------------*/
void
cb_load_cancel(FL_OBJECT *ob, long button)
{
  fl_hide_form(load_window->load_window);  
  fl_activate_form(main_window->main_window);  
}

/*----------------------------------------------------------------*/
  /* Select .bib files */
void
select_bibfiles()
{
  FILE *fileliste;
  
  char file_name[200];
  char dir_name[200];
  char command[250];

  sprintf(bibinputs,"%s",getenv("BIBINPUTS"));
  if(strstr(bibinputs,"(null)")!=0)
    sprintf(bibinputs,"%s",getenv("HOME"));
  while(isalnum(bibinputs[strlen(bibinputs)-1])==0)
    bibinputs[strlen(bibinputs)-1]=0;
  strcat(bibinputs,"/");

 /* list  directories to file */
  sprintf(command,"ls -apw 1  %s > %s/.fileliste",
	  bibinputs,getenv("HOME"));
  system(command);

  sprintf(file_name,"%s/.fileliste",getenv("HOME"));
  /* open list */
  fileliste=fopen(file_name,"r");
  
  fl_clear_browser(load_window->load_dir);
  while(fgets(file_name,200,fileliste)!=NULL)
    if(file_name[strlen(file_name)-2]=='/')
      {
	file_name[strlen(file_name)-1]=0;
	fl_addto_browser(load_window->load_dir,file_name);
      }
  fl_set_browser_topline(load_window->load_dir,1);
  fclose(fileliste);
  
 /* list  bib-files to file */
  sprintf(command,"ls -apw 1 %s*.bib > %s/.fileliste",bibinputs,getenv("HOME"));/**/
  system(command);

  sprintf(file_name,"%s/.fileliste",getenv("HOME"));
  /* open list */
  fileliste=fopen(file_name,"r");
  
  fl_clear_browser(load_window->load_files);
  while(fgets(file_name,200,fileliste)!=NULL)
    {
      while(strstr(file_name,"/"))
	memmove(file_name,strstr(file_name,"/")+1,strlen(file_name));
      file_name[strlen(file_name)-1]=0; 
      fl_addto_browser(load_window->load_files,file_name);
    }
  fl_set_browser_topline(load_window->load_files,1);
  fclose(fileliste);
  sprintf(command,"rm %s/.fileliste",getenv("HOME"));
  system(command);

  fl_deactivate_form(main_window->main_window);
  fl_activate_form(load_window->load_window);    
  fl_show_form(load_window->load_window,FL_PLACE_MOUSE,FL_FULLBORDER,"BibOrg Load");
 
}

BS_data_list
load_data()
{
  FILE *datafile,*fileliste;
  char *resultat;

  char file_name[100];

  char line[LINESIZE],buffer[BUFFERSIZE];
  char entry_type[20];
  char message[200];

  int *n_files;
  int nf,bibtexfile,nfile,entries,irun;

  BS_data_list first_entry, present_entry;
             

  const FL_Dirlist *Dirlist;  
  FL_Dirlist *dl;  

  nf=0;

  entries=0;

  sprintf(file_name,"%s%s",bibinputs,file_names[nf]);
  while(strlen(file_names[nf]) != 0)
    {
      nf++;
      
      /* load bibfile entries into memory */
      
      /* initialize list */
      
      bibtexfile=0;
      
      if(datafile=fopen(file_name,"r"))
	{
	  sprintf(message,"Loading form %s",file_name);
	  fl_addto_browser(message_window->messages,message);
	  buffer[0]=0;
	  resultat=fgets(line,LINESIZE,datafile);
	  while(resultat != NULL  )
	    {
	      if(line[0] == '@')
		{
		  sprintf(buffer,line);
		  bibtexfile=1;
		  
		  do{
		    resultat=fgets(line,LINESIZE,datafile);
		    strcat(buffer,line);
		  }while(line[0] != '@' && resultat != NULL);
		  
		  if(check_buffer(buffer,file_name,entry_type)!=0)
		    {
		      /* Write Bib-entry to memory */
		      entries++;
		      if(entries ==1)
			{
			  present_entry = (BS_data_list) malloc(sizeof(BS_dl_entry));
			  first_entry=present_entry;
			}
		      else
			{
			  present_entry->next_entry= 
			    (BS_data_list) malloc(sizeof(BS_dl_entry));		  
			  present_entry=present_entry->next_entry;
			}
		      present_entry->next_entry=first_entry;
		      /* Save file name */ 
		      present_entry->file_name=(char *)malloc(strlen(file_name)+1);
		      memmove(present_entry->file_name,file_name,strlen(file_name)+1);
		      /* Save entry type */ 		  
		      present_entry->entry_type=(char *)malloc(strlen(entry_type)+1);
		      memmove(present_entry->entry_type,entry_type+1,strlen(entry_type));
		      /* search and save keyword */
		      search_keyword(buffer,present_entry);
		      /* search and save fields  */
		      fields(buffer,present_entry);
		      /* data visible */
		      present_entry->visible=1;

		    }
		}
	      else
		/* Next entry */
		fgets(line,LINESIZE,datafile);
	    }
	  
	  if(resultat == NULL &&
	     bibtexfile ==0)
	    {
	      printf("\007\007\007");
	      sprintf(message,"Attention: %s \n is definitely not a BibTeX file!!!",file_name);
	      fl_addto_browser(message_window->messages,message);
	    }
	  fclose(datafile);
	} 
     sprintf(file_name,"%s%s",bibinputs,file_names[nf]);
    }

  sprintf(message,"%i bib entries loaded",entries);
  fl_addto_browser(message_window->messages,message);

  if(entries ==0) first_entry=0;
  if(data!=0)
    {
      present_entry->next_entry=data;
      while(data->next_entry != present_entry->next_entry)
	data=data->next_entry;
      data->next_entry=first_entry;
    }
  data=present_entry->next_entry;
  
  /* update choices for sorting/display 2. column*/
  fl_clear_choice(main_window->list_column_choice);
  fl_clear_choice(main_window->sort_by);
  irun=0;
  while(irun++<MAXFIELDS &&
	strlen(&field_name_list[irun][0])!=0)
    {
      fl_addto_choice(main_window->sort_by,&field_name_list[irun][0]);
      fl_addto_choice(main_window->list_column_choice,&field_name_list[irun][0]);
    }
  fl_set_choice(main_window->list_column_choice,19);

  return data;
}





