#include <stdio.h>
#include <ctype.h>
#include <X11/Intrinsic.h>
#include <unistd.h>
#include "bibview.h"


#define YYSTYPE char

#define __RUNTIME_YYMAXDEPTH
#define YYMAXDEPTH 1000

char uebergabe[MAX_UEBERGABE];
char ue2[MAX_UEBERGABE];
int ueIdx = 0;

FILE *tempDatei;
extern FILE *yyin;
extern YY_NEW_FILE;
extern int yy_init;

extern int fld_indent, cont_indent, newline_indent, max_fields;

typedef struct _Snode {
                       char inh;
                       int slen;
                       struct _Snode *next;
} Snode;

/*******************************************/
/* Globale Variablen                       */
/*******************************************/

int yynline;
int yynflexcalls;
int yynerrs;
char errorstr[MAX_ERRORSTRLEN];

/*******************************************/
/* Lokale Variablen                        */
/*******************************************/

static Snode *key = NULL;            
static Snode *fldname = NULL;       

static char errstr[MAX_ERRLINELENGTH];
#ifdef GERMAN
static char *anfhelpstr = 
  "Es wurden leider Fehler entdeckt\n\n\t%15s\t\t%10s\t%10s\n";
static char *endhelpstr = 
  "\n%40s: %3d Fehler";
#else
static char *anfhelpstr = 
  "Sorry, but there were syntax errors:\n\n\t%15s\t\t%10s\t%10s\n";
static char *endhelpstr = 
  "\n%40s: %3d errors";
#endif
static CardType cardtype;
static CardData *card = NULL;
static UserFld *helpufield = NULL;
static String helpFldName = NULL;
static String errkey;
static Errcode err;
static BibPtr glbbp;
static int beginIdx;
static int keyline;
static int errorline;

/*******************************************/
/* Lokale Funktionen                       */
/*******************************************/

static void PushSign(Snode **w, char a);
static void FreeStack(Snode **s);
static void StringToString(char *text1, char **text); 
static void StackToString(Snode *s, char **text); 
static void GetKey();
static void GetFldNameCont();
static void SecStrcat(int maxlen, char *str1, char *str2);

static int SetInputFile(char *file);
static int SkipSpace(char *text, char *text2);
static int SkipNewLineSpace(char *text);
static int SkipApe(char *text);
static int StringIsPeteEmpty(char *text);
static void WriteRecToFile(CardData *card, FILE *datei);
static long WriteLineToFile(FILE *datei, char *feld, char *inh);
#ifdef __cplusplus
#  include <stdio.h>
   extern "C" {
     extern void yyerror(char *);
     extern int yylex();
   }
#endif	/* __cplusplus */ 
# define COMMENT 257
# define STRING 258
# define PREAMBLE 259
# define TYPE 260
# define KOMMA 261
# define EQ 262
# define AFFE 263
# define LGKL 264
# define RGKL 265
# define LRKL 266
# define RRKL 267
# define DAZ 268
# define ZAUN 269
# define PROZENT 270
# define ZEICHEN 271
# define WHITE_SPACE 272
# define BUCHSTABE_ZAHL 273
# define KOMMENTAR 274
#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif

/* __YYSCLASS defines the scoping/storage class for global objects
 * that are NOT renamed by the -p option.  By default these names
 * are going to be 'static' so that multi-definition errors
 * will not occur with multiple parsers.
 * If you want (unsupported) access to internal names you need
 * to define this to be null so it implies 'extern' scope.
 * This should not be used in conjunction with -p.
 */
#ifndef __YYSCLASS
# define __YYSCLASS static
#endif
#ifndef YYSTYPE
#define YYSTYPE int
#endif
YYSTYPE yylval;
__YYSCLASS YYSTYPE yyval;
typedef int yytabelem;
# define YYERRCODE 256



static int SkipApe(char *text)
{ 
 int erg, back;

 erg = 0;
 while (erg < MAX_UEBERGABE) {
   if (*text == '@') 
     return erg+1;
   text++;
   erg++;
 }
 return 0;
}


static int SkipNewLineSpace(char *text)
{ 
 int erg, back;

 erg = 0;
 while (erg < MAX_UEBERGABE) {
   if (*text == '{' ||  *text == '(') {
     back = strlen(text);
     text = text + back;
     while (*text != '}' && *text != ')') { 
       *text = '\0';
       text--;
     }
     return erg;
   }
   text++;
   erg++;
 }
 return 0;
}


static int SkipSpace(char *text, char *text2)
{
 int erg, lgkl, daz, index, inmakro;
 char *zaehler;

 index = 0;
 lgkl = 0;
 daz = 0;
 inmakro = 0;
 zaehler = text2;

 while ((*text == ' ' || *text == '=' || *text == '\t') && index < ueIdx) { text++; index++; }
 erg = index;
 if (*text == '{') {
   lgkl += 1;
   index++;
   text++; 
   inmakro = 0;
 }
 else if (*text == '"') {
   daz += 1;
   index++;
   text++; 
   inmakro = 0;
 }
 else {
   *zaehler++ = '@';
   *zaehler++ = *text;
   index++;
   text++; 
   inmakro = 1;
 }
 while (index < ueIdx) {
   if (isalnum(*text)) {
     if (lgkl < 1 && daz < 1 && (inmakro==0)) {
       if (text[index-1] != ' ') 
	 *zaehler++ = ' ';
       *zaehler++ = '@';
       *zaehler++ = *text;
       inmakro = 1;
     }
     else {                        /* Zeichen in String */
       *zaehler++ = *text;
     }
     text++;
     index++;
   } 
   else if (*text == '{') {
     if (lgkl >= 1 || daz >= 1) {  /* Klammer in String */
       *zaehler++ = *text;
     }
     text++;                       /* Klammer nach Zaun */
     index++;
     lgkl += 1;
     inmakro = 0;
   }
   else if (*text == '\n') {
     *zaehler++ = *text;
     text++;
     index++;
     while ((*text == ' ') || (*text == '\t')){
        text++;
	index++;
	}
     inmakro = 0;
   }
   else if (*text == '}') {
     if ((lgkl > 1) || (daz >= 1)) {
       *zaehler++ = *text;
     } 
     text++;
     index++;
     lgkl -= 1;
     inmakro = 0;
   }
   else if (*text == '"') {
     if (lgkl >= 1) {
       *zaehler++ = *text;
       text++;
       index++;
     } 
     else {
       text++;
       index++;
       if (daz == 0) daz++;
       else daz = 0;
     }
     inmakro = 0;
   }
   else if (*text == '#') {        /* Space vor/nach Konkatenation */
     if (lgkl < 1 && daz < 1) {
       if (text[index-1] != ' ')
          *zaehler++ = ' ';
       *zaehler++ = '@';
       *zaehler++ = *text;
       if (text[index+1] != ' ')
          *zaehler++ = ' ';
     }
     else {                        /* Konkatenation in String */
       *zaehler++ = *text;
     }
     text++;
     index++;
     inmakro = 0;
   } 
   else if (*text == ',') {        /* Komma am Ende */
     if (lgkl < 1 && daz != 1) break;
     else {
       *zaehler++ = *text;
       text++;
       index++;
     }
     inmakro = 0;
   }
   else if (*text == ')') {        /* runde Klammer am Ende */
     if (lgkl < 1 && daz != 1) break;
     else {
       *zaehler++ = *text;
       text++;
       index++;
     }
     inmakro = 0;
   }
   else if (*text == '@') {        /* @ */
     *zaehler++ = *text;
     *zaehler++ = *text;
     text++;
     index++;
     inmakro = 0;
   } 
   else if (*text == '-') {        /* - */
     *zaehler++ = *text;
     text++;
     index++;
   } 
   else {                        /* sonstiges Zeichen in String */
     *zaehler++ = *text;
     text++;
     index++;
     inmakro = 0;
   } 
 }
 *zaehler++ = '\0';
 return erg;
}

static void PushSign(Snode **w, char a)
{
 Snode *hnode, *oldw;

 if (*w == NULL) {
   hnode = (Snode *)XtCalloc(1,sizeof(Snode));
   hnode->inh = a;
   hnode->slen = 1;
   hnode->next = NULL;
   *w = hnode;
 }
 else {
   oldw = *w; 
   hnode = (Snode *)XtCalloc(1,sizeof(Snode));
   hnode->inh = a;
   hnode->slen = oldw->slen + 1;
   hnode->next = oldw;
   *w = hnode;
}
}


static void FreeStack(Snode **s)
{
 Snode *h, *del;

 del = *s;
 while (del != NULL) {
   h = del->next;
   XtFree((char *)del);
   del = h;
 }
 *s = NULL;
} 


static void StringToString(char *text1, char **text) 
  
  {
   *text = (char *)XtCalloc(1,strlen(text1)+1);
   strcpy(*text, text1);
   }


static void StackToString(Snode *s, char **text) 
{
  char *help;
  
  if (s==NULL)
     help = (char *)XtCalloc(1,1);
  else
     help = (char *)XtCalloc(1,s->slen+1);
  *text = help;
  while (s != NULL) {
    *help = s->inh; 
    s = s->next;
    help++;
  }
  *help = '\0';
  help--;
  while (*help == '\n') {    /* NL am Ende vom Wort loeschen */
    *help = '\0';
    help--;
  }
}



static void GetKey()
{
  StackToString(key, &card->mainkey);
  FreeStack(&key);
  err = dbtInsert(glbbp, card);
  err = dbtDeleteCard(&card);
  ueIdx = 0;
}


static void GetFldNameCont()
{
  int found;
  FieldName i;
  
  if (helpFldName != NULL) {
    XtFree((char *)helpFldName);
    helpFldName = NULL;
  }
  StackToString(fldname, &helpFldName);
  strlower(helpFldName); 
  SkipSpace(uebergabe, ue2);
  found = 0;
  for (i=0;i<max_fields && (!found);i++) {
      if (strcmp(helpFldName, glbFldToName(i)) == 0) {
         if (isstandardfield(i, cardtype))
            StringToString(ue2, &card->field[i]);
         else {
            err = dbtMakeUserFld(&helpufield);
            Scalloc(&helpufield->fldName, helpFldName);
            StringToString(ue2, &helpufield->fldData); 
            err = dbtAppendUserFld(&card->ufield, helpufield);
            }
         found = 1; 
         break;
      }
  }
  if (!found){
     err = dbtMakeUserFld(&helpufield);
     Scalloc(&helpufield->fldName, helpFldName);
     StringToString(ue2, &helpufield->fldData); 
     err = dbtAppendUserFld(&card->ufield, helpufield);
     }
  FreeStack(&fldname);
}

static void SecStrcat(int maxlen, char *str1, char *str2)
{
 if (strlen(str1)+strlen(str2) < maxlen)
    strcat(str1, str2);
}

static int SetInputFile(char *file)
{
 char *infilename; 
    
 if (file)
 {
  infilename = file;

  if (access(infilename, F_OK) != 0)
     return BIF_ENOTEXISTS;

  yyin = fopen(infilename, "r" );

  if ( yyin == NULL ) {
    return BIF_EOPEN;  
  }
  return BIF_OK;  
 }
 else
 {
   yyin = stdin;
   infilename = "<stdin>";
   return BIF_OK;  
 }
}


/*********************************************
 * BibTeX-Datei lesen                        *
 *********************************************/
Errcode bifFileRead(BibPtr bp)
{
  int erg;
  char *tempName;

  yynline = 1; 
  yynflexcalls = 0;
  hlpQuitHelpError(7);

  sprintf(errorstr, anfhelpstr, "KEY", "OFFSET", "LINE");
#ifdef NO_TEMPNAM
  tempName = (char *)tmpnam(NULL);
  bp->tempfile = (char *)XtMalloc(strlen(tempName)+1);
  strcpy(bp->tempfile,tempName);
  tempName = (char *)tmpnam(NULL);
  bp->macrofile = (char *)XtMalloc(strlen(tempName)+1);
  strcpy(bp->macrofile,tempName);
#else
  bp->tempfile = (char *)tempnam(NULL, NULL);
  bp->macrofile = (char *)tempnam(NULL, NULL);
#endif
  tempDatei = fopen(bp->macrofile, "w" );

  if ((erg = SetInputFile(bp->filepath)) == BIF_ENOTEXISTS){
     glbbp = bp;
     fclose(tempDatei);
     return BIF_OK;
     }
  glbbp = bp; 
  erg = yyparse();
  fclose(tempDatei);
  uebergabe[0] = '\0';
  sprintf(errstr, endhelpstr, bp->filepath, yynerrs);
  SecStrcat(MAX_ERRORSTRLEN, errorstr, errstr);
  ueIdx = 0;
  if (erg == 0) {
    if (yyin) fclose(yyin);
    erg = yynline;
    if (yynerrs > 0)
       return yynline-1;
    else
       return BIF_OK;
  }
  else {
    erg = -yynline;
    yy_init = 1;
    if (yyin) fclose(yyin);
    FreeStack(&key);
    FreeStack(&fldname);
    return (Errcode)erg;
  }
}



Errcode bifFileWrite(BibPtr bp)
{
 char sysStr[2*MAX_FILEPATHLEN];
 CardListNode *cl1 = NULL;
 CardListNode *cl2 = NULL;
 Errcode status;

 if (bp->macrofile!=NULL){
    sprintf(sysStr, "cp  %s %s", bp->macrofile, bp->tempfile);
    system(sysStr);
    tempDatei = fopen(bp->tempfile, "r+");
    }
 else
    {tempDatei = fopen(bp->tempfile, "w+");
     }

 if (tempDatei == NULL) return BIF_EWRITE;

   /* build list */
   if ((status = dbtBuildList(bp->treeIdx, &cl1, bp->sortedby)) != OK) {
      guwError(status); 
      return(status);
   }

 cl2 = cl1; 

 while (cl1 != NULL) {
   if (!glbIsStringEmpty(cl1->data->field[ncrossref]))
      WriteRecToFile(cl1->data, tempDatei);
   cl1 = cl1->next;
 } 

 while (cl2 != NULL) {
   if (glbIsStringEmpty(cl2->data->field[ncrossref]))
      WriteRecToFile(cl2->data, tempDatei);
   cl2 = cl2->next;
 } 

 fclose(tempDatei);
 sprintf(sysStr, "cp  %s %s", bp->tempfile, bp->filepath);
 system(sysStr);
 return BIF_OK;
}


Errcode bifFileListWrite(BibPtr bp, CardListNode *list, String fname)
{
 CardListNode *hlist;
 Errcode erg;
 char sysStr[2*MAX_FILEPATHLEN];
 
 if (bp->macrofile!=NULL){
    sprintf(sysStr, "cp  %s %s", bp->macrofile, fname);
    system(sysStr);
    tempDatei = fopen(fname, "r+");
    }
 else
    {tempDatei = fopen(fname, "w+");
     }

 if (tempDatei == NULL) return BIF_EWRITE;
 hlist = list;
 while (hlist != NULL) {
   if (!glbIsStringEmpty(hlist->data->field[ncrossref]))
      WriteRecToFile(hlist->data, tempDatei);
   hlist = hlist->next;
 } 

 hlist = list;
 while (hlist != NULL) {
   if (glbIsStringEmpty(hlist->data->field[ncrossref]))
      WriteRecToFile(hlist->data, tempDatei);
   hlist = hlist->next;
 } 

 fclose(tempDatei);
 return BIF_OK;
}


static long WriteLineToFile(FILE *datei, char *feld, char *inh)
{
  int inmakro = 0;    /* weder Makro, noch String */
  int instring = 0;
  int isempty = 1;
  int zaehler;
  long pos; 
  char *blank, *blankptr, *zeichen; 
  
  blank = (char *)XtMalloc(100);
  blankptr = blank;

  for (zaehler = 0; zaehler < fld_indent; zaehler++)
     fprintf(datei," ");
  fprintf(datei,"%s", feld);
  zaehler += strlen(feld);
  for (;zaehler < cont_indent - 3; zaehler++)
     fprintf(datei," ");
  fprintf(datei," = ");
  zeichen = inh;
  while (*zeichen!='\0'){
   switch (*zeichen){
     case ' ':
     case '\t':
	  if (instring)
	     *blankptr++ = *zeichen;
          else if (inmakro){
	     fprintf(datei, " ");
	     inmakro = 0;
	     }
          break;
     case '\n':
	  if (instring){
	     *blankptr++ = *zeichen;
	     for (zaehler = 0; zaehler < newline_indent; zaehler++)
	        *blankptr++ = ' ';
             }
          else if (inmakro){
	     fprintf(datei, " ");
	     inmakro = 0;
	     }
          break;
     case '@':
          if (inmakro)
	     fprintf(datei, " ");
          else if (*(zeichen+1) == '@'){
	     if (instring){
		*blankptr++ = '\0';
		fprintf(datei, "%s", blank);
		blankptr = blank;
		}
             else {
	        fprintf(datei, "{");
		instring=1;
		}
	     fprintf(datei, "@");
	     zeichen++;
	     }
          else if (instring){
	     fprintf(datei, "} ");
	     inmakro = 1;
	     instring = 0;
	     }
          else {
	     inmakro = 1;
	     instring = 0;
	     }
          break;
     case '#':
          if (isempty && inmakro) {
	     fprintf(datei, "{ } #");
             blankptr = blank;
	     *blankptr = '\0';
	     inmakro = 0;
	     }
          else if (inmakro){
	     fprintf(datei, "# ");
             blankptr = blank;
	     *blankptr = '\0';
	     inmakro = 0;
	     }
          else if (instring) 
	     fprintf(datei, "#");
          else {
	     fprintf(datei, "{#");
	     instring = 1;
	     }
          break;
      default:
          isempty = 0;
          if (inmakro)
	     fprintf(datei, "%c", *zeichen);
          else if (instring){
	     *blankptr++ = '\0';
	     fprintf(datei, "%s", blank);
	     blankptr = blank;
	     fprintf(datei, "%c", *zeichen);
	     }
          else{
	     fprintf(datei, "{%c", *zeichen);
	     instring = 1;
	     inmakro = 0;
	     }
          break;
      } /* case */
  zeichen++;
  } /* while */
	   
  if ((isempty==1) && (inmakro==0) && (instring==0))
    fprintf(datei,"{ }");    
  else if (instring) {
    fprintf(datei,"}");    
  }
        
  pos = ftell(datei);
  fprintf(datei,",\n");
  XtFree(blank);
  return pos;
}

static void WriteRecToFile(CardData *card, FILE *datei)
{
 UserFld *h;
 String newType;
 long pos;
 FieldName i;

 fseek(datei, 0L, SEEK_END); 
 fprintf(datei,"\n");
 pos = ftell(datei);
 newType = glbNewString(card->cardtypestr);
 fprintf(datei,"@%s{%s",newType, card->mainkey);
 XtFree(newType);
 pos = ftell(datei);
 fprintf(datei,",\n");

 for (i=0; i<max_fields; i++) {
    if (!StringIsPeteEmpty(card->field[i]))
       pos = WriteLineToFile(datei, glbFldToName(i), card->field[i]);
 }
 h = card->ufield; 
 while (h) {
   if (!StringIsPeteEmpty(h->fldData)) 
      pos = WriteLineToFile(datei,h->fldName,h->fldData);    
   h = h->next;
 }   
 fseek(datei, pos, SEEK_SET);
 fprintf(datei,"\n}\n\n");
}



static int StringIsPeteEmpty(char *text)
{
 if (text == NULL || *text == '\0') return 1;
 return 0;
}



yyerror(char *s)
{

 fputs(s, stderr);
 putc('\n', stderr);
}

#ifdef BIFMAIN

int main(int argc, char *argv[])
{
 Bib bp;
 int erg, b1, i;
 Errcode err;

#ifdef YYDEBUG
       extern int yydebug;

       yydebug = 1;
#endif

 strcpy(bp.filepath, argv[1]);
 dbtGetFreeTreeIdx(&b1);
 bp.treeIdx = b1;
 err = bifFileRead(&bp);
 err = bifFileWrite(&bp);
}

#endif
__YYSCLASS yytabelem yyexca[] ={
-1, 1,
	0, -1,
	-2, 0,
-1, 2,
	0, 4,
	-2, 0,
-1, 3,
	0, 3,
	-2, 0,
	};
# define YYNPROD 234
# define YYLAST 573
__YYSCLASS yytabelem yyact[]={

   266,    97,    33,   227,    34,    98,    99,    96,   255,   100,
    95,    33,    94,    34,   225,   212,   232,    60,    58,    59,
    57,    49,    50,    61,    54,   231,    55,    56,    53,    51,
    52,    47,    45,    48,    46,    60,    58,    59,    57,    49,
    50,    61,    54,   115,    55,    56,    53,    51,    52,    47,
    45,    48,    46,    21,    22,    23,    24,    26,     4,     5,
   175,     6,     7,     8,     9,    10,    11,    12,    13,    14,
    15,    16,   248,   246,   247,   245,   238,   240,   249,   244,
   173,   242,   243,   233,   241,   239,   237,   234,   236,   235,
    60,    58,    59,    57,    49,    50,    61,    54,   171,    55,
    56,    53,    51,    52,    47,    45,    48,    46,    79,    77,
    78,    76,    69,    70,    80,    74,   168,    75,   138,    73,
    71,    72,    67,    65,    68,    66,    79,    77,    78,    76,
    69,    70,    80,    74,   136,    75,   307,    73,    71,    72,
    67,    65,    68,    66,   248,   246,   247,   245,   238,   240,
   249,   244,   151,   242,   243,   147,   241,   239,   237,   234,
   236,   235,   278,   276,   277,   275,   280,   282,   279,   274,
   297,   272,   273,   281,   125,   288,   271,   268,   270,   269,
   278,   276,   277,   275,   280,   282,   279,   274,   267,   272,
   273,   281,   254,   224,   271,   268,   270,   269,    79,    77,
    78,    76,    69,    70,    80,    74,   223,    75,   222,    73,
    71,    72,    67,    65,    68,    66,   278,   276,   277,   275,
   280,   282,   279,   274,   206,   272,   273,   281,   209,   202,
   271,   268,   270,   269,   219,    33,   174,    34,   220,   203,
   172,   223,    33,   222,    34,   181,    33,   180,    34,   169,
   167,   256,   257,   258,   259,   260,   261,   262,   263,   264,
   265,   165,   283,   284,   285,   286,   287,   148,   144,   290,
   291,   292,   293,   294,   295,   296,   298,   299,   300,   301,
   302,   303,   304,   305,   289,    97,   104,    29,   219,    98,
    99,    96,   220,   100,    95,   223,    94,   222,   308,    41,
   184,    43,    38,   183,    40,   306,   164,    33,   309,    34,
    33,    35,    34,    37,    30,   152,    32,   195,   211,    33,
   221,    34,    33,    33,    34,    34,   201,    33,   192,    34,
    92,    33,   181,    34,   180,   190,   101,    44,   102,    33,
   216,    34,    33,    88,    34,    89,    84,    62,    85,    63,
   217,   179,   207,    31,    36,    39,    42,   178,     1,   215,
    25,    27,    28,    20,    81,    82,   176,    93,    91,    64,
    19,    18,    17,    83,     3,     2,    87,     0,     0,     0,
     0,     0,     0,   105,   106,   107,   108,   109,   110,   111,
   112,   113,   114,   116,   117,   118,   119,   120,   121,   122,
   123,     0,     0,     0,     0,     0,     0,    86,     0,     0,
    90,     0,   103,     0,     0,   140,     0,     0,     0,     0,
     0,     0,   145,     0,   154,     0,   149,     0,     0,     0,
     0,     0,     0,   124,     0,   126,   127,   128,   129,   130,
   131,   132,   133,   134,   135,   137,   139,     0,   141,   142,
   143,     0,     0,   166,     0,   146,     0,     0,     0,   150,
   153,     0,   155,   156,   157,   158,   159,   160,   161,     0,
   162,   163,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,   177,   182,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,   177,     0,     0,     0,     0,
     0,     0,     0,   186,     0,     0,   170,   189,     0,   193,
   194,     0,     0,     0,   177,   177,   200,     0,     0,     0,
     0,     0,     0,   205,     0,     0,     0,     0,     0,   208,
   210,   185,   196,   197,   214,   191,     0,     0,   218,   187,
     0,   188,     0,   250,   251,     0,   218,     0,   228,     0,
   198,   199,     0,     0,     0,     0,   226,   230,   218,   204,
   253,     0,     0,   191,     0,     0,     0,     0,   252,   229,
   213,     0,   191 };
__YYSCLASS yytabelem yypact[]={

  -203, -3000,  -203,  -203, -3000, -3000, -3000, -3000, -3000, -3000,
 -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000,
 -3000,    22,    50,    47,    38,    35, -3000, -3000, -3000, -3000,
  -167,    83,   -59,  -270,  -270,  -167,    82,   -59,  -167,    79,
   -59,  -261,    72,  -261,    21,  -167,  -167,  -167,  -167,  -167,
  -167,  -167,  -167,  -167,  -222,  -167,  -167,  -167,  -167,  -167,
  -167,  -167,  -167,   -59,   -93,   -59,   -59,   -59,   -59,   -59,
   -59,   -59,   -59,   -59,  -131,  -149,   -59,  -167,   -59,   -59,
   -59, -3000, -3000,     3,  -167,   -59,  -112,     2,  -167,   -59,
  -115,    54,    23,  -270,    23,    23,    23,    23,    23,    23,
    23,  -261,  -261,    45, -3000, -3000, -3000, -3000, -3000, -3000,
 -3000, -3000, -3000, -3000,    -4,  -167, -3000, -3000, -3000, -3000,
 -3000, -3000, -3000,   -15,  -151, -3000, -3000, -3000, -3000, -3000,
 -3000, -3000, -3000, -3000, -3000,   -16,   -59,  -169, -3000, -3000,
 -3000, -3000, -3000, -3000, -3000,   -25,  -187, -3000, -3000,   -29,
  -207, -3000,   -26,  -270, -3000, -3000, -3000, -3000, -3000, -3000,
 -3000, -3000,    42,    39,   -26,  -167, -3000, -3000, -3000,   -59,
 -3000,   -59, -3000, -3000, -3000, -3000,    70,    61,    67,    55,
    61,    61, -3000,   -26,   -26,    59, -3000, -3000, -3000,   -36,
 -3000,   -22,   -26, -3000,   -38, -3000, -3000, -3000,   -37,    51,
  -252, -3000, -3000,   -26, -3000,    61, -3000,   -30,   -72, -3000,
  -253, -3000, -3000, -3000,    61,   -30,  -266,  -270,    24,  -240,
  -185, -3000,   -65,   -65, -3000, -3000,  -266,   -30, -3000,  -270,
   -73, -3000,  -260, -3000,  -113,  -113,  -113,  -113,  -113,  -113,
  -113,  -113,  -113,  -113,   -77,  -113,  -113,  -113,  -113,  -113,
 -3000, -3000,  -266, -3000, -3000, -3000, -3000, -3000, -3000, -3000,
 -3000, -3000, -3000, -3000, -3000, -3000,   -90,  -113,   -41,   -41,
   -41,   -41,   -41,   -41,   -95,   -41,   -41,   -41,   -41,   -41,
   -41,   -41,   -41, -3000, -3000, -3000, -3000, -3000,  -113, -3000,
 -3000, -3000, -3000, -3000, -3000, -3000,  -129,   -41, -3000, -3000,
 -3000, -3000, -3000, -3000, -3000, -3000, -3000,   -41, -3000, -3000 };
__YYSCLASS yytabelem yypgo[]={

     0,   358,   375,   374,   372,   371,   370,   363,   337,   330,
   369,   360,   368,   366,   367,   357,   351,   359,   340,   352,
   350,    16,   320,     0 };
__YYSCLASS yytabelem yyr1[]={

     0,     1,     1,     1,     1,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     3,     3,
     3,     3,     3,     5,     5,     5,     5,     4,     4,     4,
     4,     6,     6,     6,     6,     8,     8,     8,     8,     8,
     8,     8,     8,     8,     8,     8,     8,     8,     8,     8,
     8,     8,     8,     8,     8,     8,     8,     8,     8,     8,
     8,     8,     8,     8,     8,     8,     8,     8,     8,     8,
     8,    10,    10,    10,    10,    10,    10,    10,    10,    10,
    10,    10,    10,    10,    10,    10,    10,    10,    10,    10,
    10,    10,    10,    10,    10,    10,    10,    10,    10,    10,
    10,    10,    10,    10,    10,    10,     7,     7,     7,     7,
     7,     7,     7,     7,    11,    12,    12,    12,    12,    14,
    14,    14,    14,    14,    14,    14,    14,    14,    14,    14,
    14,    14,    14,    13,    13,    13,    13,    13,    13,    13,
    13,    13,    17,    15,    19,    15,    16,    16,    16,    16,
     9,     9,     9,     9,    18,    18,    18,    18,    18,    20,
    20,    20,    20,    20,    22,    22,    22,    22,    21,    21,
    21,    21,    21,    21,    21,    21,    21,    21,    21,    21,
    21,    21,    21,    21,    21,    21,    21,    21,    21,    21,
    21,    21,    21,    21,    21,    21,    21,    21,    21,    21,
    21,    21,    23,    23,    23,    23,    23,    23,    23,    23,
    23,    23,    23,    23,    23,    23,    23,    23,    23,    23,
    23,    23,    23,    23,    23,    23,    23,    23,    23,    23,
    23,    23,    23,    23 };
__YYSCLASS yytabelem yyr2[]={

     0,     4,     4,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     5,     9,    11,     9,    11,     9,    11,     9,
    11,     9,    11,     9,    11,     4,     4,     4,     4,     4,
     4,     4,     4,     4,     8,     6,     6,     4,     4,     4,
     4,     4,     4,     4,     4,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     4,     4,     4,     4,     4,     4,     4,     4,     4,
     8,     6,     6,     4,     8,     6,     4,     4,     4,     4,
     4,     4,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,    15,    17,    13,    15,
    15,    17,    13,    15,     3,     4,     4,     6,     2,     5,
     5,     5,     5,     5,     5,     5,     3,     3,     3,     3,
     3,     3,     3,     8,     6,     6,     8,     4,     6,     4,
     2,     4,     1,    11,     1,     9,     5,     5,     3,     3,
     4,     4,     2,     2,     6,     2,     4,     4,     6,     6,
     6,     4,     4,     2,     4,     4,     2,     2,     4,     4,
     4,     4,     4,     4,     4,     4,     4,     4,     6,     8,
     4,     6,     4,     4,     4,     4,     4,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     4,     4,     4,     4,     4,     4,     6,     8,
     4,     6,     4,     4,     4,     4,     4,     2,     2,     2,
     4,     4,     4,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2 };
__YYSCLASS yytabelem yychk[]={

 -3000,    -1,    -2,    -3,   261,   262,   264,   265,   266,   267,
   268,   269,   270,   271,   272,   273,   274,    -4,    -5,    -6,
    -7,   256,   257,   258,   259,   -11,   260,    -1,    -1,   265,
   264,    -9,   266,   272,   274,   264,    -9,   266,   264,    -9,
   266,   264,    -9,   266,    -8,   272,   274,   271,   273,   261,
   262,   269,   270,   268,   264,   266,   267,   260,   258,   259,
   257,   263,   264,   266,   -10,   272,   274,   271,   273,   261,
   262,   269,   270,   268,   264,   266,   260,   258,   259,   257,
   263,    -9,    -9,    -8,   264,   266,   -10,    -8,   264,   266,
   -10,   -12,    -9,   -14,   273,   271,   268,   262,   266,   267,
   270,   264,   266,   -12,   265,    -8,    -8,    -8,    -8,    -8,
    -8,    -8,    -8,    -8,    -8,   265,    -8,    -8,    -8,    -8,
    -8,    -8,    -8,    -8,   -10,   267,   -10,   -10,   -10,   -10,
   -10,   -10,   -10,   -10,   -10,   -10,   265,   -10,   267,   -10,
    -8,   -10,   -10,   -10,   265,    -8,   -10,   267,   265,    -8,
   -10,   267,   261,   -14,    -9,   -14,   -14,   -14,   -14,   -14,
   -14,   -14,   -12,   -12,   261,   265,    -8,   265,   267,   265,
   -10,   267,   265,   267,   265,   267,   -13,    -9,   -15,   -16,
   273,   271,    -9,   261,   261,   -13,    -8,   -10,   -10,    -9,
   265,   -15,   261,    -9,    -9,   262,   -16,   -16,   -13,   -13,
    -9,   267,   265,   261,   -13,    -9,   262,   -19,    -9,   265,
    -9,   267,   267,   -13,    -9,   -17,   -18,   -20,    -9,   264,
   268,   -22,   273,   271,   265,   267,   -18,   269,    -9,   -20,
    -8,   265,   -21,   268,   272,   274,   273,   271,   261,   270,
   262,   269,   266,   267,   264,   260,   258,   259,   257,   263,
   -22,   -22,   -18,    -9,   265,   268,   -21,   -21,   -21,   -21,
   -21,   -21,   -21,   -21,   -21,   -21,   -23,   265,   272,   274,
   273,   271,   266,   267,   264,   260,   258,   259,   257,   263,
   261,   268,   262,   -21,   -21,   -21,   -21,   -21,   265,   -21,
   -23,   -23,   -23,   -23,   -23,   -23,   -23,   265,   -23,   -23,
   -23,   -23,   -23,   -23,   -23,   -23,   -21,   265,   -23,   -23 };
__YYSCLASS yytabelem yydef[]={

     0,    -2,    -2,    -2,     5,     6,     7,     8,     9,    10,
    11,    12,    13,    14,    15,    16,    17,    18,    19,    20,
    21,     0,     0,     0,     0,     0,   114,     1,     2,    22,
     0,     0,     0,   152,   153,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,    55,    56,    57,    58,    59,
    60,    61,    62,    63,     0,    64,    65,    66,    68,    69,
    70,    67,     0,     0,     0,    92,    93,    94,    95,    96,
    97,    98,    99,   100,     0,     0,   101,   103,   104,   105,
   102,   150,   151,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,   118,   126,   127,   129,   128,   131,   132,
   130,     0,     0,     0,    27,    35,    36,    37,    38,    39,
    40,    41,    42,    43,     0,    47,    48,    49,    50,    51,
    52,    53,    54,     0,     0,    29,    71,    72,    73,    74,
    75,    76,    77,    78,    79,     0,    83,     0,    91,    86,
    87,    88,    89,    90,    23,     0,     0,    25,    31,     0,
     0,    33,     0,   115,   116,   119,   120,   121,   122,   123,
   124,   125,     0,     0,     0,    46,    45,    28,    30,    82,
    81,    85,    24,    26,    32,    34,     0,     0,   140,     0,
   148,   149,   117,     0,     0,     0,    44,    80,    84,     0,
   108,   139,   137,   141,     0,   144,   146,   147,     0,     0,
     0,   112,   106,   135,   134,   138,   142,     0,     0,   109,
     0,   113,   110,   133,   136,     0,   145,   155,     0,     0,
     0,   163,   166,   167,   107,   111,   143,     0,   156,   157,
     0,   162,     0,   161,   187,   188,   189,   190,   191,   192,
   193,   194,   195,   196,     0,   198,   199,   200,   201,   197,
   164,   165,   154,   158,   159,   160,   168,   169,   170,   171,
   172,   173,   174,   175,   176,   177,     0,   180,   217,   218,
   219,   223,   225,   226,     0,   230,   231,   232,   233,   229,
   227,   228,   224,   182,   183,   184,   185,   186,   178,   181,
   202,   203,   204,   205,   206,   207,     0,   210,   212,   213,
   214,   215,   216,   220,   221,   222,   179,   208,   211,   209 };
typedef struct { char *t_name; int t_val; } yytoktype;
#ifndef YYDEBUG
#	define YYDEBUG	0	/* don't allow debugging */
#endif

#if YYDEBUG

__YYSCLASS yytoktype yytoks[] =
{
	"COMMENT",	257,
	"STRING",	258,
	"PREAMBLE",	259,
	"TYPE",	260,
	"KOMMA",	261,
	"EQ",	262,
	"AFFE",	263,
	"LGKL",	264,
	"RGKL",	265,
	"LRKL",	266,
	"RRKL",	267,
	"DAZ",	268,
	"ZAUN",	269,
	"PROZENT",	270,
	"ZEICHEN",	271,
	"WHITE_SPACE",	272,
	"BUCHSTABE_ZAHL",	273,
	"KOMMENTAR",	274,
	"-unknown-",	-1	/* ends search */
};

__YYSCLASS char * yyreds[] =
{
	"-no such reduction-",
	"datei : between datei",
	"datei : entry datei",
	"datei : entry",
	"datei : between",
	"between : KOMMA",
	"between : EQ",
	"between : LGKL",
	"between : RGKL",
	"between : LRKL",
	"between : RRKL",
	"between : DAZ",
	"between : ZAUN",
	"between : PROZENT",
	"between : ZEICHEN",
	"between : WHITE_SPACE",
	"between : BUCHSTABE_ZAHL",
	"between : KOMMENTAR",
	"entry : comment",
	"entry : string",
	"entry : preamble",
	"entry : eintrag",
	"entry : error RGKL",
	"string : STRING LGKL allstringG RGKL",
	"string : STRING leerraum LGKL allstringG RGKL",
	"string : STRING LRKL allstringR RRKL",
	"string : STRING leerraum LRKL allstringR RRKL",
	"comment : COMMENT LGKL allstringG RGKL",
	"comment : COMMENT leerraum LGKL allstringG RGKL",
	"comment : COMMENT LRKL allstringR RRKL",
	"comment : COMMENT leerraum LRKL allstringR RRKL",
	"preamble : PREAMBLE LGKL allstringG RGKL",
	"preamble : PREAMBLE leerraum LGKL allstringG RGKL",
	"preamble : PREAMBLE LRKL allstringR RRKL",
	"preamble : PREAMBLE leerraum LRKL allstringR RRKL",
	"allstringG : WHITE_SPACE allstringG",
	"allstringG : KOMMENTAR allstringG",
	"allstringG : ZEICHEN allstringG",
	"allstringG : BUCHSTABE_ZAHL allstringG",
	"allstringG : KOMMA allstringG",
	"allstringG : EQ allstringG",
	"allstringG : ZAUN allstringG",
	"allstringG : PROZENT allstringG",
	"allstringG : DAZ allstringG",
	"allstringG : LGKL allstringG RGKL allstringG",
	"allstringG : LGKL RGKL allstringG",
	"allstringG : LGKL allstringG RGKL",
	"allstringG : LGKL RGKL",
	"allstringG : LRKL allstringG",
	"allstringG : RRKL allstringG",
	"allstringG : TYPE allstringG",
	"allstringG : STRING allstringG",
	"allstringG : PREAMBLE allstringG",
	"allstringG : COMMENT allstringG",
	"allstringG : AFFE allstringG",
	"allstringG : WHITE_SPACE",
	"allstringG : KOMMENTAR",
	"allstringG : ZEICHEN",
	"allstringG : BUCHSTABE_ZAHL",
	"allstringG : KOMMA",
	"allstringG : EQ",
	"allstringG : ZAUN",
	"allstringG : PROZENT",
	"allstringG : DAZ",
	"allstringG : LRKL",
	"allstringG : RRKL",
	"allstringG : TYPE",
	"allstringG : AFFE",
	"allstringG : STRING",
	"allstringG : PREAMBLE",
	"allstringG : COMMENT",
	"allstringR : WHITE_SPACE allstringR",
	"allstringR : KOMMENTAR allstringR",
	"allstringR : ZEICHEN allstringR",
	"allstringR : BUCHSTABE_ZAHL allstringR",
	"allstringR : KOMMA allstringR",
	"allstringR : EQ allstringR",
	"allstringR : ZAUN allstringR",
	"allstringR : PROZENT allstringR",
	"allstringR : DAZ allstringR",
	"allstringR : LGKL allstringR RGKL allstringR",
	"allstringR : LGKL RGKL allstringR",
	"allstringR : LGKL allstringR RGKL",
	"allstringR : LGKL RGKL",
	"allstringR : LRKL allstringR RRKL allstringR",
	"allstringR : LRKL allstringR RRKL",
	"allstringR : TYPE allstringR",
	"allstringR : STRING allstringG",
	"allstringR : PREAMBLE allstringR",
	"allstringR : COMMENT allstringR",
	"allstringR : AFFE allstringR",
	"allstringR : LRKL RRKL",
	"allstringR : WHITE_SPACE",
	"allstringR : KOMMENTAR",
	"allstringR : ZEICHEN",
	"allstringR : BUCHSTABE_ZAHL",
	"allstringR : KOMMA",
	"allstringR : EQ",
	"allstringR : ZAUN",
	"allstringR : PROZENT",
	"allstringR : DAZ",
	"allstringR : TYPE",
	"allstringR : AFFE",
	"allstringR : STRING",
	"allstringR : PREAMBLE",
	"allstringR : COMMENT",
	"eintrag : eingabetyp LGKL schluessel KOMMA felder leerraum RGKL",
	"eintrag : eingabetyp leerraum LGKL schluessel KOMMA felder leerraum RGKL",
	"eintrag : eingabetyp LGKL schluessel KOMMA felder RGKL",
	"eintrag : eingabetyp leerraum LGKL schluessel KOMMA felder RGKL",
	"eintrag : eingabetyp LRKL schluessel KOMMA felder leerraum RRKL",
	"eintrag : eingabetyp leerraum LRKL schluessel KOMMA felder leerraum RRKL",
	"eintrag : eingabetyp LRKL schluessel KOMMA felder RRKL",
	"eintrag : eingabetyp leerraum LRKL schluessel KOMMA felder RRKL",
	"eingabetyp : TYPE",
	"schluessel : leerraum schl",
	"schluessel : schl leerraum",
	"schluessel : leerraum schl leerraum",
	"schluessel : schl",
	"schl : BUCHSTABE_ZAHL schl",
	"schl : ZEICHEN schl",
	"schl : DAZ schl",
	"schl : EQ schl",
	"schl : LRKL schl",
	"schl : RRKL schl",
	"schl : PROZENT schl",
	"schl : BUCHSTABE_ZAHL",
	"schl : ZEICHEN",
	"schl : EQ",
	"schl : DAZ",
	"schl : PROZENT",
	"schl : LRKL",
	"schl : RRKL",
	"felder : leerraum feld KOMMA felder",
	"felder : feld KOMMA felder",
	"felder : leerraum feld KOMMA",
	"felder : leerraum feld KOMMA leerraum",
	"felder : feld KOMMA",
	"felder : feld KOMMA leerraum",
	"felder : leerraum feld",
	"felder : feld",
	"felder : feld leerraum",
	"feld : feldname leerraum EQ",
	"feld : feldname leerraum EQ konkatenation",
	"feld : feldname EQ",
	"feld : feldname EQ konkatenation",
	"feldname : BUCHSTABE_ZAHL feldname",
	"feldname : ZEICHEN feldname",
	"feldname : BUCHSTABE_ZAHL",
	"feldname : ZEICHEN",
	"leerraum : WHITE_SPACE leerraum",
	"leerraum : KOMMENTAR leerraum",
	"leerraum : WHITE_SPACE",
	"leerraum : KOMMENTAR",
	"konkatenation : konkatenation ZAUN konkatenation",
	"konkatenation : feldinhalt",
	"konkatenation : feldinhalt leerraum",
	"konkatenation : leerraum feldinhalt",
	"konkatenation : leerraum feldinhalt leerraum",
	"feldinhalt : LGKL allstringG RGKL",
	"feldinhalt : DAZ dazfeldinhalt DAZ",
	"feldinhalt : DAZ DAZ",
	"feldinhalt : LGKL RGKL",
	"feldinhalt : makro",
	"makro : BUCHSTABE_ZAHL makro",
	"makro : ZEICHEN makro",
	"makro : BUCHSTABE_ZAHL",
	"makro : ZEICHEN",
	"dazfeldinhalt : WHITE_SPACE dazfeldinhalt",
	"dazfeldinhalt : KOMMENTAR dazfeldinhalt",
	"dazfeldinhalt : BUCHSTABE_ZAHL dazfeldinhalt",
	"dazfeldinhalt : ZEICHEN dazfeldinhalt",
	"dazfeldinhalt : KOMMA dazfeldinhalt",
	"dazfeldinhalt : PROZENT dazfeldinhalt",
	"dazfeldinhalt : EQ dazfeldinhalt",
	"dazfeldinhalt : ZAUN dazfeldinhalt",
	"dazfeldinhalt : LRKL dazfeldinhalt",
	"dazfeldinhalt : RRKL dazfeldinhalt",
	"dazfeldinhalt : LGKL dazdaz RGKL",
	"dazfeldinhalt : LGKL dazdaz RGKL dazfeldinhalt",
	"dazfeldinhalt : LGKL RGKL",
	"dazfeldinhalt : LGKL RGKL dazfeldinhalt",
	"dazfeldinhalt : TYPE dazfeldinhalt",
	"dazfeldinhalt : STRING dazfeldinhalt",
	"dazfeldinhalt : PREAMBLE dazfeldinhalt",
	"dazfeldinhalt : COMMENT dazfeldinhalt",
	"dazfeldinhalt : AFFE dazfeldinhalt",
	"dazfeldinhalt : WHITE_SPACE",
	"dazfeldinhalt : KOMMENTAR",
	"dazfeldinhalt : BUCHSTABE_ZAHL",
	"dazfeldinhalt : ZEICHEN",
	"dazfeldinhalt : KOMMA",
	"dazfeldinhalt : PROZENT",
	"dazfeldinhalt : EQ",
	"dazfeldinhalt : ZAUN",
	"dazfeldinhalt : LRKL",
	"dazfeldinhalt : RRKL",
	"dazfeldinhalt : AFFE",
	"dazfeldinhalt : TYPE",
	"dazfeldinhalt : STRING",
	"dazfeldinhalt : PREAMBLE",
	"dazfeldinhalt : COMMENT",
	"dazdaz : WHITE_SPACE dazdaz",
	"dazdaz : KOMMENTAR dazdaz",
	"dazdaz : BUCHSTABE_ZAHL dazdaz",
	"dazdaz : ZEICHEN dazdaz",
	"dazdaz : LRKL dazdaz",
	"dazdaz : RRKL dazdaz",
	"dazdaz : LGKL dazdaz RGKL",
	"dazdaz : LGKL dazdaz RGKL dazdaz",
	"dazdaz : LGKL RGKL",
	"dazdaz : LGKL RGKL dazdaz",
	"dazdaz : TYPE dazdaz",
	"dazdaz : STRING dazdaz",
	"dazdaz : PREAMBLE dazdaz",
	"dazdaz : COMMENT dazdaz",
	"dazdaz : AFFE dazdaz",
	"dazdaz : WHITE_SPACE",
	"dazdaz : KOMMENTAR",
	"dazdaz : BUCHSTABE_ZAHL",
	"dazdaz : KOMMA dazdaz",
	"dazdaz : DAZ dazdaz",
	"dazdaz : EQ dazdaz",
	"dazdaz : ZEICHEN",
	"dazdaz : EQ",
	"dazdaz : LRKL",
	"dazdaz : RRKL",
	"dazdaz : KOMMA",
	"dazdaz : DAZ",
	"dazdaz : AFFE",
	"dazdaz : TYPE",
	"dazdaz : STRING",
	"dazdaz : PREAMBLE",
	"dazdaz : COMMENT",
};
#endif /* YYDEBUG */
#define YYFLAG  (-3000)
/* @(#) $Revision: 70.7 $ */    

/*
** Skeleton parser driver for yacc output
*/

#if defined(NLS) && !defined(NL_SETN)
#include <msgbuf.h>
#endif

#ifndef nl_msg
#define nl_msg(i,s) (s)
#endif

/*
** yacc user known macros and defines
*/
#define YYERROR		goto yyerrlab

#ifndef __RUNTIME_YYMAXDEPTH
#define YYACCEPT	return(0)
#define YYABORT		return(1)
#else
#define YYACCEPT	{free_stacks(); return(0);}
#define YYABORT		{free_stacks(); return(1);}
#endif

#define YYBACKUP( newtoken, newvalue )\
{\
	if ( yychar >= 0 || ( yyr2[ yytmp ] >> 1 ) != 1 )\
	{\
		yyerror( (nl_msg(30001,"syntax error - cannot backup")) );\
		goto yyerrlab;\
	}\
	yychar = newtoken;\
	yystate = *yyps;\
	yylval = newvalue;\
	goto yynewstate;\
}
#define YYRECOVERING()	(!!yyerrflag)
#ifndef YYDEBUG
#	define YYDEBUG	1	/* make debugging available */
#endif

/*
** user known globals
*/
int yydebug;			/* set to 1 to get debugging */

/*
** driver internal defines
*/
/* define for YYFLAG now generated by yacc program. */
/*#define YYFLAG		(FLAGVAL)*/

/*
** global variables used by the parser
*/
# ifndef __RUNTIME_YYMAXDEPTH
__YYSCLASS YYSTYPE yyv[ YYMAXDEPTH ];	/* value stack */
__YYSCLASS int yys[ YYMAXDEPTH ];		/* state stack */
# else
__YYSCLASS YYSTYPE *yyv;			/* pointer to malloc'ed value stack */
__YYSCLASS int *yys;			/* pointer to malloc'ed stack stack */


static int allocate_stacks(); 
static void free_stacks();
# ifndef YYINCREMENT
# define YYINCREMENT (YYMAXDEPTH/2) + 10
# endif
# endif	/* __RUNTIME_YYMAXDEPTH */
long  yymaxdepth = YYMAXDEPTH;

__YYSCLASS YYSTYPE *yypv;			/* top of value stack */
__YYSCLASS int *yyps;			/* top of state stack */

__YYSCLASS int yystate;			/* current state */
__YYSCLASS int yytmp;			/* extra var (lasts between blocks) */

int yynerrs;			/* number of errors */
__YYSCLASS int yyerrflag;			/* error recovery flag */
int yychar;			/* current input token number */



/*
** yyparse - return 0 if worked, 1 if syntax error not recovered from
*/
int
yyparse()
{
	register YYSTYPE *yypvt;	/* top of value stack for $vars */

	/*
	** Initialize externals - yyparse may be called more than once
	*/
# ifdef __RUNTIME_YYMAXDEPTH
	if (allocate_stacks()) YYABORT;
# endif
	yypv = &yyv[-1];
	yyps = &yys[-1];
	yystate = 0;
	yytmp = 0;
	yynerrs = 0;
	yyerrflag = 0;
	yychar = -1;

	goto yystack;
	{
		register YYSTYPE *yy_pv;	/* top of value stack */
		register int *yy_ps;		/* top of state stack */
		register int yy_state;		/* current state */
		register int  yy_n;		/* internal state number info */

		/*
		** get globals into registers.
		** branch to here only if YYBACKUP was called.
		*/
	yynewstate:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;
		goto yy_newstate;

		/*
		** get globals into registers.
		** either we just started, or we just finished a reduction
		*/
	yystack:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;

		/*
		** top of for (;;) loop while no reductions done
		*/
	yy_stack:
		/*
		** put a state and value onto the stacks
		*/
#if YYDEBUG
		/*
		** if debugging, look up token value in list of value vs.
		** name pairs.  0 and negative (-1) are special values.
		** Note: linear search is used since time is not a real
		** consideration while debugging.
		*/
		if ( yydebug )
		{
			register int yy_i;

			printf( "State %d, token ", yy_state );
			if ( yychar == 0 )
				printf( "end-of-file\n" );
			else if ( yychar < 0 )
				printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ++yy_ps >= &yys[ yymaxdepth ] )	/* room on stack? */
		{
# ifndef __RUNTIME_YYMAXDEPTH
			yyerror( (nl_msg(30002,"yacc stack overflow")) );
			YYABORT;
# else
			/* save old stack bases to recalculate pointers */
			YYSTYPE * yyv_old = yyv;
			int * yys_old = yys;
			yymaxdepth += YYINCREMENT;
			yys = (int *) realloc(yys, yymaxdepth * sizeof(int));
			yyv = (YYSTYPE *) realloc(yyv, yymaxdepth * sizeof(YYSTYPE));
			if (yys==0 || yyv==0) {
			    yyerror( (nl_msg(30002,"yacc stack overflow")) );
			    YYABORT;
			    }
			/* Reset pointers into stack */
			yy_ps = (yy_ps - yys_old) + yys;
			yyps = (yyps - yys_old) + yys;
			yy_pv = (yy_pv - yyv_old) + yyv;
			yypv = (yypv - yyv_old) + yyv;
# endif

		}
		*yy_ps = yy_state;
		*++yy_pv = yyval;

		/*
		** we have a new state - find out what to do
		*/
	yy_newstate:
		if ( ( yy_n = yypact[ yy_state ] ) <= YYFLAG )
			goto yydefault;		/* simple state */
#if YYDEBUG
		/*
		** if debugging, need to mark whether new token grabbed
		*/
		yytmp = yychar < 0;
#endif
		if ( ( yychar < 0 ) && ( ( yychar = yylex() ) < 0 ) )
			yychar = 0;		/* reached EOF */
#if YYDEBUG
		if ( yydebug && yytmp )
		{
			register int yy_i;

			printf( "Received token " );
			if ( yychar == 0 )
				printf( "end-of-file\n" );
			else if ( yychar < 0 )
				printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ( ( yy_n += yychar ) < 0 ) || ( yy_n >= YYLAST ) )
			goto yydefault;
		if ( yychk[ yy_n = yyact[ yy_n ] ] == yychar )	/*valid shift*/
		{
			yychar = -1;
			yyval = yylval;
			yy_state = yy_n;
			if ( yyerrflag > 0 )
				yyerrflag--;
			goto yy_stack;
		}

	yydefault:
		if ( ( yy_n = yydef[ yy_state ] ) == -2 )
		{
#if YYDEBUG
			yytmp = yychar < 0;
#endif
			if ( ( yychar < 0 ) && ( ( yychar = yylex() ) < 0 ) )
				yychar = 0;		/* reached EOF */
#if YYDEBUG
			if ( yydebug && yytmp )
			{
				register int yy_i;

				printf( "Received token " );
				if ( yychar == 0 )
					printf( "end-of-file\n" );
				else if ( yychar < 0 )
					printf( "-none-\n" );
				else
				{
					for ( yy_i = 0;
						yytoks[yy_i].t_val >= 0;
						yy_i++ )
					{
						if ( yytoks[yy_i].t_val
							== yychar )
						{
							break;
						}
					}
					printf( "%s\n", yytoks[yy_i].t_name );
				}
			}
#endif /* YYDEBUG */
			/*
			** look through exception table
			*/
			{
				register int *yyxi = yyexca;

				while ( ( *yyxi != -1 ) ||
					( yyxi[1] != yy_state ) )
				{
					yyxi += 2;
				}
				while ( ( *(yyxi += 2) >= 0 ) &&
					( *yyxi != yychar ) )
					;
				if ( ( yy_n = yyxi[1] ) < 0 )
					YYACCEPT;
			}
		}

		/*
		** check for syntax error
		*/
		if ( yy_n == 0 )	/* have an error */
		{
			/* no worry about speed here! */
			switch ( yyerrflag )
			{
			case 0:		/* new error */
				yyerror( (nl_msg(30003,"syntax error")) );
				yynerrs++;
				goto skip_init;
			yyerrlab:
				/*
				** get globals into registers.
				** we have a user generated syntax type error
				*/
				yy_pv = yypv;
				yy_ps = yyps;
				yy_state = yystate;
				yynerrs++;
			skip_init:
			case 1:
			case 2:		/* incompletely recovered error */
					/* try again... */
				yyerrflag = 3;
				/*
				** find state where "error" is a legal
				** shift action
				*/
				while ( yy_ps >= yys )
				{
					yy_n = yypact[ *yy_ps ] + YYERRCODE;
					if ( yy_n >= 0 && yy_n < YYLAST &&
						yychk[yyact[yy_n]] == YYERRCODE)					{
						/*
						** simulate shift of "error"
						*/
						yy_state = yyact[ yy_n ];
						goto yy_stack;
					}
					/*
					** current state has no shift on
					** "error", pop stack
					*/
#if YYDEBUG
#	define _POP_ "Error recovery pops state %d, uncovers state %d\n"
					if ( yydebug )
						printf( _POP_, *yy_ps,
							yy_ps[-1] );
#	undef _POP_
#endif
					yy_ps--;
					yy_pv--;
				}
				/*
				** there is no state on stack with "error" as
				** a valid shift.  give up.
				*/
				YYABORT;
			case 3:		/* no shift yet; eat a token */
#if YYDEBUG
				/*
				** if debugging, look up token in list of
				** pairs.  0 and negative shouldn't occur,
				** but since timing doesn't matter when
				** debugging, it doesn't hurt to leave the
				** tests here.
				*/
				if ( yydebug )
				{
					register int yy_i;

					printf( "Error recovery discards " );
					if ( yychar == 0 )
						printf( "token end-of-file\n" );
					else if ( yychar < 0 )
						printf( "token -none-\n" );
					else
					{
						for ( yy_i = 0;
							yytoks[yy_i].t_val >= 0;
							yy_i++ )
						{
							if ( yytoks[yy_i].t_val
								== yychar )
							{
								break;
							}
						}
						printf( "token %s\n",
							yytoks[yy_i].t_name );
					}
				}
#endif /* YYDEBUG */
				if ( yychar == 0 )	/* reached EOF. quit */
					YYABORT;
				yychar = -1;
				goto yy_newstate;
			}
		}/* end if ( yy_n == 0 ) */
		/*
		** reduction by production yy_n
		** put stack tops, etc. so things right after switch
		*/
#if YYDEBUG
		/*
		** if debugging, print the string that is the user's
		** specification of the reduction which is just about
		** to be done.
		*/
		if ( yydebug )
			printf( "Reduce by (%d) \"%s\"\n",
				yy_n, yyreds[ yy_n ] );
#endif
		yytmp = yy_n;			/* value to switch over */
		yypvt = yy_pv;			/* $vars top of value stack */
		/*
		** Look in goto table for next state
		** Sorry about using yy_state here as temporary
		** register variable, but why not, if it works...
		** If yyr2[ yy_n ] doesn't have the low order bit
		** set, then there is no action to be done for
		** this reduction.  So, no saving & unsaving of
		** registers done.  The only difference between the
		** code just after the if and the body of the if is
		** the goto yy_stack in the body.  This way the test
		** can be made before the choice of what to do is needed.
		*/
		{
			/* length of production doubled with extra bit */
			register int yy_len = yyr2[ yy_n ];

			if ( !( yy_len & 01 ) )
			{
				yy_len >>= 1;
				yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
				yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
					*( yy_ps -= yy_len ) + 1;
				if ( yy_state >= YYLAST ||
					yychk[ yy_state =
					yyact[ yy_state ] ] != -yy_n )
				{
					yy_state = yyact[ yypgo[ yy_n ] ];
				}
				goto yy_stack;
			}
			yy_len >>= 1;
			yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
			yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
				*( yy_ps -= yy_len ) + 1;
			if ( yy_state >= YYLAST ||
				yychk[ yy_state = yyact[ yy_state ] ] != -yy_n )
			{
				yy_state = yyact[ yypgo[ yy_n ] ];
			}
		}
					/* save until reenter driver code */
		yystate = yy_state;
		yyps = yy_ps;
		yypv = yy_pv;
	}
	/*
	** code supplied by user is placed in this switch
	*/
	switch( yytmp )
	{
		
case 22:{StackToString(key, &errkey);
	       FreeStack(&key);
	       if ((errkey!=NULL) && (errkey[0]!='\0')){
		 sprintf(errstr, "\t%15s:\t%10d\t%10d\n", 
				 errkey, errorline-keyline, errorline-1);
                 XtFree(errkey);
		 errkey = NULL;
		 }
               else
		 sprintf(errstr, "\t%15s:\t%10d\t%10d\n", "key unknown", 
				     errorline-keyline, errorline-1);
               SecStrcat(MAX_ERRORSTRLEN, errorstr, errstr);
	       } break;
case 23:{         
		keyline = yynline;
                beginIdx = SkipApe(uebergabe);
                fprintf(tempDatei,"@%s\n",&uebergabe[beginIdx]); 
                ueIdx = 0;
              } break;
case 24:{          
		keyline = yynline;
                beginIdx = SkipApe(uebergabe);
                fprintf(tempDatei,"@%s\n",&uebergabe[beginIdx]); 
                ueIdx = 0;
              } break;
case 25:{         
		keyline = yynline;
                beginIdx = SkipApe(uebergabe);
                fprintf(tempDatei,"@%s\n",&uebergabe[beginIdx]); 
                ueIdx = 0;
              } break;
case 26:{         
		keyline = yynline;
                beginIdx = SkipApe(uebergabe);
                fprintf(tempDatei,"@%s\n",&uebergabe[beginIdx]); 
                ueIdx = 0;
              } break;
case 27:{         
		keyline = yynline;
                beginIdx = SkipApe(uebergabe);
                fprintf(tempDatei,"@%s\n",&uebergabe[beginIdx]); 
                ueIdx = 0;
              } break;
case 28:{          
		keyline = yynline;
                beginIdx = SkipApe(uebergabe);
                fprintf(tempDatei,"@%s\n",&uebergabe[beginIdx]); 
                ueIdx = 0;
              } break;
case 29:{         
		keyline = yynline;
                beginIdx = SkipApe(uebergabe);
                fprintf(tempDatei,"@%s\n",&uebergabe[beginIdx]); 
                ueIdx = 0;
              } break;
case 30:{         
		keyline = yynline;
                beginIdx = SkipApe(uebergabe);
                fprintf(tempDatei,"@%s\n",&uebergabe[beginIdx]); 
                ueIdx = 0;
              } break;
case 31:{         
		keyline = yynline;
                beginIdx = SkipApe(uebergabe);
                fprintf(tempDatei,"@%s\n",&uebergabe[beginIdx]); 
                ueIdx = 0;
              } break;
case 32:{         
		keyline = yynline;
                beginIdx = SkipApe(uebergabe);
                fprintf(tempDatei,"@%s\n",&uebergabe[beginIdx]); 
                ueIdx = 0;
              } break;
case 33:{         
		keyline = yynline;
                beginIdx = SkipApe(uebergabe);
                fprintf(tempDatei,"@%s\n",&uebergabe[beginIdx]); 
                ueIdx = 0;
              } break;
case 34:{         
		keyline = yynline;
                beginIdx = SkipApe(uebergabe);
                fprintf(tempDatei,"@%s\n",&uebergabe[beginIdx]); 
                ueIdx = 0;
              } break;
case 106:{                 
                  GetKey();
                } break;
case 107:{
                  GetKey();
                } break;
case 108:{
                  GetKey();
                } break;
case 109:{
                  GetKey();
                } break;
case 110:{
                  GetKey();
                } break;
case 111:{
                  GetKey();
                } break;
case 112:{
                  GetKey();
                } break;
case 113:{
                  GetKey();
                } break;
case 114:{
		  err = dbtMakeCard(&card);
		  beginIdx = SkipApe(uebergabe);
		  card->cardtype = cardtype = 
		     glbNameToType(strlower(&uebergabe[beginIdx])); 
		  if (cardtype == -1)
		     card->cardtype = cardtype = MAX_BIBTEX_TYPES;
		  Scalloc(&card->cardtypestr, &uebergabe[beginIdx]);
		  ueIdx = 0;
                } break;
case 119:{
                  PushSign(&key, yypvt[-1]);
		  keyline = yynline;
                } break;
case 120:{
                  PushSign(&key, yypvt[-1]);
		  keyline = yynline;
                } break;
case 121:{
                  PushSign(&key, yypvt[-1]);
		  keyline = yynline;
                } break;
case 122:{
                  PushSign(&key, yypvt[-1]);
		  keyline = yynline;
                } break;
case 123:{
                  PushSign(&key, yypvt[-1]);
		  keyline = yynline;
                } break;
case 124:{
                  PushSign(&key, yypvt[-1]);
		  keyline = yynline;
                } break;
case 125:{
                  PushSign(&key, '%');
		  keyline = yynline;
                  PushSign(&key, '\\');
                } break;
case 126:{
                  PushSign(&key, yypvt[-0]);
		  keyline = yynline;
                } break;
case 127:{
                  PushSign(&key, yypvt[-0]);
		  keyline = yynline;
                } break;
case 128:{
                  PushSign(&key, yypvt[-0]);
		  keyline = yynline;
                } break;
case 129:{
                  PushSign(&key, yypvt[-0]);
		  keyline = yynline;
                } break;
case 130:{
                  PushSign(&key, '%');
                  PushSign(&key, '\\');
		  keyline = yynline;
                } break;
case 131:{
                  PushSign(&key, yypvt[-0]);
		  keyline = yynline;
                } break;
case 132:{
                  PushSign(&key, yypvt[-0]);
		  keyline = yynline;
                } break;
case 142:{
		  ueIdx = 0;
                } break;
case 143:{
                  GetFldNameCont();
                } break;
case 144:{
		  ueIdx = 0;
                } break;
case 145:{
                  GetFldNameCont();
                } break;
case 146:{
                  PushSign(&fldname, yypvt[-1]);
                  ueIdx = 0;
                } break;
case 147:{
                  PushSign(&fldname, yypvt[-1]);
                  ueIdx = 0;
                } break;
case 148:{
                  PushSign(&fldname, yypvt[-0]);
                  ueIdx = 0;
                } break;
case 149:{
                  PushSign(&fldname, yypvt[-0]);
                  ueIdx = 0;
                } break;
	}
	goto yystack;		/* reset registers in driver code */
}

# ifdef __RUNTIME_YYMAXDEPTH

static int allocate_stacks() {
	/* allocate the yys and yyv stacks */
	yys = (int *) malloc(yymaxdepth * sizeof(int));
	yyv = (YYSTYPE *) malloc(yymaxdepth * sizeof(YYSTYPE));

	if (yys==0 || yyv==0) {
	   yyerror( (nl_msg(30004,"unable to allocate space for yacc stacks")) );
	   return(1);
	   }
	else return(0);

}


static void free_stacks() {
	if (yys!=0) free((char *) yys);
	if (yyv!=0) free((char *) yyv);
}

# endif  /* defined(__RUNTIME_YYMAXDEPTH) */

