#include <qregexp.h>
#include "entry.h"
#include "qbibman.h"
extern "C" {
void save_input_file(char* f){}
void save_macro_file(char* f){}
void save_output_file(char* f){}
}
char *FIELDS[]={
		     "crossref",
		     "title",
		     "journal",
		     "booktitle",
		     "chapter",
		     "year",
		     "month",
		     "number",
		     "volume",
		     "pages",
		     "edition",
		     "publisher",
		     "address",
		     "howpublished",
		     "institution",
		     "school",
		     "organization",
		     "series",
		     "note",
		     "type",
		     "annote",
		     "key",
		     "abstract",
		     "author",
		     "editor",
		     NULL
};
int addit(DB db,Record e){
 extern ApplicationWindow *CurAW;
 if (!(RecordIsDELETED(e))) 
  CurAW->addEntry(e);
 return 0;
}
int ch_ent(DB db,Record r){
 if (RecordType(r)==9) RecordType(r)=12;
 rewrite_record(db,r);
 return 1;
}
QString strip_braces(const char *s){
 QString qs(s);
 return strip_braces(qs);
}
QString strip_braces(QString qs){
  if (qs.isEmpty()) return qs;
  if (qs[0]=='{') {
   int b=1,h=0;
   for (unsigned i=1;i<qs.length();i++){
    if (qs[i]=='{') b++;
    if (qs[i]=='}') b--;
    if ((qs[i]=='#') && (!b)) {h=1;break;}
   } 
   if (!h){
    qs.remove(0,1);
    qs.resize(qs.length());
   } else qs.prepend("@");
  } else qs.prepend("@");
  return qs;
}

QStrList getnames(const char *names){
 QStrList rl;
 QString qname(strip_braces(names));
 char *t1,*t2,*p1,*p2;
 QRegExp re;
 int b=0,l;

 if (*names!='{') {rl.append(names); return rl;} // Must be a @string
 t1=(char*) malloc(qname.length()+1);
 t2=(char*) malloc(qname.length()+1);
 p1=t1;
 p2=t2;
 strcpy(t1,qname.data());
 if (!(t1 && t2)) exit(-1);
 for (unsigned i=0;i<qname.length();i++){
  if (t1[i]=='{') b++;
  if (t1[i]=='}') b--;
  if (b) t2[i]='1';else t2[i]='0';
 }
 b=0;
 re="\\s+and\\s+";
 while((b=re.match(p1,b,&l))!=-1){
  if (p2[b]=='1') continue;
  p1[b]='\0';
  rl.append(p1);
  p1+=b+l;
  p2+=b+l;
  b=0;
 } 
 rl.append(p1);
 free(t2);
 free(t1);
 return rl;
}
