package Google::Ads::AdWords::v201809::ResellerConstraint;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'https://adwords.google.com/api/adwords/cm/v201809' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}


use base qw(Google::Ads::AdWords::v201809::PolicyTopicConstraint);
# Variety: sequence
use Class::Std::Fast::Storable constructor => 'none';
use base qw(Google::Ads::SOAP::Typelib::ComplexType);

{ # BLOCK to scope variables

my %constraintType_of :ATTR(:get<constraintType>);
my %PolicyTopicConstraint__Type_of :ATTR(:get<PolicyTopicConstraint__Type>);

__PACKAGE__->_factory(
    [ qw(        constraintType
        PolicyTopicConstraint__Type

    ) ],
    {
        'constraintType' => \%constraintType_of,
        'PolicyTopicConstraint__Type' => \%PolicyTopicConstraint__Type_of,
    },
    {
        'constraintType' => 'Google::Ads::AdWords::v201809::PolicyTopicConstraint::PolicyTopicConstraintType',
        'PolicyTopicConstraint__Type' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
    },
    {

        'constraintType' => 'constraintType',
        'PolicyTopicConstraint__Type' => 'PolicyTopicConstraint.Type',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

Google::Ads::AdWords::v201809::ResellerConstraint

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
ResellerConstraint from the namespace https://adwords.google.com/api/adwords/cm/v201809.

Constraint indicating that the policy topic was constrained by disapproval of the website for reseller purposes. 




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over



=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():






=head1 AUTHOR

Generated by SOAP::WSDL

=cut

