use lib '../lib';
use Firebase;
use Test::More;

my $firebase = Firebase->new(auth => { secret => $ENV{FIREBASE_TOKEN}, admin => \1 }, firebase => $ENV{FIREBASE});

isa_ok($firebase, 'Firebase');

is $firebase->firebase, $ENV{FIREBASE}, 'set the firebase';
isa_ok $firebase->authobj, 'Firebase::Auth';
is $firebase->authobj->secret, $ENV{FIREBASE_TOKEN}, 'set the secret token';

my $result = $firebase->put('test', { foo => 'bar' });
is $result->{foo}, 'bar', 'created object';

$result = $firebase->get('test');
is $result->{foo}, 'bar', 'authenticate read object';

$result = Firebase->new(firebase => $ENV{FIREBASE})->get('test');
is $result->{foo}, 'bar', 'anonymous read object';

$result = $firebase->delete('test');
is $result, undef, 'delete object';




done_testing();

1;
