# Generated by default/object.tt
package Paws::GlueDataBrew::Job;
  use Moose;
  has AccountId => (is => 'ro', isa => 'Str');
  has CreateDate => (is => 'ro', isa => 'Str');
  has CreatedBy => (is => 'ro', isa => 'Str');
  has DataCatalogOutputs => (is => 'ro', isa => 'ArrayRef[Paws::GlueDataBrew::DataCatalogOutput]');
  has DatasetName => (is => 'ro', isa => 'Str');
  has EncryptionKeyArn => (is => 'ro', isa => 'Str');
  has EncryptionMode => (is => 'ro', isa => 'Str');
  has JobSample => (is => 'ro', isa => 'Paws::GlueDataBrew::JobSample');
  has LastModifiedBy => (is => 'ro', isa => 'Str');
  has LastModifiedDate => (is => 'ro', isa => 'Str');
  has LogSubscription => (is => 'ro', isa => 'Str');
  has MaxCapacity => (is => 'ro', isa => 'Int');
  has MaxRetries => (is => 'ro', isa => 'Int');
  has Name => (is => 'ro', isa => 'Str', required => 1);
  has Outputs => (is => 'ro', isa => 'ArrayRef[Paws::GlueDataBrew::Output]');
  has ProjectName => (is => 'ro', isa => 'Str');
  has RecipeReference => (is => 'ro', isa => 'Paws::GlueDataBrew::RecipeReference');
  has ResourceArn => (is => 'ro', isa => 'Str');
  has RoleArn => (is => 'ro', isa => 'Str');
  has Tags => (is => 'ro', isa => 'Paws::GlueDataBrew::TagMap');
  has Timeout => (is => 'ro', isa => 'Int');
  has Type => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::GlueDataBrew::Job

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::GlueDataBrew::Job object:

  $service_obj->Method(Att1 => { AccountId => $value, ..., Type => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::GlueDataBrew::Job object:

  $result = $service_obj->Method(...);
  $result->Att1->AccountId

=head1 DESCRIPTION

Represents all of the attributes of a DataBrew job.

=head1 ATTRIBUTES


=head2 AccountId => Str

The ID of the Amazon Web Services account that owns the job.


=head2 CreateDate => Str

The date and time that the job was created.


=head2 CreatedBy => Str

The Amazon Resource Name (ARN) of the user who created the job.


=head2 DataCatalogOutputs => ArrayRef[L<Paws::GlueDataBrew::DataCatalogOutput>]

One or more artifacts that represent the AWS Glue Data Catalog output
from running the job.


=head2 DatasetName => Str

A dataset that the job is to process.


=head2 EncryptionKeyArn => Str

The Amazon Resource Name (ARN) of an encryption key that is used to
protect the job output. For more information, see Encrypting data
written by DataBrew jobs
(https://docs.aws.amazon.com/databrew/latest/dg/encryption-security-configuration.html)


=head2 EncryptionMode => Str

The encryption mode for the job, which can be one of the following:

=over

=item *

C<SSE-KMS> - Server-side encryption with keys managed by KMS.

=item *

C<SSE-S3> - Server-side encryption with keys managed by Amazon S3.

=back



=head2 JobSample => L<Paws::GlueDataBrew::JobSample>

A sample configuration for profile jobs only, which determines the
number of rows on which the profile job is run. If a C<JobSample> value
isn't provided, the default value is used. The default value is
CUSTOM_ROWS for the mode parameter and 20,000 for the size parameter.


=head2 LastModifiedBy => Str

The Amazon Resource Name (ARN) of the user who last modified the job.


=head2 LastModifiedDate => Str

The modification date and time of the job.


=head2 LogSubscription => Str

The current status of Amazon CloudWatch logging for the job.


=head2 MaxCapacity => Int

The maximum number of nodes that can be consumed when the job processes
data.


=head2 MaxRetries => Int

The maximum number of times to retry the job after a job run fails.


=head2 B<REQUIRED> Name => Str

The unique name of the job.


=head2 Outputs => ArrayRef[L<Paws::GlueDataBrew::Output>]

One or more artifacts that represent output from running the job.


=head2 ProjectName => Str

The name of the project that the job is associated with.


=head2 RecipeReference => L<Paws::GlueDataBrew::RecipeReference>

A set of steps that the job runs.


=head2 ResourceArn => Str

The unique Amazon Resource Name (ARN) for the job.


=head2 RoleArn => Str

The Amazon Resource Name (ARN) of the role to be assumed for this job.


=head2 Tags => L<Paws::GlueDataBrew::TagMap>

Metadata tags that have been applied to the job.


=head2 Timeout => Int

The job's timeout in minutes. A job that attempts to run longer than
this timeout period ends with a status of C<TIMEOUT>.


=head2 Type => Str

The job type of the job, which must be one of the following:

=over

=item *

C<PROFILE> - A job to analyze a dataset, to determine its size, data
types, data distribution, and more.

=item *

C<RECIPE> - A job to apply one or more transformations to a dataset.

=back




=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::GlueDataBrew>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

