package com.us.ctserver.test;

/**
 * Ozzy Espaillat 13/02/03
 *
 * Implementation of the classic Bayonne "playrec":
 * 1. Prompts caller to record or play a message
 * 2. Asks caller for 3 digit file name, then plays/record that file.
 * 3. Dont forget to start ctserver before starting!
 *
 * ctserver - client/server library for Computer Telephony programming in Java
 * Copyright (C) 2003 Ozzy Espaillat ozzy@unwiredsolutions.com
 * see COPYING.TXT
 */

import com.us.ctserver.CTPort;

import java.io.IOException;

public class PlayRec {
   CTPort ct;
   
   public PlayRec(String host, int port) throws IOException {
      // Connects to the CT server
      ct = new CTPort(host, port);
   }
   
   public void run() throws IOException {
      while(true) {
         String caller = ct.waitForRing();
         System.out.println("The Caller is: '" + caller + "'");
         ct.offHook();
         takeCall();
         ct.onHook();
      }
   }
   
   void takeCall() throws IOException {
      do {
         ct.clear();
         ct.play("playrec.ul");   // "Press 1 to Play, or 2 to record"
         // Wait ten seconds unless key pressed, if key is pressed while playing do not wait
         if (ct.ctsleep(10) == null) {
            return;      // if no events then finished
         }
         
         if ("1".equals(ct.getLastEvent())) {         // DTMF digit 1 pressed
            ct.clear();                  // clear events and digit buffer
            ct.play("playrec1.ul");    // "Enter the 3 digit number..."
            String digits = ct.collect(3, 10, 3);  
            ct.play(ct.spell(digits)); // play the digits back to the user.
            String playfile = digits + ".wav";
            ct.play(playfile);        
         }
         
         else if ("2".equals(ct.getLastEvent())) {        // DTMF digit 2 pressed
            ct.clear();
            ct.play("playrec2.ul");      // "Enter the three digit number"
            String digits = ct.collect(3, 10, 3);
            ct.play(ct.number(Integer.parseInt(digits))); // play the number back to the user 
            String recfile = digits + ".wav";
            ct.record(recfile, 6, "#*"); 
            // record for 6 seconds, or terminate
            // by pressing # or *
         }
         
         else if (!"#".equals(ct.getLastEvent())) {
            ct.play("playrec0.ul");      // "You have pressed an invaild"
         }
      } while ( !"#".equals(ct.getLastEvent()) ); // # terminates the call
   }
   
   public static void main(String args[]) {
      if (args.length != 2) {
         System.out.println("To run type PlayRec host port");
         System.exit(-1);
      }
      try {
         PlayRec pr =  new PlayRec(args[0], Integer.parseInt(args[1]));
         pr.run();
      } catch (Throwable e) {
         System.out.println("To run type PlayRec host port");
         System.err.println("There was an error running...");         
         e.printStackTrace();
      }
   }
}

