/*
 * Decompiled with CFR 0.152.
 */
package com.us.ctserver;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class CTPort {
    private static final String ON_HOOK = "cthangup";
    private static final String OFF_HOOK = "ctanswer";
    private static final String WAIT_FOR_RING = "ctwaitforring";
    private static final String WAIT_FOR_DIALTONE = "ctwaitfordial";
    private static final String PLAY = "ctplay";
    private static final String RECORD = "ctrecord";
    private static final String CTSLEEP = "ctsleep";
    private static final String CTCLEAR = "ctclear";
    private static final String CTCOLLECT = "ctcollect";
    private static final String DIAL = "ctdial";
    private static final String VALID_EVENT_CHARS = "0123456789ABCD*#";
    Socket socket;
    BufferedReader in;
    BufferedWriter out;
    String event;
    String defaultFileExt = "au";
    List pathList = new ArrayList();

    public void setDefaultFileExtention(String ext) {
        if (ext != null) {
            this.defaultFileExt = ext.startsWith(".") ? ext.substring(1) : ext;
        }
    }

    public String getDefaultFileExtention() {
        return this.defaultFileExt;
    }

    public void addPath(String path) {
        File dir = new File(path);
        if (dir.isDirectory()) {
            this.pathList.add(dir);
        }
    }

    public boolean removePath(String path) {
        File dir = new File(path);
        return this.pathList.remove(dir);
    }

    public String getFilePath(String fileName) {
        File path;
        if (fileName.indexOf(46) < 0) {
            fileName = fileName + "." + this.defaultFileExt;
        }
        if ((path = new File(fileName)).exists()) {
            return path.getAbsolutePath();
        }
        Iterator i = this.pathList.iterator();
        while (i.hasNext()) {
            File dir = (File)i.next();
            path = new File(dir, fileName);
            if (!path.exists()) continue;
            return path.getAbsolutePath();
        }
        return null;
    }

    public String getLastEvent() {
        return this.event;
    }

    protected void writeParam(String param) throws IOException {
        System.err.println("Sending: '" + param + "'");
        this.out.write(param);
        this.out.write(10);
    }

    protected String validateChars(String rawEvent) {
        StringBuffer eventBuffer = new StringBuffer();
        int i = 0;
        while (i < rawEvent.length()) {
            char c = rawEvent.charAt(i);
            if (VALID_EVENT_CHARS.indexOf(c) >= 0) {
                eventBuffer.append(c);
            }
            ++i;
        }
        return eventBuffer.toString();
    }

    protected String readEvent() throws IOException {
        String rawEvent = this.readReturn();
        this.event = this.validateChars(rawEvent);
        if ("".equals(this.event)) {
            this.event = null;
        }
        return this.event;
    }

    protected String readReturn() throws IOException {
        String rawReturn = this.in.readLine();
        System.err.println("The Return Value is: '" + rawReturn + "'");
        return rawReturn;
    }

    public void onHook() throws IOException {
        this.writeParam(ON_HOOK);
        this.out.flush();
        this.readReturn();
    }

    public void offHook() throws IOException {
        this.writeParam(OFF_HOOK);
        this.out.flush();
        this.readReturn();
    }

    public String waitForRing() throws IOException {
        this.writeParam(WAIT_FOR_RING);
        this.out.flush();
        String callerId = this.readReturn();
        return callerId;
    }

    public void waitForDialTone() throws IOException {
        this.writeParam(WAIT_FOR_DIALTONE);
        this.out.flush();
        this.readReturn();
    }

    public String play(List playFileList) throws IOException {
        Iterator i = playFileList.iterator();
        while (i.hasNext()) {
            String fileName = (String)i.next();
            if (this.event != null) continue;
            this.playFile(fileName);
        }
        return this.event;
    }

    public String play(String files) throws IOException {
        StringTokenizer tokenizer = new StringTokenizer(files, " \t");
        ArrayList<String> fileList = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            fileList.add(tokenizer.nextToken());
        }
        return this.play(fileList);
    }

    protected String playFile(String playFile) throws IOException {
        String fullFilePath = this.getFilePath(playFile);
        if (fullFilePath == null) {
            System.err.println("Could not find the file to play: " + playFile);
            return null;
        }
        this.writeParam(PLAY);
        this.writeParam(fullFilePath);
        this.out.flush();
        return this.readEvent();
    }

    public String record(String outFile, int timeout, String termDigits) throws IOException {
        if (outFile == null) {
            throw new IllegalArgumentException("output file must be specified");
        }
        this.writeParam(RECORD);
        this.writeParam(outFile);
        this.writeParam(Integer.toString(timeout));
        this.writeParam(termDigits == null ? "" : termDigits);
        this.out.flush();
        return this.readEvent();
    }

    public String ctsleep(int secs) throws IOException {
        if (this.event != null) {
            return this.event;
        }
        this.writeParam(CTSLEEP);
        this.writeParam(Integer.toString(secs));
        this.out.flush();
        return this.readEvent();
    }

    public void clear() throws IOException {
        this.writeParam(CTCLEAR);
        this.out.flush();
        this.readReturn();
        this.event = null;
    }

    public String collect(int maxDigits, int maxSecs, int maxInterSecs) throws IOException {
        this.writeParam(CTCOLLECT);
        this.writeParam(Integer.toString(maxDigits));
        this.writeParam(Integer.toString(maxSecs));
        this.writeParam(Integer.toString(Math.min(maxInterSecs, maxSecs)));
        this.out.flush();
        this.event = null;
        String collectedDigits = this.readReturn();
        return this.validateChars(collectedDigits);
    }

    public void dial(String dialString) throws IOException {
        this.writeParam(DIAL);
        this.writeParam(dialString);
        this.out.flush();
        this.readReturn();
    }

    public String spell(String word) {
        StringBuffer list = new StringBuffer(word.length() * 2);
        int i = 0;
        while (i < word.length()) {
            list.append(word.charAt(i));
            list.append(' ');
            ++i;
        }
        return list.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    public String number(int num) {
        StringBuffer digits = new StringBuffer();
        if (num == 0) {
            digits.append(Integer.toString(num));
        }
        int multiplier = 1;
        int magnitude = 0;
        int onesDigit = num % 10;
        block11: while (num > 0) {
            int digitFile = num % 10;
            num /= 10;
            if (multiplier == 1) {
                onesDigit = digitFile;
            }
            if (digitFile == 0) continue;
            switch (multiplier) {
                case 1: {
                    digits.insert(0, ' ');
                    digits.insert(0, Integer.toString(digitFile));
                    break;
                }
                case 10: {
                    if (digitFile == 1) {
                        if (onesDigit == 0) {
                            digits.insert(0, ' ');
                            digits.insert(0, Integer.toString(multiplier));
                            break;
                        }
                        digits.deleteCharAt(0);
                        digits.insert(0, Integer.toString(10 + onesDigit));
                        break;
                    }
                    digits.insert(0, ' ');
                    digits.insert(0, Integer.toString(digitFile * multiplier));
                    break;
                }
                case 100: {
                    digits.insert(0, ' ');
                    digits.insert(0, "hundred");
                    digits.insert(0, ' ');
                    digits.insert(0, Integer.toString(digitFile));
                    break;
                }
                case 1000: {
                    multiplier = 1;
                    num *= 10;
                    num += digitFile;
                    switch (++magnitude) {
                        case 1: {
                            digits.insert(0, ' ');
                            digits.insert(0, "thousand");
                            break;
                        }
                        case 2: {
                            digits.insert(0, ' ');
                            digits.insert(0, "million");
                            break;
                        }
                        case 3: {
                            digits.insert(0, ' ');
                            digits.insert(0, "billion");
                            break;
                        }
                    }
                    continue block11;
                }
            }
            multiplier *= 10;
        }
        return digits.toString();
    }

    public CTPort(String host, int port) throws IOException {
        this.socket = new Socket(host, port);
        this.in = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
        this.out = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream()));
        this.addPath(".");
        this.addPath(System.getProperty("user.home"));
        this.addPath(System.getProperty("user.home") + "/prompts");
        this.addPath(System.getProperty("user.dir"));
        this.addPath(System.getProperty("user.dir") + "/prompts");
        this.addPath("/var/ctserver/USEngM");
        this.addPath("/var/ctserver/USEngF");
        this.onHook();
    }
}

