use strict;
use warnings;
use lib 't/lib';
use Util;
use Test::More;
use SQL::Format;

subtest '%t: undef' => sub {
    eval { sqlf 'SELECT foo FROM %t' };
    like $@, mk_errstr 1, '%t';
};

subtest '%w: undef' => sub {
    eval {
        sqlf 'SELECT %c FROM %t WHERE %w', (
            [qw/bar baz/], 'foo',
        );
    };
    like $@, mk_errstr 3, '%w';
};

subtest '%o: limit' => sub {
    eval {
        sqlf '%o', (
            { limit => 'foo' },
        );
    };
    like $@, qr/limit must be numeric specified/;
};

subtest '%o: offset' => sub {
    eval {
        sqlf '%o', (
            { limit => 10, offset => 'foo' },
        );
    };
    like $@, qr/offset must be numeric specified/;
};

subtest 'Unkown LIMIT_DIALECT' => sub {
    eval {
        local $SQL::Format::LIMIT_DIALECT = 'Unkown';
        sqlf '%o', (
            { limit => 1, offset => 1 },
        );
    };
    like $@, qr/Unkown LIMIT_DIALECT/;
};

done_testing;
