use v6;
use NativeCall;
use Test;

use Gnome::Gtk3::AccelGroup;
use Gnome::Gtk3::AccelLabel;
use Gnome::Gtk3::Label;

use Gnome::Gdk3::Types;
use Gnome::Gdk3::Keysyms;

use Gnome::GObject::Closure;

use Gnome::N::N-GObject;
#use Gnome::N::X;
#Gnome::N::debug(:on);

#-------------------------------------------------------------------------------
my Gnome::Gtk3::AccelLabel $al;
#-------------------------------------------------------------------------------
subtest 'ISA test', {
  $al .= new(:text('Save'));
  isa-ok $al, Gnome::Gtk3::AccelLabel, '.new(:text)';
}

#-------------------------------------------------------------------------------
# set environment variable 'raku-test-all' if rest must be tested too.
unless %*ENV<raku_test_all>:exists {
  done-testing;
  exit;
}

#-------------------------------------------------------------------------------
class CTest {
  method ctrl-s-pressed ( Str :$arg1 ) {
    diag "ctrl-s pressed, user argument = '$arg1'";
  }
}

#-------------------------------------------------------------------------------
subtest 'Manipulations', {
  is $al.get-text, 'Save', 'label is checked';

  my Gnome::Gtk3::Label $label .= new(:text('<b>Don\'t</b> Start'));
  $label.set-use-markup(True);

  is $al.get-accel-widget, N-GObject, 'Widget not defined';
  $al.set-accel-widget($label);
  is $al.get-accel-widget.().get-text, 'Don\'t Start',
    '.set-accel-widget() / .get-accel-widget-rk()';

  ok $al.get-accel-width == 0, '.get-accel-width()';
  my Gnome::Gtk3::AccelGroup $ag .= new;
  my Gnome::GObject::Closure $cl .= new(
    :handler-object(CTest.new), :handler-name<ctrl-s-pressed>,
    :handler-opts(:arg1<foo>)
  );
  $ag.connect( GDK_KEY_s, GDK_CONTROL_MASK, 0, $cl);

  lives-ok {
    $al.set-accel-closure($cl);
    $al.set-accel( GDK_KEY_s, GDK_CONTROL_MASK);
  }, '.set-accel-closure() / .set-accel()';

#  note $al.get-accel-width, ', ', $al.get-text, ', ', $al.get-accel-widget-rk.get-text;


}

#-------------------------------------------------------------------------------
subtest 'Inherit Gnome::Gtk3::AccelLabel', {
  class MyClass is Gnome::Gtk3::AccelLabel {
    method new ( |c ) {
      self.bless( :GtkAccelLabel, |c);
    }

    submethod BUILD ( *%options ) {

    }
  }

  my MyClass $mgc .= new;
  isa-ok $mgc, Gnome::Gtk3::AccelLabel, 'MyClass.new()';
}

#-------------------------------------------------------------------------------
subtest 'Properties ...', {
  my @r = $al.get-properties(
   'accel-widget', N-GObject, 'accel-closure', N-GObject
  );

  my Gnome::Gtk3::Label $l .= new(:native-object(@r[0]));
  ok $l.is-valid, 'accel-widget';

  my Gnome::GObject::Closure $c .= new(:native-object(@r[1]));
  ok $c.is-valid, 'accel-closure';
}

#-------------------------------------------------------------------------------
done-testing;

=finish

#-------------------------------------------------------------------------------
subtest 'Interface ...', {
}

#-------------------------------------------------------------------------------
subtest 'Properties ...', {
  use Gnome::GObject::Value;
  use Gnome::GObject::Type;

  #my Gnome::Gtk3::AccelLabel $al .= new;

  sub test-property (
    $type, Str $prop, Str $routine, $value,
    Bool :$approx = False, Bool :$is-local = False
  ) {
    my Gnome::GObject::Value $gv .= new(:init($type));
    $al.get-property( $prop, $gv);
    my $gv-value = $gv."$routine"();
    if $approx {
      is-approx $gv-value, $value,
        "property $prop, value: " ~ $gv-value;
    }

    # dependency on local settings might result in different values
    elsif $is-local {
      if $gv-value ~~ /$value/ {
        like $gv-value, /$value/, "property $prop, value: " ~ $gv-value;
      }

      else {
        ok 1, "property $prop, value: " ~ $gv-value;
      }
    }

    else {
      is $gv-value, $value,
        "property $prop, value: " ~ $gv-value;
    }
    $gv.clear-object;
  }

  # example calls
  #test-property( G_TYPE_BOOLEAN, 'homogeneous', 'get-boolean', False);
  #test-property( G_TYPE_STRING, 'label', 'get-string', '...');
  #test-property( G_TYPE_FLOAT, 'xalign', 'get-float', 23e-2, :approx);
}

#-------------------------------------------------------------------------------
subtest 'Themes ...', {
}

#-------------------------------------------------------------------------------
subtest 'Signals ...', {
  use Gnome::Gtk3::Main;
  use Gnome::N::GlibToRakuTypes;

  my Gnome::Gtk3::Main $main .= new;

  class SignalHandlers {
    has Bool $!signal-processed = False;

    method ... (
      'any-args',
      Gnome::Gtk3::AccelLabel() :_native-object($_widget), gulong :$_handler-id
      # --> ...
    ) {

      isa-ok $_widget, Gnome::Gtk3::AccelLabel;
      $!signal-processed = True;
    }

    method signal-emitter ( Gnome::Gtk3::AccelLabel :$widget --> Str ) {

      while $main.gtk-events-pending() { $main.iteration-do(False); }

      $widget.emit-by-name(
        'signal',
      #  'any-args',
      #  :return-type(int32),
      #  :parameters([int32,])
      );
      is $!signal-processed, True, '\'...\' signal processed';

      while $main.gtk-events-pending() { $main.iteration-do(False); }

      #$!signal-processed = False;
      #$widget.emit-by-name(
      #  'signal',
      #  'any-args',
      #  :return-type(int32),
      #  :parameters([int32,])
      #);
      #is $!signal-processed, True, '\'...\' signal processed';

      while $main.gtk-events-pending() { $main.iteration-do(False); }
      sleep(0.4);
      $main.gtk-main-quit;

      'done'
    }
  }

  my Gnome::Gtk3::AccelLabel $al .= new;

  #my Gnome::Gtk3::Window $w .= new;
  #$w.add($m);

  my SignalHandlers $sh .= new;
  $al.register-signal( $sh, 'method', 'signal');

  my Promise $p = $al.start-thread(
    $sh, 'signal-emitter',
    # :!new-context,
    # :start-time(now + 1)
  );

  is $main.gtk-main-level, 0, "loop level 0";
  $main.gtk-main;
  #is $main.gtk-main-level, 0, "loop level is 0 again";

  is $p.result, 'done', 'emitter finished';
}
