# Online resources for PiFlash

This is a list of online resources for PiFlash
* [PiFlash release on CPAN](https://metacpan.org/release/PiFlash)
* [PiFlash source on GitHub](https://github.com/ikluft/piflash)

## Where to download Raspberry Pi bootable images

The first place to look for Raspberry Pi bootable images is usually the Raspberry Pi Foundation's download page.
https://www.raspberrypi.org/downloads/ .  But they stopped adding new sources long ago. There are more. These OS downloads include SD card images for the Raspberry Pi.

Please suggest (or directly submit edits via pull requests on GitHub) other places to download bootable Raspberry Pi images (SD card files).

This is also the list to watch that PiFlash should be able to recognize the file types available for download here and automatically handle them all. If anything changes in the file formats offered in these downloads, please point it out so PiFlash can be updated to work with it.

* [Alpine Linux](https://alpinelinux.org/downloads/)

  Alpine is a compact security-oriented Linux distribution, popular for containter and IoT
  (uses its own packaging system)

* [Arch Linux](https://archlinuxarm.org/about/downloads)

  Arch is a compact Linux distribution based on a rolling-release model
  (uses its own packaging system)

* [Fedora Linux](https://arm.fedoraproject.org/)

  Fedora is the Open Source Linux distribution which acts as the foundation that RedHat Enterprise Linux is built on
  (based on RPM RedHat Package Manager)

* [FreeBSD](https://www.freebsd.org/where.html)

  FreeBSD is the largest Open Source derivative of Berkeley BSD Unix

* [FreedomBox](https://freedombox.org/download/stable/)

  personal server project of Debian Linux

* [Slackware ARM on a Raspberry Pi (SARPi)](http://rpi.fatdog.eu/)

  Slackware Linux, one of the original Linux distributions
  (uses its own packaging system)

## Presentations and Articles

* ["Perl on Raspberry Pi"](https://www.slideshare.net/ikluft/perl-on-raspberry-pi-svperl-20170202)
  presentation by Ian Kluft at Silicon Valley Perl (SVPerl) in Santa Clara, California on February 2, 2017

* ["Getting started with Perl on the Raspberry Pi"](https://opensource.com/article/17/3/perl-raspberry-pi)
  article by Ian Kluft at OpenSource.com on March 13, 2017

* ["PiFlash: Linux utility to flash SD cards for Raspberry Pi computers"](https://www.slideshare.net/ikluft/piflash-linux-utility-to-flash-sd-cards-for-raspberry-pi-computers)
  presentation by Ian Kluft at Silicon Valley Perl (SVPerl) inSunnyvale, California on February 7, 2019

* ["Getting started with PiFlash: Booting your Raspberry Pi on Linux"](https://opensource.com/article/19/3/piflash)
  article by Ian Kluft at OpenSource.com on March 15, 2019 
