/*
 * A n t l r  T r a n s l a t i o n  H e a d e r
 *
 * Terence Parr, Will Cohen, and Hank Dietz: 1989-1994
 * Purdue University Electrical Engineering
 * With AHPCRC, University of Minnesota
 * ANTLR Version 1.33
 */
#include <stdio.h>
#define ANTLR_VERSION	133

#define ZZCOL
#define USER_ZZSYN

#include "attrib.h"
#include "lex_auxiliary.h"
#include "error.h"
#include "bibtex_ast.h"
#define GENAST

#include "ast.h"

#define zzSET_SIZE 4
#include "antlr.h"
#include "tokens.h"
#include "dlgdef.h"
#include "mode.h"
#ifndef PURIFY
#define PURIFY(r,s)
#endif
#include "ast.c"
zzASTgvars

ANTLR_INFO

void
#ifdef __STDC__
bibfile(AST**_root)
#else
bibfile(_root)
AST **_root;
#endif
{
	zzRULE;
	zzBLOCK(zztasp1);
	zzMake0;
	{
	AST *last; (*_root) = NULL;   
	{
		zzBLOCK(zztasp2);
		zzMake0;
		{
		while ( (LA(1)==AT) ) {
			_ast = NULL; entry(&_ast, 0 );
			/* a little creative forestry... */
			if ((*_root) == NULL)
			(*_root) = zzastArg(1);
			else
			last->right = zzastArg(1);
			last = zzastArg(1);
			zzLOOP(zztasp2);
		}
		zzEXIT(zztasp2);
		}
	}
	zzEXIT(zztasp1);
	return;
fail:
	zzEXIT(zztasp1);
	zzsyn(zzMissText, zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk, zzBadText);
	zzresynch(setwd1, 0x1);
	}
}

void
#ifdef __STDC__
entry(AST**_root, int cur_line )
#else
entry(_root,cur_line)
AST **_root;
 int cur_line ;
#endif
{
	zzRULE;
	zzBLOCK(zztasp1);
	zzMake0;
	{
	
	if ( cur_line > 0) zzline =  cur_line;
	zzmatch(AT);  zzCONSUME;
	zzmatch(ENTRY_TYPE); zzsubroot(_root, &_sibling, &_tail); zzCONSUME;
	zzmatch(ENTRY_OPEN);  zzCONSUME;
	contents(zzSTR); zzlink(_root, &_sibling, &_tail);
	zzmatch(ENTRY_CLOSE); 
	
	switch (EntryMetatype)
	{
		case ETYPE_STRUCTURED: zzastArg(1)->nodetype = AST_ENTRY; break;
		case ETYPE_MACRODEF  : zzastArg(1)->nodetype = AST_MACRODEF; break;
		case ETYPE_TEXT      : zzastArg(1)->nodetype = AST_TEXT; break;
	}
 zzCONSUME;

	zzEXIT(zztasp1);
	return;
fail:
	zzEXIT(zztasp1);
	zzsyn(zzMissText, zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk, zzBadText);
	zzresynch(setwd1, 0x2);
	}
}

void
#ifdef __STDC__
contents(AST**_root)
#else
contents(_root)
AST **_root;
#endif
{
	zzRULE;
	zzBLOCK(zztasp1);
	zzMake0;
	{
	if ( (LA(1)==ENTRY_KEY) ) {
		zzmatch(ENTRY_KEY); zzsubchild(_root, &_sibling, &_tail);
		
		if (strlen (zzaArg(zztasp1,1 ).text) == 0)
		lexical_warning ("empty key");
		zzastArg(1)->nodetype = AST_KEY;
 zzCONSUME;

		zzmatch(COMMA);  zzCONSUME;
		fields(zzSTR); zzlink(_root, &_sibling, &_tail);
	}
	else {
		if ( (LA(1)==KEYWORD) ) {
			if (!(EntryMetatype == ETYPE_MACRODEF )) {zzfailed_pred("   EntryMetatype == ETYPE_MACRODEF ");}
			field(zzSTR); zzlink(_root, &_sibling, &_tail);
		}
		else {zzFAIL(1,zzerr1,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
	}
	zzEXIT(zztasp1);
	return;
fail:
	zzEXIT(zztasp1);
	zzsyn(zzMissText, zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk, zzBadText);
	zzresynch(setwd1, 0x4);
	}
}

void
#ifdef __STDC__
fields(AST**_root)
#else
fields(_root)
AST **_root;
#endif
{
	zzRULE;
	zzBLOCK(zztasp1);
	zzMake0;
	{
	if ( (LA(1)==KEYWORD) ) {
		field(zzSTR); zzlink(_root, &_sibling, &_tail);
		{
			zzBLOCK(zztasp2);
			zzMake0;
			{
			if ( (LA(1)==COMMA) ) {
				zzmatch(COMMA);  zzCONSUME;
				fields(zzSTR); zzlink(_root, &_sibling, &_tail);
			}
			zzEXIT(zztasp2);
			}
		}
	}
	else {
		if ( (LA(1)==ENTRY_CLOSE) ) {
		}
		else {zzFAIL(1,zzerr2,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
	}
	zzEXIT(zztasp1);
	return;
fail:
	zzEXIT(zztasp1);
	zzsyn(zzMissText, zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk, zzBadText);
	zzresynch(setwd1, 0x8);
	}
}

void
#ifdef __STDC__
field(AST**_root)
#else
field(_root)
AST **_root;
#endif
{
	zzRULE;
	zzBLOCK(zztasp1);
	zzMake0;
	{
	zzmatch(KEYWORD); zzsubroot(_root, &_sibling, &_tail); zzCONSUME;
	zzmatch(EQUALS);  zzCONSUME;
	field_data(zzSTR); zzlink(_root, &_sibling, &_tail);
	zzastArg(1)->nodetype = AST_FIELD;   
	
#if DEBUG > 1
	printf ("field: fieldname = %p (%s)\n"
	"       first val = %p (%s)\n",
	zzastArg(1)->text, zzastArg(1)->text, zzastArg(2)->text, zzastArg(2)->text);
#endif
	zzEXIT(zztasp1);
	return;
fail:
	zzEXIT(zztasp1);
	zzsyn(zzMissText, zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk, zzBadText);
	zzresynch(setwd1, 0x10);
	}
}

void
#ifdef __STDC__
field_data(AST**_root)
#else
field_data(_root)
AST **_root;
#endif
{
	zzRULE;
	zzBLOCK(zztasp1);
	zzMake0;
	{
	field_datum(zzSTR); zzlink(_root, &_sibling, &_tail);
	{
		zzBLOCK(zztasp2);
		zzMake0;
		{
		while ( (LA(1)==HASH) ) {
			zzmatch(HASH);  zzCONSUME;
			field_datum(zzSTR); zzlink(_root, &_sibling, &_tail);
			zzLOOP(zztasp2);
		}
		zzEXIT(zztasp2);
		}
	}
	zzEXIT(zztasp1);
	return;
fail:
	zzEXIT(zztasp1);
	zzsyn(zzMissText, zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk, zzBadText);
	zzresynch(setwd1, 0x20);
	}
}

void
#ifdef __STDC__
field_datum(AST**_root)
#else
field_datum(_root)
AST **_root;
#endif
{
	zzRULE;
	zzBLOCK(zztasp1);
	zzMake0;
	{
	if ( (LA(1)==STRING) ) {
		zzmatch(STRING); zzsubchild(_root, &_sibling, &_tail);
		zzastArg(1)->nodetype = AST_STRING;   
 zzCONSUME;

	}
	else {
		if ( (LA(1)==NUMBER) ) {
			zzmatch(NUMBER); zzsubchild(_root, &_sibling, &_tail);
			zzastArg(1)->nodetype = AST_NUMBER;   
 zzCONSUME;

		}
		else {
			if ( (LA(1)==KEYWORD) ) {
				zzmatch(KEYWORD); zzsubchild(_root, &_sibling, &_tail);
				zzastArg(1)->nodetype = AST_MACRO;   
 zzCONSUME;

			}
			else {zzFAIL(1,zzerr3,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
		}
	}
	zzEXIT(zztasp1);
	return;
fail:
	zzEXIT(zztasp1);
	zzsyn(zzMissText, zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk, zzBadText);
	zzresynch(setwd1, 0x40);
	}
}
